/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.util;

import java.util.List;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import org.apache.commons.lang3.Validate;

public final class InstructionUtil {
    private InstructionUtil() {
    }

    public static Instruction getInstructionAt(List<Instruction> list, int offset) {
        Instruction i;
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.get(0).getOffset() >= offset) {
            return list.get(0);
        }
        int length = list.size();
        if (length == 1 || list.get(length - 1).getOffset() < offset) {
            return null;
        }
        int firstIndex = 0;
        int lastIndex = length - 1;
        while (true) {
            int medIndex;
            if ((i = list.get(medIndex = (lastIndex + firstIndex) / 2)).getOffset() < offset) {
                firstIndex = medIndex + 1;
                continue;
            }
            if (list.get(medIndex - 1).getOffset() < offset) break;
            lastIndex = medIndex - 1;
        }
        return i;
    }

    public static int getIndexForOffset(List<Instruction> list, LocalVariable lv) {
        int indexForNewDeclaration = InstructionUtil.getIndexForOffset(list, lv.getStartPc());
        if (indexForNewDeclaration == -1) {
            indexForNewDeclaration = 0;
        }
        return indexForNewDeclaration;
    }

    public static int getIndexForOffset(List<Instruction> list, int offset) {
        int medIndex;
        Validate.inclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)offset, (String)("offset=" + offset));
        if (list == null || list.isEmpty()) {
            return -1;
        }
        if (list.get(0).getOffset() >= offset) {
            return 0;
        }
        int length = list.size();
        if (length == 1 || list.get(length - 1).getOffset() < offset) {
            return -1;
        }
        int firstIndex = 0;
        int lastIndex = length - 1;
        while (true) {
            Instruction i;
            if ((i = list.get(medIndex = (lastIndex + firstIndex) / 2)).getOffset() < offset) {
                firstIndex = medIndex + 1;
                continue;
            }
            if (list.get(medIndex - 1).getOffset() < offset) break;
            lastIndex = medIndex - 1;
        }
        return medIndex;
    }

    public static boolean checkNoJumpToInterval(List<Instruction> list, int firstIndex, int afterIndex, int firstOffset, int lastOffset) {
        int index = firstIndex;
        while (index < afterIndex) {
            int jumpOffset;
            Instruction i = list.get(index);
            if (ByteCodeUtil.isIfOrGotoInstruction((int)i.getOpcode(), (boolean)false) && firstOffset < (jumpOffset = ((BranchInstruction)i).getJumpOffset()) && jumpOffset <= lastOffset) {
                return false;
            }
            ++index;
        }
        return true;
    }
}

