/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.process.analyzer.classfile.visitor.CompareInstructionVisitor;

public class FastCompareInstructionVisitor
extends CompareInstructionVisitor {
    public boolean visit(List<Instruction> list1, List<Instruction> list2, int index1, int index2, int length) {
        if (index1 + length <= list1.size() && index2 + length <= list2.size()) {
            while (length-- > 0) {
                if (this.visit(list1.get(index1++), list2.get(index2++))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean visit(Instruction i1, Instruction i2) {
        if (i1.getOpcode() != i2.getOpcode()) {
            return false;
        }
        switch (i1.getOpcode()) {
            case 318: {
                FastTry.FastCatch fc2;
                FastTry.FastCatch fc1;
                FastTry ft1 = (FastTry)i1;
                FastTry ft2 = (FastTry)i2;
                int i = ft1.getCatches().size();
                if (i != ft2.getCatches().size()) {
                    return false;
                }
                if (ft1.getFinallyInstructions() == null ? ft2.getFinallyInstructions() != null : (ft2.getFinallyInstructions() == null ? ft1.getFinallyInstructions() != null : !this.visit(ft1.getFinallyInstructions(), ft2.getFinallyInstructions()))) {
                    return false;
                }
                do {
                    if (i-- <= 0) {
                        return this.visit(ft1.getInstructions(), ft2.getInstructions());
                    }
                    fc1 = ft1.getCatches().get(i);
                    fc2 = ft2.getCatches().get(i);
                } while (fc1.exceptionTypeIndex() == fc2.exceptionTypeIndex() && this.visit(fc1.instructions(), fc2.instructions()) && FastCompareInstructionVisitor.compareExceptionTypeIndexes(fc1.otherExceptionTypeIndexes(), fc2.otherExceptionTypeIndexes()));
                return false;
            }
            case 319: {
                FastSynchronized fs1 = (FastSynchronized)i1;
                FastSynchronized fs2 = (FastSynchronized)i2;
                if (!this.visit(fs1.getMonitor(), fs2.getMonitor())) {
                    return false;
                }
                return this.visit(fs1.getInstructions(), fs2.getInstructions());
            }
            case 301: 
            case 302: 
            case 306: {
                Instruction test1 = ((FastTestList)i1).getTest();
                Instruction test2 = ((FastTestList)i2).getTest();
                List<Instruction> instructions1 = ((FastTestList)i1).getInstructions();
                List<Instruction> instructions2 = ((FastTestList)i2).getInstructions();
                return this.visit(test1, test2) && this.visit(instructions1, instructions2);
            }
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                FastInstruction fi1 = (FastInstruction)i1;
                FastInstruction fi2 = (FastInstruction)i2;
                return this.visit(fi1.getInstruction(), fi2.getInstruction());
            }
            case 320: {
                FastLabel fl1 = (FastLabel)i1;
                FastLabel fl2 = (FastLabel)i2;
                return this.visit(fl1.getInstruction(), fl2.getInstruction());
            }
            case 317: {
                FastDeclaration fd1 = (FastDeclaration)i1;
                FastDeclaration fd2 = (FastDeclaration)i2;
                return this.visit(fd1.getInstruction(), fd2.getInstruction());
            }
        }
        return super.visit(i1, i2);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean compareExceptionTypeIndexes(int[] otherExceptionTypeIndexes1, int[] otherExceptionTypeIndexes2) {
        if (otherExceptionTypeIndexes1 == null) {
            return otherExceptionTypeIndexes2 == null;
        }
        if (otherExceptionTypeIndexes2 == null) {
            return false;
        }
        i = otherExceptionTypeIndexes1.length;
        if (i == otherExceptionTypeIndexes2.length) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if (otherExceptionTypeIndexes1[i] == otherExceptionTypeIndexes2[i]) continue;
            return false;
lbl10:
            // 2 sources

            ** while (i-- > 0)
        }
lbl11:
        // 1 sources

        return true;
    }
}

