/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.attribute.ObjectrefAttribute;
import jd.core.model.instruction.bytecode.instruction.attribute.ValuerefAttribute;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastForEach;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;

public class CountDupLoadVisitor {
    private DupStore dupStore;
    private int counter;

    public CountDupLoadVisitor() {
        this.init(null);
    }

    public void init(DupStore dupStore) {
        this.dupStore = dupStore;
        this.counter = 0;
    }

    public void visit(Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 190: {
                this.visit(((ArrayLength)instruction).getArrayref());
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                this.visit(asi.getArrayref());
                this.visit(asi.getIndexref());
                this.visit(asi.getValueref());
                break;
            }
            case 191: {
                this.visit(((AThrow)instruction).getValue());
                break;
            }
            case 266: {
                this.visit(((UnaryOperatorInstruction)instruction).getValue());
                break;
            }
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                this.visit(boi.getValue1());
                this.visit(boi.getValue2());
                break;
            }
            case 87: 
            case 180: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 264: 
            case 280: {
                this.visit(((ObjectrefAttribute)((Object)instruction)).getObjectref());
                break;
            }
            case 54: 
            case 58: 
            case 179: 
            case 269: 
            case 273: {
                this.visit(((ValuerefAttribute)((Object)instruction)).getValueref());
                break;
            }
            case 275: 
            case 276: {
                this.visit(((ConvertInstruction)instruction).getValue());
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                this.visit(ifCmp.getValue1());
                this.visit(ifCmp.getValue2());
                break;
            }
            case 260: 
            case 262: {
                this.visit(((IfInstruction)instruction).getValue());
                break;
            }
            case 284: {
                this.visit(((ComplexConditionalBranchInstruction)instruction).getInstructions());
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                this.visit(((InvokeNoStaticInstruction)instruction).getObjectref());
            }
            case 184: {
                this.visit(((InvokeInstruction)instruction).getArgs());
                break;
            }
            case 274: {
                this.visit(((InvokeNew)instruction).getArgs());
                break;
            }
            case 170: 
            case 171: {
                this.visit(((Switch)instruction).getKey());
                break;
            }
            case 197: {
                this.visit(((MultiANewArray)instruction).getDimensions());
                break;
            }
            case 188: {
                this.visit(((NewArray)instruction).getDimension());
                break;
            }
            case 189: {
                this.visit(((ANewArray)instruction).getDimension());
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                this.visit(putField.getObjectref());
                this.visit(putField.getValueref());
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                this.visit(to.getValue1());
                this.visit(to.getValue2());
                break;
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)instruction;
                this.visit(ai.getValue1());
                this.visit(ai.getValue2());
                break;
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                this.visit(ali.getArrayref());
                this.visit(ali.getIndexref());
                break;
            }
            case 277: 
            case 278: {
                this.visit(((IncInstruction)instruction).getValue());
                break;
            }
            case 263: {
                if (((DupLoad)instruction).getDupStore() != this.dupStore) break;
                ++this.counter;
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                this.visit(iai.getNewArray());
                if (iai.getValues() == null) break;
                this.visit(iai.getValues());
                break;
            }
            case 304: {
                FastFor ff = (FastFor)instruction;
                if (ff.getInit() != null) {
                    this.visit(ff.getInit());
                }
                if (ff.getInc() != null) {
                    this.visit(ff.getInc());
                }
            }
            case 301: 
            case 302: 
            case 306: {
                Instruction test = ((FastTestList)instruction).getTest();
                if (test != null) {
                    this.visit(test);
                }
            }
            case 303: {
                List<Instruction> instructions = ((FastList)instruction).getInstructions();
                if (instructions == null) break;
                this.visit(instructions);
                break;
            }
            case 305: {
                FastForEach ffe = (FastForEach)instruction;
                this.visit(ffe.getVariable());
                this.visit(ffe.getValues());
                this.visit(ffe.getInstructions());
                break;
            }
            case 307: {
                FastTest2Lists ft2l = (FastTest2Lists)instruction;
                this.visit(ft2l.getTest());
                this.visit(ft2l.getInstructions());
                this.visit(ft2l.getInstructions2());
                break;
            }
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                FastInstruction fi = (FastInstruction)instruction;
                if (fi.getInstruction() == null) break;
                this.visit(fi.getInstruction());
                break;
            }
            case 314: 
            case 315: 
            case 316: {
                FastSwitch fs = (FastSwitch)instruction;
                this.visit(fs.getTest());
                FastSwitch.Pair[] pairs = fs.getPairs();
                int i = pairs.length - 1;
                while (i >= 0) {
                    List<Instruction> instructions = pairs[i].getInstructions();
                    if (instructions != null) {
                        this.visit(instructions);
                    }
                    --i;
                }
                break;
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                this.visit(ft.getInstructions());
                if (ft.getFinallyInstructions() != null) {
                    this.visit(ft.getFinallyInstructions());
                }
                List<FastTry.FastCatch> catchs = ft.getCatches();
                int i = catchs.size() - 1;
                while (i >= 0) {
                    this.visit(catchs.get(i).instructions());
                    --i;
                }
                break;
            }
            case 319: {
                FastSynchronized fsd = (FastSynchronized)instruction;
                this.visit(fsd.getMonitor());
                this.visit(fsd.getInstructions());
                break;
            }
            case 320: {
                FastLabel fl = (FastLabel)instruction;
                if (fl.getInstruction() == null) break;
                this.visit(fl.getInstruction());
                break;
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                if (fd.getInstruction() == null) break;
                this.visit(fd.getInstruction());
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 186: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 268: 
            case 270: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not count DupLoad in " + instruction.getClass().getName() + ", opcode=" + instruction.getOpcode());
            }
        }
    }

    private void visit(List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            this.visit(instructions.get(i));
            --i;
        }
    }

    public int getCounter() {
        return this.counter;
    }
}

