/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.visitor;

import java.util.List;
import java.util.function.Predicate;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.attribute.ObjectrefAttribute;
import jd.core.model.instruction.bytecode.instruction.attribute.ValuerefAttribute;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastForEach;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;

public final class CheckLocalVariableUsedVisitor {
    private CheckLocalVariableUsedVisitor() {
    }

    public static boolean visit(Predicate<IndexInstruction> predicate, Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 190: {
                return CheckLocalVariableUsedVisitor.visit(predicate, ((ArrayLength)instruction).getArrayref());
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, asi.getIndexref()) || CheckLocalVariableUsedVisitor.visit(predicate, asi.getValueref());
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, ai.getTest()) || ai.getMsg() != null && CheckLocalVariableUsedVisitor.visit(predicate, ai.getMsg());
            }
            case 191: {
                return CheckLocalVariableUsedVisitor.visit(predicate, ((AThrow)instruction).getValue());
            }
            case 266: {
                return CheckLocalVariableUsedVisitor.visit(predicate, ((UnaryOperatorInstruction)instruction).getValue());
            }
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, boi.getValue1()) || CheckLocalVariableUsedVisitor.visit(predicate, boi.getValue2());
            }
            case 87: 
            case 180: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 264: 
            case 280: {
                return CheckLocalVariableUsedVisitor.visit(predicate, ((ObjectrefAttribute)((Object)instruction)).getObjectref());
            }
            case 21: 
            case 25: 
            case 268: {
                LoadInstruction li = (LoadInstruction)instruction;
                return predicate.test(li);
            }
            case 54: 
            case 58: 
            case 269: {
                StoreInstruction si = (StoreInstruction)instruction;
                return predicate.test(si) || CheckLocalVariableUsedVisitor.visit(predicate, si.getValueref());
            }
            case 275: 
            case 276: {
                return CheckLocalVariableUsedVisitor.visit(predicate, ((ConvertInstruction)instruction).getValue());
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, ifCmp.getValue1()) || CheckLocalVariableUsedVisitor.visit(predicate, ifCmp.getValue2());
            }
            case 260: 
            case 262: {
                return CheckLocalVariableUsedVisitor.visit(predicate, ((IfInstruction)instruction).getValue());
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).getInstructions();
                int i = branchList.size() - 1;
                while (i >= 0) {
                    if (CheckLocalVariableUsedVisitor.visit(predicate, branchList.get(i))) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 182: 
            case 183: 
            case 185: {
                if (CheckLocalVariableUsedVisitor.visit(predicate, ((InvokeNoStaticInstruction)instruction).getObjectref())) {
                    return true;
                }
            }
            case 184: {
                List<Instruction> list = ((InvokeInstruction)instruction).getArgs();
                int i = list.size() - 1;
                while (i >= 0) {
                    if (CheckLocalVariableUsedVisitor.visit(predicate, list.get(i))) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 274: {
                List<Instruction> list = ((InvokeNew)instruction).getArgs();
                int i = list.size() - 1;
                while (i >= 0) {
                    if (CheckLocalVariableUsedVisitor.visit(predicate, list.get(i))) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 170: 
            case 171: {
                return CheckLocalVariableUsedVisitor.visit(predicate, ((Switch)instruction).getKey());
            }
            case 197: {
                List<Instruction> dimensions = ((MultiANewArray)instruction).getDimensions();
                for (Instruction dimension : dimensions) {
                    if (!CheckLocalVariableUsedVisitor.visit(predicate, dimension)) continue;
                    return true;
                }
                return false;
            }
            case 188: {
                return CheckLocalVariableUsedVisitor.visit(predicate, ((NewArray)instruction).getDimension());
            }
            case 189: {
                return CheckLocalVariableUsedVisitor.visit(predicate, ((ANewArray)instruction).getDimension());
            }
            case 181: {
                PutField putField = (PutField)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, putField.getObjectref()) || CheckLocalVariableUsedVisitor.visit(predicate, putField.getValueref());
            }
            case 179: 
            case 273: {
                return CheckLocalVariableUsedVisitor.visit(predicate, ((ValuerefAttribute)((Object)instruction)).getValueref());
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, to.getValue1()) || CheckLocalVariableUsedVisitor.visit(predicate, to.getValue2());
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, ai.getValue1()) || CheckLocalVariableUsedVisitor.visit(predicate, ai.getValue2());
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, ali.getArrayref()) || CheckLocalVariableUsedVisitor.visit(predicate, ali.getIndexref());
            }
            case 277: 
            case 278: {
                return CheckLocalVariableUsedVisitor.visit(predicate, ((IncInstruction)instruction).getValue());
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, iai.getNewArray()) || iai.getValues() != null && CheckLocalVariableUsedVisitor.visit(predicate, iai.getValues());
            }
            case 304: {
                FastFor ff = (FastFor)instruction;
                return ff.getInit() != null && CheckLocalVariableUsedVisitor.visit(predicate, ff.getInit()) || ff.getInc() != null && CheckLocalVariableUsedVisitor.visit(predicate, ff.getInc()) || ff.getInstructions() != null && CheckLocalVariableUsedVisitor.visit(predicate, ff.getInstructions());
            }
            case 301: 
            case 302: 
            case 306: {
                Instruction test = ((FastTestList)instruction).getTest();
                List<Instruction> instructions = ((FastTestList)instruction).getInstructions();
                return test != null && CheckLocalVariableUsedVisitor.visit(predicate, test) || instructions != null && CheckLocalVariableUsedVisitor.visit(predicate, instructions);
            }
            case 303: {
                List<Instruction> instructions = ((FastList)instruction).getInstructions();
                return instructions != null && CheckLocalVariableUsedVisitor.visit(predicate, instructions);
            }
            case 305: {
                FastForEach ffe = (FastForEach)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, ffe.getVariable()) || CheckLocalVariableUsedVisitor.visit(predicate, ffe.getValues()) || CheckLocalVariableUsedVisitor.visit(predicate, ffe.getInstructions());
            }
            case 307: {
                FastTest2Lists ft2l = (FastTest2Lists)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, ft2l.getTest()) || CheckLocalVariableUsedVisitor.visit(predicate, ft2l.getInstructions()) || CheckLocalVariableUsedVisitor.visit(predicate, ft2l.getInstructions2());
            }
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                FastInstruction fi = (FastInstruction)instruction;
                return fi.getInstruction() != null && CheckLocalVariableUsedVisitor.visit(predicate, fi.getInstruction());
            }
            case 314: 
            case 315: 
            case 316: {
                FastSwitch fs = (FastSwitch)instruction;
                if (CheckLocalVariableUsedVisitor.visit(predicate, fs.getTest())) {
                    return true;
                }
                FastSwitch.Pair[] pairs = fs.getPairs();
                int i = pairs.length - 1;
                while (i >= 0) {
                    List<Instruction> instructions = pairs[i].getInstructions();
                    if (instructions != null && CheckLocalVariableUsedVisitor.visit(predicate, instructions)) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                if (CheckLocalVariableUsedVisitor.visit(predicate, ft.getInstructions()) || ft.getFinallyInstructions() != null && CheckLocalVariableUsedVisitor.visit(predicate, ft.getFinallyInstructions())) {
                    return true;
                }
                List<FastTry.FastCatch> catchs = ft.getCatches();
                int i = catchs.size() - 1;
                while (i >= 0) {
                    if (CheckLocalVariableUsedVisitor.visit(predicate, catchs.get(i).instructions())) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 319: {
                FastSynchronized fsd = (FastSynchronized)instruction;
                return CheckLocalVariableUsedVisitor.visit(predicate, fsd.getMonitor()) || CheckLocalVariableUsedVisitor.visit(predicate, fsd.getInstructions());
            }
            case 320: {
                FastLabel fl = (FastLabel)instruction;
                return fl.getInstruction() != null && CheckLocalVariableUsedVisitor.visit(predicate, fl.getInstruction());
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                return fd.getInstruction() != null && CheckLocalVariableUsedVisitor.visit(predicate, fd.getInstruction());
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 186: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 270: 
            case 279: 
            case 285: {
                return false;
            }
        }
        System.err.println("Can not find local variable used in " + instruction.getClass().getName() + ", opcode=" + instruction.getOpcode());
        return false;
    }

    public static boolean visit(Predicate<IndexInstruction> predicate, List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            if (CheckLocalVariableUsedVisitor.visit(predicate, instructions.get(i))) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static boolean visit(LocalVariables localVariables, int maxOffset, List<Instruction> instructions) {
        return CheckLocalVariableUsedVisitor.visit((IndexInstruction ii) -> {
            LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(ii.getIndex(), ii.getOffset());
            return lv != null && maxOffset <= lv.getStartPc();
        }, instructions);
    }

    public static boolean visit(LocalVariable lv, List<Instruction> instructions) {
        return CheckLocalVariableUsedVisitor.visit(new LocalVariables(lv), lv.getStartPc(), instructions);
    }

    public static boolean checkNameUsed(LocalVariables localVariables, int lvNameIndex, List<Instruction> instructions) {
        return CheckLocalVariableUsedVisitor.visit((IndexInstruction ii) -> {
            LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(ii.getIndex(), ii.getOffset());
            return lv != null && lv.getNameIndex() == lvNameIndex;
        }, instructions);
    }

    public static boolean visit(LocalVariables localVariables, int maxOffset, Instruction instruction) {
        return CheckLocalVariableUsedVisitor.visit((IndexInstruction ii) -> {
            LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(ii.getIndex(), ii.getOffset());
            return lv != null && maxOffset <= lv.getStartPc();
        }, instruction);
    }
}

