/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.attribute.ObjectrefAttribute;
import jd.core.model.instruction.bytecode.instruction.attribute.ValuerefAttribute;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;

public abstract class AbstractReplaceInstructionVisitor<T> {
    private Instruction oldInstruction;
    private Instruction newInstruction;
    private Instruction parentFound;

    protected AbstractReplaceInstructionVisitor(Instruction newInstruction) {
        this.init(newInstruction);
    }

    protected AbstractReplaceInstructionVisitor() {
        this(null);
    }

    protected void init(Instruction newInstruction) {
        this.oldInstruction = null;
        this.newInstruction = newInstruction;
        this.parentFound = null;
    }

    public void visit(Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 190: {
                ArrayLength al = (ArrayLength)instruction;
                T found = this.match(al, al.getArrayref());
                if (found != null) {
                    al.setArrayref(this.newInstruction(al.getArrayref(), found));
                }
                this.visit(al.getArrayref());
                break;
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                T found = this.match(ali, ali.getArrayref());
                if (found != null) {
                    ali.setArrayref(this.newInstruction(ali.getArrayref(), found));
                }
                this.visit(ali.getArrayref());
                if (this.oldInstruction != null) break;
                found = this.match(ali, ali.getIndexref());
                if (found != null) {
                    ali.setIndexref(this.newInstruction(ali.getIndexref(), found));
                }
                this.visit(ali.getIndexref());
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                T found = this.match(asi, asi.getArrayref());
                if (found != null) {
                    asi.setArrayref(this.newInstruction(asi.getArrayref(), found));
                }
                this.visit(asi.getArrayref());
                if (this.oldInstruction != null) break;
                found = this.match(asi, asi.getIndexref());
                if (found != null) {
                    asi.setIndexref(this.newInstruction(asi.getIndexref(), found));
                }
                this.visit(asi.getIndexref());
                if (this.oldInstruction != null) break;
                found = this.match(asi, asi.getValueref());
                if (found != null) {
                    asi.setValueref(this.newInstruction(asi.getValueref(), found));
                }
                this.visit(asi.getValueref());
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                T found = this.match(ai, ai.getTest());
                if (found != null) {
                    ai.setTest(this.newInstruction(ai.getTest(), found));
                }
                this.visit(ai.getTest());
                if (this.oldInstruction != null || ai.getMsg() == null) break;
                found = this.match(ai, ai.getMsg());
                if (found != null) {
                    ai.setMsg(this.newInstruction(ai.getMsg(), found));
                }
                this.visit(ai.getMsg());
                break;
            }
            case 191: {
                AThrow aThrow = (AThrow)instruction;
                T found = this.match(aThrow, aThrow.getValue());
                if (found != null) {
                    aThrow.setValue(this.newInstruction(aThrow.getValue(), found));
                }
                this.visit(aThrow.getValue());
                break;
            }
            case 266: {
                UnaryOperatorInstruction uoi = (UnaryOperatorInstruction)instruction;
                T found = this.match(uoi, uoi.getValue());
                if (found != null) {
                    uoi.setValue(this.newInstruction(uoi.getValue(), found));
                }
                this.visit(uoi.getValue());
                break;
            }
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                T found = this.match(boi, boi.getValue1());
                if (found != null) {
                    boi.setValue1(this.newInstruction(boi.getValue1(), found));
                }
                this.visit(boi.getValue1());
                if (this.oldInstruction != null) break;
                found = this.match(boi, boi.getValue2());
                if (found != null) {
                    boi.setValue2(this.newInstruction(boi.getValue2(), found));
                }
                this.visit(boi.getValue2());
                break;
            }
            case 87: 
            case 180: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 264: 
            case 280: {
                this.visitObjectref(instruction);
                break;
            }
            case 54: 
            case 58: 
            case 179: 
            case 269: 
            case 273: {
                this.visitValueref(instruction);
                break;
            }
            case 275: 
            case 276: {
                ConvertInstruction ci = (ConvertInstruction)instruction;
                T found = this.match(ci, ci.getValue());
                if (found != null) {
                    ci.setValue(this.newInstruction(ci.getValue(), found));
                }
                this.visit(ci.getValue());
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                T found = this.match(ifCmp, ifCmp.getValue1());
                if (found != null) {
                    ifCmp.setValue1(this.newInstruction(ifCmp.getValue1(), found));
                }
                this.visit(ifCmp.getValue1());
                if (this.oldInstruction != null) break;
                found = this.match(ifCmp, ifCmp.getValue2());
                if (found != null) {
                    ifCmp.setValue2(this.newInstruction(ifCmp.getValue2(), found));
                }
                this.visit(ifCmp.getValue2());
                break;
            }
            case 260: 
            case 262: {
                IfInstruction iff = (IfInstruction)instruction;
                T found = this.match(iff, iff.getValue());
                if (found != null) {
                    iff.setValue(this.newInstruction(iff.getValue(), found));
                }
                this.visit(iff.getValue());
                break;
            }
            case 284: {
                this.visit(instruction, ((ComplexConditionalBranchInstruction)instruction).getInstructions());
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                this.visitObjectref(instruction);
            }
            case 184: 
            case 274: {
                this.visit(instruction, ((InvokeInstruction)instruction).getArgs());
                break;
            }
            case 170: 
            case 171: {
                Switch ls = (Switch)instruction;
                T found = this.match(ls, ls.getKey());
                if (found != null) {
                    ls.setKey(this.newInstruction(ls.getKey(), found));
                }
                this.visit(ls.getKey());
                break;
            }
            case 197: {
                this.visit(instruction, ((MultiANewArray)instruction).getDimensions());
                break;
            }
            case 188: {
                NewArray newArray = (NewArray)instruction;
                T found = this.match(newArray, newArray.getDimension());
                if (found != null) {
                    newArray.setDimension(this.newInstruction(newArray.getDimension(), found));
                }
                this.visit(newArray.getDimension());
                break;
            }
            case 189: {
                ANewArray aNewArray = (ANewArray)instruction;
                T found = this.match(aNewArray, aNewArray.getDimension());
                if (found != null) {
                    aNewArray.setDimension(this.newInstruction(aNewArray.getDimension(), found));
                }
                this.visit(aNewArray.getDimension());
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                T found = this.match(putField, putField.getObjectref());
                if (found != null) {
                    putField.setObjectref(this.newInstruction(putField.getObjectref(), found));
                }
                this.visit(putField.getObjectref());
                if (this.oldInstruction != null) break;
                this.visitValueref(putField);
                break;
            }
            case 277: 
            case 278: {
                IncInstruction ii = (IncInstruction)instruction;
                T found = this.match(ii, ii.getValue());
                if (found != null) {
                    ii.setValue(this.newInstruction(ii.getValue(), found));
                }
                this.visit(ii.getValue());
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                T found = this.match(iai, iai.getNewArray());
                if (found != null) {
                    iai.setNewArray(this.newInstruction(iai.getNewArray(), found));
                }
                this.visit(iai.getNewArray());
                if (this.oldInstruction != null || iai.getValues() == null) break;
                this.visit(iai, iai.getValues());
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                T found = this.match(to, to.getTest());
                if (found != null) {
                    to.setTest(this.newInstruction(to.getTest(), found));
                }
                this.visit(to.getTest());
                if (this.oldInstruction != null) break;
                found = this.match(to, to.getValue1());
                if (found != null) {
                    to.setValue1(this.newInstruction(to.getValue1(), found));
                }
                this.visit(to.getValue1());
                if (this.oldInstruction != null) break;
                found = this.match(to, to.getValue2());
                if (found != null) {
                    to.setValue2(this.newInstruction(to.getValue2(), found));
                }
                this.visit(to.getValue2());
                break;
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)instruction;
                T found = this.match(ai, ai.getValue1());
                if (found != null) {
                    ai.setValue1(this.newInstruction(ai.getValue1(), found));
                }
                this.visit(ai.getValue1());
                if (this.oldInstruction != null) break;
                found = this.match(ai, ai.getValue2());
                if (found != null) {
                    ai.setValue2(this.newInstruction(ai.getValue2(), found));
                }
                this.visit(ai.getValue2());
                break;
            }
            case 304: {
                T found;
                FastFor ff = (FastFor)instruction;
                if (ff.getInit() != null) {
                    found = this.match(ff, ff.getInit());
                    if (found != null) {
                        ff.setInit(this.newInstruction(ff.getInit(), found));
                    }
                    this.visit(ff.getInit());
                }
                if (this.oldInstruction == null && ff.getInc() != null) {
                    found = this.match(ff, ff.getInc());
                    if (found != null) {
                        ff.setInc(this.newInstruction(ff.getInc(), found));
                    }
                    this.visit(ff.getInc());
                }
            }
            case 301: 
            case 302: 
            case 306: {
                T found;
                FastTestList ftl = (FastTestList)instruction;
                if (ftl.getTest() != null) {
                    found = this.match(ftl, ftl.getTest());
                    if (found != null) {
                        ftl.setTest(this.newInstruction(ftl.getTest(), found));
                    }
                    this.visit(ftl.getTest());
                }
            }
            case 303: {
                List<Instruction> instructions = ((FastList)instruction).getInstructions();
                if (instructions == null) break;
                this.visit(instruction, instructions);
                break;
            }
            case 314: 
            case 315: 
            case 316: {
                FastSwitch fs = (FastSwitch)instruction;
                T found = this.match(fs, fs.getTest());
                if (found != null) {
                    fs.setTest(this.newInstruction(fs.getTest(), found));
                }
                this.visit(fs.getTest());
                FastSwitch.Pair[] pairs = fs.getPairs();
                int i = pairs.length - 1;
                while (i >= 0 && this.oldInstruction == null) {
                    this.visit(fs, pairs[i].getInstructions());
                    --i;
                }
                break;
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                this.visit(ft, ft.getResources());
                this.visit(ft, ft.getInstructions());
                if (this.oldInstruction != null) break;
                if (ft.getFinallyInstructions() != null) {
                    this.visit(ft, ft.getFinallyInstructions());
                }
                int i = ft.getCatches().size() - 1;
                while (i >= 0 && this.oldInstruction == null) {
                    this.visit(ft, ft.getCatches().get(i).instructions());
                    --i;
                }
                break;
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                if (fd.getInstruction() == null) break;
                T found = this.match(fd, fd.getInstruction());
                if (found != null) {
                    fd.setInstruction(this.newInstruction(fd.getInstruction(), found));
                }
                this.visit(fd.getInstruction());
                break;
            }
            case 319: {
                FastSynchronized fsy = (FastSynchronized)instruction;
                T found = this.match(fsy, fsy.getMonitor());
                if (found != null) {
                    fsy.setMonitor(this.newInstruction(fsy.getMonitor(), found));
                }
                this.visit(fsy.getMonitor());
                if (this.oldInstruction != null) break;
                this.visit(fsy, fsy.getInstructions());
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 186: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not replace code in " + instruction.getClass().getName() + ", opcode=" + instruction.getOpcode());
            }
        }
    }

    private void visitValueref(Instruction instruction) {
        ValuerefAttribute v = (ValuerefAttribute)((Object)instruction);
        T found = this.match(instruction, v.getValueref());
        if (found != null) {
            v.setValueref(this.newInstruction(v.getValueref(), found));
        }
        this.visit(v.getValueref());
    }

    private void visitObjectref(Instruction instruction) {
        ObjectrefAttribute o = (ObjectrefAttribute)((Object)instruction);
        T found = this.match(instruction, o.getObjectref());
        if (found != null) {
            o.setObjectref(this.newInstruction(o.getObjectref(), found));
        }
        this.visit(o.getObjectref());
    }

    public void visit(Instruction parent, List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0 && this.oldInstruction == null) {
            T found = this.match(parent, instructions.get(i));
            if (found != null) {
                instructions.set(i, this.newInstruction(instructions.get(i), found));
            }
            this.visit(instructions.get(i));
            --i;
        }
    }

    public void visit(List<Instruction> instructions) {
        this.visit(null, instructions);
    }

    public Instruction getOldInstruction() {
        return this.oldInstruction;
    }

    public void setOldInstruction(Instruction oldInstruction) {
        this.oldInstruction = oldInstruction;
    }

    protected T match(Instruction parentFound, Instruction instruction) {
        T found = this.match(instruction);
        if (found != null) {
            this.oldInstruction = instruction;
            this.parentFound = parentFound;
            return found;
        }
        return null;
    }

    protected abstract T match(Instruction var1);

    protected Instruction newInstruction(Instruction i, T item) {
        return this.newInstruction;
    }

    public Instruction getParentFound() {
        return this.parentFound;
    }
}

