/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.reconstructor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.process.analyzer.instruction.bytecode.ComparisonInstructionAnalyzer;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.process.analyzer.instruction.fast.visitor.ReplaceInstructionVisitor;

public final class TernaryOpReconstructor {
    private TernaryOpReconstructor() {
    }

    /*
     * WARNING - void declaration
     */
    public static void reconstruct(List<Instruction> list) {
        int length = list.size();
        int index = 1;
        while (index < length) {
            Instruction i = list.get(index);
            if (i.getOpcode() == 280 && index + 2 < length) {
                Instruction gi = list.get(index + 1);
                Instruction afterGi = list.get(index + 2);
                Instruction test = null;
                int indexTest = index;
                while (indexTest-- > 0) {
                    Instruction instruction = list.get(indexTest);
                    int opcode = instruction.getOpcode();
                    if (!ByteCodeUtil.isIfInstruction((int)opcode, (boolean)true)) continue;
                    int jumpOffset = ((BranchInstruction)instruction).getJumpOffset();
                    if (gi.getOffset() >= jumpOffset || jumpOffset > afterGi.getOffset()) continue;
                    test = instruction;
                    break;
                }
                if (test != null) {
                    Instruction instruction;
                    Instruction value2;
                    Instruction instruction2;
                    TernaryOpStore value1 = (TernaryOpStore)i;
                    ComparisonInstructionAnalyzer.inverseComparison(test);
                    TernaryOperator fto = new TernaryOperator(281, value1.getTernaryOp2ndValueOffset(), test.getLineNumber(), test, value1.getObjectref(), null);
                    ReplaceInstructionVisitor visitor = new ReplaceInstructionVisitor(value1.getTernaryOp2ndValueOffset(), fto);
                    int indexVisitor = index + 2;
                    while (indexVisitor < length && visitor.getOldInstruction() == null) {
                        instruction2 = list.get(indexVisitor);
                        if (instruction2.getOffset() == value1.getTernaryOp2ndValueOffset()) {
                            visitor.setOldInstruction(instruction2);
                            list.set(indexVisitor, fto);
                        } else {
                            visitor.visit(instruction2);
                        }
                        ++indexVisitor;
                    }
                    Instruction instruction3 = visitor.getOldInstruction();
                    if (instruction3 instanceof TernaryOperator && (instruction2 = (TernaryOperator)instruction3) == (TernaryOperator)instruction3) {
                        void op;
                        fto.setValue1((Instruction)op);
                        value2 = op.getValue2();
                        op.setValue2(value1.getObjectref());
                        fto.setValue2(value2);
                    } else {
                        fto.setValue2(visitor.getOldInstruction());
                    }
                    if (TernaryOpReconstructor.isBooleanConstant(fto.getValue2()) && (instruction = fto.getValue1()) instanceof IConst && (value2 = (IConst)instruction) == (IConst)instruction) {
                        void iConst1;
                        iConst1.setSignature("Z");
                    }
                    if (TernaryOpReconstructor.isBooleanConstant(fto.getValue1())) {
                        if (((IConst)fto.getValue1()).getValue() == 0) {
                            ComparisonInstructionAnalyzer.inverseComparison(fto.getTest());
                        }
                        visitor.init(fto.getOffset(), fto.getTest());
                        indexVisitor = index + 2;
                        while (indexVisitor < length && visitor.getOldInstruction() == null) {
                            visitor.visit(list.get(indexVisitor++));
                        }
                    }
                    list.remove(index + 1);
                    list.remove(index);
                    list.remove(indexTest);
                    index -= 2;
                    length -= 3;
                }
            }
            ++index;
        }
    }

    private static boolean isBooleanConstant(Instruction instruction) {
        return instruction != null && ByteCodeUtil.isLoadIntValue((int)instruction.getOpcode()) && "Z".equals(instruction.getReturnedSignature(null, null));
    }
}

