/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.reconstructor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.classfile.visitor.ReplaceDupLoadVisitor;

public final class RemoveDupConstantsAttributes {
    private RemoveDupConstantsAttributes() {
    }

    public static void reconstruct(List<Instruction> list) {
        int dupStoreIndex = 0;
        while (dupStoreIndex < list.size()) {
            DupStore dupstore;
            int opcode;
            if (list.get(dupStoreIndex).getOpcode() == 264 && ((opcode = (dupstore = (DupStore)list.get(dupStoreIndex)).getObjectref().getOpcode()) == 180 || opcode == 178 || opcode == 16 || opcode == 17 || opcode == 25 || opcode == 21)) {
                Instruction i = dupstore.getObjectref();
                int dupLoadIndex = dupStoreIndex + 1;
                ReplaceDupLoadVisitor visitor = new ReplaceDupLoadVisitor(dupstore, i);
                int length = list.size();
                while (dupLoadIndex < length) {
                    visitor.visit(list.get(dupLoadIndex));
                    if (visitor.getParentFound() != null) break;
                    ++dupLoadIndex;
                }
                visitor.init(dupstore, i);
                while (dupLoadIndex < length) {
                    visitor.visit(list.get(dupLoadIndex));
                    if (visitor.getParentFound() != null) break;
                    ++dupLoadIndex;
                }
                list.remove(dupStoreIndex--);
            }
            ++dupStoreIndex;
        }
    }
}

