/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.reconstructor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.BIPush;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.SIPush;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.process.analyzer.util.ReconstructorUtil;

public final class InitArrayInstructionReconstructor {
    private InitArrayInstructionReconstructor() {
    }

    public static void reconstruct(List<Instruction> list) {
        int index = list.size() - 1;
        while (index >= 0) {
            DupStore dupStore;
            int opcode;
            Instruction i = list.get(index);
            if (i.getOpcode() == 264 && ((opcode = (dupStore = (DupStore)i).getObjectref().getOpcode()) == 188 || opcode == 189)) {
                InitArrayInstructionReconstructor.reconstructAInstruction(list, index, dupStore);
            }
            --index;
        }
    }

    private static void reconstructAInstruction(List<Instruction> list, int index, DupStore dupStore) {
        int length = list.size();
        int firstDupStoreIndex = index;
        DupStore lastDupStore = dupStore;
        Instruction lastAsi = null;
        int arrayIndex = 0;
        ArrayList<Instruction> values = new ArrayList<Instruction>();
        while (++index < length) {
            DupStore nextDupStore;
            ArrayStoreInstruction asi;
            Instruction i = list.get(index);
            if (i.getOpcode() != 83 && i.getOpcode() != 272 || (asi = (ArrayStoreInstruction)i).getArrayref().getOpcode() != 263 || asi.getArrayref().getOffset() != lastDupStore.getOffset()) break;
            lastAsi = asi;
            int indexOfArrayStoreInstruction = InitArrayInstructionReconstructor.getArrayIndex(asi.getIndexref());
            while (indexOfArrayStoreInstruction > arrayIndex) {
                values.add(new IConst(256, asi.getOffset(), asi.getLineNumber(), 0));
                ++arrayIndex;
            }
            values.add(asi.getValueref());
            ++arrayIndex;
            if (++index >= length || (i = list.get(index)).getOpcode() != 264 || (nextDupStore = (DupStore)i).getObjectref().getOpcode() != 263 || nextDupStore.getObjectref().getOffset() != lastDupStore.getOffset()) break;
            lastDupStore = nextDupStore;
        }
        if (lastAsi != null) {
            DupLoad dl;
            ArrayStoreInstruction asi;
            TernaryOperator fto;
            InitArrayInstruction iai = new InitArrayInstruction(283, lastAsi.getOffset(), dupStore.getLineNumber(), dupStore.getObjectref(), values);
            Instruction parent = ReconstructorUtil.replaceDupLoad(list, index, lastDupStore, iai);
            if (parent != null && parent.getOpcode() == 281 && (fto = (TernaryOperator)parent).getValue1() == iai && fto.getValue2().getOpcode() == 83 && (asi = (ArrayStoreInstruction)fto.getValue2()).getArrayref().getOpcode() == 263 && (dl = (DupLoad)asi.getArrayref()).getDupStore() == list.get(index)) {
                fto.setValue2(new InitArrayInstruction(283, asi.getOffset(), dl.getDupStore().getLineNumber(), dl.getDupStore().getObjectref(), Collections.singletonList(asi.getValueref())));
                ReconstructorUtil.replaceDupLoad(list, index, dl.getDupStore(), fto);
                list.remove(fto);
            }
            if (parent != null && parent.getOpcode() == 83) {
                if (list.get(index).getOpcode() == 281) {
                    fto = (TernaryOperator)list.get(index);
                    if (fto.getValue2().getOpcode() == 83 && (asi = (ArrayStoreInstruction)fto.getValue2()).getArrayref() == iai && asi.getIndexref().getOpcode() == 256) {
                        IConst iConst = (IConst)asi.getIndexref();
                        values.add(iConst.getValue(), asi.getValueref());
                        fto.setValue2(iai);
                        ReconstructorUtil.replaceDupLoad(list, index, lastDupStore, fto);
                        list.remove(index);
                    }
                } else {
                    iai.setOpcode(282);
                }
            }
            while (firstDupStoreIndex < index) {
                list.remove(--index);
            }
            if (iai.getNewArray().getOpcode() == 188) {
                NewArray na = (NewArray)iai.getNewArray();
                switch (na.getType()) {
                    case 4: {
                        InitArrayInstructionReconstructor.setContantTypes("Z", iai.getValues());
                        break;
                    }
                    case 5: {
                        InitArrayInstructionReconstructor.setContantTypes("C", iai.getValues());
                        break;
                    }
                    case 8: {
                        InitArrayInstructionReconstructor.setContantTypes("B", iai.getValues());
                        break;
                    }
                    case 9: {
                        InitArrayInstructionReconstructor.setContantTypes("S", iai.getValues());
                        break;
                    }
                    case 10: {
                        InitArrayInstructionReconstructor.setContantTypes("I", iai.getValues());
                    }
                }
            }
        }
    }

    private static void setContantTypes(String signature, List<Instruction> values) {
        for (Instruction value : values) {
            if (value.getOpcode() != 16 && value.getOpcode() != 256 && value.getOpcode() != 17) continue;
            ((IConst)value).setReturnedSignature(signature);
        }
    }

    private static int getArrayIndex(Instruction i) {
        return switch (i.getOpcode()) {
            case 256 -> ((IConst)i).getValue();
            case 16 -> ((BIPush)i).getValue();
            case 17 -> ((SIPush)i).getValue();
            default -> -1;
        };
    }
}

