/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.reconstructor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.Goto;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.instruction.bytecode.ComparisonInstructionAnalyzer;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;

public final class IfGotoToIfReconstructor {
    private IfGotoToIfReconstructor() {
    }

    public static void reconstruct(List<Instruction> list) {
        int length = list.size();
        if (length < 3) {
            return;
        }
        int index = length - 2;
        while (index-- > 0) {
            Instruction i = list.get(index);
            if (!ByteCodeUtil.isIfInstruction((int)i.getOpcode(), (boolean)true)) continue;
            BranchInstruction bi = (BranchInstruction)i;
            i = list.get(index + 1);
            if (i.getOpcode() != 167) continue;
            Goto g = (Goto)i;
            i = list.get(index + 2);
            int jumpOffset = bi.getJumpOffset();
            if (jumpOffset <= g.getOffset() || i.getOffset() < jumpOffset) continue;
            bi.setBranch(g.getJumpOffset() - bi.getOffset());
            ComparisonInstructionAnalyzer.inverseComparison(bi);
            list.remove(index + 1);
        }
    }
}

