/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast;

import java.util.List;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;

public class StoreReturnAnalyzer {
    private StoreReturnAnalyzer() {
    }

    public static void cleanup(List<Instruction> list, LocalVariables localVariables) {
        int index = list.size();
        while (index-- > 1) {
            ReturnInstruction ri;
            if (list.get(index).getOpcode() != 273 || (ri = (ReturnInstruction)list.get(index)).getLineNumber() == 0) continue;
            switch (ri.getValueref().getOpcode()) {
                case 25: {
                    if (list.get(index - 1).getOpcode() != 58) break;
                    index = StoreReturnAnalyzer.compact(list, localVariables, ri, index);
                    break;
                }
                case 268: {
                    if (list.get(index - 1).getOpcode() != 269) break;
                    index = StoreReturnAnalyzer.compact(list, localVariables, ri, index);
                    break;
                }
                case 21: {
                    if (list.get(index - 1).getOpcode() != 54) break;
                    index = StoreReturnAnalyzer.compact(list, localVariables, ri, index);
                }
            }
        }
    }

    private static int compact(List<Instruction> list, LocalVariables localVariables, ReturnInstruction ri, int index) {
        IndexInstruction load = (IndexInstruction)ri.getValueref();
        StoreInstruction store = (StoreInstruction)list.get(index - 1);
        if (load.getIndex() == store.getIndex() && load.getLineNumber() == store.getLineNumber()) {
            LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(store.getIndex(), store.getOffset());
            if (lv != null && lv.getStartPc() == store.getOffset() && lv.getStartPc() + lv.getLength() <= ri.getOffset()) {
                localVariables.removeLocalVariableWithIndexAndOffset(store.getIndex(), store.getOffset());
            }
            ri.setValueref(store.getValueref());
            list.remove(--index);
        }
        return index;
    }
}

