/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast;

import java.util.List;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Return;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTry;

public final class ReturnLineNumberAnalyzer {
    private ReturnLineNumberAnalyzer() {
    }

    public static void check(Method method) {
        int afterListLineNumber;
        List<Instruction> list = method.getFastNodes();
        int length = list.size();
        if (length > 1 && (afterListLineNumber = list.get(length - 1).getLineNumber()) != 0) {
            ReturnLineNumberAnalyzer.recursiveCheck(list, afterListLineNumber);
        }
    }

    private static void recursiveCheck(List<Instruction> list, int afterListLineNumber) {
        int index = list.size();
        while (index-- > 0) {
            Instruction instruction = list.get(index);
            switch (instruction.getOpcode()) {
                case 301: 
                case 302: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 319: {
                    List<Instruction> instructions = ((FastList)instruction).getInstructions();
                    if (instructions == null) break;
                    ReturnLineNumberAnalyzer.recursiveCheck(instructions, afterListLineNumber);
                    break;
                }
                case 307: {
                    FastTest2Lists ft2l = (FastTest2Lists)instruction;
                    ReturnLineNumberAnalyzer.recursiveCheck(ft2l.getInstructions(), afterListLineNumber);
                    ReturnLineNumberAnalyzer.recursiveCheck(ft2l.getInstructions2(), afterListLineNumber);
                    break;
                }
                case 314: 
                case 315: 
                case 316: {
                    FastSwitch.Pair[] pairs = ((FastSwitch)instruction).getPairs();
                    if (pairs == null) break;
                    int i = pairs.length - 1;
                    while (i >= 0) {
                        List<Instruction> instructions = pairs[i].getInstructions();
                        if (instructions != null) {
                            ReturnLineNumberAnalyzer.recursiveCheck(instructions, afterListLineNumber);
                            if (!instructions.isEmpty()) {
                                afterListLineNumber = instructions.get(0).getLineNumber();
                            }
                        }
                        --i;
                    }
                    break;
                }
                case 318: {
                    int i;
                    FastTry ft = (FastTry)instruction;
                    if (ft.getFinallyInstructions() != null) {
                        ReturnLineNumberAnalyzer.recursiveCheck(ft.getFinallyInstructions(), afterListLineNumber);
                        if (!ft.getFinallyInstructions().isEmpty()) {
                            afterListLineNumber = ft.getFinallyInstructions().get(0).getLineNumber();
                        }
                    }
                    if (ft.getCatches() != null) {
                        i = ft.getCatches().size() - 1;
                        while (i >= 0) {
                            List<Instruction> catchInstructions = ft.getCatches().get(i).instructions();
                            ReturnLineNumberAnalyzer.recursiveCheck(catchInstructions, afterListLineNumber);
                            if (!catchInstructions.isEmpty()) {
                                afterListLineNumber = catchInstructions.get(0).getLineNumber();
                            }
                            --i;
                        }
                    }
                    ReturnLineNumberAnalyzer.recursiveCheck(ft.getInstructions(), afterListLineNumber);
                    break;
                }
                case 177: {
                    Return r = (Return)instruction;
                    if (r.getLineNumber() <= afterListLineNumber) break;
                    r.setLineNumber(0);
                }
            }
            afterListLineNumber = instruction.getLineNumber();
        }
    }
}

