/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.AConstNull;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.AStore;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BIPush;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.ExceptionLoad;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Goto;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.IInc;
import jd.core.model.instruction.bytecode.instruction.ILoad;
import jd.core.model.instruction.bytecode.instruction.IStore;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.bytecode.instruction.Jsr;
import jd.core.model.instruction.bytecode.instruction.Ldc;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.Return;
import jd.core.model.instruction.bytecode.instruction.ReturnAddressLoad;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastForEach;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.model.reference.ReferenceMap;
import jd.core.process.analyzer.classfile.ClassFileAnalyzer;
import jd.core.process.analyzer.classfile.reconstructor.AssignmentOperatorReconstructor;
import jd.core.process.analyzer.classfile.visitor.CheckCastAndConvertInstructionVisitor;
import jd.core.process.analyzer.classfile.visitor.RemoveCheckCastVisitor;
import jd.core.process.analyzer.classfile.visitor.SearchInstructionByTypeVisitor;
import jd.core.process.analyzer.instruction.bytecode.ComparisonInstructionAnalyzer;
import jd.core.process.analyzer.instruction.bytecode.reconstructor.AssertInstructionReconstructor;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.process.analyzer.instruction.fast.FastCodeExceptionAnalyzer;
import jd.core.process.analyzer.instruction.fast.SingleDupLoadAnalyzer;
import jd.core.process.analyzer.instruction.fast.StoreReturnAnalyzer;
import jd.core.process.analyzer.instruction.fast.UnexpectedElementException;
import jd.core.process.analyzer.instruction.fast.UnexpectedInstructionException;
import jd.core.process.analyzer.instruction.fast.reconstructor.DotClass118BReconstructor;
import jd.core.process.analyzer.instruction.fast.reconstructor.EmptySynchronizedBlockReconstructor;
import jd.core.process.analyzer.instruction.fast.reconstructor.IfGotoToIfReconstructor;
import jd.core.process.analyzer.instruction.fast.reconstructor.InitArrayInstructionReconstructor;
import jd.core.process.analyzer.instruction.fast.reconstructor.RemoveDupConstantsAttributes;
import jd.core.process.analyzer.instruction.fast.reconstructor.TernaryOpInReturnReconstructor;
import jd.core.process.analyzer.instruction.fast.reconstructor.TernaryOpReconstructor;
import jd.core.process.analyzer.instruction.fast.visitor.CheckLocalVariableUsedVisitor;
import jd.core.process.analyzer.util.InstructionUtil;
import jd.core.process.layouter.visitor.MinMaxLineNumberVisitor;
import jd.core.util.IntSet;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public final class FastInstructionListBuilder {
    private static final boolean DECLARED = true;
    private static final boolean NOT_DECLARED = false;

    private FastInstructionListBuilder() {
    }

    public static void build(ReferenceMap referenceMap, ClassFile classFile, Method method, List<Instruction> list) {
        Instruction instruction;
        if (list == null || list.isEmpty()) {
            return;
        }
        List<FastCodeExceptionAnalyzer.FastCodeExcepcion> lfce = FastCodeExceptionAnalyzer.aggregateCodeExceptions(method, list);
        LocalVariables localVariables = method.getLocalVariables();
        if (localVariables != null) {
            FastInstructionListBuilder.initDelcarationFlags(localVariables);
        }
        IntSet offsetLabelSet = new IntSet();
        int returnOffset = -1;
        if (!list.isEmpty() && (instruction = list.get(list.size() - 1)).getOpcode() == 177) {
            returnOffset = instruction.getOffset();
        }
        if (lfce != null) {
            int i = lfce.size() - 1;
            while (i >= 0) {
                FastCodeExceptionAnalyzer.FastCodeExcepcion fce = lfce.get(i);
                if (fce.hasSynchronizedFlag()) {
                    FastInstructionListBuilder.createSynchronizedBlock(referenceMap, classFile, list, localVariables, fce);
                } else {
                    FastInstructionListBuilder.createFastTry(referenceMap, classFile, list, localVariables, fce, returnOffset);
                }
                --i;
            }
        }
        list.removeIf(instr -> instr.getOpcode() == 168);
        FastInstructionListBuilder.executeReconstructors(referenceMap, classFile, list, localVariables);
        FastInstructionListBuilder.analyzeList(classFile, method, list, localVariables, offsetLabelSet, -1, -1, -1, -1, -1, -1, returnOffset);
        if (localVariables != null) {
            localVariables.removeUselessLocalVariables();
        }
        FastInstructionListBuilder.manageRedeclaredVariables(list);
        if (!offsetLabelSet.isEmpty()) {
            FastInstructionListBuilder.addLabels(list, offsetLabelSet);
        }
    }

    private static void manageRedeclaredVariables(List<Instruction> list) {
        FastInstructionListBuilder.manageRedeclaredVariables(new HashSet<FastDeclaration>(), new HashSet<FastDeclaration>(), list);
    }

    private static void manageRedeclaredVariables(Set<FastDeclaration> outsideDeclarations, Set<FastDeclaration> insideDeclarations, List<Instruction> instructions) {
        if (instructions == null) {
            return;
        }
        int i = 0;
        while (i < instructions.size()) {
            Instruction instruction = instructions.get(i);
            if (instruction instanceof FastDeclaration var6_6) {
                if (insideDeclarations.contains(declaration) || outsideDeclarations.contains(declaration)) {
                    if (declaration.getInstruction() == null) {
                        instructions.remove(i);
                        --i;
                    } else {
                        var11_10 = declaration.getInstruction();
                        if (var11_10 instanceof StoreInstruction var9_8) {
                            instructions.set(i, (Instruction)si);
                        }
                    }
                } else {
                    insideDeclarations.add((FastDeclaration)declaration);
                }
            }
            if (!(blocks = FastInstructionListBuilder.getBlocks(instruction)).isEmpty()) {
                mergedDeclarations = FastInstructionListBuilder.mergeSets(outsideDeclarations, insideDeclarations);
                var11_10 = blocks.iterator();
                while (var11_10.hasNext()) {
                    List block = (List)var11_10.next();
                    FastInstructionListBuilder.manageRedeclaredVariables(new HashSet<FastDeclaration>((Collection<FastDeclaration>)mergedDeclarations), new HashSet<FastDeclaration>(), block);
                }
            }
            if (i + 1 < instructions.size() && (var11_10 = instruction) instanceof FastTest2Lists && (mergedDeclarations = (FastTest2Lists)var11_10) == (FastTest2Lists)var11_10) {
                List<Instruction> list1 = fastTest2Lists.getInstructions();
                List<Instruction> list2 = fastTest2Lists.getInstructions2();
                if (fastTest2Lists.isFirstInstructionInstanceOf(FastDeclaration.class) && !list2.isEmpty()) {
                    FastDeclaration fd1 = (FastDeclaration)list1.get(0);
                    Instruction instruction2 = list2.get(0);
                    if (instruction2 instanceof FastTestList var17_16) {
                        List<Instruction> subList = fastTestList.getInstructions();
                        if (fastTestList.isFirstInstructionInstanceOf(FastDeclaration.class) && fd1.equals(fd2 = (FastDeclaration)subList.get(0)) && (var24_21 = (nextInstruction = instructions.get(i + 1))) instanceof FastList && (var22_20 = (FastList)var24_21) == (FastList)var24_21) {
                            List<Instruction> nextSubList = fastList.getInstructions();
                            if (fastList.isFirstInstructionInstanceOf(FastDeclaration.class) && (fd3 = (FastDeclaration)nextSubList.get(0)).getInstruction() == null && fd1.equals(fd3)) {
                                list1.set(0, fd1.getInstruction());
                                subList.set(0, fd2.getInstruction());
                                nextSubList.remove(0);
                                instructions.add(i, new FastDeclaration(fd1.getLv().getStartPc(), 0, fd1.getLv(), null));
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private static List<List<Instruction>> getBlocks(Instruction instruction) {
        if (instruction instanceof FastTest2Lists var1_2) {
            return Arrays.asList(fastTest2Lists.getInstructions(), fastTest2Lists.getInstructions2());
        }
        if (instruction instanceof FastTestList var4_4) {
            return Collections.singletonList(fastTestList.getInstructions());
        }
        if (instruction instanceof FastTry var7_6) {
            ArrayList<List<Instruction>> instructions = new ArrayList<List<Instruction>>();
            instructions.add(fastTry.getInstructions());
            for (FastTry.FastCatch fastCatch : fastTry.getCatches()) {
                instructions.add(fastCatch.instructions());
            }
            if (fastTry.getFinallyInstructions() != null) {
                instructions.add(fastTry.getFinallyInstructions());
            }
            return instructions;
        }
        return Collections.emptyList();
    }

    private static <T> Set<T> mergeSets(Set<T> a, Set<T> b) {
        return Stream.concat(a.stream(), b.stream()).collect(Collectors.toSet());
    }

    private static void initDelcarationFlags(LocalVariables localVariables) {
        int nbrOfLocalVariables = localVariables.size();
        int indexOfFirstLocalVariable = localVariables.getIndexOfFirstLocalVariable();
        int i = 0;
        while (i < indexOfFirstLocalVariable && i < nbrOfLocalVariables) {
            localVariables.getLocalVariableAt(i).setDeclarationFlag(true);
            ++i;
        }
        int i2 = indexOfFirstLocalVariable;
        while (i2 < nbrOfLocalVariables) {
            LocalVariable lv;
            lv.setDeclarationFlag((lv = localVariables.getLocalVariableAt(i2)).isExceptionOrReturnAddress());
            ++i2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void createSynchronizedBlock(ReferenceMap referenceMap, ClassFile classFile, List<Instruction> list, LocalVariables localVariables, FastCodeExceptionAnalyzer.FastCodeExcepcion fce) {
        int index = InstructionUtil.getIndexForOffset(list, fce.getTryFromOffset());
        Instruction instruction = list.get(index);
        int synchronizedBlockJumpOffset = -1;
        if (fce.getType() == 2) {
            int fastSynchronizedOffset;
            int tryFromIndex = index;
            index = InstructionUtil.getIndexForOffset(list, fce.getFinallyFromOffset());
            int subProcedureOffset = list.get(index + 2).getOffset();
            while (index-- > tryFromIndex) {
                instruction = list.get(index);
                if (instruction.getOpcode() != 168) continue;
                int jumpOffset = ((Jsr)instruction).getJumpOffset();
                list.remove(index);
                if (jumpOffset == subProcedureOffset) break;
            }
            int finallyFromOffset = fce.getFinallyFromOffset();
            index = InstructionUtil.getIndexForOffset(list, fce.getAfterOffset());
            if (index == -1) {
                index = list.size() - 1;
                while (list.get(index).getOffset() >= finallyFromOffset) {
                    list.remove(index);
                    --index;
                }
            } else if (index > 0) {
                --index;
                while (list.get(index).getOffset() >= finallyFromOffset) {
                    list.remove(index);
                    --index;
                }
            }
            ArrayList<Instruction> instructions = new ArrayList<Instruction>();
            if (index > 0) {
                int tryFromOffset = fce.getTryFromOffset();
                while (list.get(index).getOffset() >= tryFromOffset) {
                    instructions.add(list.remove(index));
                    --index;
                }
            }
            if (!instructions.isEmpty()) {
                Instruction lastInstruction = (Instruction)instructions.get(0);
                fastSynchronizedOffset = lastInstruction.getOffset();
            } else {
                fastSynchronizedOffset = -1;
            }
            synchronizedBlockJumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(instructions, 0, instructions.size(), fce.getTryFromOffset(), fce.getAfterOffset());
            Collections.reverse(instructions);
            FastInstructionListBuilder.executeReconstructors(referenceMap, classFile, instructions, localVariables);
            MonitorEnter menter = (MonitorEnter)list.remove(index);
            --index;
            int fastSynchronizedLineNumber = menter.getLineNumber();
            if (menter.getObjectref().getOpcode() != 25) {
                throw new UnexpectedInstructionException();
            }
            int varMonitorIndex = ((IndexInstruction)menter.getObjectref()).getIndex();
            localVariables.removeLocalVariableWithIndexAndOffset(varMonitorIndex, menter.getOffset());
            AStore astore = (AStore)list.get(index);
            Instruction monitor = astore.getValueref();
            int branch = 1;
            if (fastSynchronizedOffset != -1 && synchronizedBlockJumpOffset != -1) {
                branch = synchronizedBlockJumpOffset - fastSynchronizedOffset;
            }
            FastSynchronized fastSynchronized = new FastSynchronized(319, fastSynchronizedOffset, fastSynchronizedLineNumber, branch, instructions);
            fastSynchronized.setMonitor(monitor);
            list.set(index, fastSynchronized);
        } else if (fce.getType() == 6) {
            ArrayList<Instruction> instructions = new ArrayList<Instruction>();
            instruction = list.remove(index);
            int fastSynchronizedOffset = instruction.getOffset();
            instructions.add(instruction);
            synchronizedBlockJumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(instructions, 0, instructions.size(), fce.getTryFromOffset(), fce.getAfterOffset());
            MonitorEnter menter = (MonitorEnter)list.remove(index - 1);
            AStore astore = (AStore)list.get(index - 2);
            Instruction monitor = astore.getValueref();
            int varMonitorIndex2 = astore.getIndex();
            localVariables.removeLocalVariableWithIndexAndOffset(varMonitorIndex2, menter.getOffset());
            int branch = 1;
            if (synchronizedBlockJumpOffset != -1) {
                branch = synchronizedBlockJumpOffset - fastSynchronizedOffset;
            }
            FastSynchronized fastSynchronized = new FastSynchronized(319, fastSynchronizedOffset, menter.getLineNumber(), branch, instructions);
            fastSynchronized.setMonitor(monitor);
            list.set(index - 2, fastSynchronized);
        } else if (instruction.getOpcode() == 195) {
            if (list.get(--index).getOpcode() == 194) {
                Instruction monitor;
                MonitorEnter me = (MonitorEnter)list.remove(index);
                if (me.getObjectref().getOpcode() == 265) {
                    ALoad branch;
                    Instruction varMonitorIndex;
                    AssignmentInstruction ai = (AssignmentInstruction)me.getObjectref();
                    Instruction varMonitorIndex2 = ai.getValue1();
                    if (varMonitorIndex2 instanceof AStore astore) {
                        localVariables.removeLocalVariableWithIndexAndOffset(astore.getIndex(), astore.getOffset());
                    }
                    if ((varMonitorIndex = ai.getValue1()) instanceof ALoad && (branch = (ALoad)varMonitorIndex) == (ALoad)varMonitorIndex) {
                        void aload;
                        localVariables.removeLocalVariableWithIndexAndOffset(aload.getIndex(), aload.getOffset());
                    }
                    monitor = ai.getValue2();
                    list.remove(index);
                } else {
                    list.remove(index);
                    AStore astore = (AStore)list.remove(--index);
                    monitor = astore.getValueref();
                    localVariables.removeLocalVariableWithIndexAndOffset(astore.getIndex(), astore.getOffset());
                }
                ArrayList<Instruction> instructions = new ArrayList<Instruction>();
                Instruction gi = list.remove(index);
                if (gi.getOpcode() != 167 || ((Goto)gi).getJumpOffset() != fce.getAfterOffset()) {
                    instructions.add(gi);
                }
                if (list.get(index).getOpcode() == 58) {
                    list.remove(index);
                }
                Instruction monitorexit = list.remove(index);
                FastInstructionListBuilder.executeReconstructors(referenceMap, classFile, instructions, localVariables);
                FastSynchronized fastSynchronized = new FastSynchronized(319, monitorexit.getOffset(), instruction.getLineNumber(), 1, instructions);
                fastSynchronized.setMonitor(monitor);
                list.set(index, fastSynchronized);
            } else {
                LoadInstruction li;
                MonitorExit mexit;
                int varMonitorIndex;
                MonitorEnter menter;
                list.remove(index);
                list.remove(index);
                list.remove(index);
                instruction = list.remove(index);
                Instruction monitor = switch (instruction.getOpcode()) {
                    case 58 -> {
                        menter = (MonitorEnter)list.remove(index);
                        AStore astore = (AStore)instruction;
                        varMonitorIndex = astore.getIndex();
                        yield astore.getValueref();
                    }
                    case 194 -> {
                        menter = (MonitorEnter)instruction;
                        AssignmentInstruction ai = (AssignmentInstruction)menter.getObjectref();
                        IndexInstruction indexInstruction = (IndexInstruction)ai.getValue1();
                        varMonitorIndex = indexInstruction.getIndex();
                        yield ai.getValue2();
                    }
                    default -> throw new UnexpectedInstructionException();
                };
                localVariables.removeLocalVariableWithIndexAndOffset(varMonitorIndex, menter.getOffset());
                ArrayList<Instruction> instructions = new ArrayList<Instruction>();
                while ((instruction = list.get(index)).getOpcode() != 195 || (mexit = (MonitorExit)instruction).getObjectref().getOpcode() != 25 || (li = (LoadInstruction)mexit.getObjectref()).getIndex() != varMonitorIndex) {
                    instructions.add(list.remove(index));
                }
                if (index + 1 < list.size() && list.get(index + 1).getOpcode() == 273) {
                    Instruction monitorexit = list.get(index);
                    Instruction value = ((ReturnInstruction)list.get(index + 1)).getValueref();
                    if (monitorexit.getOffset() > value.getOffset()) {
                        instructions.add(list.remove(index + 1));
                    }
                }
                FastInstructionListBuilder.executeReconstructors(referenceMap, classFile, instructions, localVariables);
                synchronizedBlockJumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(instructions, 0, instructions.size(), fce.getTryFromOffset(), fce.getAfterOffset());
                int branch = 1;
                if (synchronizedBlockJumpOffset != -1) {
                    branch = synchronizedBlockJumpOffset - instruction.getOffset();
                }
                FastSynchronized fastSynchronized = new FastSynchronized(319, instruction.getOffset(), menter.getLineNumber(), branch, instructions);
                fastSynchronized.setMonitor(monitor);
                list.set(index, fastSynchronized);
            }
        } else {
            AStore astore;
            index = fce.getAfterOffset() > list.get(list.size() - 1).getOffset() ? list.size() : InstructionUtil.getIndexForOffset(list, fce.getAfterOffset());
            int lastOffset = list.get(--index).getOffset();
            Instruction i = null;
            int finallyFromOffset = fce.getFinallyFromOffset();
            while (list.get(index).getOffset() >= finallyFromOffset) {
                i = list.remove(index);
                --index;
            }
            int exceptionLoadIndex = -1;
            if (i != null && i.getOpcode() == 58 && (astore = (AStore)i).getValueref().getOpcode() == 270) {
                exceptionLoadIndex = astore.getIndex();
            }
            ArrayList<Instruction> instructions = new ArrayList<Instruction>();
            i = null;
            if (index > 0) {
                int tryFromOffset = fce.getTryFromOffset();
                i = list.get(index);
                if (i.getOffset() >= tryFromOffset) {
                    instructions.add(i);
                    while (index-- > 0) {
                        i = list.get(index);
                        if (i.getOffset() < tryFromOffset) break;
                        list.remove(index + 1);
                        instructions.add(i);
                    }
                    list.set(index + 1, null);
                }
            }
            synchronizedBlockJumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(instructions, 0, instructions.size(), fce.getTryFromOffset(), fce.getAfterOffset());
            Collections.reverse(instructions);
            int lineNumber = i == null ? 0 : i.getLineNumber();
            int length = instructions.size();
            int monitorLocalVariableIndex = FastInstructionListBuilder.getMonitorLocalVariableIndex(list, index);
            if (length > 0) {
                Instruction lastInstruction = (Instruction)instructions.get(length - 1);
                if (lastInstruction.getOpcode() == 167) {
                    instructions.remove(--length);
                } else if (lastInstruction.getOpcode() == 273) {
                    --length;
                }
                FastInstructionListBuilder.removeAllMonitorExitInstructions(instructions, length, monitorLocalVariableIndex);
                int lastIndex = list.size() - 1;
                i = list.get(lastIndex);
                if (i != null && i.getOpcode() == 191) {
                    ALoad aload;
                    AThrow at = (AThrow)list.get(lastIndex);
                    if (at.getValue().getOpcode() == 270) {
                        ExceptionLoad el = (ExceptionLoad)at.getValue();
                        if (el.getExceptionNameIndex() == 0) {
                            list.remove(lastIndex);
                        }
                    } else if (at.getValue().getOpcode() == 25 && (aload = (ALoad)at.getValue()).getIndex() == exceptionLoadIndex) {
                        list.remove(lastIndex);
                    }
                }
            }
            if (monitorLocalVariableIndex != -1) {
                MonitorEnter menter = (MonitorEnter)list.get(index);
                localVariables.removeLocalVariableWithIndexAndOffset(monitorLocalVariableIndex, menter.getOffset());
            }
            int branch = 1;
            if (synchronizedBlockJumpOffset != -1) {
                branch = synchronizedBlockJumpOffset - lastOffset;
            }
            FastSynchronized fastSynchronized = new FastSynchronized(319, lastOffset, lineNumber, branch, instructions);
            FastInstructionListBuilder.executeReconstructors(referenceMap, classFile, instructions, localVariables);
            list.set(index + 1, fastSynchronized);
            fastSynchronized.setMonitor(FastInstructionListBuilder.formatAndExtractMonitor(list, index));
        }
    }

    private static Instruction formatAndExtractMonitor(List<Instruction> list, int index) {
        MonitorEnter menter = (MonitorEnter)list.remove(index);
        --index;
        switch (menter.getObjectref().getOpcode()) {
            case 265: {
                return ((AssignmentInstruction)menter.getObjectref()).getValue2();
            }
            case 263: {
                list.remove(index);
                DupStore dupstore = (DupStore)list.remove(--index);
                return dupstore.getObjectref();
            }
            case 25: {
                AStore astore = (AStore)list.remove(index);
                return astore.getValueref();
            }
        }
        return null;
    }

    private static void removeAllMonitorExitInstructions(List<Instruction> instructions, int length, int monitorLocalVariableIndex) {
        int index = length;
        block5: while (index-- > 0) {
            Instruction instruction = instructions.get(index);
            switch (instruction.getOpcode()) {
                case 195: {
                    int aloadIndex;
                    MonitorExit mexit = (MonitorExit)instruction;
                    if (mexit.getObjectref().getOpcode() != 25 || (aloadIndex = ((ALoad)mexit.getObjectref()).getIndex()) != monitorLocalVariableIndex) continue block5;
                    instructions.remove(index);
                    break;
                }
                case 318: {
                    FastTry ft = (FastTry)instruction;
                    FastInstructionListBuilder.removeAllMonitorExitInstructions(ft.getInstructions(), ft.getInstructions().size(), monitorLocalVariableIndex);
                    int i = ft.getCatches().size();
                    while (i-- > 0) {
                        FastTry.FastCatch fc = ft.getCatches().get(i);
                        FastInstructionListBuilder.removeAllMonitorExitInstructions(fc.instructions(), fc.instructions().size(), monitorLocalVariableIndex);
                    }
                    if (ft.getFinallyInstructions() == null) break;
                    FastInstructionListBuilder.removeAllMonitorExitInstructions(ft.getFinallyInstructions(), ft.getFinallyInstructions().size(), monitorLocalVariableIndex);
                    break;
                }
                case 319: {
                    FastSynchronized fsy = (FastSynchronized)instruction;
                    FastInstructionListBuilder.removeAllMonitorExitInstructions(fsy.getInstructions(), fsy.getInstructions().size(), monitorLocalVariableIndex);
                    break;
                }
            }
        }
    }

    private static int getMonitorLocalVariableIndex(List<Instruction> list, int index) {
        MonitorEnter menter = (MonitorEnter)list.get(index);
        switch (menter.getObjectref().getOpcode()) {
            case 263: {
                return ((AStore)list.get(index - 1)).getIndex();
            }
            case 25: {
                return ((ALoad)menter.getObjectref()).getIndex();
            }
            case 265: {
                Instruction i = ((AssignmentInstruction)menter.getObjectref()).getValue1();
                if (i.getOpcode() != 25) break;
                return ((ALoad)i).getIndex();
            }
        }
        return -1;
    }

    private static void createFastTry(ReferenceMap referenceMap, ClassFile classFile, List<Instruction> list, LocalVariables localVariables, FastCodeExceptionAnalyzer.FastCodeExcepcion fce, int returnOffset) {
        int afterListOffset = fce.getAfterOffset();
        int tryJumpOffset = -1;
        int lastIndex = list.size() - 1;
        if (afterListOffset == -1 || afterListOffset > list.get(lastIndex).getOffset()) {
            index = lastIndex;
        } else {
            index = InstructionUtil.getIndexForOffset(list, afterListOffset);
            assert (index != -1);
            --index;
        }
        int lastOffset = list.get(index).getOffset();
        ArrayList<Instruction> finallyInstructions = null;
        if (fce.getFinallyFromOffset() > 0) {
            int finallyFromOffset = fce.getFinallyFromOffset();
            finallyInstructions = new ArrayList<Instruction>();
            while (list.get(index).getOffset() >= finallyFromOffset) {
                finallyInstructions.add(list.remove(index));
                --index;
            }
            Validate.notEmpty(finallyInstructions, (String)"Unexpected structure for finally block", (Object[])new Object[0]);
            Collections.reverse(finallyInstructions);
            int firstOffset = ((Instruction)finallyInstructions.get(0)).getOffset();
            int minimalJumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(finallyInstructions, 0, finallyInstructions.size(), firstOffset, afterListOffset);
            afterListOffset = firstOffset;
            if (minimalJumpOffset != -1 && afterListOffset > minimalJumpOffset) {
                afterListOffset = minimalJumpOffset;
            }
        }
        ArrayList<FastTry.FastCatch> catches = null;
        if (fce.getCatches() != null) {
            int i = fce.getCatches().size();
            catches = new ArrayList<FastTry.FastCatch>(i);
            while (i-- > 0) {
                FastCodeExceptionAnalyzer.FastCodeExceptionCatch fcec = fce.getCatches().get(i);
                int fromOffset = fcec.getFromOffset();
                ArrayList<Instruction> instructions = new ArrayList<Instruction>();
                while (list.get(index).getOffset() >= fromOffset) {
                    instructions.add(list.remove(index));
                    if (index == 0) break;
                    --index;
                }
                int instructionsLength = instructions.size();
                Validate.exclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)instructionsLength, (String)"Empty catch block");
                Instruction lastInstruction = (Instruction)instructions.get(0);
                int tryJumpOffsetTmp = FastInstructionListBuilder.searchMinusJumpOffset(instructions, 0, instructionsLength, fce.getTryFromOffset(), fce.getAfterOffset());
                if (tryJumpOffsetTmp != -1 && (tryJumpOffset == -1 || tryJumpOffset > tryJumpOffsetTmp)) {
                    tryJumpOffset = tryJumpOffsetTmp;
                }
                Collections.reverse(instructions);
                ExceptionLoad el = FastInstructionListBuilder.searchExceptionLoadInstruction(instructions);
                if (el == null) continue;
                int offset = lastInstruction.getOffset();
                catches.add(0, new FastTry.FastCatch(el.getOffset(), fcec.getType(), fcec.getOtherTypes(), el.getIndex(), instructions));
                int firstOffset = ((Instruction)instructions.get(0)).getOffset();
                int minimalJumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(instructions, 0, instructions.size(), firstOffset, offset);
                if (afterListOffset > firstOffset) {
                    afterListOffset = firstOffset;
                }
                if (minimalJumpOffset == -1 || afterListOffset <= minimalJumpOffset) continue;
                afterListOffset = minimalJumpOffset;
            }
        }
        ArrayList<Instruction> tryInstructions = new ArrayList<Instruction>();
        if (fce.getTryToOffset() < afterListOffset) {
            index = FastCodeExceptionAnalyzer.computeTryToIndex(list, fce, index, afterListOffset);
        }
        int tryFromOffset = fce.getTryFromOffset();
        Instruction i = list.get(index);
        int outOfTryIndex = -1;
        if (i.getOffset() >= tryFromOffset) {
            if (i.getOffset() < afterListOffset) {
                tryInstructions.add(i);
            } else {
                outOfTryIndex = index;
            }
            while (index-- > 0) {
                i = list.get(index);
                if (i.getOffset() < tryFromOffset) break;
                if (index + 1 != outOfTryIndex) {
                    list.remove(index + 1);
                }
                tryInstructions.add(i);
            }
            list.set(index + 1, null);
        }
        if ((tryJumpOffsetTmp = FastInstructionListBuilder.searchMinusJumpOffset(tryInstructions, 0, tryInstructions.size(), fce.getTryFromOffset(), fce.getTryToOffset())) != -1 && (tryJumpOffset == -1 || tryJumpOffset > tryJumpOffsetTmp)) {
            tryJumpOffset = tryJumpOffsetTmp;
        }
        Collections.reverse(tryInstructions);
        int lineNumber = ((Instruction)tryInstructions.get(0)).getLineNumber();
        if (tryJumpOffset == -1) {
            tryJumpOffset = lastOffset + 1;
        }
        FastTry fastTry = new FastTry(318, lastOffset, lineNumber, tryJumpOffset - lastOffset, tryInstructions, catches, finallyInstructions);
        FastCodeExceptionAnalyzer.formatFastTry(localVariables, fce, fastTry, returnOffset);
        if (classFile.getMajorVersion() == 45 && tryInstructions.size() >= 4 && (last = (Instruction)tryInstructions.get(length = tryInstructions.size() - 1)).getOpcode() == 169) {
            tryInstructions.remove(length);
            last = (Instruction)tryInstructions.get(--length);
            if (last.getOpcode() == 195) {
                last = (Instruction)tryInstructions.get(--length);
            }
            if (last instanceof AStore firstOffset && astore.getValueref() instanceof ReturnAddressLoad) {
                tryInstructions.remove(length);
                last = (Instruction)tryInstructions.get(--length);
            }
            if ((var27_40 = last) instanceof AThrow var25_41 && ((AThrow)((Object)athrow)).getValue() instanceof ExceptionLoad && (exceptionLoad = (ExceptionLoad)((AThrow)last).getValue()).getExceptionNameIndex() == 0) {
                tryInstructions.remove(length);
            }
        }
        FastInstructionListBuilder.executeReconstructors(referenceMap, classFile, tryInstructions, localVariables);
        if (catches != null) {
            int length = catches.size();
            int j = 0;
            while (j < length) {
                FastTry.FastCatch fc = (FastTry.FastCatch)catches.get(j);
                List<Instruction> catchInstructions = fc.instructions();
                FastInstructionListBuilder.executeReconstructors(referenceMap, classFile, catchInstructions, localVariables);
                ++j;
            }
            fastTry.removeOutOfBounds();
        }
        if (finallyInstructions != null) {
            FastInstructionListBuilder.executeReconstructors(referenceMap, classFile, finallyInstructions, localVariables);
        }
        ConstantPool cp = classFile.getConstantPool();
        boolean removedTryResourcesPattern = fastTry.removeTryResourcesPattern(localVariables, cp, finallyInstructions);
        boolean processTryResources = fastTry.processTryResources();
        if (index >= 1 && (removedTryResourcesPattern |= fastTry.removeTryResourcesPattern(localVariables, cp, tryInstructions)) && !processTryResources && !fastTry.hasCatch() && !fastTry.hasFinally()) {
            Instruction beforeTry1 = list.get(index - 1);
            Instruction beforeTry2 = list.get(index);
            Instruction instruction = beforeTry1;
            if (instruction instanceof AStore && (athrow = (AStore)instruction) == (AStore)instruction && (var30_45 = beforeTry2) instanceof AStore && (var27_40 = (AStore)var30_45) == (AStore)var30_45) {
                LocalVariable lv1 = localVariables.getLocalVariableWithIndexAndOffset(beforeTryAstore1.getIndex(), beforeTryAstore1.getOffset());
                LocalVariable lv2 = localVariables.getLocalVariableWithIndexAndOffset(beforeTryAstore2.getIndex(), beforeTryAstore2.getOffset());
                if (lv2.isThrowableFromTryResources() && beforeTryAstore2.getValueref() instanceof AConstNull && lv1.getTryResources() == fastTry) {
                    list.set(index - 1, null);
                    list.set(index, null);
                    fastTry.addResource((StoreInstruction)beforeTryAstore1, lv1);
                    if (lv2.isExceptionOrThrowable(cp)) {
                        lv2.setToBeRemoved(true);
                        if (index >= 2 && (var35_48 = list.get(index - 2)) instanceof AStore && (var33_49 = (AStore)var35_48) == (AStore)var35_48 && (lv0 = localVariables.getLocalVariableWithIndexAndOffset(aStore.getIndex(), aStore.getOffset())).isExceptionOrThrowable(cp)) {
                            lv0.setToBeRemoved(true);
                            list.set(index - 2, null);
                        }
                    }
                }
            }
        }
        ArrayList<Instruction> instructionsToMove = new ArrayList<Instruction>();
        if (fastTry.hasFinally() && (minMaxLineNumber = MinMaxLineNumberVisitor.visit(finallyInstructions)).isValid()) {
            for (Instruction tryInstruction : fastTry.getInstructions()) {
                if (tryInstruction.getLineNumber() <= minMaxLineNumber.maxLineNumber()) continue;
                instructionsToMove.add(tryInstruction);
            }
            fastTry.removeOutOfBoundsInstructions(minMaxLineNumber.minLineNumber());
        }
        list.set(index + 1, fastTry);
        if (index >= 0 && (var27_40 = (instruction = list.get(index))) instanceof AStore && (tryInstruction = (AStore)var27_40) == (AStore)var27_40) {
            boolean removeNull = false;
            if (astore.getValueref() instanceof AConstNull && index > 0 && list.get(index - 1) instanceof AStore) {
                astore = (AStore)list.get(index - 1);
                removeNull = true;
            }
            if ((lv = localVariables.getLocalVariableWithIndexAndOffset(astore.getIndex(), astore.getOffset())) != null && lv.getTryResources() == fastTry) {
                fastTry.addResource(astore, lv);
                list.remove(index);
                if (removeNull) {
                    list.remove(index - 1);
                }
            }
        }
        list.removeIf(Objects::isNull);
        if (!instructionsToMove.isEmpty()) {
            list.addAll(index + 2, instructionsToMove);
        }
    }

    private static ExceptionLoad searchExceptionLoadInstruction(List<Instruction> instructions) {
        SearchInstructionByTypeVisitor<ExceptionLoad> visitor = new SearchInstructionByTypeVisitor<ExceptionLoad>(ExceptionLoad.class);
        for (Instruction instruction : instructions) {
            if ((instruction = visitor.visit(instruction)) == null) continue;
            return (ExceptionLoad)instruction;
        }
        return null;
    }

    private static void executeReconstructors(ReferenceMap referenceMap, ClassFile classFile, List<Instruction> list, LocalVariables localVariables) {
        EmptySynchronizedBlockReconstructor.reconstruct(localVariables, list);
        DotClass118BReconstructor.reconstruct(referenceMap, classFile, list);
        IfGotoToIfReconstructor.reconstruct(list);
        ComparisonInstructionAnalyzer.aggregate(list);
        AssertInstructionReconstructor.reconstruct(classFile, list);
        TernaryOpReconstructor.reconstruct(list);
        InitArrayInstructionReconstructor.reconstruct(list);
        AssignmentOperatorReconstructor.reconstruct(list);
        RemoveDupConstantsAttributes.reconstruct(list);
        ClassFileAnalyzer.replaceStringBufferAndStringBuilder(classFile, localVariables, list);
    }

    private static void removeNoJumpGotoInstruction(List<Instruction> list, int afterListOffset) {
        int branch;
        int index = list.size();
        if (index == 0) {
            return;
        }
        Instruction instruction = list.get(--index);
        int lastInstructionOffset = instruction.getOffset();
        if (instruction.getOpcode() == 167 && (branch = ((Goto)instruction).getBranch()) >= 0 && instruction.getOffset() + branch <= afterListOffset) {
            list.remove(index);
        }
        while (index-- > 0) {
            instruction = list.get(index);
            if (instruction.getOpcode() == 167 && (branch = ((Goto)instruction).getBranch()) >= 0 && instruction.getOffset() + branch <= lastInstructionOffset) {
                list.remove(index);
            }
            lastInstructionOffset = instruction.getOffset();
        }
    }

    private static void removeSyntheticReturn(List<Instruction> list, int afterListOffset, int returnOffset) {
        if (afterListOffset == returnOffset) {
            int index = list.size();
            if (index == 1) {
                FastInstructionListBuilder.removeSyntheticReturn(list, --index);
            } else if (index-- > 1 && list.get(index).getLineNumber() < list.get(index - 1).getLineNumber()) {
                FastInstructionListBuilder.removeSyntheticReturn(list, index);
            }
        }
    }

    private static void removeSyntheticReturn(List<Instruction> list, int index) {
        FastLabel fl;
        int iOpCode = list.get(index).getOpcode();
        if (iOpCode == 177) {
            list.remove(index);
        } else if (iOpCode == 320 && (fl = (FastLabel)list.get(index)).getInstruction().getOpcode() == 177) {
            fl.setInstruction(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addCastInstructionOnReturn(ClassFile classFile, Method method, List<Instruction> list) {
        ConstantPool constants = classFile.getConstantPool();
        LocalVariables localVariables = method.getLocalVariables();
        int signatureIndex = method.getSignatureIndex();
        String signature = constants.getConstantUtf8(signatureIndex);
        String methodReturnedSignature = SignatureUtil.getMethodReturnedSignature(signature);
        int index = list.size();
        while (index-- > 0) {
            void cc;
            CheckCast checkCast;
            Instruction valueref;
            Instruction instruction;
            Instruction instruction2 = list.get(index);
            if (instruction2.getOpcode() != 273) continue;
            TypeMaker typeMaker = new TypeMaker(classFile.getLoader());
            Type methodReturnedType = typeMaker.makeFromSignature(methodReturnedSignature);
            ReturnInstruction ri = (ReturnInstruction)instruction2;
            String returnedSignature = ri.getValueref().getReturnedSignature(classFile, localVariables);
            int methodReturnedSignatureIndex = constants.addConstantUtf8(methodReturnedSignature);
            CheckCastAndConvertInstructionVisitor.addOrUpdateCast(localVariables, classFile, ri, methodReturnedSignatureIndex);
            RemoveCheckCastVisitor visitor = new RemoveCheckCastVisitor(classFile, localVariables, typeMaker, methodReturnedType);
            visitor.visit(ri.getValueref());
            if (!"[Ljava/lang/Object;".equals(returnedSignature) || !methodReturnedType.isGenericType() || !((instruction = (valueref = ri.getValueref())) instanceof CheckCast) || (checkCast = (CheckCast)instruction) != (CheckCast)instruction) continue;
            cc.setIndex(methodReturnedSignatureIndex);
        }
    }

    private static Set<FastDeclaration> analyzeList(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int beforeListOffset, int afterListOffset, int breakOffset, int returnOffset, boolean addDeclarations) {
        FastInstructionListBuilder.createLoops(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, beforeListOffset, afterListOffset, returnOffset);
        FastInstructionListBuilder.createSwitch(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, returnOffset);
        FastInstructionListBuilder.analyzeTryAndSynchronized(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeListOffset, afterListOffset, breakOffset, returnOffset);
        TernaryOpInReturnReconstructor.reconstruct(list);
        FastInstructionListBuilder.createContinue(list, beforeLoopEntryOffset, loopEntryOffset, returnOffset);
        FastInstructionListBuilder.createIfElse(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, breakOffset, returnOffset);
        FastInstructionListBuilder.removeNopGoto(list);
        StoreReturnAnalyzer.cleanup(list, localVariables);
        Set<FastDeclaration> outerDeclarations = FastInstructionListBuilder.addDeclarations(list, localVariables, beforeListOffset, addDeclarations, classFile, method);
        FastInstructionListBuilder.removeNoJumpGotoInstruction(list, afterListOffset);
        FastInstructionListBuilder.createBreakAndContinue(classFile, method, list, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, breakOffset, returnOffset);
        SingleDupLoadAnalyzer.cleanup(list);
        FastInstructionListBuilder.removeSyntheticReturn(list, afterListOffset, returnOffset);
        FastInstructionListBuilder.addCastInstructionOnReturn(classFile, method, list);
        return outerDeclarations;
    }

    private static void analyzeList(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int beforeListOffset, int afterListOffset, int breakOffset, int returnOffset) {
        FastInstructionListBuilder.analyzeList(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeListOffset, afterListOffset, breakOffset, returnOffset, true);
    }

    private static void analyzeTryAndSynchronized(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int beforeListOffset, int afterListOffset, int breakOffset, int returnOffset) {
        int index = list.size();
        while (index-- > 0) {
            Instruction instruction = list.get(index);
            switch (instruction.getOpcode()) {
                case 318: {
                    FastTry ft = (FastTry)instruction;
                    int tmpBeforeListOffset = index > 0 ? list.get(index - 1).getOffset() : beforeListOffset;
                    Set<FastDeclaration> outerDeclarations = FastInstructionListBuilder.analyzeList(classFile, method, ft.getInstructions(), localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, tmpBeforeListOffset, afterListOffset, breakOffset, returnOffset, false);
                    FastInstructionListBuilder.declareOuterVariables(list, ft.getInstructions(), localVariables, index, outerDeclarations);
                    for (FastTry.FastCatch fastCatch : ft.getCatches()) {
                        List<Instruction> catchInstructions = fastCatch.instructions();
                        outerDeclarations = FastInstructionListBuilder.analyzeList(classFile, method, catchInstructions, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, tmpBeforeListOffset, afterListOffset, breakOffset, returnOffset, false);
                        FastInstructionListBuilder.declareOuterVariables(list, catchInstructions, localVariables, index, outerDeclarations);
                    }
                    if (ft.getFinallyInstructions() == null) break;
                    FastInstructionListBuilder.analyzeList(classFile, method, ft.getFinallyInstructions(), localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, tmpBeforeListOffset, afterListOffset, breakOffset, returnOffset);
                    break;
                }
                case 319: {
                    FastSynchronized fs = (FastSynchronized)instruction;
                    int tmpBeforeListOffset = index > 0 ? list.get(index - 1).getOffset() : beforeListOffset;
                    FastInstructionListBuilder.analyzeList(classFile, method, fs.getInstructions(), localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, tmpBeforeListOffset, afterListOffset, breakOffset, returnOffset);
                    break;
                }
                case 194: 
                case 195: {
                    list.remove(index);
                }
            }
            afterListOffset = instruction.getOffset();
        }
    }

    private static void declareOuterVariables(List<Instruction> list, List<Instruction> sublist, LocalVariables localVariables, int index, Set<FastDeclaration> outerDeclarations) {
        for (FastDeclaration outerDeclaration : outerDeclarations) {
            LocalVariable lv = outerDeclaration.getLv();
            if (CheckLocalVariableUsedVisitor.checkNameUsed(localVariables, lv.getNameIndex(), list.subList(index + 1, list.size()))) {
                if (outerDeclaration.getInstruction() != null) {
                    outerDeclaration.setInstruction(null);
                    outerDeclaration.setLineNumber(0);
                }
                FastInstructionListBuilder.insertNewDeclaration(localVariables, list, -1, outerDeclaration, true, outerDeclarations);
                continue;
            }
            int indexForNewDeclaration = Optional.ofNullable(outerDeclaration.getInstruction()).map(sublist::indexOf).orElse(-1);
            FastInstructionListBuilder.insertNewDeclaration(localVariables, sublist, indexForNewDeclaration, outerDeclaration, true, outerDeclarations);
        }
    }

    private static void removeNopGoto(List<Instruction> list) {
        int length = list.size();
        if (length > 1) {
            int nextOffset = list.get(length - 1).getOffset();
            int index = length - 2;
            while (index >= 0) {
                Goto gi;
                Instruction instruction = list.get(index);
                if (instruction.getOpcode() == 167 && (gi = (Goto)instruction).getBranch() >= 0 && gi.getJumpOffset() <= nextOffset) {
                    list.remove(index);
                }
                nextOffset = instruction.getOffset();
                --index;
            }
        }
    }

    private static Set<FastDeclaration> addDeclarations(List<Instruction> list, LocalVariables localVariables, int beforeListOffset, boolean addDeclarations, ClassFile classFile, Method method) {
        HashSet<FastDeclaration> outerDeclarations = new HashSet<FastDeclaration>();
        if (!list.isEmpty()) {
            int lastOffset = list.get(list.size() - 1).getOffset();
            int i = 0;
            while (i < list.size()) {
                Instruction instruction = list.get(i);
                if (instruction instanceof StoreInstruction var10_11 && FastInstructionListBuilder.isUndeclared((LocalVariable)(lv = localVariables.getLocalVariableWithIndexAndOffset(si.getIndex(), si.getOffset()))) && beforeListOffset < ((LocalVariable)lv).getStartPc() && (((LocalVariable)lv).getStartPc() + ((LocalVariable)lv).getLength() - 1 <= lastOffset || method.getNameIndex() == classFile.getConstantPool().getClassConstructorIndex())) {
                    FastDeclaration fastDeclaration = new FastDeclaration(si.getOffset(), si.getLineNumber(), (LocalVariable)lv, (Instruction)si);
                    FastInstructionListBuilder.insertNewDeclaration(localVariables, list, i, fastDeclaration, addDeclarations, outerDeclarations);
                    FastInstructionListBuilder.updateNewAndInitArrayInstruction((Instruction)si);
                }
                if ((var17_16 = instruction) instanceof FastFor && (lv = (FastFor)var17_16) == (FastFor)var17_16 && (var18_17 = ff.getInit()) instanceof StoreInstruction && (var15_15 = (StoreInstruction)var18_17) == (StoreInstruction)var18_17 && FastInstructionListBuilder.isUndeclared(lv = localVariables.getLocalVariableWithIndexAndOffset(si.getIndex(), si.getOffset())) && beforeListOffset < lv.getStartPc()) {
                    if (CheckLocalVariableUsedVisitor.visit(lv, list.subList(i + 1, list.size()))) {
                        FastDeclaration fastDeclaration = new FastDeclaration(lv.getStartPc(), 0, lv, null);
                        FastInstructionListBuilder.insertNewDeclaration(localVariables, list, i, fastDeclaration, true, outerDeclarations);
                    } else {
                        ff.setInit(new FastDeclaration(si.getOffset(), si.getLineNumber(), lv, (Instruction)si));
                        IndexInstruction ii = si;
                        while (ii != null) {
                            lv = localVariables.getLocalVariableWithIndexAndOffset(ii.getIndex(), ii.getOffset());
                            lv.setDeclarationFlag(true);
                            ii = (IndexInstruction)ii.getNext();
                        }
                        FastInstructionListBuilder.updateNewAndInitArrayInstruction((Instruction)si);
                    }
                }
                SearchInstructionByTypeVisitor<AssignmentInstruction> asiVisitor = new SearchInstructionByTypeVisitor<AssignmentInstruction>(AssignmentInstruction.class, asi -> {
                    Instruction instruction = asi.getValue1();
                    if (instruction instanceof LoadInstruction var5_6) {
                        void li;
                        LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(li.getIndex(), li.getOffset());
                        return FastInstructionListBuilder.isUndeclared(lv) && beforeListOffset < lv.getStartPc() && lv.getStartPc() + lv.getLength() - 1 <= lastOffset && !FastInstructionListBuilder.declarationFound(list, lv);
                    }
                    return false;
                });
                while ((asi = asiVisitor.visit(instruction)) != null) {
                    LoadInstruction li = (LoadInstruction)asi.getValue1();
                    LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(li.getIndex(), li.getOffset());
                    FastDeclaration fastDeclaration = new FastDeclaration(lv.getStartPc(), 0, lv, null);
                    FastInstructionListBuilder.insertNewDeclaration(localVariables, list, i, fastDeclaration, true, outerDeclarations);
                }
                SearchInstructionByTypeVisitor<StoreInstruction> siVisitor = new SearchInstructionByTypeVisitor<StoreInstruction>(StoreInstruction.class, si -> {
                    LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(si.getIndex(), si.getOffset());
                    return FastInstructionListBuilder.isUndeclared(lv) && beforeListOffset < lv.getStartPc() && lv.getStartPc() + lv.getLength() - 1 <= lastOffset && !FastInstructionListBuilder.declarationFound(list, lv);
                });
                while ((si = siVisitor.visit(instruction)) != null) {
                    LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(si.getIndex(), si.getOffset());
                    FastDeclaration fastDeclaration = new FastDeclaration(lv.getStartPc(), 0, lv, null);
                    FastInstructionListBuilder.insertNewDeclaration(localVariables, list, i, fastDeclaration, true, outerDeclarations);
                }
                ++i;
            }
            int lvLength = Optional.ofNullable(localVariables).map(LocalVariables::size).orElse(0);
            int i2 = 0;
            while (i2 < lvLength) {
                LocalVariable lv = localVariables.getLocalVariableAt(i2);
                if (!(lv.hasDeclarationFlag() || lv.isToBeRemoved() || beforeListOffset >= lv.getStartPc() || lv.getStartPc() + lv.getLength() - 1 > lastOffset || "Ljava/lang/Object;".equals(lv.getName(classFile.getConstantPool())) || classFile.getMajorVersion() == 45 && lv.getLength() == 1 && lv.getStartPc() == lastOffset)) {
                    FastDeclaration fastDeclaration = new FastDeclaration(lv.getStartPc(), 0, lv, null);
                    FastInstructionListBuilder.insertNewDeclaration(localVariables, list, -1, fastDeclaration, addDeclarations, outerDeclarations);
                }
                ++i2;
            }
        }
        return outerDeclarations;
    }

    private static void insertNewDeclaration(LocalVariables localVariables, List<Instruction> list, int i, FastDeclaration fastDeclaration, boolean addDeclaration, Set<FastDeclaration> outerDeclarations) {
        LocalVariable lv = fastDeclaration.getLv();
        if (addDeclaration) {
            if (i == -1) {
                i = InstructionUtil.getIndexForOffset(list, lv);
            }
            if (fastDeclaration.getInstruction() == null) {
                if (!FastInstructionListBuilder.declarationFound(list, lv) && CheckLocalVariableUsedVisitor.visit(lv, list)) {
                    Instruction instruction = list.get(i);
                    if (lv == localVariables.getLocalVariableForStoreInstruction(instruction)) {
                        fastDeclaration.setLineNumber(instruction.getLineNumber());
                        fastDeclaration.setInstruction(instruction);
                        list.set(i, fastDeclaration);
                    } else {
                        list.add(i, fastDeclaration);
                    }
                }
            } else {
                list.set(i, fastDeclaration);
            }
            lv.setDeclarationFlag(true);
        } else {
            outerDeclarations.add(fastDeclaration);
        }
    }

    private static boolean isUndeclared(LocalVariable lv) {
        return lv != null && !lv.hasDeclarationFlag();
    }

    private static boolean declarationFound(List<Instruction> list, LocalVariable lv) {
        return list.stream().filter(FastDeclaration.class::isInstance).anyMatch(i -> ((FastDeclaration)i).getLv().getNameIndex() == lv.getNameIndex());
    }

    private static void updateNewAndInitArrayInstruction(Instruction instruction) {
        Instruction valueref;
        if (instruction.getOpcode() == 58 && (valueref = ((StoreInstruction)instruction).getValueref()).getOpcode() == 283) {
            valueref.setOpcode(282);
        }
    }

    private static void createContinue(List<Instruction> list, int beforeLoopEntryOffset, int loopEntryOffset, int returnOffset) {
        int length = list.size();
        int index = 0;
        while (index < length) {
            block7: {
                BranchInstruction bi;
                block10: {
                    Instruction nextInstruction;
                    int jumpOffset;
                    block8: {
                        block9: {
                            Instruction instruction = list.get(index);
                            if (!ByteCodeUtil.isIfInstruction((int)instruction.getOpcode(), (boolean)true)) break block7;
                            bi = (BranchInstruction)instruction;
                            jumpOffset = bi.getJumpOffset();
                            if (jumpOffset != returnOffset) break block8;
                            if (index + 1 >= length) break block9;
                            nextInstruction = list.get(index + 1);
                            if (bi.getLineNumber() != 0 && bi.getLineNumber() + 1 == nextInstruction.getLineNumber()) break block7;
                        }
                        ArrayList<Instruction> instructions = new ArrayList<Instruction>(1);
                        instructions.add(new Return(177, bi.getOffset(), 0));
                        list.set(index, new FastTestList(306, bi.getOffset(), bi.getLineNumber(), jumpOffset - bi.getOffset(), bi, instructions));
                        break block7;
                    }
                    if (beforeLoopEntryOffset >= jumpOffset || jumpOffset > loopEntryOffset) break block7;
                    if (index + 1 >= length) break block10;
                    nextInstruction = list.get(index + 1);
                    if (bi.getLineNumber() != 0 && index + 1 < length && bi.getLineNumber() + 1 == nextInstruction.getLineNumber() || nextInstruction.getOpcode() == 177 || nextInstruction.getOpcode() == 273) break block7;
                }
                list.set(index, new FastInstruction(308, bi.getOffset(), bi.getLineNumber(), bi));
            }
            ++index;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void createBreakAndContinue(ClassFile classFile, Method method, List<Instruction> list, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int breakOffset, int returnOffset) {
        length = list.size();
        index = 0;
        while (index < length) {
            block14: {
                block19: {
                    block18: {
                        block17: {
                            block12: {
                                block16: {
                                    block15: {
                                        block13: {
                                            instruction = list.get(index);
                                            if (!ByteCodeUtil.isIfInstruction((int)instruction.getOpcode(), (boolean)true)) break block12;
                                            bi = (BranchInstruction)instruction;
                                            jumpOffset = bi.getJumpOffset();
                                            if (beforeLoopEntryOffset >= jumpOffset || jumpOffset > loopEntryOffset) break block13;
                                            list.set(index, new FastInstruction(308, bi.getOffset(), bi.getLineNumber(), bi));
                                            break block14;
                                        }
                                        if (!ByteCodeUtil.jumpTo((byte[])method.getCode(), (int)breakOffset, (int)jumpOffset)) break block15;
                                        list.set(index, new FastInstruction(309, bi.getOffset(), bi.getLineNumber(), bi));
                                        break block14;
                                    }
                                    if (!ByteCodeUtil.jumpTo((byte[])method.getCode(), (int)jumpOffset, (int)returnOffset)) break block16;
                                    instructions = new ArrayList<Instruction>(1);
                                    instructions.add(new Return(177, bi.getOffset(), 0));
                                    list.set(index, new FastTestList(306, bi.getOffset(), bi.getLineNumber(), jumpOffset - bi.getOffset(), bi, instructions));
                                    break block14;
                                }
                                code = method.getCode();
                                if (code.length != jumpOffset + 2 || (load /* !! */  = FastInstructionListBuilder.duplicateLoadInstruction(code[jumpOffset] & 255, bi.getOffset(), 0)) == null) ** GOTO lbl-1000
                                signatureIndex = method.getSignatureIndex();
                                signature = classFile.getConstantPool().getConstantUtf8(signatureIndex);
                                returnSignature = SignatureUtil.getMethodReturnedSignature(signature);
                                ri = FastInstructionListBuilder.duplicateReturnInstruction(code[jumpOffset + 1] & 255, bi.getOffset(), 0, load /* !! */ , returnSignature);
                                if (ri != null) {
                                    instructions = new ArrayList<Instruction>(1);
                                    instructions.add(ri);
                                    list.set(index, new FastTestList(306, bi.getOffset(), bi.getLineNumber(), jumpOffset - bi.getOffset(), bi, instructions));
                                } else lbl-1000:
                                // 2 sources

                                {
                                    offsetLabelSet.add(jumpOffset);
                                    list.set(index, new FastInstruction(310, bi.getOffset(), bi.getLineNumber(), bi));
                                }
                                break block14;
                            }
                            if (instruction.getOpcode() != 167) break block14;
                            g = (Goto)instruction;
                            jumpOffset = g.getJumpOffset();
                            lineNumber = g.getLineNumber();
                            if (index == 0 || list.get(index - 1).getLineNumber() == lineNumber) {
                                lineNumber = 0;
                            }
                            if (beforeLoopEntryOffset >= jumpOffset || jumpOffset > loopEntryOffset) break block17;
                            if (afterListOffset == afterBodyLoopOffset && index + 1 == length) {
                                list.remove(index);
                            } else if (index + 1 < length && index > 0 && (signature = list.get(index - 1)) instanceof FastTry && (load /* !! */  = (FastTry)signature) == (FastTry)signature && fastTry.hasCatch()) {
                                catches = fastTry.getCatches();
                                fastCatch = catches.get(catches.size() - 1);
                                fastCatch.instructions().add(new FastInstruction(311, g.getOffset(), lineNumber, null));
                                list.remove(index);
                                --index;
                                --length;
                            } else {
                                list.set(index, new FastInstruction(311, g.getOffset(), lineNumber, null));
                            }
                            break block14;
                        }
                        if (!ByteCodeUtil.jumpTo((byte[])method.getCode(), (int)jumpOffset, (int)returnOffset)) break block18;
                        list.set(index, new Return(177, g.getOffset(), lineNumber));
                        break block14;
                    }
                    if (!ByteCodeUtil.jumpTo((byte[])method.getCode(), (int)breakOffset, (int)jumpOffset)) break block19;
                    list.set(index, new FastInstruction(312, g.getOffset(), lineNumber, null));
                    break block14;
                }
                code = method.getCode();
                if (code.length != jumpOffset + 2 || (load = FastInstructionListBuilder.duplicateLoadInstruction(code[jumpOffset] & 255, g.getOffset(), lineNumber)) == null) ** GOTO lbl-1000
                signatureIndex = method.getSignatureIndex();
                signature = classFile.getConstantPool().getConstantUtf8(signatureIndex);
                returnSignature = SignatureUtil.getMethodReturnedSignature(signature);
                ri = FastInstructionListBuilder.duplicateReturnInstruction(code[jumpOffset + 1] & 255, g.getOffset(), lineNumber, load, returnSignature);
                if (ri != null) {
                    if (index > 0) {
                        instruction = list.get(index - 1);
                        if (load.getLineNumber() == instruction.getLineNumber() && 54 <= instruction.getOpcode() && instruction.getOpcode() <= 78 && load.getIndex() == ((StoreInstruction)instruction).getIndex()) {
                            si = (StoreInstruction)instruction;
                            ri.setValueref(si.getValueref());
                            list.remove(--index);
                            --length;
                        }
                    }
                    list.set(index, ri);
                } else lbl-1000:
                // 2 sources

                {
                    offsetLabelSet.add(jumpOffset);
                    list.set(index, new FastInstruction(313, g.getOffset(), lineNumber, g));
                }
            }
            ++index;
        }
    }

    private static LoadInstruction duplicateLoadInstruction(int opcode, int offset, int lineNumber) {
        return switch (opcode) {
            case 21 -> new ILoad(21, offset, lineNumber, 0);
            case 22 -> new LoadInstruction(268, offset, lineNumber, 0, "J");
            case 23 -> new LoadInstruction(268, offset, lineNumber, 0, "F");
            case 24 -> new LoadInstruction(268, offset, lineNumber, 0, "D");
            case 25 -> new ALoad(25, offset, lineNumber, 0);
            case 26, 27, 28, 29 -> new ILoad(21, offset, lineNumber, opcode - 26);
            case 30, 31, 32, 33 -> new LoadInstruction(268, offset, lineNumber, opcode - 30, "J");
            case 34, 35, 36, 37 -> new LoadInstruction(268, offset, lineNumber, opcode - 34, "F");
            case 38, 39, 40, 41 -> new LoadInstruction(268, offset, lineNumber, opcode - 38, "D");
            case 42, 43, 44, 45 -> new ALoad(25, offset, lineNumber, opcode - 42);
            default -> null;
        };
    }

    private static ReturnInstruction duplicateReturnInstruction(int opcode, int offset, int lineNumber, Instruction instruction, String signature) {
        if (opcode == 172 || opcode == 173 || opcode == 174 || opcode == 175 || opcode == 176) {
            return new ReturnInstruction(273, offset, lineNumber, instruction, signature);
        }
        return null;
    }

    private static int unoptimizeIfElseInLoop(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeListOffset, int afterListOffset, int returnOffset, int offset, int jumpOffset, int index) {
        int length;
        int firstLoopInstructionIndex = InstructionUtil.getIndexForOffset(list, jumpOffset);
        if (firstLoopInstructionIndex != -1 && index + 1 < (length = list.size())) {
            int afterLoopJumpOffset;
            int afterLoopInstructionOffset = list.get(index + 1).getOffset();
            Instruction firstLoopInstruction = list.get(firstLoopInstructionIndex);
            if (ByteCodeUtil.isIfOrGotoInstruction((int)firstLoopInstruction.getOpcode(), (boolean)true) || firstLoopInstruction.getOpcode() == 318 || firstLoopInstruction.getOpcode() == 319) {
                BranchInstruction bi = (BranchInstruction)firstLoopInstruction;
                afterLoopJumpOffset = bi.getJumpOffset();
            } else {
                afterLoopJumpOffset = -1;
            }
            if (afterLoopJumpOffset > afterLoopInstructionOffset) {
                int lastInstructionoffset;
                int afterLoopInstructionIndex = InstructionUtil.getIndexForOffset(list, afterLoopJumpOffset);
                if (afterLoopInstructionIndex == -1 && afterLoopJumpOffset <= afterListOffset) {
                    afterLoopInstructionIndex = length;
                }
                if (afterLoopInstructionIndex != -1 && InstructionUtil.checkNoJumpToInterval(list, 0, firstLoopInstructionIndex, offset, lastInstructionoffset = list.get(afterLoopInstructionIndex - 1).getOffset()) && InstructionUtil.checkNoJumpToInterval(list, afterLoopInstructionIndex, list.size(), offset, lastInstructionoffset)) {
                    Instruction lastInstruction = list.get(afterLoopInstructionIndex - 1);
                    Goto newGi = new Goto(167, lastInstruction.getOffset(), 0, jumpOffset - lastInstruction.getOffset());
                    list.add(afterLoopInstructionIndex, newGi);
                    return FastInstructionListBuilder.analyzeBackGoto(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, afterLoopJumpOffset, returnOffset, afterLoopInstructionIndex, newGi, jumpOffset);
                }
            }
        }
        return -1;
    }

    private static int unoptimizeIfiniteLoop(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeListOffset, int afterListOffset, int returnOffset, BranchInstruction bi, int jumpOffset, int jumpIndex) {
        int length = list.size();
        if (jumpIndex + 1 >= length) {
            return -1;
        }
        Instruction instruction = list.get(jumpIndex + 1);
        if (instruction.getOpcode() != 167) {
            return -1;
        }
        int afterGotoOffset = jumpIndex + 2 >= length ? afterListOffset : list.get(jumpIndex + 2).getOffset();
        Goto g = (Goto)instruction;
        int jumpGotoOffset = g.getJumpOffset();
        if (g.getOffset() >= jumpGotoOffset || jumpGotoOffset > afterGotoOffset) {
            return -1;
        }
        int newGotoOffset = g.getOffset() + 1;
        bi.setJumpOffset(newGotoOffset);
        Goto newGoto = new Goto(167, newGotoOffset, 0, jumpOffset - newGotoOffset);
        list.add(jumpIndex + 2, newGoto);
        return FastInstructionListBuilder.analyzeBackGoto(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, jumpGotoOffset, returnOffset, jumpIndex + 2, newGoto, jumpOffset);
    }

    /*
     * Unable to fully structure code
     */
    private static void createLoops(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int beforeListOffset, int afterListOffset, int returnOffset) {
        index = list.size();
        if (true) ** GOTO lbl6
        do {
            if (!ByteCodeUtil.isIfOrGotoInstruction((int)(instruction = list.get(index)).getOpcode(), (boolean)true) || FastInstructionListBuilder.unoptimizeLoopInLoop(list, beforeListOffset, index, instruction)) {
                // empty if block
            }
lbl6:
            // 4 sources

            v0 = ++index;
            --index;
        } while (v0 > 0);
        index = list.size();
        block6: while (index-- > 0) {
            instruction = list.get(index);
            switch (instruction.getOpcode()) {
                case 260: 
                case 261: 
                case 262: 
                case 284: {
                    bi = (BranchInstruction)instruction;
                    if (bi.getBranch() >= 0 || beforeListOffset >= (jumpOffset = bi.getJumpOffset()) || beforeLoopEntryOffset < jumpOffset && jumpOffset <= loopEntryOffset) continue block6;
                    newIndex = FastInstructionListBuilder.unoptimizeIfElseInLoop(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, afterListOffset, returnOffset, bi.getOffset(), jumpOffset, index);
                    if (newIndex == -1) {
                        newIndex = FastInstructionListBuilder.unoptimizeIfiniteLoop(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, afterListOffset, returnOffset, bi, jumpOffset, index);
                    }
                    if (newIndex == -1) {
                        index = FastInstructionListBuilder.analyzeBackIf(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, returnOffset, index, bi);
                        break;
                    }
                    index = newIndex;
                    break;
                }
                case 167: {
                    gi = (Goto)instruction;
                    if (gi.getBranch() >= 0 || beforeListOffset >= (jumpOffset = gi.getJumpOffset()) || beforeLoopEntryOffset < jumpOffset && jumpOffset <= loopEntryOffset) continue block6;
                    newIndex = FastInstructionListBuilder.unoptimizeIfElseInLoop(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, afterListOffset, returnOffset, gi.getOffset(), jumpOffset, index);
                    if (newIndex == -1) {
                        index = FastInstructionListBuilder.analyzeBackGoto(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, gi.getOffset(), returnOffset, index, gi, jumpOffset);
                        break;
                    }
                    index = newIndex;
                    break;
                }
                case 318: 
                case 319: {
                    fl = (FastList)instruction;
                    if (fl.getInstructions().isEmpty()) break;
                    previousOffset = index > 0 ? list.get(index - 1).getOffset() : beforeListOffset;
                    jumpOffset = fl.getJumpOffset();
                    if (jumpOffset == -1 || previousOffset < jumpOffset || beforeListOffset >= jumpOffset || beforeLoopEntryOffset < jumpOffset && jumpOffset <= loopEntryOffset) continue block6;
                    fl.setBranch(1);
                    afterSubListOffset = index + 1 < list.size() ? list.get(index + 1).getOffset() : afterListOffset;
                    index = FastInstructionListBuilder.analyzeBackGoto(classFile, method, list, localVariables, offsetLabelSet, beforeListOffset, afterSubListOffset, returnOffset, index, fl, jumpOffset);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean unoptimizeLoopInLoop(List<Instruction> list, int beforeListOffset, int index, Instruction instruction) {
        block26: {
            bi = (BranchInstruction)instruction;
            if (bi.getBranch() >= 0) {
                return false;
            }
            jumpOffset = bi.getJumpOffset();
            if (jumpOffset <= beforeListOffset) {
                return false;
            }
            indexBi = index;
            block0: while (true) {
                if (index == 0) {
                    return false;
                }
                if ((instruction = list.get(--index)).getOffset() <= jumpOffset) break block26;
                if (instruction.getOpcode() != 171 && instruction.getOpcode() != 170) continue;
                s = (Switch)instruction;
                if (s.getOffset() + s.getDefaultOffset() > bi.getOffset()) {
                    return false;
                }
                j = s.getOffsets().length;
                do {
                    if (j-- > 0) ** break;
                    continue block0;
                } while (s.getOffset() + s.getOffset(j) <= bi.getOffset());
                break;
            }
            return false;
        }
        instruction = list.get(index + 1);
        if (bi == instruction) {
            return false;
        }
        if (ByteCodeUtil.isIfInstruction((int)instruction.getOpcode(), (boolean)true)) {
            block27: {
                bi2 = (BranchInstruction)instruction;
                if (bi2.getBranch() >= 0) {
                    return false;
                }
                i = 0;
                while (i < index) {
                    instruction = list.get(i);
                    if (instruction.getOpcode() == 171 || instruction.getOpcode() == 170) {
                        s = (Switch)instruction;
                        if (s.getOffset() + s.getDefaultOffset() > bi2.getOffset()) {
                            return false;
                        }
                        j = s.getOffsets().length;
                        while (j-- > 0) {
                            if (s.getOffset() + s.getOffset(j) <= bi2.getOffset()) continue;
                            return false;
                        }
                    }
                    ++i;
                }
                jumpOffset2 = bi2.getJumpOffset();
                block4: while (true) {
                    if (index == 0) {
                        return false;
                    }
                    if ((instruction = list.get(--index)).getOffset() <= jumpOffset2) break block27;
                    if (instruction.getOpcode() != 171 && instruction.getOpcode() != 170) continue;
                    s = (Switch)instruction;
                    if (s.getOffset() + s.getDefaultOffset() > bi.getOffset()) {
                        return false;
                    }
                    j = s.getOffsets().length;
                    do {
                        if (j-- > 0) ** break;
                        continue block4;
                    } while (s.getOffset() + s.getOffset(j) <= bi.getOffset());
                    break;
                }
                return false;
            }
            target = list.get(index + 1);
            if (bi2 == target) {
                return false;
            }
            i = 0;
            while (i < index) {
                instruction = list.get(i);
                if (instruction.getOpcode() == 171 || instruction.getOpcode() == 170) {
                    s = (Switch)instruction;
                    if (s.getOffset() + s.getDefaultOffset() > bi2.getOffset()) {
                        return false;
                    }
                    j = s.getOffsets().length;
                    while (j-- > 0) {
                        if (s.getOffset() + s.getOffset(j) <= bi2.getOffset()) continue;
                        return false;
                    }
                }
                ++i;
            }
            if (bi.getOpcode() == 167) {
                list.add(indexBi + 1, new Goto(167, bi.getOffset() + 1, 0, jumpOffset2 - bi.getOffset() - 1));
                bi2.setJumpOffset(bi.getOffset() + 1);
            } else if (target.getOpcode() == 167 && ((Goto)target).getJumpOffset() == jumpOffset2) {
                bi.setJumpOffset(jumpOffset2);
            } else {
                list.add(index + 1, new Goto(167, jumpOffset2 - 1, 0, jumpOffset - jumpOffset2 + 1));
                bi.setJumpOffset(jumpOffset2 - 1);
                return true;
            }
        }
        return false;
    }

    private static void createIfElse(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int breakOffset, int returnOffset) {
        int length = list.size();
        int index = 0;
        while (index < length) {
            Instruction instruction = list.get(index);
            if (ByteCodeUtil.isIfInstruction((int)instruction.getOpcode(), (boolean)true)) {
                FastInstructionListBuilder.analyzeIfAndIfElse(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, breakOffset, returnOffset, index, (ConditionalBranchInstruction)instruction);
                length = list.size();
            }
            ++index;
        }
    }

    private static void createSwitch(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int returnOffset) {
        int index = 0;
        while (index < list.size()) {
            Instruction instruction = list.get(index);
            if (instruction.getOpcode() == 171) {
                FastInstructionListBuilder.analyzeLookupSwitch(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, returnOffset, index, (LookupSwitch)instruction);
            } else if (instruction.getOpcode() == 170) {
                index = FastInstructionListBuilder.analyzeTableSwitch(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, returnOffset, index, (TableSwitch)instruction);
            }
            ++index;
        }
    }

    private static void removeLocalVariable(Method method, IndexInstruction ii) {
        LocalVariable lv = method.getLocalVariables().searchLocalVariableWithIndexAndOffset(ii.getIndex(), ii.getOffset());
        if (lv != null && ii.getOffset() == lv.getStartPc()) {
            method.getLocalVariables().removeLocalVariableWithIndexAndOffset(ii.getIndex(), ii.getOffset());
        }
    }

    private static int analyzeBackIf(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeListOffset, int returnOffset, int testIndex, Instruction test) {
        int index;
        block29: {
            int breakOffset;
            int subListLength;
            int beforeLoopEntryOffset;
            ArrayList<Instruction> subList;
            block28: {
                index = testIndex - 1;
                subList = new ArrayList<Instruction>();
                int firstOffset = ((BranchInstruction)test).getJumpOffset();
                beforeLoopEntryOffset = index >= 0 ? list.get(index).getOffset() : beforeListOffset;
                while (index >= 0 && list.get(index).getOffset() >= firstOffset) {
                    subList.add(list.remove(index));
                    --index;
                }
                subListLength = subList.size();
                if (index >= 0) {
                    beforeListOffset = list.get(index).getOffset();
                }
                breakOffset = FastInstructionListBuilder.searchMinusJumpOffset(subList, 0, subListLength, beforeListOffset, test.getOffset());
                Instruction jumpInstructionBeforeLoop = null;
                if (index >= 0) {
                    int i = index + 1;
                    while (i-- > 0) {
                        int lastBodyOffset;
                        Instruction instruction = list.get(i);
                        if (!ByteCodeUtil.isIfOrGotoInstruction((int)instruction.getOpcode(), (boolean)true) && instruction.getOpcode() != 318 && instruction.getOpcode() != 319) continue;
                        BranchInstruction bi = (BranchInstruction)instruction;
                        int offset = bi.getJumpOffset();
                        int n = lastBodyOffset = !subList.isEmpty() ? ((Instruction)subList.get(0)).getOffset() : bi.getOffset();
                        if (lastBodyOffset >= offset || offset > test.getOffset()) continue;
                        jumpInstructionBeforeLoop = bi;
                        i = 0;
                    }
                }
                if (jumpInstructionBeforeLoop == null) break block28;
                if (jumpInstructionBeforeLoop.getOpcode() == 167) {
                    list.remove(index);
                    --index;
                }
                Instruction beforeLoop = index >= 0 && index < list.size() ? list.get(index) : null;
                Instruction lastBodyLoop = null;
                Instruction beforeLastBodyLoop = null;
                if (subListLength > 0) {
                    lastBodyLoop = (Instruction)subList.get(0);
                    if (subListLength > 1) {
                        beforeLastBodyLoop = (Instruction)subList.get(1);
                        if (!InstructionUtil.checkNoJumpToInterval(subList, 0, subListLength, lastBodyLoop.getOffset(), test.getOffset())) {
                            lastBodyLoop = null;
                            beforeLastBodyLoop = null;
                        }
                    }
                }
                int typeLoop = FastInstructionListBuilder.getLoopType(beforeLoop, test, beforeLastBodyLoop, lastBodyLoop);
                switch (typeLoop) {
                    case 2: {
                        if (subListLength > 0) {
                            Collections.reverse(subList);
                            FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, test.getOffset(), test.getOffset(), jumpInstructionBeforeLoop.getOffset(), test.getOffset(), breakOffset, returnOffset);
                        }
                        int branch = 1;
                        if (breakOffset != -1) {
                            branch = breakOffset - test.getOffset();
                        }
                        list.set(++index, new FastTestList(301, test.getOffset(), test.getLineNumber(), branch, test, subList));
                        break block29;
                    }
                    case 3: {
                        list.remove(index);
                        if (subListLength > 0) {
                            Collections.reverse(subList);
                            FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, test.getOffset(), test.getOffset(), jumpInstructionBeforeLoop.getOffset(), test.getOffset(), breakOffset, returnOffset);
                        }
                        FastInstructionListBuilder.createForLoopCase1(classFile, method, list, index, beforeLoop, test, subList, breakOffset);
                        break block29;
                    }
                    case 6: {
                        int branch;
                        if (subListLength > 1) {
                            Collections.reverse(subList);
                            subList.remove(--subListLength);
                            if (beforeLastBodyLoop != null && lastBodyLoop != null) {
                                FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.getOffset(), lastBodyLoop.getOffset(), lastBodyLoop.getOffset(), jumpInstructionBeforeLoop.getOffset(), lastBodyLoop.getOffset(), breakOffset, returnOffset);
                            }
                            branch = 1;
                            if (breakOffset != -1) {
                                branch = breakOffset - test.getOffset();
                            }
                            list.set(++index, new FastFor(304, test.getOffset(), test.getLineNumber(), branch, null, test, lastBodyLoop, subList));
                        } else {
                            if (subListLength == 1) {
                                FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, test.getOffset(), test.getOffset(), jumpInstructionBeforeLoop.getOffset(), test.getOffset(), breakOffset, returnOffset);
                            }
                            branch = 1;
                            if (breakOffset != -1) {
                                branch = breakOffset - test.getOffset();
                            }
                            list.set(++index, new FastTestList(301, test.getOffset(), test.getLineNumber(), branch, test, subList));
                        }
                        break block29;
                    }
                    case 7: {
                        if (subListLength > 0) {
                            list.remove(index);
                            Collections.reverse(subList);
                            subList.remove(--subListLength);
                            if (subListLength > 0 && beforeLastBodyLoop != null && lastBodyLoop != null) {
                                FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.getOffset(), lastBodyLoop.getOffset(), lastBodyLoop.getOffset(), jumpInstructionBeforeLoop.getOffset(), lastBodyLoop.getOffset(), breakOffset, returnOffset);
                            }
                        }
                        index = FastInstructionListBuilder.createForLoopCase3(classFile, method, list, index, beforeLoop, test, lastBodyLoop, subList, breakOffset, localVariables);
                        break block29;
                    }
                    default: {
                        throw new UnexpectedElementException("AnalyzeBackIf");
                    }
                }
            }
            if (subListLength > 0) {
                Collections.reverse(subList);
                FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, test.getOffset(), test.getOffset(), beforeListOffset, test.getOffset(), breakOffset, returnOffset);
                int branch = 1;
                if (breakOffset != -1) {
                    branch = breakOffset - test.getOffset();
                }
                list.set(++index, new FastTestList(302, test.getOffset(), 0, branch, test, subList));
            } else {
                list.set(++index, new FastTestList(301, test.getOffset(), test.getLineNumber(), 1, test, null));
            }
        }
        return index;
    }

    private static int searchMinusJumpOffset(List<Instruction> list, int fromIndex, int toIndex, int beforeListOffset, int lastListOffset) {
        int breakOffset = -1;
        int index = toIndex;
        block6: while (index-- > fromIndex) {
            Instruction instruction = list.get(index);
            switch (instruction.getOpcode()) {
                case 167: 
                case 260: 
                case 261: 
                case 262: 
                case 284: {
                    BranchInstruction bi = (BranchInstruction)instruction;
                    int jumpOffset = bi.getJumpOffset();
                    if (jumpOffset == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset) continue block6;
                    breakOffset = jumpOffset;
                    break;
                }
                case 301: 
                case 302: 
                case 304: 
                case 305: 
                case 319: {
                    int jumpOffset;
                    FastList fl = (FastList)instruction;
                    List<Instruction> instructions = fl.getInstructions();
                    if (instructions == null || (jumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(instructions, 0, instructions.size(), beforeListOffset, lastListOffset)) == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset) continue block6;
                    breakOffset = jumpOffset;
                    break;
                }
                case 318: {
                    List<Instruction> finallyInstructions;
                    List<Instruction> instructions;
                    FastTry ft = (FastTry)instruction;
                    int jumpOffset = ft.getJumpOffset();
                    if (!(jumpOffset == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset)) {
                        breakOffset = jumpOffset;
                    }
                    if (!((jumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(instructions = ft.getInstructions(), 0, instructions.size(), beforeListOffset, lastListOffset)) == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset)) {
                        breakOffset = jumpOffset;
                    }
                    int i = ft.getCatches().size();
                    while (i-- > 0) {
                        List<Instruction> catchInstructions = ft.getCatches().get(i).instructions();
                        jumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(catchInstructions, 0, catchInstructions.size(), beforeListOffset, lastListOffset);
                        if (jumpOffset == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset) continue;
                        breakOffset = jumpOffset;
                    }
                    if (ft.getFinallyInstructions() == null || (jumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(finallyInstructions = ft.getFinallyInstructions(), 0, finallyInstructions.size(), beforeListOffset, lastListOffset)) == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset) continue block6;
                    breakOffset = jumpOffset;
                    break;
                }
                case 314: 
                case 315: 
                case 316: {
                    FastSwitch fs = (FastSwitch)instruction;
                    int jumpOffset = fs.getJumpOffset();
                    if (!(jumpOffset == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset)) {
                        breakOffset = jumpOffset;
                    }
                    int i = fs.getPairs().length;
                    while (i-- > 0) {
                        List<Instruction> caseInstructions = fs.getPair(i).getInstructions();
                        if (caseInstructions == null || (jumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(caseInstructions, 0, caseInstructions.size(), beforeListOffset, lastListOffset)) == -1 || jumpOffset > beforeListOffset && lastListOffset >= jumpOffset || breakOffset != -1 && breakOffset <= jumpOffset) continue;
                        breakOffset = jumpOffset;
                    }
                    continue block6;
                }
            }
        }
        return breakOffset;
    }

    private static int getMaxOffset(Instruction beforeWhileLoop, Instruction test) {
        return beforeWhileLoop.getOffset() > test.getOffset() ? beforeWhileLoop.getOffset() : test.getOffset();
    }

    private static int getMaxOffset(Instruction beforeWhileLoop, Instruction test, Instruction lastBodyWhileLoop) {
        int offset = FastInstructionListBuilder.getMaxOffset(beforeWhileLoop, test);
        return offset > lastBodyWhileLoop.getOffset() ? offset : lastBodyWhileLoop.getOffset();
    }

    private static Instruction createForEachVariableInstruction(Instruction i, LocalVariables localVariables) {
        switch (i.getOpcode()) {
            case 317: {
                FastDeclaration fd = (FastDeclaration)i;
                fd.setInstruction(null);
                fd.getLv().setDeclarationFlag(true);
                return i;
            }
            case 58: {
                ALoad aLoad = new ALoad(25, i.getOffset(), i.getLineNumber(), ((AStore)i).getIndex());
                LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(aLoad.getIndex(), aLoad.getOffset());
                if (lv != null && !lv.hasDeclarationFlag()) {
                    FastDeclaration fd = new FastDeclaration(aLoad.getOffset(), aLoad.getLineNumber(), lv, null);
                    lv.setDeclarationFlag(true);
                    return fd;
                }
                return aLoad;
            }
            case 54: {
                return new ILoad(21, i.getOffset(), i.getLineNumber(), ((IStore)i).getIndex());
            }
            case 269: {
                return new LoadInstruction(268, i.getOffset(), i.getLineNumber(), ((StoreInstruction)i).getIndex(), ((StoreInstruction)i).getReturnedSignature(null, null));
            }
        }
        return i;
    }

    private static void createForLoopCase1(ClassFile classFile, Method method, List<Instruction> list, int beforeWhileLoopIndex, Instruction beforeWhileLoop, Instruction test, List<Instruction> subList, int breakOffset) {
        int forLoopOffset = FastInstructionListBuilder.getMaxOffset(beforeWhileLoop, test);
        int branch = 1;
        if (breakOffset != -1) {
            branch = breakOffset - forLoopOffset;
        }
        if (!subList.isEmpty() && (var12_10 = subList.get(0)) instanceof AStore && (var10_11 = (AStore)var12_10) == (AStore)var12_10) {
            LocalVariable lv = method.getLocalVariables().getLocalVariableWithIndexAndOffset(astore.getIndex(), astore.getOffset());
            subList.set(0, new FastDeclaration(astore.getOffset(), astore.getLineNumber(), lv, (Instruction)astore));
        }
        if (FastInstructionListBuilder.isAForEachIteratorPattern(classFile, method, beforeWhileLoop, test, subList)) {
            Instruction variable = FastInstructionListBuilder.createForEachVariableInstruction(subList.remove(0), method.getLocalVariables());
            Instruction valueref = ((AStore)beforeWhileLoop).getValueref();
            if (valueref instanceof CheckCast var15_15) {
                valueref = checkCast.getObjectref();
            }
            InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)valueref;
            Instruction values = insi.getObjectref();
            FastInstructionListBuilder.removeLocalVariable(method, (StoreInstruction)beforeWhileLoop);
            variable.setLineNumber(values.getLineNumber());
            list.set(beforeWhileLoopIndex, new FastForEach(305, forLoopOffset, values.getLineNumber(), branch, variable, values, subList));
        } else {
            list.set(beforeWhileLoopIndex, new FastFor(304, forLoopOffset, beforeWhileLoop.getLineNumber(), branch, beforeWhileLoop, test, null, subList));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int createForLoopCase3(ClassFile classFile, Method method, List<Instruction> list, int beforeWhileLoopIndex, Instruction beforeWhileLoop, Instruction test, Instruction lastBodyWhileLoop, List<Instruction> subList, int breakOffset, LocalVariables localVariables) {
        int forLoopOffset = FastInstructionListBuilder.getMaxOffset(beforeWhileLoop, test, lastBodyWhileLoop);
        int branch = 1;
        if (breakOffset != -1) {
            branch = breakOffset - forLoopOffset;
        }
        switch (FastInstructionListBuilder.getForEachArrayPatternType(classFile, beforeWhileLoop, test, lastBodyWhileLoop, list, beforeWhileLoopIndex, subList)) {
            case 1: {
                Instruction variable = FastInstructionListBuilder.createForEachVariableInstruction(subList.remove(0), localVariables);
                StoreInstruction beforeBeforeWhileLoop = (StoreInstruction)list.remove(--beforeWhileLoopIndex);
                AssignmentInstruction ai = (AssignmentInstruction)((ArrayLength)beforeBeforeWhileLoop.getValueref()).getArrayref();
                Instruction values = ai.getValue2();
                FastInstructionListBuilder.removeLocalVariable(method, beforeBeforeWhileLoop);
                FastInstructionListBuilder.removeLocalVariable(method, (StoreInstruction)beforeWhileLoop);
                FastInstructionListBuilder.removeLocalVariable(method, (ALoad)ai.getValue1());
                list.set(beforeWhileLoopIndex, new FastForEach(305, forLoopOffset, variable.getLineNumber(), branch, variable, values, subList));
                break;
            }
            case 2: {
                Instruction valueref;
                Instruction variable = FastInstructionListBuilder.createForEachVariableInstruction(subList.remove(0), localVariables);
                StoreInstruction beforeBeforeWhileLoop = (StoreInstruction)list.remove(--beforeWhileLoopIndex);
                StoreInstruction beforeBeforeBeforeWhileLoop = (StoreInstruction)list.remove(--beforeWhileLoopIndex);
                Instruction instruction = valueref = beforeBeforeBeforeWhileLoop.getValueref();
                if (instruction instanceof CheckCast var16_31) {
                    void cc;
                    String lvSignature = variable.getReturnedSignature(classFile, localVariables);
                    cc.setIndex(classFile.getConstantPool().addConstantUtf8("[" + lvSignature));
                }
                Instruction values = beforeBeforeBeforeWhileLoop.getValueref();
                FastInstructionListBuilder.removeLocalVariable(method, beforeBeforeWhileLoop);
                FastInstructionListBuilder.removeLocalVariable(method, (StoreInstruction)beforeWhileLoop);
                FastInstructionListBuilder.removeLocalVariable(method, beforeBeforeBeforeWhileLoop);
                list.set(beforeWhileLoopIndex, new FastForEach(305, forLoopOffset, variable.getLineNumber(), branch, variable, values, subList));
                break;
            }
            case 3: {
                Instruction variable = FastInstructionListBuilder.createForEachVariableInstruction(subList.remove(0), localVariables);
                StoreInstruction siIndex = (StoreInstruction)list.remove(--beforeWhileLoopIndex);
                StoreInstruction siTmpArray = (StoreInstruction)list.remove(--beforeWhileLoopIndex);
                Instruction values = siTmpArray.getValueref();
                FastInstructionListBuilder.removeLocalVariable(method, (StoreInstruction)beforeWhileLoop);
                FastInstructionListBuilder.removeLocalVariable(method, siIndex);
                FastInstructionListBuilder.removeLocalVariable(method, siTmpArray);
                list.set(beforeWhileLoopIndex, new FastForEach(305, forLoopOffset, variable.getLineNumber(), branch, variable, values, subList));
                break;
            }
            default: {
                Instruction lastInstruction;
                int i;
                MinMaxLineNumberVisitor.MinMaxLineNumber minMaxLineNumber = MinMaxLineNumberVisitor.visit(subList);
                if (!subList.isEmpty() && lastBodyWhileLoop.getLineNumber() > minMaxLineNumber.maxLineNumber()) {
                    if (lastBodyWhileLoop.getOpcode() != 167) {
                        subList.add(lastBodyWhileLoop);
                    }
                    Instruction variable = FastInstructionListBuilder.createForEachVariableInstruction(subList.remove(0), localVariables);
                    InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)((AStore)beforeWhileLoop).getValueref();
                    Instruction values = insi.getObjectref();
                    FastInstructionListBuilder.removeLocalVariable(method, (StoreInstruction)beforeWhileLoop);
                    variable.setLineNumber(values.getLineNumber());
                    list.set(beforeWhileLoopIndex, new FastForEach(305, forLoopOffset, values.getLineNumber(), branch, variable, values, subList));
                    break;
                }
                if (!subList.isEmpty() && FastInstructionListBuilder.isAssignment(lastBodyWhileLoop)) {
                    i = subList.size() - 1;
                    while (i >= 0) {
                        lastInstruction = subList.get(i);
                        if (!FastInstructionListBuilder.isAssignment(lastInstruction) || lastInstruction.getLineNumber() != lastBodyWhileLoop.getLineNumber()) break;
                        lastInstruction.setNext(lastBodyWhileLoop);
                        lastBodyWhileLoop = lastInstruction;
                        subList.remove(i);
                        --i;
                    }
                }
                if (beforeWhileLoopIndex > 1 && beforeWhileLoop instanceof StoreInstruction) {
                    i = beforeWhileLoopIndex - 1;
                    while (i >= 0) {
                        lastInstruction = list.get(i);
                        if (!(lastInstruction instanceof StoreInstruction) || lastInstruction.getLineNumber() != beforeWhileLoop.getLineNumber()) break;
                        lastInstruction.setNext(beforeWhileLoop);
                        beforeWhileLoop = lastInstruction;
                        list.remove(i);
                        --beforeWhileLoopIndex;
                        --i;
                    }
                }
                list.set(beforeWhileLoopIndex, new FastFor(304, forLoopOffset, beforeWhileLoop.getLineNumber(), branch, beforeWhileLoop, test, lastBodyWhileLoop, subList));
            }
        }
        return beforeWhileLoopIndex;
    }

    private static boolean isAssignment(Instruction instruction) {
        return instruction instanceof IInc || instruction instanceof IncInstruction || instruction instanceof StoreInstruction || instruction instanceof AssignmentInstruction;
    }

    private static boolean isAForEachIteratorPattern(ClassFile classFile, Method method, Instruction init, Instruction test, List<Instruction> subList) {
        if (classFile.getMajorVersion() < 49 || subList.isEmpty()) {
            return false;
        }
        if (test.getLineNumber() != subList.get(0).getLineNumber() || init.getOpcode() != 58) {
            return false;
        }
        AStore astoreIterator = (AStore)init;
        Instruction valueref = astoreIterator.getValueref();
        if (valueref instanceof CheckCast var7_8) {
            valueref = checkCast.getObjectref();
        }
        if (valueref.getOpcode() != 185 && valueref.getOpcode() != 182) {
            return false;
        }
        LocalVariable lv = method.getLocalVariables().getLocalVariableWithIndexAndOffset(astoreIterator.getIndex(), astoreIterator.getOffset());
        if (lv == null || lv.getSignatureIndex() == 0) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        String iteratorMethodName = constants.getConstantUtf8((cnat = constants.getConstantNameAndType((cmr = constants.getConstantMethodref((insi = (InvokeNoStaticInstruction)valueref).getIndex())).getNameAndTypeIndex())).getNameIndex());
        if (!"iterator".equals(iteratorMethodName)) {
            return false;
        }
        String iteratorMethodDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        if (!"()Ljava/util/Iterator;".equals(iteratorMethodDescriptor) || test.getOpcode() != 260) {
            return false;
        }
        IfInstruction ifi = (IfInstruction)test;
        if (ifi.getValue().getOpcode() != 185) {
            return false;
        }
        insi = (InvokeNoStaticInstruction)ifi.getValue();
        Instruction objectref = insi.getObjectref();
        if (objectref.getOpcode() != 25 || ((ALoad)objectref).getIndex() != astoreIterator.getIndex()) {
            return false;
        }
        cmr = constants.getConstantMethodref(insi.getIndex());
        cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String hasNextMethodName = constants.getConstantUtf8(cnat.getNameIndex());
        if (!"hasNext".equals(hasNextMethodName)) {
            return false;
        }
        String hasNextMethodDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        if (!"()Z".equals(hasNextMethodDescriptor) || subList.get(0).getOpcode() != 317) {
            return false;
        }
        FastDeclaration declaration = (FastDeclaration)subList.get(0);
        if (declaration.getInstruction() == null || declaration.getInstruction().getOpcode() != 58) {
            return false;
        }
        AStore astoreVariable = (AStore)declaration.getInstruction();
        if (astoreVariable.getValueref().getOpcode() == 192) {
            CheckCast cc = (CheckCast)astoreVariable.getValueref();
            if (cc.getObjectref().getOpcode() != 185) {
                return false;
            }
            insi = (InvokeNoStaticInstruction)cc.getObjectref();
        } else {
            if (astoreVariable.getValueref().getOpcode() != 185) {
                return false;
            }
            insi = (InvokeNoStaticInstruction)astoreVariable.getValueref();
        }
        if (objectref.getOpcode() != 25 || ((ALoad)objectref).getIndex() != astoreIterator.getIndex()) {
            return false;
        }
        cmr = constants.getConstantMethodref(insi.getIndex());
        cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String nextMethodName = constants.getConstantUtf8(cnat.getNameIndex());
        if (!"next".equals(nextMethodName)) {
            return false;
        }
        String nextMethodDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        return "()Ljava/lang/Object;".equals(nextMethodDescriptor);
    }

    private static int getForEachArraySun15PatternType(Instruction init, Instruction test, Instruction inc, Instruction firstInstruction, StoreInstruction siLength, ConstantPool cp) {
        ArrayLength al = (ArrayLength)siLength.getValueref();
        if (al.getArrayref().getOpcode() != 265) {
            return 0;
        }
        AssignmentInstruction ai = (AssignmentInstruction)al.getArrayref();
        if (!"=".equals(ai.getOperator()) || ai.getValue1().getOpcode() != 25) {
            return 0;
        }
        LoadInstruction liTmpArray = (LoadInstruction)ai.getValue1();
        if (init.getOpcode() != 54) {
            return 0;
        }
        StoreInstruction siIndex = (StoreInstruction)init;
        if (siIndex.getValueref().getOpcode() != 256) {
            return 0;
        }
        IConst iconst = (IConst)siIndex.getValueref();
        if (iconst.getValue() != 0 || !"I".equals(iconst.getSignature()) || test.getOpcode() != 261) {
            return 0;
        }
        IfCmp ifcmp = (IfCmp)test;
        if (ifcmp.getValue1().getOpcode() != 21 || ifcmp.getValue2().getOpcode() != 21 || ((ILoad)ifcmp.getValue1()).getIndex() != siIndex.getIndex() || ((ILoad)ifcmp.getValue2()).getIndex() != siLength.getIndex() || inc.getOpcode() != 132 || ((IInc)inc).getIndex() != siIndex.getIndex() || ((IInc)inc).getCount() != 1) {
            return 0;
        }
        if (firstInstruction.getOpcode() == 317) {
            FastDeclaration declaration = (FastDeclaration)firstInstruction;
            if (declaration.getInstruction() == null) {
                return 0;
            }
            firstInstruction = declaration.getInstruction();
        }
        if (firstInstruction.getOpcode() != 269 && firstInstruction.getOpcode() != 58 && firstInstruction.getOpcode() != 54) {
            return 0;
        }
        StoreInstruction siVariable = (StoreInstruction)firstInstruction;
        Instruction valueref = siVariable.getValueref();
        if (valueref instanceof Invokevirtual var14_15) {
            cmr = cp.getConstantMethodref(iv.getIndex());
            ConstantNameAndType cnat = cp.getConstantNameAndType(cmr.getNameAndTypeIndex());
            String name = cp.getConstantUtf8(cnat.getNameIndex());
            String signature = cp.getConstantUtf8(cnat.getSignatureIndex());
            if (!StringUtils.equalsAny((CharSequence)(String.valueOf(name) + signature), (CharSequence[])new CharSequence[]{"intValue()I", "longValue()J", "doubleValue()D", "floatValue()F", "byteValue()B", "shortValue()S", "charValue()C", "booleanValue()Z"})) {
                return 0;
            }
            valueref = iv.getObjectref();
        }
        if ((var19_18 = valueref) instanceof CheckCast && (cmr = (CheckCast)var19_18) == (CheckCast)var19_18) {
            valueref = cc.getObjectref();
        }
        if (valueref.getOpcode() != 271) {
            return 0;
        }
        ArrayLoadInstruction ali = (ArrayLoadInstruction)valueref;
        if (ali.getArrayref().getOpcode() != 25 || ali.getIndexref().getOpcode() != 21 || ((ALoad)ali.getArrayref()).getIndex() != liTmpArray.getIndex() || ((ILoad)ali.getIndexref()).getIndex() != siIndex.getIndex()) {
            return 0;
        }
        return 1;
    }

    private static int getForEachArraySun16PatternType(Instruction init, Instruction test, Instruction inc, Instruction firstInstruction, StoreInstruction siLength, Instruction beforeBeforeForInstruction, ConstantPool cp) {
        ArrayLength al = (ArrayLength)siLength.getValueref();
        if (al.getArrayref().getOpcode() != 25 || beforeBeforeForInstruction.getOpcode() != 58) {
            return 0;
        }
        StoreInstruction siTmpArray = (StoreInstruction)beforeBeforeForInstruction;
        if (siTmpArray.getIndex() != ((IndexInstruction)al.getArrayref()).getIndex() || init.getOpcode() != 54) {
            return 0;
        }
        StoreInstruction siIndex = (StoreInstruction)init;
        if (siIndex.getValueref().getOpcode() != 256) {
            return 0;
        }
        IConst iconst = (IConst)siIndex.getValueref();
        if (iconst.getValue() != 0 || test.getOpcode() != 261) {
            return 0;
        }
        IfCmp ifcmp = (IfCmp)test;
        if (ifcmp.getValue1().getOpcode() != 21 || ifcmp.getValue2().getOpcode() != 21 || ((ILoad)ifcmp.getValue1()).getIndex() != siIndex.getIndex() || ((ILoad)ifcmp.getValue2()).getIndex() != siLength.getIndex() || inc.getOpcode() != 132 || ((IInc)inc).getIndex() != siIndex.getIndex() || ((IInc)inc).getCount() != 1) {
            return 0;
        }
        if (firstInstruction.getOpcode() == 317) {
            FastDeclaration declaration = (FastDeclaration)firstInstruction;
            if (declaration.getInstruction() == null) {
                return 0;
            }
            firstInstruction = declaration.getInstruction();
        }
        if (firstInstruction.getOpcode() != 269 && firstInstruction.getOpcode() != 58 && firstInstruction.getOpcode() != 54) {
            return 0;
        }
        StoreInstruction siVariable = (StoreInstruction)firstInstruction;
        Instruction valueref = siVariable.getValueref();
        if (valueref instanceof CheckCast var14_15) {
            valueref = cc.getObjectref();
        }
        if (valueref instanceof Invokevirtual var17_17) {
            ConstantCP cmr = cp.getConstantMethodref(iv.getIndex());
            ConstantNameAndType cnat = cp.getConstantNameAndType(cmr.getNameAndTypeIndex());
            String name = cp.getConstantUtf8(cnat.getNameIndex());
            String signature = cp.getConstantUtf8(cnat.getSignatureIndex());
            if (!StringUtils.equalsAny((CharSequence)(String.valueOf(name) + signature), (CharSequence[])new CharSequence[]{"intValue()I", "longValue()J", "doubleValue()D", "floatValue()F", "byteValue()B", "shortValue()S", "charValue()C", "booleanValue()Z"})) {
                return 0;
            }
            valueref = iv.getObjectref();
        }
        if (valueref.getOpcode() != 271) {
            return 0;
        }
        ArrayLoadInstruction ali = (ArrayLoadInstruction)valueref;
        if (ali.getArrayref().getOpcode() != 25 || ali.getIndexref().getOpcode() != 21 || ((ALoad)ali.getArrayref()).getIndex() != siTmpArray.getIndex() || ((ILoad)ali.getIndexref()).getIndex() != siIndex.getIndex()) {
            return 0;
        }
        return 2;
    }

    private static int getForEachArrayIbmPatternType(Instruction init, Instruction test, Instruction inc, List<Instruction> list, int beforeWhileLoopIndex, Instruction firstInstruction, StoreInstruction siIndex) {
        IConst icont = (IConst)siIndex.getValueref();
        if (icont.getValue() != 0 || beforeWhileLoopIndex < 2) {
            return 0;
        }
        Instruction beforeBeforeForInstruction = list.get(beforeWhileLoopIndex - 2);
        if (test.getLineNumber() != beforeBeforeForInstruction.getLineNumber() || beforeBeforeForInstruction.getOpcode() != 58) {
            return 0;
        }
        StoreInstruction siTmpArray = (StoreInstruction)beforeBeforeForInstruction;
        if (init.getOpcode() != 54) {
            return 0;
        }
        StoreInstruction siLength = (StoreInstruction)init;
        if (siLength.getValueref().getOpcode() != 190) {
            return 0;
        }
        ArrayLength al = (ArrayLength)siLength.getValueref();
        if (al.getArrayref().getOpcode() != 25 || ((ALoad)al.getArrayref()).getIndex() != siTmpArray.getIndex() || test.getOpcode() != 261) {
            return 0;
        }
        IfCmp ifcmp = (IfCmp)test;
        if (ifcmp.getValue1().getOpcode() != 21 || ifcmp.getValue2().getOpcode() != 21 || ((ILoad)ifcmp.getValue1()).getIndex() != siIndex.getIndex() || ((ILoad)ifcmp.getValue2()).getIndex() != siLength.getIndex() || inc.getOpcode() != 132 || ((IInc)inc).getIndex() != siIndex.getIndex() || ((IInc)inc).getCount() != 1 || firstInstruction.getOpcode() != 317) {
            return 0;
        }
        FastDeclaration declaration = (FastDeclaration)firstInstruction;
        if (declaration.getInstruction() == null || declaration.getInstruction().getOpcode() != 269 && declaration.getInstruction().getOpcode() != 58 && declaration.getInstruction().getOpcode() != 54) {
            return 0;
        }
        StoreInstruction siVariable = (StoreInstruction)declaration.getInstruction();
        if (siVariable.getValueref().getOpcode() != 271) {
            return 0;
        }
        ArrayLoadInstruction ali = (ArrayLoadInstruction)siVariable.getValueref();
        if (ali.getArrayref().getOpcode() != 25 || ali.getIndexref().getOpcode() != 21 || ((ALoad)ali.getArrayref()).getIndex() != siTmpArray.getIndex() || ((ILoad)ali.getIndexref()).getIndex() != siIndex.getIndex()) {
            return 0;
        }
        return 3;
    }

    /*
     * WARNING - void declaration
     */
    private static int getForEachArrayPatternType(ClassFile classFile, Instruction init, Instruction test, Instruction inc, List<Instruction> list, int beforeWhileLoopIndex, List<Instruction> subList) {
        if (classFile.getMajorVersion() < 49 || beforeWhileLoopIndex == 0 || subList.isEmpty()) {
            return 0;
        }
        Instruction firstInstruction = subList.get(0);
        if (test.getLineNumber() != firstInstruction.getLineNumber()) {
            return 0;
        }
        Instruction beforeForInstruction = list.get(beforeWhileLoopIndex - 1);
        if (test.getLineNumber() != beforeForInstruction.getLineNumber() || beforeForInstruction.getOpcode() != 54) {
            return 0;
        }
        StoreInstruction si = (StoreInstruction)beforeForInstruction;
        Instruction instruction = si.getValueref();
        if (instruction instanceof CheckCast var10_11) {
            void cc;
            si.setValueref(cc.getObjectref());
        }
        if (si.getValueref().getOpcode() == 190) {
            ArrayLength al = (ArrayLength)si.getValueref();
            if (al.getArrayref().getOpcode() == 265) {
                return FastInstructionListBuilder.getForEachArraySun15PatternType(init, test, inc, firstInstruction, si, classFile.getConstantPool());
            }
            if (beforeWhileLoopIndex > 1) {
                Instruction beforeBeforeForInstruction = list.get(beforeWhileLoopIndex - 2);
                return FastInstructionListBuilder.getForEachArraySun16PatternType(init, test, inc, firstInstruction, si, beforeBeforeForInstruction, classFile.getConstantPool());
            }
        }
        if (si.getValueref().getOpcode() == 256) {
            return FastInstructionListBuilder.getForEachArrayIbmPatternType(init, test, inc, list, beforeWhileLoopIndex, firstInstruction, si);
        }
        return 0;
    }

    private static int getLoopType(Instruction beforeLoop, Instruction test, Instruction beforeLastBodyLoop, Instruction lastBodyLoop) {
        if (beforeLoop == null) {
            if (test == null) {
                if (lastBodyLoop == null) {
                    return 0;
                }
                return beforeLastBodyLoop != null && beforeLastBodyLoop.getLineNumber() > lastBodyLoop.getLineNumber() ? 4 : 0;
            }
            if (lastBodyLoop != null && test.getLineNumber() != 0) {
                return test.getLineNumber() == lastBodyLoop.getLineNumber() ? 6 : 2;
            }
            return 2;
        }
        if (beforeLoop.getOpcode() == 265) {
            beforeLoop = ((AssignmentInstruction)beforeLoop).getValue1();
        }
        if (test == null) {
            if (lastBodyLoop == null) {
                return beforeLoop == null ? 0 : 1;
            }
            if (lastBodyLoop.getOpcode() == 265) {
                lastBodyLoop = ((AssignmentInstruction)lastBodyLoop).getValue1();
            }
            if (beforeLoop.getLineNumber() == 0) {
                return FastInstructionListBuilder.checkBeforeLoopAndLastBodyLoop(beforeLoop, lastBodyLoop) ? 5 : 0;
            }
            if (beforeLoop.getLineNumber() == lastBodyLoop.getLineNumber()) {
                return 5;
            }
            return beforeLastBodyLoop != null && beforeLastBodyLoop.getLineNumber() > lastBodyLoop.getLineNumber() ? 4 : 0;
        }
        if (lastBodyLoop == null) {
            if (beforeLoop.getLineNumber() == 0) {
                return 2;
            }
            return beforeLoop.getLineNumber() == test.getLineNumber() ? 3 : 2;
        }
        if (lastBodyLoop.getOpcode() == 265) {
            lastBodyLoop = ((AssignmentInstruction)lastBodyLoop).getValue1();
        }
        if (beforeLoop.getLineNumber() == 0) {
            return FastInstructionListBuilder.checkBeforeLoopAndLastBodyLoop(beforeLoop, lastBodyLoop) ? 7 : 2;
        }
        if (beforeLastBodyLoop == null) {
            if (beforeLoop.getLineNumber() == test.getLineNumber()) {
                return beforeLoop.getLineNumber() == lastBodyLoop.getLineNumber() ? 7 : 3;
            }
            return test.getLineNumber() == lastBodyLoop.getLineNumber() ? 6 : 2;
        }
        if (beforeLastBodyLoop.getLineNumber() < lastBodyLoop.getLineNumber()) {
            return beforeLoop.getLineNumber() == test.getLineNumber() ? 3 : 2;
        }
        if (beforeLoop.getLineNumber() == test.getLineNumber()) {
            return 7;
        }
        return FastInstructionListBuilder.checkBeforeLoopAndLastBodyLoop(beforeLoop, lastBodyLoop) ? 7 : 6;
    }

    private static boolean checkBeforeLoopAndLastBodyLoop(Instruction beforeLoop, Instruction lastBodyLoop) {
        if (beforeLoop.getOpcode() == 268 || beforeLoop.getOpcode() == 269 || beforeLoop.getOpcode() == 25 || beforeLoop.getOpcode() == 58 || beforeLoop.getOpcode() == 178 || beforeLoop.getOpcode() == 179 || beforeLoop.getOpcode() == 180 || beforeLoop.getOpcode() == 181) {
            if (lastBodyLoop.getOpcode() == 268 || lastBodyLoop.getOpcode() == 269 || lastBodyLoop.getOpcode() == 25 || lastBodyLoop.getOpcode() == 58 || lastBodyLoop.getOpcode() == 178 || lastBodyLoop.getOpcode() == 179 || lastBodyLoop.getOpcode() == 180 || lastBodyLoop.getOpcode() == 181) {
                return ((IndexInstruction)beforeLoop).getIndex() == ((IndexInstruction)lastBodyLoop).getIndex();
            }
        } else if (beforeLoop.getOpcode() == 54 && (beforeLoop.getOpcode() == lastBodyLoop.getOpcode() || lastBodyLoop.getOpcode() == 132)) {
            return ((IndexInstruction)beforeLoop).getIndex() == ((IndexInstruction)lastBodyLoop).getIndex();
        }
        return false;
    }

    private static int analyzeBackGoto(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeListOffset, int afterSubListOffset, int returnOffset, int jumpInstructionIndex, Instruction jumpInstruction, int firstOffset) {
        int index;
        block49: {
            ArrayList<Instruction> subList;
            block48: {
                BranchInstruction bi;
                Instruction beforeLoop;
                subList = new ArrayList<Instruction>();
                index = jumpInstructionIndex - 1;
                if (jumpInstruction.getOpcode() == 318 || jumpInstruction.getOpcode() == 319) {
                    subList.add(list.get(jumpInstructionIndex));
                    list.set(jumpInstructionIndex, null);
                }
                while (index >= 0 && list.get(index).getOffset() >= firstOffset) {
                    subList.add(list.remove(index));
                    --index;
                }
                int subListLength = subList.size();
                if (subListLength <= 0) break block48;
                Instruction instruction = beforeLoop = index >= 0 ? list.get(index) : null;
                if (beforeLoop != null) {
                    beforeListOffset = beforeLoop.getOffset();
                }
                Instruction instruction2 = (Instruction)subList.get(subListLength - 1);
                int breakOffset = FastInstructionListBuilder.searchMinusJumpOffset(subList, 0, subListLength, beforeListOffset, jumpInstruction.getOffset());
                BranchInstruction test = null;
                if (ByteCodeUtil.isIfInstruction((int)instruction2.getOpcode(), (boolean)true) && (bi = (BranchInstruction)instruction2).getJumpOffset() == breakOffset) {
                    test = bi;
                }
                Instruction lastBodyLoop = null;
                Instruction beforeLastBodyLoop = null;
                if (subListLength > 0) {
                    lastBodyLoop = (Instruction)subList.get(0);
                    if (lastBodyLoop == test) {
                        lastBodyLoop = null;
                    } else if (subListLength > 1) {
                        beforeLastBodyLoop = (Instruction)subList.get(1);
                        if (beforeLastBodyLoop == test) {
                            beforeLastBodyLoop = null;
                        }
                        if (!InstructionUtil.checkNoJumpToInterval(subList, 0, subListLength, lastBodyLoop.getOffset(), jumpInstruction.getOffset()) || !InstructionUtil.checkNoJumpToInterval(subList, 0, subListLength, beforeListOffset, firstOffset)) {
                            lastBodyLoop = null;
                            beforeLastBodyLoop = null;
                        }
                    }
                }
                int typeLoop = FastInstructionListBuilder.getLoopType(beforeLoop, test, beforeLastBodyLoop, lastBodyLoop);
                switch (typeLoop) {
                    case 0: {
                        Collections.reverse(subList);
                        Instruction firstBodyLoop = (Instruction)subList.get(0);
                        FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeListOffset, firstBodyLoop.getOffset(), afterSubListOffset, beforeListOffset, afterSubListOffset, breakOffset, returnOffset);
                        int branch = 1;
                        if (breakOffset != -1) {
                            branch = breakOffset - jumpInstruction.getOffset();
                        }
                        list.set(++index, new FastList(303, jumpInstruction.getOffset(), 0, branch, subList));
                        break;
                    }
                    case 1: {
                        Collections.reverse(subList);
                        Instruction firstBodyLoop = (Instruction)subList.get(0);
                        if (beforeLoop != null) {
                            FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoop.getOffset(), firstBodyLoop.getOffset(), afterSubListOffset, beforeListOffset, afterSubListOffset, breakOffset, returnOffset);
                        }
                        int branch = 1;
                        if (breakOffset != -1) {
                            branch = breakOffset - jumpInstruction.getOffset();
                        }
                        list.set(++index, new FastList(303, jumpInstruction.getOffset(), 0, branch, subList));
                        break;
                    }
                    case 2: {
                        subList.remove(--subListLength);
                        if (subListLength > 0) {
                            Collections.reverse(subList);
                            int beforeTestOffset = beforeLoop == null ? beforeListOffset : beforeLoop.getOffset();
                            if (test != null) {
                                FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeTestOffset, test.getOffset(), afterSubListOffset, test.getOffset(), afterSubListOffset, breakOffset, returnOffset);
                            }
                        }
                        int branch = 1;
                        if (breakOffset != -1) {
                            branch = breakOffset - jumpInstruction.getOffset();
                        }
                        ComparisonInstructionAnalyzer.inverseComparison(test);
                        ++index;
                        if (test != null) {
                            list.set(index, new FastTestList(301, jumpInstruction.getOffset(), test.getLineNumber(), branch, test, subList));
                            break;
                        }
                        break block49;
                    }
                    case 3: {
                        list.remove(index);
                        subList.remove(--subListLength);
                        if (subListLength > 0) {
                            Collections.reverse(subList);
                            if (test != null && beforeLoop != null) {
                                FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoop.getOffset(), test.getOffset(), afterSubListOffset, test.getOffset(), afterSubListOffset, breakOffset, returnOffset);
                            }
                        }
                        ComparisonInstructionAnalyzer.inverseComparison(test);
                        FastInstructionListBuilder.createForLoopCase1(classFile, method, list, index, beforeLoop, test, subList, breakOffset);
                        break;
                    }
                    case 4: {
                        Collections.reverse(subList);
                        subList.remove(--subListLength);
                        if (subListLength > 0) {
                            beforeLastBodyLoop = (Instruction)subList.get(--subListLength);
                            if (lastBodyLoop != null) {
                                FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.getOffset(), lastBodyLoop.getOffset(), lastBodyLoop.getOffset(), beforeListOffset, afterSubListOffset, breakOffset, returnOffset);
                            }
                        }
                        int branch = 1;
                        if (breakOffset != -1) {
                            branch = breakOffset - jumpInstruction.getOffset();
                        }
                        ++index;
                        if (lastBodyLoop != null) {
                            list.set(index, new FastFor(304, jumpInstruction.getOffset(), lastBodyLoop.getLineNumber(), branch, null, null, lastBodyLoop, subList));
                            break;
                        }
                        break block49;
                    }
                    case 5: {
                        list.remove(index);
                        Collections.reverse(subList);
                        subList.remove(--subListLength);
                        if (subListLength > 0) {
                            beforeLastBodyLoop = (Instruction)subList.get(--subListLength);
                            if (lastBodyLoop != null) {
                                FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.getOffset(), lastBodyLoop.getOffset(), lastBodyLoop.getOffset(), beforeListOffset, afterSubListOffset, breakOffset, returnOffset);
                            }
                        }
                        int branch = 1;
                        if (breakOffset != -1) {
                            branch = breakOffset - jumpInstruction.getOffset();
                        }
                        if (lastBodyLoop != null) {
                            list.set(index, new FastFor(304, jumpInstruction.getOffset(), lastBodyLoop.getLineNumber(), branch, beforeLoop, null, lastBodyLoop, subList));
                            break;
                        }
                        break block49;
                    }
                    case 6: {
                        subList.remove(--subListLength);
                        if (subListLength > 1) {
                            Collections.reverse(subList);
                            subList.remove(--subListLength);
                            if (subListLength > 0 && lastBodyLoop != null && test != null) {
                                beforeLastBodyLoop = (Instruction)subList.get(subListLength - 1);
                                FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.getOffset(), lastBodyLoop.getOffset(), lastBodyLoop.getOffset(), test.getOffset(), afterSubListOffset, breakOffset, returnOffset);
                            }
                            int branch = 1;
                            if (breakOffset != -1) {
                                branch = breakOffset - jumpInstruction.getOffset();
                            }
                            ComparisonInstructionAnalyzer.inverseComparison(test);
                            ++index;
                            if (lastBodyLoop != null) {
                                if (lastBodyLoop instanceof Goto) {
                                    list.set(index, new FastFor(304, jumpInstruction.getOffset(), lastBodyLoop.getLineNumber(), branch, null, test, null, subList));
                                    break;
                                }
                                list.set(index, new FastFor(304, jumpInstruction.getOffset(), lastBodyLoop.getLineNumber(), branch, null, test, lastBodyLoop, subList));
                                break;
                            }
                        } else {
                            if (subListLength == 1) {
                                int beforeTestOffset = beforeLoop == null ? beforeListOffset : beforeLoop.getOffset();
                                if (test != null && lastBodyLoop != null) {
                                    FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeTestOffset, test.getOffset(), lastBodyLoop.getOffset(), test.getOffset(), afterSubListOffset, breakOffset, returnOffset);
                                }
                            }
                            int branch = 1;
                            if (breakOffset != -1) {
                                branch = breakOffset - jumpInstruction.getOffset();
                            }
                            ComparisonInstructionAnalyzer.inverseComparison(test);
                            ++index;
                            if (test != null) {
                                list.set(index, new FastTestList(301, jumpInstruction.getOffset(), test.getLineNumber(), branch, test, subList));
                                break;
                            }
                        }
                        break block49;
                    }
                    case 7: {
                        list.remove(index);
                        subList.remove(--subListLength);
                        Collections.reverse(subList);
                        subList.remove(--subListLength);
                        if (subListLength > 0 && lastBodyLoop != null && test != null) {
                            beforeLastBodyLoop = (Instruction)subList.get(subListLength - 1);
                            FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLastBodyLoop.getOffset(), lastBodyLoop.getOffset(), lastBodyLoop.getOffset(), test.getOffset(), afterSubListOffset, breakOffset, returnOffset);
                        }
                        ComparisonInstructionAnalyzer.inverseComparison(test);
                        index = FastInstructionListBuilder.createForLoopCase3(classFile, method, list, index, beforeLoop, test, lastBodyLoop, subList, breakOffset, localVariables);
                    }
                }
                break block49;
            }
            list.set(++index, new FastList(303, jumpInstruction.getOffset(), 0, 0, subList));
        }
        return index;
    }

    private static void analyzeIfAndIfElse(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int breakOffset, int returnOffset, int testIndex, ConditionalBranchInstruction test) {
        int length = list.size();
        if (length == 0) {
            return;
        }
        int elseOffset = test.getJumpOffset();
        if (test.getBranch() < 0 && beforeLoopEntryOffset < elseOffset && elseOffset <= loopEntryOffset && afterBodyLoopOffset == afterListOffset) {
            elseOffset = afterListOffset;
        }
        if (elseOffset <= test.getOffset() || afterListOffset != -1 && elseOffset > afterListOffset) {
            return;
        }
        int index = testIndex + 1;
        if (index < length) {
            ArrayList<Instruction> subList = new ArrayList<Instruction>();
            length = FastInstructionListBuilder.extrackBlock(list, subList, index, length, elseOffset);
            int subListLength = subList.size();
            if (subListLength == 0) {
                ComparisonInstructionAnalyzer.inverseComparison(test);
                list.set(testIndex, new FastTestList(306, test.getOffset(), test.getLineNumber(), elseOffset - test.getOffset(), test, null));
                return;
            }
            int beforeSubListOffset = test.getOffset();
            Instruction beforeElseBlock = (Instruction)subList.get(subListLength - 1);
            int minusJumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(subList, 0, subListLength, test.getOffset(), beforeElseBlock.getOffset());
            int lastListOffset = list.get(length - 1).getOffset();
            if (minusJumpOffset == -1 && subListLength > 1 && beforeElseBlock.getOpcode() == 177 && (afterListOffset == -1 || afterListOffset == returnOffset || ByteCodeUtil.jumpTo((byte[])method.getCode(), (int)ByteCodeUtil.nextInstructionOffset((byte[])method.getCode(), (int)lastListOffset), (int)returnOffset)) && (((Instruction)subList.get(subListLength - 2)).getLineNumber() > beforeElseBlock.getLineNumber() || index < length && list.get(index).getLineNumber() < beforeElseBlock.getLineNumber())) {
                int n = minusJumpOffset = returnOffset == -1 ? lastListOffset + 1 : returnOffset;
            }
            if (minusJumpOffset != -1) {
                int positiveJumpOffset;
                if (subListLength == 1 && beforeElseBlock.getOpcode() == 167) {
                    FastInstructionListBuilder.createBreakAndContinue(classFile, method, subList, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, breakOffset, returnOffset);
                    ComparisonInstructionAnalyzer.inverseComparison(test);
                    list.set(testIndex, new FastTestList(306, beforeElseBlock.getOffset(), test.getLineNumber(), elseOffset - beforeElseBlock.getOffset(), test, subList));
                    return;
                }
                int afterIfElseOffset = minusJumpOffset < test.getOffset() && beforeLoopEntryOffset < minusJumpOffset && minusJumpOffset <= loopEntryOffset ? (((positiveJumpOffset = FastInstructionListBuilder.searchMinusJumpOffset(subList, 0, subListLength, -1, beforeElseBlock.getOffset())) == -1 || positiveJumpOffset >= afterListOffset) && afterBodyLoopOffset == afterListOffset ? afterListOffset : positiveJumpOffset) : minusJumpOffset;
                if (afterIfElseOffset > elseOffset && (afterListOffset == -1 || afterIfElseOffset <= afterListOffset || ByteCodeUtil.jumpTo((byte[])method.getCode(), (int)ByteCodeUtil.nextInstructionOffset((byte[])method.getCode(), (int)lastListOffset), (int)afterIfElseOffset))) {
                    if (beforeElseBlock.getOpcode() == 167 && ((Goto)beforeElseBlock).getJumpOffset() == minusJumpOffset || beforeElseBlock.getOpcode() == 177) {
                        subList.remove(subListLength - 1);
                    }
                    ArrayList<Instruction> subElseList = new ArrayList<Instruction>();
                    FastInstructionListBuilder.extrackBlock(list, subElseList, index, length, afterIfElseOffset);
                    if (!subElseList.isEmpty()) {
                        FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeSubListOffset, afterIfElseOffset, breakOffset, returnOffset);
                        beforeSubListOffset = beforeElseBlock.getOffset();
                        FastInstructionListBuilder.analyzeList(classFile, method, subElseList, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeSubListOffset, afterIfElseOffset, breakOffset, returnOffset);
                        int subElseListLength = subElseList.size();
                        int lastIfElseOffset = subElseListLength > 0 ? ((Instruction)subElseList.get(subElseListLength - 1)).getOffset() : beforeSubListOffset;
                        ComparisonInstructionAnalyzer.inverseComparison(test);
                        list.set(testIndex, new FastTest2Lists(307, lastIfElseOffset, test.getLineNumber(), afterIfElseOffset - lastIfElseOffset, test, subList, subElseList));
                        return;
                    }
                }
            }
            FastInstructionListBuilder.analyzeList(classFile, method, subList, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeSubListOffset, elseOffset, breakOffset, returnOffset);
            ComparisonInstructionAnalyzer.inverseComparison(test);
            list.set(testIndex, new FastTestList(306, beforeElseBlock.getOffset(), test.getLineNumber(), elseOffset - beforeElseBlock.getOffset(), test, subList));
        } else if (elseOffset == breakOffset) {
            list.set(testIndex, new FastInstruction(309, test.getOffset(), test.getLineNumber(), test));
        } else {
            list.set(testIndex, new FastTestList(306, test.getOffset(), test.getLineNumber(), elseOffset - test.getOffset(), test, null));
        }
    }

    private static int extrackBlock(List<Instruction> list, List<Instruction> subList, int index, int length, int endOffset) {
        while (index < length && list.get(index).getOffset() < endOffset) {
            subList.add(list.remove(index));
            --length;
        }
        return length;
    }

    private static void analyzeLookupSwitch(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int returnOffset, int switchIndex, LookupSwitch ls) {
        int pairLength = ls.getKeys().length;
        FastSwitch.Pair[] pairs = new FastSwitch.Pair[pairLength + 1];
        boolean defaultFlag = true;
        int pairIndex = 0;
        int i = 0;
        while (i < pairLength) {
            if (defaultFlag && ls.getOffset(i) > ls.getDefaultOffset()) {
                pairs[pairIndex] = new FastSwitch.Pair(true, 0, ls.getOffset() + ls.getDefaultOffset());
                ++pairIndex;
                defaultFlag = false;
            }
            pairs[pairIndex] = new FastSwitch.Pair(false, ls.getKey(i), ls.getOffset() + ls.getOffset(i));
            ++pairIndex;
            ++i;
        }
        if (defaultFlag) {
            pairs[pairIndex] = new FastSwitch.Pair(true, 0, ls.getOffset() + ls.getDefaultOffset());
        }
        int switchOpcode = FastInstructionListBuilder.analyzeSwitchType(classFile, ls.getKey());
        if (classFile.getMajorVersion() >= 51 && switchOpcode == 314 && ls.getKey().getOpcode() == 21 && switchIndex > 2 && FastInstructionListBuilder.analyzeSwitchString(classFile, localVariables, list, switchIndex, ls, pairs)) {
            list.remove(--switchIndex);
            list.remove(--switchIndex);
            list.remove(--switchIndex);
            switchOpcode = 316;
        }
        FastInstructionListBuilder.analyzeSwitch(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, returnOffset, switchIndex, switchOpcode, ls.getOffset(), ls.getLineNumber(), ls.getKey(), pairs, pairLength);
    }

    private static int analyzeSwitchType(ClassFile classFile, Instruction i) {
        ArrayLoadInstruction ali;
        if (i.getOpcode() == 271 && (ali = (ArrayLoadInstruction)i).getIndexref().getOpcode() == 182) {
            ConstantPool constants;
            ConstantCP cmr;
            Invokestatic is;
            if (ali.getArrayref().getOpcode() == 178) {
                ConstantCP cmr2;
                Invokevirtual iv;
                GetStatic gs = (GetStatic)ali.getArrayref();
                ConstantPool constants2 = classFile.getConstantPool();
                ConstantFieldref cfr = constants2.getConstantFieldref(gs.getIndex());
                ConstantNameAndType cnat = constants2.getConstantNameAndType(cfr.getNameAndTypeIndex());
                String cnatName = constants2.getConstantUtf8(cnat.getNameIndex());
                if ((classFile.getSwitchMaps().containsKey(cnatName) || classFile.getOuterClass().getSwitchMaps().containsKey(cnatName)) && (iv = (Invokevirtual)ali.getIndexref()).getArgs().isEmpty() && "ordinal".equals(constants2.getConstantUtf8((cnat = constants2.getConstantNameAndType((cmr2 = constants2.getConstantMethodref(iv.getIndex())).getNameAndTypeIndex())).getNameIndex()))) {
                    return 315;
                }
            } else if (ali.getArrayref().getOpcode() == 184 && (is = (Invokestatic)ali.getArrayref()).getArgs().isEmpty() && (cmr = (constants = classFile.getConstantPool()).getConstantMethodref(is.getIndex())).getClassIndex() == classFile.getThisClassIndex()) {
                Invokevirtual iv;
                ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
                String cnatName = constants.getConstantUtf8(cnat.getNameIndex());
                if (classFile.getSwitchMaps().containsKey(cnatName) && (iv = (Invokevirtual)ali.getIndexref()).getArgs().isEmpty() && "ordinal".equals(constants.getConstantUtf8((cnat = constants.getConstantNameAndType((cmr = constants.getConstantMethodref(iv.getIndex())).getNameAndTypeIndex())).getNameIndex()))) {
                    return 315;
                }
            }
        }
        return 314;
    }

    private static int analyzeTableSwitch(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int returnOffset, int switchIndex, TableSwitch ts) {
        int pairLength = ts.getOffsets().length;
        FastSwitch.Pair[] pairs = new FastSwitch.Pair[pairLength + 1];
        boolean defaultFlag = true;
        int pairIndex = 0;
        int i = 0;
        while (i < pairLength) {
            if (defaultFlag && ts.getOffset(i) > ts.getDefaultOffset()) {
                pairs[pairIndex] = new FastSwitch.Pair(true, 0, ts.getOffset() + ts.getDefaultOffset());
                ++pairIndex;
                defaultFlag = false;
            }
            pairs[pairIndex] = new FastSwitch.Pair(false, ts.getLow() + i, ts.getOffset() + ts.getOffset(i));
            ++pairIndex;
            ++i;
        }
        if (defaultFlag) {
            pairs[pairIndex] = new FastSwitch.Pair(true, 0, ts.getOffset() + ts.getDefaultOffset());
        }
        int switchOpcode = FastInstructionListBuilder.analyzeSwitchType(classFile, ts.getKey());
        if (classFile.getMajorVersion() >= 51 && switchOpcode == 314 && ts.getKey().getOpcode() == 21 && switchIndex > 2 && FastInstructionListBuilder.analyzeSwitchString(classFile, localVariables, list, switchIndex, ts, pairs)) {
            list.remove(--switchIndex);
            list.remove(--switchIndex);
            list.remove(--switchIndex);
            switchOpcode = 316;
        }
        FastInstructionListBuilder.analyzeSwitch(classFile, method, list, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, afterListOffset, returnOffset, switchIndex, switchOpcode, ts.getOffset(), ts.getLineNumber(), ts.getKey(), pairs, pairLength);
        return switchIndex;
    }

    private static boolean analyzeSwitchString(ClassFile classFile, LocalVariables localVariables, List<Instruction> list, int switchIndex, Switch s, FastSwitch.Pair[] pairs) {
        FastSwitch.Pair pair;
        ConstantCP cmr;
        ConstantNameAndType cnat;
        Instruction instruction = list.get(switchIndex - 3);
        if (instruction.getOpcode() != 58 || instruction.getLineNumber() != s.getKey().getLineNumber()) {
            return false;
        }
        AStore astore = (AStore)instruction;
        instruction = list.get(switchIndex - 2);
        if (instruction.getOpcode() != 54 || instruction.getLineNumber() != astore.getLineNumber()) {
            return false;
        }
        instruction = list.get(switchIndex - 1);
        if (instruction.getOpcode() != 314 || instruction.getLineNumber() != astore.getLineNumber()) {
            return false;
        }
        FastSwitch previousSwitch = (FastSwitch)instruction;
        if (previousSwitch.getTest().getOpcode() != 182) {
            return false;
        }
        Invokevirtual iv = (Invokevirtual)previousSwitch.getTest();
        if (iv.getObjectref().getOpcode() != 25 || !iv.getArgs().isEmpty()) {
            return false;
        }
        ConstantPool constants = classFile.getConstantPool();
        String methodDescriptor = constants.getConstantUtf8((cnat = constants.getConstantNameAndType((cmr = constants.getConstantMethodref(iv.getIndex())).getNameAndTypeIndex())).getSignatureIndex());
        String methodReturnedSignature = SignatureUtil.getMethodReturnedSignature(methodDescriptor);
        if (!"I".equals(methodReturnedSignature)) {
            return false;
        }
        String className = constants.getConstantClassName(cmr.getClassIndex());
        if (!"java/lang/String".equals(className)) {
            return false;
        }
        String descriptorName = constants.getConstantUtf8(cnat.getSignatureIndex());
        if (!"()I".equals(descriptorName)) {
            return false;
        }
        String methodName = constants.getConstantUtf8(cnat.getNameIndex());
        if (!"hashCode".equals(methodName)) {
            return false;
        }
        FastSwitch.Pair[] previousPairs = previousSwitch.getPairs();
        int i = previousPairs.length;
        if (i == 0) {
            return false;
        }
        int tsKeyIloadIndex = ((ILoad)s.getKey()).getIndex();
        int previousSwitchAloadIndex = ((ALoad)iv.getObjectref()).getIndex();
        HashMap<Integer, Integer> stringIndexes = new HashMap<Integer, Integer>();
        block4: while (i-- > 0) {
            pair = previousPairs[i];
            if (pair.isDefault()) continue;
            List<Instruction> instructions = pair.getInstructions();
            int length;
            while ((length = instructions.size()) != 0) {
                instruction = instructions.get(0);
                if (instruction.getOpcode() == 306) {
                    switch (length) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (instructions.get(1).getOpcode() == 312) break;
                        }
                        default: {
                            return false;
                        }
                    }
                    FastTestList ftl = (FastTestList)instruction;
                    if (ftl.getInstructions().size() == 1 && FastInstructionListBuilder.analyzeSwitchStringTestInstructions(constants, cmr, tsKeyIloadIndex, previousSwitchAloadIndex, stringIndexes, ftl.getTest(), ftl.getInstructions().get(0), 7)) continue block4;
                    return false;
                }
                if (instruction.getOpcode() != 307 || length != 1) {
                    return false;
                }
                FastTest2Lists ft2l = (FastTest2Lists)instruction;
                if (ft2l.getInstructions().size() != 1 || !FastInstructionListBuilder.analyzeSwitchStringTestInstructions(constants, cmr, tsKeyIloadIndex, previousSwitchAloadIndex, stringIndexes, ft2l.getTest(), ft2l.getInstructions().get(0), 7)) {
                    return false;
                }
                instructions = ft2l.getInstructions2();
            }
            return false;
        }
        i = pairs.length;
        while (i-- > 0) {
            pair = pairs[i];
            if (pair.isDefault()) continue;
            pair.setKey((Integer)stringIndexes.get(pair.getKey()));
        }
        localVariables.removeLocalVariableWithIndexAndOffset(tsKeyIloadIndex, s.getKey().getOffset());
        localVariables.removeLocalVariableWithIndexAndOffset(astore.getIndex(), astore.getOffset());
        s.setKey(astore.getValueref());
        return true;
    }

    private static boolean analyzeSwitchStringTestInstructions(ConstantPool constants, ConstantCP cmr, int tsKeyIloadIndex, int previousSwitchAloadIndex, Map<Integer, Integer> stringIndexes, Instruction test, Instruction value, int cmp) {
        int index;
        if (test.getOpcode() != 260 || value.getOpcode() != 54) {
            return false;
        }
        IStore istore = (IStore)value;
        if (istore.getIndex() != tsKeyIloadIndex) {
            return false;
        }
        int opcode = istore.getValueref().getOpcode();
        if (opcode == 16) {
            index = ((BIPush)istore.getValueref()).getValue();
        } else if (opcode == 256) {
            index = ((IConst)istore.getValueref()).getValue();
        } else {
            return false;
        }
        IfInstruction ii = (IfInstruction)test;
        if (ii.getCmp() != cmp || ii.getValue().getOpcode() != 182) {
            return false;
        }
        Invokevirtual ivTest = (Invokevirtual)ii.getValue();
        if (ivTest.getArgs().size() != 1 || ivTest.getObjectref().getOpcode() != 25 || ((ALoad)ivTest.getObjectref()).getIndex() != previousSwitchAloadIndex || ivTest.getArgs().get(0).getOpcode() != 18) {
            return false;
        }
        ConstantCP cmrTest = constants.getConstantMethodref(ivTest.getIndex());
        if (cmr.getClassIndex() != cmrTest.getClassIndex()) {
            return false;
        }
        ConstantNameAndType cnatTest = constants.getConstantNameAndType(cmrTest.getNameAndTypeIndex());
        String descriptorNameTest = constants.getConstantUtf8(cnatTest.getSignatureIndex());
        if (!"(Ljava/lang/Object;)Z".equals(descriptorNameTest)) {
            return false;
        }
        String methodNameTest = constants.getConstantUtf8(cnatTest.getNameIndex());
        if (!"equals".equals(methodNameTest)) {
            return false;
        }
        stringIndexes.put(index, ((Ldc)ivTest.getArgs().get(0)).getIndex());
        return true;
    }

    private static void analyzeSwitch(ClassFile classFile, Method method, List<Instruction> list, LocalVariables localVariables, IntSet offsetLabelSet, int beforeLoopEntryOffset, int loopEntryOffset, int afterBodyLoopOffset, int afterListOffset, int returnOffset, int switchIndex, int switchOpcode, int switchOffset, int switchLineNumber, Instruction test, FastSwitch.Pair[] pairs, int pairLength) {
        int breakOffset = -1;
        Arrays.sort(pairs);
        int lastSwitchOffset = switchOffset;
        int index = switchIndex + 1;
        if (index < list.size()) {
            int nbrInstructions;
            int i = 0;
            while (i < pairLength) {
                ArrayList<Instruction> instructions = null;
                int beforeCaseOffset = lastSwitchOffset;
                int afterCaseOffset = pairs[i + 1].getOffset();
                while (index < list.size()) {
                    Instruction instruction = list.get(index);
                    if (instruction.getOffset() >= afterCaseOffset) {
                        int nbrInstructions2;
                        if (instructions == null || (nbrInstructions2 = instructions.size()) <= 0) break;
                        int breakOffsetTmp = FastInstructionListBuilder.searchMinusJumpOffset(instructions, 0, nbrInstructions2, beforeCaseOffset, lastSwitchOffset);
                        if (breakOffsetTmp != -1 && (breakOffset == -1 || breakOffset > breakOffsetTmp)) {
                            breakOffset = breakOffsetTmp;
                        }
                        if ((instruction = (Instruction)instructions.get(nbrInstructions2 - 1)).getOpcode() != 167) break;
                        int lineNumber = instruction.getLineNumber();
                        if (nbrInstructions2 <= 1 || ((Instruction)instructions.get(nbrInstructions2 - 2)).getLineNumber() == lineNumber) {
                            lineNumber = 0;
                        }
                        instructions.set(nbrInstructions2 - 1, new FastInstruction(312, instruction.getOffset(), lineNumber, null));
                        break;
                    }
                    if (instructions == null) {
                        instructions = new ArrayList<Instruction>();
                    }
                    list.remove(index);
                    instructions.add(instruction);
                    lastSwitchOffset = instruction.getOffset();
                }
                pairs[i].setInstructions(instructions);
                ++i;
            }
            if (breakOffset != -1) {
                int jumpOffset;
                Instruction instruction;
                int afterSwitchOffset = breakOffset >= switchOffset ? breakOffset : list.get(list.size() - 1).getOffset() + 1;
                int i2 = switchIndex;
                while (i2-- > 0) {
                    instruction = list.get(i2);
                    if (!ByteCodeUtil.isIfOrGotoInstruction((int)instruction.getOpcode(), (boolean)true) && instruction.getOpcode() != 314 && instruction.getOpcode() != 315 && instruction.getOpcode() != 316 || lastSwitchOffset >= (jumpOffset = ((BranchInstruction)instruction).getJumpOffset()) || jumpOffset >= afterSwitchOffset) continue;
                    afterSwitchOffset = jumpOffset;
                }
                i2 = list.size();
                while (i2-- > 0) {
                    instruction = list.get(i2);
                    if ((ByteCodeUtil.isIfOrGotoInstruction((int)instruction.getOpcode(), (boolean)true) || instruction.getOpcode() == 314 || instruction.getOpcode() == 315 || instruction.getOpcode() == 316) && lastSwitchOffset < (jumpOffset = ((BranchInstruction)instruction).getJumpOffset()) && jumpOffset < afterSwitchOffset) {
                        afterSwitchOffset = jumpOffset;
                    }
                    if (instruction.getOffset() <= afterSwitchOffset || instruction.getOffset() <= lastSwitchOffset) break;
                }
                ArrayList<Instruction> instructions = null;
                while (index < list.size()) {
                    instruction = list.get(index);
                    if (instruction.getOffset() >= afterSwitchOffset) {
                        if (instructions == null || (nbrInstructions = instructions.size()) <= 0 || (instruction = (Instruction)instructions.get(nbrInstructions - 1)).getOpcode() != 167) break;
                        instructions.set(nbrInstructions - 1, new FastInstruction(312, instruction.getOffset(), instruction.getLineNumber(), null));
                        break;
                    }
                    if (instructions == null) {
                        instructions = new ArrayList<Instruction>();
                    }
                    list.remove(index);
                    instructions.add(instruction);
                    lastSwitchOffset = instruction.getOffset();
                }
                pairs[pairLength].setInstructions(instructions);
            }
            int beforeListOffset = test.getOffset();
            if (index < list.size()) {
                afterListOffset = list.get(index).getOffset();
            }
            int i3 = 0;
            while (i3 <= pairLength) {
                FastSwitch.Pair pair = pairs[i3];
                List<Instruction> instructions = pair.getInstructions();
                if (instructions != null && (nbrInstructions = instructions.size()) > 0) {
                    Instruction instruction = instructions.get(nbrInstructions - 1);
                    if (instruction.getOpcode() == 312) {
                        FastInstructionListBuilder.removeLastInstruction(instructions);
                        FastInstructionListBuilder.analyzeList(classFile, method, instructions, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeListOffset, afterListOffset, breakOffset, returnOffset);
                        instructions.add(instruction);
                    } else {
                        int jumpOffset;
                        FastInstructionListBuilder.analyzeList(classFile, method, instructions, localVariables, offsetLabelSet, beforeLoopEntryOffset, loopEntryOffset, afterBodyLoopOffset, beforeListOffset, afterListOffset, breakOffset, returnOffset);
                        nbrInstructions = instructions.size();
                        if (!(nbrInstructions <= 0 || !ByteCodeUtil.isIfOrGotoInstruction((int)(instruction = instructions.get(nbrInstructions - 1)).getOpcode(), (boolean)true) && instruction.getOpcode() != 306 && instruction.getOpcode() != 307 && instruction.getOpcode() != 314 && instruction.getOpcode() != 315 && instruction.getOpcode() != 316 || (jumpOffset = ((BranchInstruction)instruction).getJumpOffset()) >= switchOffset && lastSwitchOffset >= jumpOffset)) {
                            instructions.add(new FastInstruction(312, lastSwitchOffset + 1, 0, null));
                        }
                    }
                    beforeListOffset = instruction.getOffset();
                }
                ++i3;
            }
        }
        int branch = breakOffset == -1 ? 1 : breakOffset - lastSwitchOffset;
        list.set(switchIndex, new FastSwitch(switchOpcode, lastSwitchOffset, switchLineNumber, branch, test, pairs));
    }

    private static void removeLastInstruction(List<Instruction> instructions) {
        instructions.remove(instructions.size() - 1);
    }

    private static void addLabels(List<Instruction> list, IntSet offsetLabelSet) {
        int i = offsetLabelSet.size() - 1;
        while (i >= 0) {
            FastInstructionListBuilder.searchInstructionAndAddLabel(list, offsetLabelSet.get(i));
            --i;
        }
    }

    private static boolean searchInstructionAndAddLabel(List<Instruction> list, int labelOffset) {
        int index = InstructionUtil.getIndexForOffset(list, labelOffset);
        if (index < 0) {
            return false;
        }
        boolean found = false;
        Instruction instruction = list.get(index);
        switch (instruction.getOpcode()) {
            case 303: {
                List<Instruction> instructions = ((FastList)instruction).getInstructions();
                if (instructions == null) break;
                found = FastInstructionListBuilder.searchInstructionAndAddLabel(instructions, labelOffset);
                break;
            }
            case 301: 
            case 302: 
            case 306: {
                FastTestList ftl = (FastTestList)instruction;
                if (labelOffset < ftl.getTest().getOffset() || ftl.getInstructions() == null) break;
                found = FastInstructionListBuilder.searchInstructionAndAddLabel(ftl.getInstructions(), labelOffset);
                break;
            }
            case 319: {
                FastSynchronized fs = (FastSynchronized)instruction;
                if (labelOffset < fs.getMonitor().getOffset() || fs.getInstructions() == null) break;
                found = FastInstructionListBuilder.searchInstructionAndAddLabel(fs.getInstructions(), labelOffset);
                break;
            }
            case 304: {
                FastFor ff = (FastFor)instruction;
                if (ff.getInit() != null && labelOffset < ff.getInit().getOffset() || ff.getInstructions() == null) break;
                found = FastInstructionListBuilder.searchInstructionAndAddLabel(ff.getInstructions(), labelOffset);
                break;
            }
            case 307: {
                FastTest2Lists ft2l = (FastTest2Lists)instruction;
                if (labelOffset < ft2l.getTest().getOffset()) break;
                found = FastInstructionListBuilder.searchInstructionAndAddLabel(ft2l.getInstructions(), labelOffset) || FastInstructionListBuilder.searchInstructionAndAddLabel(ft2l.getInstructions2(), labelOffset);
                break;
            }
            case 314: 
            case 315: 
            case 316: {
                FastSwitch.Pair[] pairs;
                FastSwitch fs = (FastSwitch)instruction;
                if (labelOffset < fs.getTest().getOffset() || (pairs = fs.getPairs()) == null) break;
                int i = pairs.length - 1;
                while (i >= 0 && !found) {
                    List<Instruction> instructions = pairs[i].getInstructions();
                    if (instructions != null) {
                        found = FastInstructionListBuilder.searchInstructionAndAddLabel(instructions, labelOffset);
                    }
                    --i;
                }
                break;
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                found = FastInstructionListBuilder.searchInstructionAndAddLabel(ft.getInstructions(), labelOffset);
                if (!found && ft.getCatches() != null) {
                    int i = ft.getCatches().size() - 1;
                    while (i >= 0 && !found) {
                        found = FastInstructionListBuilder.searchInstructionAndAddLabel(ft.getCatches().get(i).instructions(), labelOffset);
                        --i;
                    }
                }
                if (found || ft.getFinallyInstructions() == null) break;
                found = FastInstructionListBuilder.searchInstructionAndAddLabel(ft.getFinallyInstructions(), labelOffset);
            }
        }
        if (!found) {
            list.set(index, new FastLabel(320, labelOffset, instruction.getLineNumber(), instruction));
        }
        return true;
    }
}

