/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.AStore;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ExceptionLoad;
import jd.core.model.instruction.bytecode.instruction.Goto;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Jsr;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.ReturnAddressLoad;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.process.analyzer.instruction.bytecode.ComparisonInstructionAnalyzer;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.process.analyzer.instruction.fast.UnexpectedInstructionException;
import jd.core.process.analyzer.instruction.fast.visitor.CheckLocalVariableUsedVisitor;
import jd.core.process.analyzer.instruction.fast.visitor.FastCompareInstructionVisitor;
import jd.core.process.analyzer.util.InstructionUtil;
import jd.core.util.IntSet;
import org.apache.bcel.classfile.CodeException;
import org.apache.commons.lang3.ArrayUtils;

public final class FastCodeExceptionAnalyzer {
    private FastCodeExceptionAnalyzer() {
    }

    public static List<FastCodeExcepcion> aggregateCodeExceptions(Method method, List<Instruction> list) {
        Object[] arrayOfCodeException = method.getCodeExceptions();
        if (ArrayUtils.isEmpty((Object[])arrayOfCodeException)) {
            return null;
        }
        ArrayList<FastAggregatedCodeExcepcion> fastAggregatedCodeExceptions = new ArrayList<FastAggregatedCodeExcepcion>(arrayOfCodeException.length);
        FastCodeExceptionAnalyzer.populateListOfFastAggregatedCodeException(method, list, fastAggregatedCodeExceptions);
        int length = fastAggregatedCodeExceptions.size();
        ArrayList<FastCodeExcepcion> fastCodeExceptions = new ArrayList<FastCodeExcepcion>(length);
        fastCodeExceptions.add(FastCodeExceptionAnalyzer.newFastCodeException(list, (FastAggregatedCodeExcepcion)fastAggregatedCodeExceptions.get(0)));
        int i = 1;
        while (i < length) {
            FastAggregatedCodeExcepcion fastAggregatedCodeException = (FastAggregatedCodeExcepcion)fastAggregatedCodeExceptions.get(i);
            if (!FastCodeExceptionAnalyzer.updateFastCodeException(fastCodeExceptions, fastAggregatedCodeException)) {
                fastCodeExceptions.add(FastCodeExceptionAnalyzer.newFastCodeException(list, fastAggregatedCodeException));
            }
            ++i;
        }
        Collections.sort(fastCodeExceptions);
        int i2 = fastCodeExceptions.size() - 1;
        while (i2 >= 1) {
            FastCodeExcepcion fce1 = (FastCodeExcepcion)fastCodeExceptions.get(i2);
            FastCodeExcepcion fce2 = (FastCodeExcepcion)fastCodeExceptions.get(i2 - 1);
            if (!(fce1.getTryFromOffset() != fce2.getTryFromOffset() || fce1.getTryToOffset() != fce2.getTryToOffset() || fce1.hasSynchronizedFlag() != fce2.hasSynchronizedFlag() || fce1.getAfterOffset() != -1 && fce1.getAfterOffset() <= fce2.maxOffset || fce2.getAfterOffset() != -1 && fce2.getAfterOffset() <= fce1.maxOffset)) {
                fce2.getCatches().addAll(fce1.getCatches());
                Collections.sort(fce2.getCatches());
                if (fce2.nbrFinally == 0) {
                    fce2.setFinallyFromOffset(fce1.getFinallyFromOffset());
                    fce2.nbrFinally = fce1.nbrFinally;
                }
                if (fce2.maxOffset < fce1.maxOffset) {
                    fce2.maxOffset = fce1.maxOffset;
                }
                if (fce2.getAfterOffset() == -1 || fce1.getAfterOffset() != -1 && fce1.getAfterOffset() < fce2.getAfterOffset()) {
                    fce2.setAfterOffset(fce1.getAfterOffset());
                }
                fastCodeExceptions.remove(i2);
            }
            --i2;
        }
        List<int[]> switchCaseOffsets = FastCodeExceptionAnalyzer.searchSwitchCaseOffsets(list);
        int i3 = fastCodeExceptions.size() - 1;
        while (i3 >= 0) {
            FastCodeExcepcion fce = (FastCodeExcepcion)fastCodeExceptions.get(i3);
            FastCodeExceptionAnalyzer.defineType(list, fce);
            if (fce.getType() == 0) {
                System.err.println("Undefined type catch");
            }
            FastCodeExceptionAnalyzer.computeAfterOffset(method, list, switchCaseOffsets, fastCodeExceptions, fce, i3);
            length = list.size();
            if (fce.getAfterOffset() == -1 && length > 0) {
                Instruction lastInstruction = list.get(length - 1);
                fce.setAfterOffset(lastInstruction.getOffset());
                if (lastInstruction.getOpcode() != 177 && lastInstruction.getOpcode() != 273) {
                    fce.setAfterOffset(fce.getAfterOffset() + 1);
                }
            }
            --i3;
        }
        Collections.sort(fastCodeExceptions);
        return fastCodeExceptions;
    }

    private static void populateListOfFastAggregatedCodeException(Method method, List<Instruction> list, List<FastAggregatedCodeExcepcion> fastAggregatedCodeExceptions) {
        FastAggregatedCodeExcepcion face;
        int length = method.getCode().length;
        if (length == 0) {
            return;
        }
        FastAggregatedCodeExcepcion[] array = new FastAggregatedCodeExcepcion[length];
        CodeException[] arrayOfCodeException = method.getCodeExceptions();
        length = arrayOfCodeException.length;
        int i = 0;
        while (i < length) {
            CodeException codeException = arrayOfCodeException[i];
            if (array[codeException.getHandlerPC()] == null) {
                face = new FastAggregatedCodeExcepcion(codeException.getStartPC(), codeException.getEndPC(), codeException.getHandlerPC(), codeException.getCatchType());
                fastAggregatedCodeExceptions.add(face);
                array[codeException.getHandlerPC()] = face;
            } else {
                face = array[codeException.getHandlerPC()];
                if (face.getCatchType() == 0) {
                    ++face.nbrFinally;
                } else if (FastCodeExceptionAnalyzer.isNotAlreadyStored(face, codeException.getCatchType())) {
                    if (face.otherCatchTypes == null) {
                        face.otherCatchTypes = new int[length];
                    }
                    face.otherCatchTypes[i] = codeException.getCatchType();
                }
            }
            ++i;
        }
        i = fastAggregatedCodeExceptions.size();
        while (i-- > 0) {
            face = fastAggregatedCodeExceptions.get(i);
            if (face.getCatchType() != 0 || !FastCodeExceptionAnalyzer.isASynchronizedBlock(list, face)) continue;
            face.synchronizedFlag = true;
        }
    }

    private static boolean isNotAlreadyStored(FastAggregatedCodeExcepcion face, int catchType) {
        if (face.getCatchType() == catchType) {
            return false;
        }
        if (face.otherCatchTypes != null) {
            int i = face.otherCatchTypes.length;
            while (i-- > 0) {
                if (face.otherCatchTypes[i] != catchType) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isASynchronizedBlock(List<Instruction> list, FastAggregatedCodeExcepcion face) {
        int varMonitorIndex;
        int index = InstructionUtil.getIndexForOffset(list, face.getStartPC());
        if (index == -1) {
            return false;
        }
        if (list.get(index).getOpcode() == 195) {
            return true;
        }
        if (index < 1) {
            return false;
        }
        Instruction instruction = list.get(index - 1);
        if (instruction.getOpcode() != 194) {
            return false;
        }
        MonitorEnter monitorEnter = (MonitorEnter)instruction;
        switch (monitorEnter.getObjectref().getOpcode()) {
            case 25: {
                if (index < 2) {
                    return false;
                }
                instruction = list.get(index - 2);
                if (instruction.getOpcode() != 58) {
                    return false;
                }
                AStore astore = (AStore)instruction;
                varMonitorIndex = astore.getIndex();
                break;
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)monitorEnter.getObjectref();
                if (ai.getValue1().getOpcode() != 25) {
                    return false;
                }
                ALoad aload = (ALoad)ai.getValue1();
                varMonitorIndex = aload.getIndex();
                break;
            }
            default: {
                return false;
            }
        }
        boolean checkMonitorExit = false;
        int length = list.size();
        for (index = InstructionUtil.getIndexForOffset(list, face.getHandlerPC()); index < length; ++index) {
            instruction = list.get(index);
            if (instruction.getOpcode() != 195) continue;
            checkMonitorExit = true;
            MonitorExit monitorExit = (MonitorExit)instruction;
            if (monitorExit.getObjectref().getOpcode() != 25 || ((ALoad)monitorExit.getObjectref()).getIndex() != varMonitorIndex) continue;
            return true;
        }
        return !checkMonitorExit && index == length;
    }

    private static boolean updateFastCodeException(List<FastCodeExcepcion> fastCodeExceptions, FastAggregatedCodeExcepcion fastAggregatedCodeException) {
        if (fastAggregatedCodeException.getCatchType() == 0) {
            for (FastCodeExcepcion fce : fastCodeExceptions) {
                if (fce.getFinallyFromOffset() != -1 || fastAggregatedCodeException.getStartPC() != fce.getTryFromOffset() || fastAggregatedCodeException.getEndPC() != fce.getTryToOffset() || fastAggregatedCodeException.getHandlerPC() <= fce.maxOffset || fastAggregatedCodeException.synchronizedFlag || fce.getAfterOffset() != -1 && (fastAggregatedCodeException.getEndPC() >= fce.getAfterOffset() || fastAggregatedCodeException.getHandlerPC() >= fce.getAfterOffset())) continue;
                fce.maxOffset = fastAggregatedCodeException.getHandlerPC();
                fce.setFinallyFromOffset(fastAggregatedCodeException.getHandlerPC());
                fce.nbrFinally += fastAggregatedCodeException.nbrFinally;
                return true;
            }
            for (FastCodeExcepcion fce : fastCodeExceptions) {
                if (fce.getFinallyFromOffset() != -1 || fastAggregatedCodeException.getStartPC() != fce.getTryFromOffset() || fastAggregatedCodeException.getEndPC() < fce.getTryToOffset() || fastAggregatedCodeException.getHandlerPC() <= fce.maxOffset || fastAggregatedCodeException.synchronizedFlag || fce.getAfterOffset() != -1 && (fastAggregatedCodeException.getEndPC() >= fce.getAfterOffset() || fastAggregatedCodeException.getHandlerPC() >= fce.getAfterOffset())) continue;
                fce.maxOffset = fastAggregatedCodeException.getHandlerPC();
                fce.setFinallyFromOffset(fastAggregatedCodeException.getHandlerPC());
                fce.nbrFinally += fastAggregatedCodeException.nbrFinally;
                return true;
            }
        }
        return false;
    }

    private static FastCodeExcepcion newFastCodeException(List<Instruction> list, FastAggregatedCodeExcepcion fastCodeException) {
        FastCodeExcepcion fce = new FastCodeExcepcion(fastCodeException.getStartPC(), fastCodeException.getEndPC(), fastCodeException.getHandlerPC(), fastCodeException.synchronizedFlag);
        if (fastCodeException.getCatchType() == 0) {
            fce.setFinallyFromOffset(fastCodeException.getHandlerPC());
            fce.nbrFinally += fastCodeException.nbrFinally;
        } else {
            fce.getCatches().add(new FastCodeExceptionCatch(fastCodeException.getCatchType(), fastCodeException.otherCatchTypes, fastCodeException.getHandlerPC()));
        }
        fce.setAfterOffset(FastCodeExceptionAnalyzer.searchAfterOffset(list, fastCodeException.getHandlerPC()));
        return fce;
    }

    private static int searchAfterOffset(List<Instruction> list, int offset) {
        int index = InstructionUtil.getIndexForOffset(list, offset);
        if (index <= 0) {
            return offset;
        }
        Instruction i = list.get(--index);
        switch (i.getOpcode()) {
            case 167: {
                int branch = ((Goto)i).getBranch();
                if (branch < 0) {
                    return -1;
                }
                int jumpOffset = i.getOffset() + branch;
                index = InstructionUtil.getIndexForOffset(list, jumpOffset);
                if (index <= 0) {
                    return -1;
                }
                i = list.get(index);
                if (i.getOpcode() != 168) {
                    return jumpOffset;
                }
                branch = ((Jsr)i).getBranch();
                if (branch > 0) {
                    return i.getOffset() + branch;
                }
                return jumpOffset + 1;
            }
            case 169: {
                while (--index >= 3) {
                    if (list.get(index).getOpcode() != 191 || list.get(index - 1).getOpcode() != 168 || list.get(index - 2).getOpcode() != 58 || list.get(index - 3).getOpcode() != 167) continue;
                    Goto g = (Goto)list.get(index - 3);
                    return g.getJumpOffset();
                }
                break;
            }
        }
        return -1;
    }

    private static List<int[]> searchSwitchCaseOffsets(List<Instruction> list) {
        ArrayList<int[]> switchCaseOffsets = new ArrayList<int[]>();
        int i = list.size();
        while (i-- > 0) {
            Instruction instruction = list.get(i);
            if (instruction.getOpcode() != 170 && instruction.getOpcode() != 171) continue;
            Switch s = (Switch)instruction;
            int j = s.getOffsets().length;
            int[] offsets = new int[j + 1];
            offsets[j] = s.getOffset() + s.getDefaultOffset();
            while (j-- > 0) {
                offsets[j] = s.getOffset() + s.getOffset(j);
            }
            Arrays.sort(offsets);
            switchCaseOffsets.add(offsets);
        }
        return switchCaseOffsets;
    }

    private static void defineType(List<Instruction> list, FastCodeExcepcion fastCodeException) {
        block0 : switch (fastCodeException.nbrFinally) {
            case 0: {
                fastCodeException.setType(1);
                break;
            }
            case 1: {
                Instruction instruction;
                if (fastCodeException.getCatches() == null || fastCodeException.getCatches().isEmpty()) {
                    int index = InstructionUtil.getIndexForOffset(list, fastCodeException.getFinallyFromOffset());
                    if (index < 0) {
                        return;
                    }
                    Instruction instruction2 = list.get(index - 1);
                    switch (instruction2.getOpcode()) {
                        case 167: {
                            if (FastCodeExceptionAnalyzer.tryBlockContainsJsr(list, fastCodeException)) {
                                fastCodeException.setType(2);
                                break;
                            }
                            if (list.get(index - 2).getOpcode() == 195) {
                                fastCodeException.setType(5);
                                break;
                            }
                            fastCodeException.setType(13);
                            break;
                        }
                        case 177: 
                        case 273: {
                            if (FastCodeExceptionAnalyzer.tryBlockContainsJsr(list, fastCodeException)) {
                                fastCodeException.setType(2);
                                break;
                            }
                            if (list.get(index - 2).getOpcode() == 195) {
                                fastCodeException.setType(5);
                                break;
                            }
                            Instruction firstFinallyInstruction = list.get(index + 1);
                            int exceptionIndex = ((AStore)list.get(index)).getIndex();
                            int length = list.size();
                            while (++index < length) {
                                AThrow athrow;
                                instruction2 = list.get(index);
                                if (instruction2.getOpcode() == 191 && (athrow = (AThrow)instruction2).getValue().getOpcode() == 25 && ((ALoad)athrow.getValue()).getIndex() == exceptionIndex) break;
                            }
                            if (++index >= length) {
                                fastCodeException.setType(10);
                                break;
                            }
                            instruction2 = list.get(index);
                            fastCodeException.setType(instruction2.getOpcode() != firstFinallyInstruction.getOpcode() || firstFinallyInstruction.getLineNumber() == 0 || firstFinallyInstruction.getLineNumber() != instruction2.getLineNumber() ? 10 : 13);
                            break;
                        }
                        case 191: {
                            if (list.get(index + 1).getOpcode() == 168) {
                                fastCodeException.setType(4);
                                break;
                            }
                            if (list.get(index).getOpcode() == 195) {
                                fastCodeException.setType(2);
                                break;
                            }
                            fastCodeException.setType(11);
                            break;
                        }
                        case 169: {
                            fastCodeException.setType(6);
                        }
                    }
                    break;
                }
                int index = InstructionUtil.getIndexForOffset(list, fastCodeException.getCatches().get(0).getFromOffset());
                if (index < 0) {
                    return;
                }
                if ((instruction = list.get(--index)).getOpcode() == 167) {
                    Goto g = (Goto)instruction;
                    if ((instruction = list.get(--index)).getOpcode() == 168) {
                        fastCodeException.setType(9);
                        break;
                    }
                    index = InstructionUtil.getIndexForOffset(list, g.getJumpOffset());
                    instruction = list.get(index);
                    if (instruction.getOpcode() == 168) {
                        fastCodeException.setType(7);
                        break;
                    }
                    instruction = list.get(index - 1);
                    if (instruction.getOpcode() == 191) {
                        fastCodeException.setType(14);
                        break;
                    }
                    fastCodeException.setType(8);
                    break;
                }
                if (instruction.getOpcode() == 169) {
                    fastCodeException.setType(7);
                    break;
                }
                if ((instruction = list.get(--index)).getOpcode() != 168) break;
                fastCodeException.setType(9);
                break;
            }
            default: {
                int branch;
                int index;
                if (fastCodeException.getCatches() == null || fastCodeException.getCatches().isEmpty()) {
                    int index2 = InstructionUtil.getIndexForOffset(list, fastCodeException.getTryToOffset());
                    if (index2 < 0) {
                        return;
                    }
                    Instruction instruction = list.get(index2);
                    switch (instruction.getOpcode()) {
                        case 168: {
                            fastCodeException.setType(9);
                            break block0;
                        }
                        case 191: {
                            fastCodeException.setType(12);
                            break block0;
                        }
                        case 167: {
                            Goto g = (Goto)instruction;
                            instruction = InstructionUtil.getInstructionAt(list, g.getJumpOffset());
                            if (instruction == null) {
                                return;
                            }
                            if (instruction.getOpcode() == 168 && ((Jsr)instruction).getBranch() < 0) {
                                fastCodeException.setType(12);
                                break block0;
                            }
                            if (index2 > 0 && list.get(index2 - 1).getOpcode() == 168) {
                                fastCodeException.setType(9);
                                break block0;
                            }
                            fastCodeException.setType(10);
                            break block0;
                        }
                        case 87: {
                            FastCodeExceptionAnalyzer.defineTypeJikes122Or142(list, fastCodeException, ((Pop)instruction).getObjectref(), index2);
                            break block0;
                        }
                        case 58: {
                            FastCodeExceptionAnalyzer.defineTypeJikes122Or142(list, fastCodeException, ((AStore)instruction).getValueref(), index2);
                            break block0;
                        }
                        case 177: 
                        case 273: {
                            if (index2 > 0 && list.get(index2 - 1).getOpcode() == 168) {
                                fastCodeException.setType(9);
                                break block0;
                            }
                            fastCodeException.setType(10);
                            break block0;
                        }
                    }
                    fastCodeException.setType(10);
                    break;
                }
                boolean uniqueJumpAddressFlag = true;
                int uniqueJumpAddress = -1;
                if (fastCodeException.getCatches() != null) {
                    int i = fastCodeException.getCatches().size() - 1;
                    while (i >= 0) {
                        int branch2;
                        Instruction instruction;
                        FastCodeExceptionCatch fcec = fastCodeException.getCatches().get(i);
                        int index3 = InstructionUtil.getIndexForOffset(list, fcec.getFromOffset());
                        if (index3 != -1 && (instruction = list.get(index3 - 1)).getOpcode() == 167 && (branch2 = ((Goto)instruction).getBranch()) > 0) {
                            int jumpAddress = instruction.getOffset() + branch2;
                            if (uniqueJumpAddress == -1) {
                                uniqueJumpAddress = jumpAddress;
                            } else if (uniqueJumpAddress != jumpAddress) {
                                uniqueJumpAddressFlag = false;
                                break;
                            }
                        }
                        --i;
                    }
                }
                if ((index = InstructionUtil.getIndexForOffset(list, fastCodeException.getFinallyFromOffset())) < 0) {
                    return;
                }
                Instruction instruction = list.get(--index);
                if (uniqueJumpAddressFlag && instruction.getOpcode() == 167 && (branch = ((Goto)instruction).getBranch()) > 0) {
                    int jumpAddress = instruction.getOffset() + branch;
                    if (uniqueJumpAddress == -1) {
                        uniqueJumpAddress = jumpAddress;
                    } else if (uniqueJumpAddress != jumpAddress) {
                        uniqueJumpAddressFlag = false;
                    }
                }
                if (!uniqueJumpAddressFlag) {
                    fastCodeException.setType(14);
                    return;
                }
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.getTryToOffset());
                if (index < 0) {
                    return;
                }
                instruction = list.get(index);
                switch (instruction.getOpcode()) {
                    case 168: {
                        fastCodeException.setType(9);
                        break block0;
                    }
                    case 191: {
                        fastCodeException.setType(12);
                        break block0;
                    }
                    case 167: {
                        Goto g = (Goto)instruction;
                        instruction = InstructionUtil.getInstructionAt(list, g.getJumpOffset());
                        if (instruction == null) {
                            return;
                        }
                        if (instruction.getOpcode() == 168 && ((Jsr)instruction).getBranch() < 0) {
                            fastCodeException.setType(12);
                            break block0;
                        }
                        if (index > 0 && list.get(index - 1).getOpcode() == 168) {
                            fastCodeException.setType(9);
                            break block0;
                        }
                        fastCodeException.setType(10);
                        break block0;
                    }
                    case 87: {
                        FastCodeExceptionAnalyzer.defineTypeJikes122Or142(list, fastCodeException, ((Pop)instruction).getObjectref(), index);
                        break block0;
                    }
                    case 58: {
                        FastCodeExceptionAnalyzer.defineTypeJikes122Or142(list, fastCodeException, ((AStore)instruction).getValueref(), index);
                        break block0;
                    }
                    case 177: 
                    case 273: {
                        instruction = InstructionUtil.getInstructionAt(list, uniqueJumpAddress);
                        if (instruction != null && instruction.getOpcode() == 168 && ((Jsr)instruction).getBranch() < 0) {
                            fastCodeException.setType(12);
                            break block0;
                        }
                        if (index > 0 && list.get(index - 1).getOpcode() == 168) {
                            fastCodeException.setType(9);
                            break block0;
                        }
                        fastCodeException.setType(10);
                        break block0;
                    }
                }
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.getFinallyFromOffset());
                Instruction firstFinallyInstruction = list.get(index + 1);
                if (firstFinallyInstruction.getOpcode() != 58) {
                    fastCodeException.setType(10);
                    break;
                }
                int exceptionIndex = ((AStore)list.get(index)).getIndex();
                int length = list.size();
                while (++index < length) {
                    AThrow athrow;
                    instruction = list.get(index);
                    if (instruction.getOpcode() == 191 && (athrow = (AThrow)instruction).getValue().getOpcode() == 25 && ((ALoad)athrow.getValue()).getIndex() == exceptionIndex) break;
                }
                if (++index >= length) {
                    fastCodeException.setType(10);
                    break;
                }
                instruction = list.get(index);
                fastCodeException.setType(instruction.getOpcode() != firstFinallyInstruction.getOpcode() || firstFinallyInstruction.getLineNumber() == 0 || firstFinallyInstruction.getLineNumber() != instruction.getLineNumber() ? 10 : 14);
            }
        }
    }

    private static boolean tryBlockContainsJsr(List<Instruction> list, FastCodeExcepcion fastCodeException) {
        int index = InstructionUtil.getIndexForOffset(list, fastCodeException.getTryToOffset());
        if (index != -1) {
            Instruction instruction;
            int tryFromOffset = fastCodeException.getTryFromOffset();
            while ((instruction = list.get(index)).getOffset() > tryFromOffset) {
                if (instruction.getOpcode() == 168 && ((Jsr)instruction).getJumpOffset() > fastCodeException.getFinallyFromOffset()) {
                    return true;
                }
                if (index == 0) break;
                --index;
            }
        }
        return false;
    }

    private static void defineTypeJikes122Or142(List<Instruction> list, FastCodeExcepcion fastCodeException, Instruction instruction, int index) {
        int jumpAddress;
        if (instruction.getOpcode() == 270 && (instruction = list.get(--index)).getOpcode() == 167 && (instruction = InstructionUtil.getInstructionAt(list, jumpAddress = ((Goto)instruction).getJumpOffset())) != null && instruction.getOpcode() == 168) {
            fastCodeException.setType(12);
            return;
        }
        fastCodeException.setType(10);
    }

    /*
     * Unable to fully structure code
     */
    private static void computeAfterOffset(Method method, List<Instruction> list, List<int[]> switchCaseOffsets, List<FastCodeExcepcion> fastCodeExceptions, FastCodeExcepcion fastCodeException, int fastCodeExceptionIndex) {
        block0 : switch (fastCodeException.getType()) {
            case 7: {
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.getAfterOffset());
                if (index < 0 || index >= list.size()) {
                    return;
                }
                length = list.size();
                offsetSet = new IntSet();
                retCounter = 0;
                while (++index < length) {
                    i = list.get(index);
                    if (i.getOpcode() == 168) {
                        offsetSet.add(((Jsr)i).getJumpOffset());
                        continue;
                    }
                    if (i.getOpcode() != 169) continue;
                    if (offsetSet.size() == retCounter) {
                        fastCodeException.setAfterOffset(i.getOffset() + 1);
                        return;
                    }
                    ++retCounter;
                }
                break;
            }
            case 8: {
                instruction = InstructionUtil.getInstructionAt(list, fastCodeException.getAfterOffset());
                if (instruction == null) {
                    return;
                }
                fastCodeException.setAfterOffset(instruction.getOffset() + 1);
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.getFinallyFromOffset());
                if (index < 0) {
                    return;
                }
                length = list.size();
                instruction = list.get(index);
                if (instruction.getOpcode() == 87) {
                    while (++index < length) {
                        instruction = list.get(index);
                        if (instruction.getOpcode() != 191) continue;
                        fastCodeException.setAfterOffset(instruction.getOffset() + 1);
                        break block0;
                    }
                    break;
                }
                if (instruction.getOpcode() != 58) break;
                finallyStartIndex = index + 1;
                exceptionIndex = ((AStore)instruction).getIndex();
                while (++index < length) {
                    instruction = list.get(index);
                    if (instruction.getOpcode() == 191 && (athrow = (AThrow)instruction).getValue().getOpcode() == 25 && ((ALoad)athrow.getValue()).getIndex() == exceptionIndex) break;
                }
                if ((index += index - finallyStartIndex + 1) >= length) break;
                fastCodeException.setAfterOffset(list.get(index).getOffset());
                break;
            }
            case 14: {
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.getFinallyFromOffset());
                if (index < 0) {
                    return;
                }
                instruction = list.get(index);
                if (instruction.getOpcode() != 58) {
                    return;
                }
                finallyStartIndex = index + 1;
                exceptionIndex = ((AStore)instruction).getIndex();
                length = list.size();
                while (++index < length) {
                    instruction = list.get(index);
                    if (instruction.getOpcode() == 191 && FastCodeExceptionAnalyzer.findAloadForAThrow(exceptionIndex, athrow = (AThrow)instruction)) break;
                }
                if ((index += (delta = index - finallyStartIndex) + 1) >= list.size()) break;
                afterOffset = list.get(index).getOffset();
                if (index < length && list.get(index).getOpcode() == 167) {
                    g = (Goto)list.get(index);
                    jumpOffset = g.getJumpOffset();
                    indexTmp = index + delta + 1;
                    if (indexTmp < length && list.get(indexTmp - 1).getOffset() < jumpOffset && jumpOffset <= list.get(indexTmp).getOffset()) {
                        afterOffset = FastCodeExceptionAnalyzer.reduceAfterOffsetWithBranchInstructions(list, fastCodeException, fastCodeException.getFinallyFromOffset(), list.get(indexTmp).getOffset());
                        if (!fastCodeException.hasSynchronizedFlag()) {
                            afterOffset = FastCodeExceptionAnalyzer.reduceAfterOffsetWithLineNumbers(list, fastCodeException, afterOffset);
                        }
                        afterOffset = FastCodeExceptionAnalyzer.reduceAfterOffsetWithExceptions(fastCodeExceptions, fastCodeException.getTryFromOffset(), fastCodeException.getFinallyFromOffset(), afterOffset);
                    }
                }
                fastCodeException.setAfterOffset(afterOffset);
                break;
            }
            case 2: {
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.getFinallyFromOffset());
                if (index <= 0) {
                    return;
                }
                length = list.size();
                offsetOfJsrsLength = list.get(length - 1).getOffset() + 1;
                offsetOfJsrs = new boolean[offsetOfJsrsLength];
                level = 0;
                while (++index < length) {
                    i = list.get(index);
                    if (offsetOfJsrs[i.getOffset()]) {
                        ++level;
                    }
                    if (i.getOpcode() == 168) {
                        jumpOffset = ((Jsr)i).getJumpOffset();
                        if (jumpOffset >= offsetOfJsrsLength) continue;
                        offsetOfJsrs[jumpOffset] = true;
                        continue;
                    }
                    if (i.getOpcode() != 169) continue;
                    if (level <= 1) {
                        fastCodeException.setAfterOffset(i.getOffset() + 1);
                        break block0;
                    }
                    --level;
                }
                break;
            }
            case 4: 
            case 9: {
                index = InstructionUtil.getIndexForOffset(list, fastCodeException.getFinallyFromOffset());
                if (index <= 0) {
                    return;
                }
                length = list.size();
                while (++index < length) {
                    i = list.get(index);
                    if (i.getOpcode() != 169) continue;
                    fastCodeException.setAfterOffset(++index < length ? list.get(index).getOffset() : i.getOffset() + 1);
                    break block0;
                }
                break;
            }
            default: {
                length = list.size();
                afterOffset = fastCodeException.getAfterOffset();
                if (afterOffset == -1) {
                    afterOffset = list.get(length - 1).getOffset() + 1;
                }
                afterOffset = FastCodeExceptionAnalyzer.reduceAfterOffsetWithBranchInstructions(list, fastCodeException, fastCodeException.maxOffset, afterOffset);
                if (!fastCodeException.hasSynchronizedFlag()) {
                    afterOffset = FastCodeExceptionAnalyzer.reduceAfterOffsetWithLineNumbers(list, fastCodeException, afterOffset);
                }
                afterOffset = FastCodeExceptionAnalyzer.reduceAfterOffsetWithSwitchInstructions(switchCaseOffsets, fastCodeException.getTryFromOffset(), fastCodeException.maxOffset, afterOffset);
                afterOffset = FastCodeExceptionAnalyzer.reduceAfterOffsetWithExceptions(fastCodeExceptions, fastCodeException.getTryFromOffset(), fastCodeException.maxOffset, afterOffset);
                fastCodeException.setAfterOffset(afterOffset);
                tryFromOffset = 0x7FFFFFFF;
                tryIndex = fastCodeExceptionIndex + 1;
                while (tryIndex < fastCodeExceptions.size()) {
                    tryFromOffsetTmp = fastCodeExceptions.get(tryIndex).getTryFromOffset();
                    if (tryFromOffsetTmp > fastCodeException.maxOffset) {
                        tryFromOffset = tryFromOffsetTmp;
                        break;
                    }
                    ++tryIndex;
                }
                index = maxIndex = InstructionUtil.getIndexForOffset(list, fastCodeException.maxOffset);
                while (index < length) {
                    instruction = list.get(index);
                    if (instruction.getOffset() >= afterOffset) break block0;
                    if (instruction.getOffset() <= tryFromOffset) ** GOTO lbl157
                    fce = fastCodeExceptions.get(tryIndex);
                    afterOffsetTmp = fce.getAfterOffset();
                    while (true) {
                        if (++tryIndex < fastCodeExceptions.size()) ** GOTO lbl145
                        tryFromOffset = 0x7FFFFFFF;
                        ** GOTO lbl155
lbl145:
                        // 1 sources

                        tryFromOffsetTmp = fastCodeExceptions.get(tryIndex).getTryFromOffset();
                        if (fce.getTryFromOffset() == tryFromOffsetTmp) ** GOTO lbl149
                        tryFromOffset = tryFromOffsetTmp;
                        if (true) ** GOTO lbl155
lbl149:
                        // 1 sources

                        fceTmp = fastCodeExceptions.get(tryIndex);
                        if (afterOffsetTmp >= fceTmp.getAfterOffset()) continue;
                        afterOffsetTmp = fceTmp.getAfterOffset();
                    }
                    do {
                        ++index;
lbl155:
                        // 3 sources

                    } while (index < length && list.get(index).getOffset() < afterOffsetTmp);
                    continue;
lbl157:
                    // 1 sources

                    block9 : switch (instruction.getOpcode()) {
                        case 177: 
                        case 191: 
                        case 273: {
                            if (CheckLocalVariableUsedVisitor.visit(method.getLocalVariables(), fastCodeException.maxOffset, instruction) || FastCodeExceptionAnalyzer.checkTernaryOperator(list, index)) {
                                fastCodeException.setAfterOffset(instruction.getOffset() + 1);
                            } else if (index + 1 >= length) {
                                if (instruction.getOpcode() == 191) {
                                    fastCodeException.setAfterOffset(instruction.getOffset() + 1);
                                } else {
                                    fastCodeException.setAfterOffset(instruction.getOffset());
                                }
                            } else {
                                tryFromIndex = InstructionUtil.getIndexForOffset(list, fastCodeException.getTryFromOffset());
                                v0 = beforeInstructionOffset = index == 0 ? 0 : list.get(index - 1).getOffset();
                                if (InstructionUtil.checkNoJumpToInterval(list, tryFromIndex, maxIndex, beforeInstructionOffset, instruction.getOffset())) {
                                    fastCodeException.setAfterOffset(instruction.getOffset() + 1);
                                } else {
                                    fastCodeException.setAfterOffset(instruction.getOffset());
                                }
                            }
                            return;
                        }
                        case 167: 
                        case 260: 
                        case 261: 
                        case 262: {
                            if (instruction.getOpcode() == 167) {
                                jumpOffsetTmp = ((BranchInstruction)instruction).getJumpOffset();
                            } else {
                                index = ComparisonInstructionAnalyzer.getLastIndex(list, index);
                                lastBi = (BranchInstruction)list.get(index);
                                jumpOffsetTmp = lastBi.getJumpOffset();
                            }
                            if (jumpOffsetTmp <= instruction.getOffset()) ** GOTO lbl197
                            if (jumpOffsetTmp < afterOffset) ** GOTO lbl195
                            if (instruction.getOpcode() == 167 || jumpOffsetTmp != afterOffset) {
                                tryFromIndex = InstructionUtil.getIndexForOffset(list, fastCodeException.getTryFromOffset());
                                v1 = beforeInstructionOffset = index == 0 ? 0 : list.get(index - 1).getOffset();
                                if (InstructionUtil.checkNoJumpToInterval(list, tryFromIndex, maxIndex, beforeInstructionOffset, instruction.getOffset())) {
                                    fastCodeException.setAfterOffset(instruction.getOffset() + 1);
                                } else {
                                    fastCodeException.setAfterOffset(instruction.getOffset());
                                }
                            }
                            return;
lbl-1000:
                            // 1 sources

                            {
                                if (list.get(index).getOffset() < jumpOffsetTmp) continue;
                                --index;
                                break block9;
lbl195:
                                // 2 sources

                                ** while (++index < length)
                            }
lbl196:
                            // 1 sources

                            break;
lbl197:
                            // 1 sources

                            if (jumpOffsetTmp > fastCodeException.getTryFromOffset()) break;
                            if (index > 0 && instruction.getLineNumber() != 0) {
                                beforeInstruction = list.get(index - 1);
                                if (instruction.getLineNumber() == beforeInstruction.getLineNumber()) {
                                    if (beforeInstruction.getOpcode() == 58 && ((AStore)beforeInstruction).getValueref().getOpcode() == 270 || beforeInstruction.getOpcode() == 87 && ((Pop)beforeInstruction).getObjectref().getOpcode() == 270) {
                                        fastCodeException.setAfterOffset(instruction.getOffset());
                                    } else {
                                        fastCodeException.setAfterOffset(beforeInstruction.getOffset());
                                    }
                                    return;
                                }
                            }
                            fastCodeException.setAfterOffset(instruction.getOffset());
                            return;
                        }
                        case 170: 
                        case 171: {
                            s = (Switch)instruction;
                            maxOffset = s.getDefaultOffset();
                            i = s.getOffsets().length;
                            while (i-- > 0) {
                                offset = s.getOffset(i);
                                if (maxOffset >= offset) continue;
                                maxOffset = offset;
                            }
                            if (maxOffset >= afterOffset) break;
                            while (++index < length) {
                                if (list.get(index).getOffset() < maxOffset) continue;
                                --index;
                                break block9;
                            }
                            break;
                        }
                    }
                    ++index;
                }
                break block0;
            }
        }
    }

    private static boolean checkTernaryOperator(List<Instruction> list, int index) {
        if (index > 2 && list.get(index - 1).getOpcode() == 167 && list.get(index - 2).getOpcode() == 280) {
            Goto g = (Goto)list.get(index - 1);
            int jumpOffset = g.getJumpOffset();
            int returnOffset = list.get(index).getOffset();
            if (g.getOffset() < jumpOffset && jumpOffset <= returnOffset) {
                return true;
            }
        }
        return false;
    }

    private static int reduceAfterOffsetWithBranchInstructions(List<Instruction> list, FastCodeExcepcion fastCodeException, int firstOffset, int afterOffset) {
        int index = InstructionUtil.getIndexForOffset(list, fastCodeException.getTryFromOffset());
        if (index != -1) {
            while (index-- > 0) {
                int jumpOffset;
                Instruction instruction = list.get(index);
                if (!ByteCodeUtil.isIfOrGotoInstruction((int)instruction.getOpcode(), (boolean)false) || firstOffset >= (jumpOffset = ((BranchInstruction)instruction).getJumpOffset()) || jumpOffset >= afterOffset) continue;
                afterOffset = jumpOffset;
            }
        }
        return afterOffset;
    }

    private static int reduceAfterOffsetWithLineNumbers(List<Instruction> list, FastCodeExcepcion fastCodeException, int afterOffset) {
        int fromIndex = InstructionUtil.getIndexForOffset(list, fastCodeException.getTryFromOffset());
        int index = fromIndex;
        if (index != -1) {
            Instruction instruction;
            int length = list.size();
            int firstLineNumber = 0;
            do {
                instruction = list.get(index);
                ++index;
                if (instruction.getLineNumber() == 0) continue;
                firstLineNumber = instruction.getLineNumber();
                break;
            } while (instruction.getOffset() < afterOffset && index < length);
            if (firstLineNumber != 0) {
                int maxOffset = fastCodeException.maxOffset;
                index = InstructionUtil.getIndexForOffset(list, afterOffset);
                if (index != -1) {
                    while (index-- > 0) {
                        int maxIndex;
                        int jumpOffset;
                        instruction = list.get(index);
                        if (instruction.getOffset() <= maxOffset || instruction.getLineNumber() != 0 && instruction.getLineNumber() >= firstLineNumber || instruction.getOpcode() == 167 && !InstructionUtil.checkNoJumpToInterval(list, fromIndex, index, (jumpOffset = ((Goto)instruction).getJumpOffset()) - 1, jumpOffset) || instruction.getOpcode() == 177 && list.get((maxIndex = InstructionUtil.getIndexForOffset(list, maxOffset)) - 1).getOpcode() == instruction.getOpcode()) break;
                        afterOffset = instruction.getOffset();
                    }
                }
            }
        }
        return afterOffset;
    }

    private static int reduceAfterOffsetWithSwitchInstructions(List<int[]> switchCaseOffsets, int firstOffset, int lastOffset, int afterOffset) {
        int i = switchCaseOffsets.size();
        while (i-- > 0) {
            int[] offsets = switchCaseOffsets.get(i);
            int j = offsets.length;
            if (j <= 1) continue;
            int offset2 = offsets[--j];
            while (j-- > 0) {
                int offset1 = offsets[j];
                if (offset1 != -1 && offset1 <= firstOffset && lastOffset < offset2 && (afterOffset == -1 || afterOffset > offset2)) {
                    afterOffset = offset2;
                }
                offset2 = offset1;
            }
        }
        return afterOffset;
    }

    private static int reduceAfterOffsetWithExceptions(List<FastCodeExcepcion> fastCodeExceptions, int fromOffset, int maxOffset, int afterOffset) {
        int i = fastCodeExceptions.size();
        while (i-- > 0) {
            FastCodeExcepcion fastCodeException = fastCodeExceptions.get(i);
            int toOffset = fastCodeException.getFinallyFromOffset();
            if (fastCodeException.getCatches() != null) {
                int j = fastCodeException.getCatches().size();
                while (j-- > 0) {
                    FastCodeExceptionCatch fcec = fastCodeException.getCatches().get(j);
                    if (toOffset != -1 && fcec.getFromOffset() <= fromOffset && maxOffset < toOffset && (afterOffset == -1 || afterOffset > toOffset)) {
                        afterOffset = toOffset;
                    }
                    toOffset = fcec.getFromOffset();
                }
            }
            if (fastCodeException.getTryFromOffset() > fromOffset || maxOffset >= toOffset || afterOffset != -1 && afterOffset <= toOffset) continue;
            afterOffset = toOffset;
        }
        return afterOffset;
    }

    public static void formatFastTry(LocalVariables localVariables, FastCodeExcepcion fce, FastTry fastTry, int returnOffset) {
        switch (fce.getType()) {
            case 1: {
                FastCodeExceptionAnalyzer.formatCatch(localVariables, fce, fastTry);
                break;
            }
            case 2: {
                FastCodeExceptionAnalyzer.format118Finally(localVariables, fce, fastTry);
                break;
            }
            case 4: {
                FastCodeExceptionAnalyzer.format118FinallyThrow(fastTry);
                break;
            }
            case 7: {
                FastCodeExceptionAnalyzer.format118CatchFinally(fce, fastTry);
                break;
            }
            case 8: {
                FastCodeExceptionAnalyzer.format118CatchFinally2(fce, fastTry);
                break;
            }
            case 9: {
                FastCodeExceptionAnalyzer.format131CatchFinally(localVariables, fce, fastTry);
                break;
            }
            case 10: {
                FastCodeExceptionAnalyzer.format142(localVariables, fce, fastTry);
                break;
            }
            case 11: {
                FastCodeExceptionAnalyzer.format142FinallyThrow(fastTry);
                break;
            }
            case 12: {
                FastCodeExceptionAnalyzer.formatJikes122(localVariables, fce, fastTry, returnOffset);
                break;
            }
            case 13: {
                FastCodeExceptionAnalyzer.formatEclipse677Finally(fce, fastTry);
                break;
            }
            case 14: {
                FastCodeExceptionAnalyzer.formatEclipse677CatchFinally(fce, fastTry, returnOffset);
            }
        }
    }

    private static void formatCatch(LocalVariables localVariables, FastCodeExcepcion fce, FastTry fastTry) {
        int tmpJumpOffset;
        int lastIndex;
        Instruction instruction;
        List<Instruction> tryInstructions = fastTry.getInstructions();
        int jumpOffset = -1;
        if (!(tryInstructions.isEmpty() || (instruction = tryInstructions.get(lastIndex = tryInstructions.size() - 1)).getOpcode() != 167 || (tmpJumpOffset = ((Goto)instruction).getJumpOffset()) >= fce.getTryFromOffset() && instruction.getOffset() >= tmpJumpOffset)) {
            jumpOffset = tmpJumpOffset;
            fce.setTryToOffset(instruction.getOffset());
            tryInstructions.remove(lastIndex);
        }
        FastCodeExceptionAnalyzer.formatFastTryRemoveJsrInstructionAndCompactStoreReturn(tryInstructions, localVariables, 0);
        int i = fastTry.getCatches().size();
        while (i-- > 0) {
            int tmpJumpOffset2;
            List<Instruction> catchInstructions = fastTry.getCatches().get(i).instructions();
            if (FastCodeExceptionAnalyzer.formatCatchRemoveFirstCatchInstruction(catchInstructions.get(0))) {
                catchInstructions.remove(0);
            }
            if (catchInstructions.isEmpty()) continue;
            int lastIndex2 = catchInstructions.size() - 1;
            Instruction instruction2 = catchInstructions.get(lastIndex2);
            if (instruction2.getOpcode() == 167 && ((tmpJumpOffset2 = ((Goto)instruction2).getJumpOffset()) < fce.getTryFromOffset() || instruction2.getOffset() < tmpJumpOffset2)) {
                if (jumpOffset == -1) {
                    jumpOffset = tmpJumpOffset2;
                    catchInstructions.remove(lastIndex2);
                } else if (jumpOffset == tmpJumpOffset2) {
                    catchInstructions.remove(lastIndex2);
                }
            }
            FastCodeExceptionAnalyzer.formatFastTryRemoveJsrInstructionAndCompactStoreReturn(catchInstructions, localVariables, 0);
        }
    }

    private static boolean formatCatchRemoveFirstCatchInstruction(Instruction instruction) {
        return switch (instruction.getOpcode()) {
            case 87 -> {
                if (((Pop)instruction).getObjectref().getOpcode() == 270) {
                    yield true;
                }
                yield false;
            }
            case 58 -> {
                if (((AStore)instruction).getValueref().getOpcode() == 270) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static void format118Finally(LocalVariables localVariables, FastCodeExcepcion fce, FastTry fastTry) {
        List<Instruction> tryInstructions = fastTry.getInstructions();
        int length = tryInstructions.size();
        if (tryInstructions.get(--length).getOpcode() == 167) {
            Goto g = (Goto)tryInstructions.remove(length);
            fce.setTryToOffset(g.getOffset());
        }
        if (tryInstructions.get(--length).getOpcode() != 168) {
            throw new UnexpectedInstructionException();
        }
        tryInstructions.remove(length);
        int finallyInstructionsLineNumber = fastTry.getFinallyInstructions().get(0).getLineNumber();
        FastCodeExceptionAnalyzer.formatFastTryRemoveJsrInstructionAndCompactStoreReturn(tryInstructions, localVariables, finallyInstructionsLineNumber);
        FastCodeExceptionAnalyzer.format118FinallyThrow(fastTry);
    }

    private static void format118FinallyThrow(FastTry fastTry) {
        Instruction i;
        List<Instruction> finallyInstructions = fastTry.getFinallyInstructions();
        int length = finallyInstructions.size();
        if ((i = finallyInstructions.get(--length)).getOpcode() != 169) {
            throw new UnexpectedInstructionException();
        }
        finallyInstructions.remove(length);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
    }

    private static void format118CatchFinally(FastCodeExcepcion fce, FastTry fastTry) {
        int i;
        List<Instruction> tryInstructions = fastTry.getInstructions();
        int tryInstructionsLength = tryInstructions.size();
        if (tryInstructions.get(--tryInstructionsLength).getOpcode() == 167) {
            Goto g = (Goto)tryInstructions.remove(tryInstructionsLength);
            fce.setTryToOffset(g.getOffset());
        }
        if ((i = fastTry.getCatches().size() - 1) >= 0) {
            int catchLastOpCode;
            List<Instruction> catchInstructions = fastTry.getCatches().get(i).instructions();
            int catchInstructionsLength = catchInstructions.size();
            if (catchInstructionsLength > 0) {
                if ((catchLastOpCode = catchInstructions.get(--catchInstructionsLength).getOpcode()) == 167) {
                    catchInstructions.remove(catchInstructionsLength);
                    catchInstructions.remove(--catchInstructionsLength);
                } else if (catchLastOpCode == 177 || catchLastOpCode == 273) {
                    catchInstructions.remove(--catchInstructionsLength);
                    if (catchInstructionsLength > 0 && catchInstructions.get(catchInstructionsLength - 1).getOpcode() == 191) {
                        catchInstructions.remove(catchInstructionsLength);
                    }
                }
                catchInstructions.remove(0);
            }
            while (i-- > 0) {
                catchInstructions = fastTry.getCatches().get(i).instructions();
                catchInstructionsLength = catchInstructions.size();
                if ((catchLastOpCode = catchInstructions.get(--catchInstructionsLength).getOpcode()) == 167) {
                    catchInstructions.remove(catchInstructionsLength);
                } else if (catchLastOpCode == 177 || catchLastOpCode == 273) {
                    catchInstructions.remove(--catchInstructionsLength);
                }
                catchInstructions.remove(0);
            }
        }
        List<Instruction> finallyInstructions = fastTry.getFinallyInstructions();
        int finallyInstructionsLength = finallyInstructions.size();
        finallyInstructions.remove(--finallyInstructionsLength);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
        finallyInstructions.remove(0);
    }

    private static void format118CatchFinally2(FastCodeExcepcion fce, FastTry fastTry) {
        List<Instruction> tryInstructions = fastTry.getInstructions();
        int tryInstructionsLength = tryInstructions.size();
        if (tryInstructions.get(--tryInstructionsLength).getOpcode() == 167) {
            Goto g = (Goto)tryInstructions.remove(tryInstructionsLength);
            fce.setTryToOffset(g.getOffset());
        }
        int i = fastTry.getCatches().size();
        while (i-- > 0) {
            List<Instruction> catchInstructions = fastTry.getCatches().get(i).instructions();
            int catchInstructionsLength = catchInstructions.size();
            catchInstructions.remove(catchInstructionsLength - 1);
            catchInstructions.remove(0);
        }
        List<Instruction> finallyInstructions = fastTry.getFinallyInstructions();
        finallyInstructions.remove(0);
    }

    private static void format131CatchFinally(LocalVariables localVariables, FastCodeExcepcion fce, FastTry fastTry) {
        List<Instruction> tryInstructions = fastTry.getInstructions();
        int length = tryInstructions.size();
        if (tryInstructions.get(--length).getOpcode() == 167) {
            Goto g = (Goto)tryInstructions.remove(length);
            fce.setTryToOffset(g.getOffset());
        }
        int finallyInstructionsLineNumber = fastTry.getFinallyInstructions().get(0).getLineNumber();
        int jumpOffset = FastCodeExceptionAnalyzer.formatFastTryRemoveJsrInstructionAndCompactStoreReturn(tryInstructions, localVariables, finallyInstructionsLineNumber);
        length = tryInstructions.size();
        if (tryInstructions.get(--length).getOpcode() == 168) {
            Jsr jsr = (Jsr)tryInstructions.remove(length);
            jumpOffset = jsr.getJumpOffset();
        }
        if (jumpOffset == -1) {
            throw new UnexpectedInstructionException();
        }
        List<Instruction> finallyInstructions = fastTry.getFinallyInstructions();
        if (jumpOffset < finallyInstructions.get(0).getOffset()) {
            List<Instruction> catchInstructions;
            i = fastTry.getCatches().size();
            while (i-- > 0) {
                catchInstructions = fastTry.getCatches().get(i).instructions();
                if (catchInstructions.isEmpty() || catchInstructions.get(0).getOffset() > jumpOffset) continue;
                int index = InstructionUtil.getIndexForOffset(catchInstructions, jumpOffset);
                finallyInstructions.clear();
                while (catchInstructions.get(index).getOpcode() != 169) {
                    finallyInstructions.add(catchInstructions.remove(index));
                }
                if (catchInstructions.get(index).getOpcode() != 169) break;
                finallyInstructions.add(catchInstructions.remove(index));
                break;
            }
            i = fastTry.getCatches().size();
            while (i-- > 0) {
                catchInstructions = fastTry.getCatches().get(i).instructions();
                length = catchInstructions.size();
                if (catchInstructions.get(--length).getOpcode() == 167) {
                    catchInstructions.remove(length);
                }
                if (catchInstructions.get(--length).getOpcode() == 168) {
                    catchInstructions.remove(length);
                }
                FastCodeExceptionAnalyzer.formatFastTryRemoveJsrInstructionAndCompactStoreReturn(catchInstructions, localVariables, finallyInstructionsLineNumber);
                catchInstructions.remove(0);
            }
            length = finallyInstructions.size();
            finallyInstructions.remove(--length);
        } else {
            i = fastTry.getCatches().size();
            while (i-- > 0) {
                List<Instruction> catchInstructions = fastTry.getCatches().get(i).instructions();
                length = catchInstructions.size();
                if (catchInstructions.get(--length).getOpcode() == 167) {
                    catchInstructions.remove(length);
                }
                if (catchInstructions.get(--length).getOpcode() == 168) {
                    catchInstructions.remove(length);
                }
                FastCodeExceptionAnalyzer.formatFastTryRemoveJsrInstructionAndCompactStoreReturn(catchInstructions, localVariables, finallyInstructionsLineNumber);
                catchInstructions.remove(0);
            }
            length = finallyInstructions.size();
            finallyInstructions.remove(--length);
            finallyInstructions.remove(0);
            finallyInstructions.remove(0);
            finallyInstructions.remove(0);
        }
        AStore aStore = (AStore)finallyInstructions.get(0);
        if (aStore.getValueref() instanceof ExceptionLoad) {
            finallyInstructions.remove(0);
            finallyInstructions.remove(0);
            finallyInstructions.remove(0);
            finallyInstructions.remove(0);
        }
        if (aStore.getValueref() instanceof ReturnAddressLoad) {
            finallyInstructions.remove(0);
        }
    }

    private static void format142(LocalVariables localVariables, FastCodeExcepcion fce, FastTry fastTry) {
        int finallyFirstOpcode;
        int finallyInstructionsSize;
        List<Instruction> finallyInstructions = fastTry.getFinallyInstructions();
        if (finallyInstructions.get((finallyInstructionsSize = finallyInstructions.size()) - 1).getOpcode() == 191) {
            finallyInstructions.remove(finallyInstructionsSize - 1);
        }
        if ((finallyFirstOpcode = finallyInstructions.get(0).getOpcode()) == 58 || finallyFirstOpcode == 87) {
            finallyInstructions.remove(0);
        }
        if ((finallyInstructionsSize = finallyInstructions.size()) > 0) {
            Goto g;
            int length;
            FastCompareInstructionVisitor visitor = new FastCompareInstructionVisitor();
            List<Instruction> tryInstructions = fastTry.getInstructions();
            int tryLastOpCode = tryInstructions.get((length = tryInstructions.size()) - 1).getOpcode();
            if (tryLastOpCode == 167 && (g = (Goto)tryInstructions.get(--length)).getBranch() > 0) {
                tryInstructions.remove(length);
                fce.setTryToOffset(g.getOffset());
            }
            FastCodeExceptionAnalyzer.format142RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, tryInstructions, finallyInstructions);
            if (fastTry.getCatches() != null) {
                int i = fastTry.getCatches().size();
                while (i-- > 0) {
                    Goto g2;
                    List<Instruction> catchInstructions = fastTry.getCatches().get(i).instructions();
                    int catchLastOpCode = catchInstructions.get((length = catchInstructions.size()) - 1).getOpcode();
                    if (catchLastOpCode == 167 && (g2 = (Goto)catchInstructions.get(--length)).getBranch() > 0) {
                        catchInstructions.remove(length);
                    }
                    FastCodeExceptionAnalyzer.format142RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, catchInstructions, finallyInstructions);
                    if (catchInstructions.isEmpty()) continue;
                    catchInstructions.remove(0);
                }
            }
        }
        if (fastTry.getCatches() != null && !fastTry.getCatches().isEmpty()) {
            int i = fastTry.getCatches().size();
            while (i-- > 0) {
                List<Instruction> catchInstructions = fastTry.getCatches().get(i).instructions();
                if (catchInstructions.isEmpty() || !FastCodeExceptionAnalyzer.formatCatchRemoveFirstCatchInstruction(catchInstructions.get(0))) continue;
                catchInstructions.remove(0);
            }
        }
    }

    private static void format142RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(LocalVariables localVariables, FastCompareInstructionVisitor visitor, List<Instruction> instructions, List<Instruction> finallyInstructions) {
        boolean match;
        int index = instructions.size();
        int finallyInstructionsSize = finallyInstructions.size();
        int finallyInstructionsLineNumber = finallyInstructions.get(0).getLineNumber();
        boolean bl = match = index >= finallyInstructionsSize && visitor.visit(instructions, finallyInstructions, index - finallyInstructionsSize, 0, finallyInstructionsSize);
        if (match) {
            int j = 0;
            while (j < finallyInstructionsSize && index > 0) {
                instructions.remove(index - 1);
                --index;
                ++j;
            }
        }
        block11: while (index-- > 0) {
            Instruction instruction = instructions.get(index);
            switch (instruction.getOpcode()) {
                case 273: {
                    ReturnInstruction ri;
                    boolean bl2 = match = index >= finallyInstructionsSize && visitor.visit(instructions, finallyInstructions, index - finallyInstructionsSize, 0, finallyInstructionsSize);
                    if (match) {
                        int j = 0;
                        while (j < finallyInstructionsSize && index > 0) {
                            instructions.remove(index - 1);
                            --index;
                            ++j;
                        }
                    }
                    if ((ri = (ReturnInstruction)instruction).getLineNumber() == 0) break;
                    switch (ri.getValueref().getOpcode()) {
                        case 25: {
                            if (instructions.get(index - 1).getOpcode() != 58) break;
                            index = FastCodeExceptionAnalyzer.compactStoreReturn(instructions, localVariables, ri, index, finallyInstructionsLineNumber);
                            break;
                        }
                        case 268: {
                            if (instructions.get(index - 1).getOpcode() != 269) break;
                            index = FastCodeExceptionAnalyzer.compactStoreReturn(instructions, localVariables, ri, index, finallyInstructionsLineNumber);
                            break;
                        }
                        case 21: {
                            if (instructions.get(index - 1).getOpcode() != 54) break;
                            index = FastCodeExceptionAnalyzer.compactStoreReturn(instructions, localVariables, ri, index, finallyInstructionsLineNumber);
                        }
                    }
                    continue block11;
                }
                case 318: {
                    FastTry ft = (FastTry)instruction;
                    FastCodeExceptionAnalyzer.format142RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, ft.getInstructions(), finallyInstructions);
                    if (ft.getCatches() != null) {
                        int i = ft.getCatches().size();
                        while (i-- > 0) {
                            FastCodeExceptionAnalyzer.format142RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, ft.getCatches().get(i).instructions(), finallyInstructions);
                        }
                    }
                    if (ft.getFinallyInstructions() == null) break;
                    FastCodeExceptionAnalyzer.format142RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, ft.getFinallyInstructions(), finallyInstructions);
                    break;
                }
                case 319: {
                    FastSynchronized fs = (FastSynchronized)instruction;
                    FastCodeExceptionAnalyzer.format142RemoveFinallyInstructionsBeforeReturnAndCompactStoreReturn(localVariables, visitor, fs.getInstructions(), finallyInstructions);
                }
            }
        }
    }

    private static int compactStoreReturn(List<Instruction> instructions, LocalVariables localVariables, ReturnInstruction ri, int index, int finallyInstructionsLineNumber) {
        IndexInstruction load = (IndexInstruction)ri.getValueref();
        StoreInstruction store = (StoreInstruction)instructions.get(index - 1);
        if (load.getIndex() == store.getIndex() && (load.getLineNumber() <= store.getLineNumber() || load.getLineNumber() >= finallyInstructionsLineNumber)) {
            LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(store.getIndex(), store.getOffset());
            if (lv != null && lv.getStartPc() == store.getOffset() && lv.getStartPc() + lv.getLength() <= ri.getOffset()) {
                localVariables.removeLocalVariableWithIndexAndOffset(store.getIndex(), store.getOffset());
            }
            ri.setValueref(store.getValueref());
            if (ri.getLineNumber() > store.getLineNumber()) {
                ri.setLineNumber(store.getLineNumber());
            }
            instructions.remove(--index);
        }
        return index;
    }

    private static void format142FinallyThrow(FastTry fastTry) {
        fastTry.getFinallyInstructions().remove(fastTry.getFinallyInstructions().size() - 1);
        fastTry.getFinallyInstructions().remove(0);
    }

    private static void formatJikes122(LocalVariables localVariables, FastCodeExcepcion fce, FastTry fastTry, int returnOffset) {
        List<Instruction> tryInstructions = fastTry.getInstructions();
        int lastIndex = tryInstructions.size() - 1;
        Instruction lastTryInstruction = tryInstructions.get(lastIndex);
        int lastTryInstructionOffset = lastTryInstruction.getOffset();
        if (tryInstructions.get(lastIndex).getOpcode() == 167) {
            Goto g = (Goto)tryInstructions.remove(lastIndex);
            fce.setTryToOffset(g.getOffset());
        }
        int finallyInstructionsLineNumber = fastTry.getFinallyInstructions().isEmpty() ? -1 : fastTry.getFinallyInstructions().get(0).getLineNumber();
        FastCodeExceptionAnalyzer.formatFastTryRemoveJsrInstructionAndCompactStoreReturn(tryInstructions, localVariables, finallyInstructionsLineNumber);
        int i = fastTry.getCatches().size();
        while (i-- > 0) {
            List<Instruction> catchInstructions = fastTry.getCatches().get(i).instructions();
            if (catchInstructions.get(lastIndex = catchInstructions.size() - 1).getOpcode() == 167) {
                catchInstructions.remove(lastIndex);
            }
            if (finallyInstructionsLineNumber != -1) {
                FastCodeExceptionAnalyzer.formatFastTryRemoveJsrInstructionAndCompactStoreReturn(catchInstructions, localVariables, finallyInstructionsLineNumber);
            }
            FastCodeExceptionAnalyzer.formatFastTryFormatNegativeJumpOffset(catchInstructions, lastTryInstructionOffset, returnOffset);
            catchInstructions.remove(0);
        }
        List<Instruction> finallyInstructions = fastTry.getFinallyInstructions();
        int length = finallyInstructions.size();
        if (!finallyInstructions.isEmpty()) {
            finallyInstructions.remove(--length);
        }
        if (!finallyInstructions.isEmpty()) {
            finallyInstructions.remove(--length);
        }
        if (!finallyInstructions.isEmpty()) {
            finallyInstructions.remove(0);
        }
        if (!finallyInstructions.isEmpty() && finallyInstructions.get(0).getOpcode() == 168) {
            finallyInstructions.remove(0);
        }
        if (!finallyInstructions.isEmpty() && finallyInstructions.get(0).getOpcode() == 191) {
            finallyInstructions.remove(0);
        }
        if (!finallyInstructions.isEmpty() && finallyInstructions.get(0).getOpcode() == 58) {
            finallyInstructions.remove(0);
        }
    }

    private static int formatFastTryRemoveJsrInstructionAndCompactStoreReturn(List<Instruction> instructions, LocalVariables localVariables, int finallyInstructionsLineNumber) {
        int jumpOffset = -1;
        int index = instructions.size();
        while (index-- > 1) {
            if (instructions.get(index).getOpcode() != 168) continue;
            Jsr jsr = (Jsr)instructions.remove(index);
            jumpOffset = jsr.getJumpOffset();
        }
        index = instructions.size();
        while (index-- > 1) {
            ReturnInstruction ri;
            Instruction instruction = instructions.get(index);
            if (instruction.getOpcode() != 273 || (ri = (ReturnInstruction)instruction).getLineNumber() == 0) continue;
            switch (ri.getValueref().getOpcode()) {
                case 25: {
                    if (instructions.get(index - 1).getOpcode() != 58) break;
                    index = FastCodeExceptionAnalyzer.compactStoreReturn(instructions, localVariables, ri, index, finallyInstructionsLineNumber);
                    break;
                }
                case 268: {
                    if (instructions.get(index - 1).getOpcode() != 269) break;
                    index = FastCodeExceptionAnalyzer.compactStoreReturn(instructions, localVariables, ri, index, finallyInstructionsLineNumber);
                    break;
                }
                case 21: {
                    if (instructions.get(index - 1).getOpcode() != 54) break;
                    index = FastCodeExceptionAnalyzer.compactStoreReturn(instructions, localVariables, ri, index, finallyInstructionsLineNumber);
                }
            }
        }
        return jumpOffset;
    }

    private static void formatFastTryFormatNegativeJumpOffset(List<Instruction> instructions, int lastTryInstructionOffset, int returnOffset) {
        int i = instructions.size();
        while (i-- > 0) {
            Goto g;
            int jumpOffset;
            Instruction instruction = instructions.get(i);
            if (instruction.getOpcode() != 167 || (jumpOffset = (g = (Goto)instruction).getJumpOffset()) >= lastTryInstructionOffset) continue;
            g.setBranch(returnOffset - g.getOffset());
        }
    }

    private static void formatEclipse677Finally(FastCodeExcepcion fce, FastTry fastTry) {
        List<Instruction> finallyInstructions = fastTry.getFinallyInstructions();
        Instruction instruction = finallyInstructions.get(0);
        if (instruction.getOpcode() == 87) {
            finallyInstructions.remove(0);
            List<Instruction> tryInstructions = fastTry.getInstructions();
            int lastIndex = tryInstructions.size() - 1;
            if (tryInstructions.get(lastIndex).getOpcode() == 167) {
                Goto g = (Goto)tryInstructions.remove(lastIndex);
                fce.setTryToOffset(g.getOffset());
            }
        } else if (instruction.getOpcode() == 58) {
            int exceptionIndex = ((AStore)instruction).getIndex();
            int index = finallyInstructions.size();
            int athrowOffset = -1;
            int afterAthrowOffset = -1;
            while (index-- > 0) {
                AThrow athrow;
                instruction = finallyInstructions.get(index);
                if (instruction.getOpcode() == 191 && FastCodeExceptionAnalyzer.findAloadForAThrow(exceptionIndex, athrow = (AThrow)instruction)) {
                    athrowOffset = instruction.getOffset();
                    finallyInstructions.remove(index);
                    break;
                }
                afterAthrowOffset = instruction.getOffset();
                finallyInstructions.remove(index);
            }
            if (!finallyInstructions.isEmpty()) {
                int lastIndex;
                Instruction astore = finallyInstructions.remove(0);
                List<Instruction> tryInstructions = fastTry.getInstructions();
                if (tryInstructions.get(lastIndex = tryInstructions.size() - 1).getOpcode() == 167) {
                    Goto g = (Goto)tryInstructions.remove(lastIndex);
                    fce.setTryToOffset(g.getOffset());
                }
                fastTry.removeOutOfBoundsInstructions(astore.getLineNumber());
                FastCodeExceptionAnalyzer.formatEclipse677FinallyFormatIfInstruction(tryInstructions, athrowOffset, afterAthrowOffset, astore.getOffset());
            }
        }
    }

    private static void formatEclipse677FinallyFormatIfInstruction(List<Instruction> instructions, int athrowOffset, int afterAthrowOffset, int afterTryOffset) {
        int i = instructions.size();
        while (i-- > 0) {
            IfInstruction ifi;
            int jumpOffset;
            Instruction instruction = instructions.get(i);
            if (instruction.getOpcode() != 260 && instruction.getOpcode() != 262 && instruction.getOpcode() != 284 || athrowOffset >= (jumpOffset = (ifi = (IfInstruction)instruction).getJumpOffset()) || jumpOffset > afterAthrowOffset) continue;
            ifi.setBranch(afterTryOffset - ifi.getOffset());
        }
    }

    private static void formatEclipse677CatchFinally(FastCodeExcepcion fce, FastTry fastTry, int returnOffset) {
        List<Instruction> finallyInstructions = fastTry.getFinallyInstructions();
        int exceptionIndex = ((AStore)finallyInstructions.get(0)).getIndex();
        int index = finallyInstructions.size();
        int athrowOffset = -1;
        int afterAthrowOffset = -1;
        while (index-- > 0) {
            AThrow athrow;
            Instruction instruction = finallyInstructions.get(index);
            if (instruction.getOpcode() == 191 && FastCodeExceptionAnalyzer.findAloadForAThrow(exceptionIndex, athrow = (AThrow)instruction)) {
                athrowOffset = finallyInstructions.remove(index).getOffset();
                break;
            }
            afterAthrowOffset = instruction.getOffset();
            finallyInstructions.remove(index);
        }
        if (!finallyInstructions.isEmpty()) {
            Instruction astore = finallyInstructions.remove(0);
            List<Instruction> tryInstructions = fastTry.getInstructions();
            int lastIndex = tryInstructions.size() - 1;
            Instruction lastTryInstruction = tryInstructions.get(lastIndex);
            int lastTryInstructionOffset = lastTryInstruction.getOffset();
            if (lastTryInstruction.getOpcode() == 167) {
                Goto g = (Goto)tryInstructions.remove(lastIndex);
                fce.setTryToOffset(g.getOffset());
            }
            fastTry.removeOutOfBoundsInstructions(astore.getLineNumber());
            FastCodeExceptionAnalyzer.formatEclipse677FinallyFormatIfInstruction(tryInstructions, athrowOffset, afterAthrowOffset, lastTryInstructionOffset + 1);
            int i = fastTry.getCatches().size();
            while (i-- > 0) {
                Goto g;
                int jumpOffset;
                FastTry.FastCatch fastCatch = fastTry.getCatches().get(i);
                List<Instruction> catchInstructions = fastCatch.instructions();
                index = catchInstructions.size();
                Instruction lastInstruction = catchInstructions.get(index - 1);
                int lastInstructionOffset = lastInstruction.getOffset();
                if (lastInstruction.getOpcode() == 167 && (jumpOffset = (g = (Goto)catchInstructions.remove(--index)).getJumpOffset()) > fastTry.getOffset()) {
                    int j = finallyInstructions.size();
                    while (j > 0) {
                        catchInstructions.remove(--index);
                        --j;
                    }
                }
                FastCodeExceptionAnalyzer.formatEclipse677FinallyFormatIfInstruction(catchInstructions, athrowOffset, afterAthrowOffset, lastInstructionOffset + 1);
                FastCodeExceptionAnalyzer.formatFastTryFormatNegativeJumpOffset(catchInstructions, lastTryInstructionOffset, returnOffset);
                catchInstructions.remove(0);
            }
        }
    }

    private static boolean findAloadForAThrow(int exceptionIndex, AThrow athrow) {
        return athrow.getValue().getOpcode() == 25 && ((ALoad)athrow.getValue()).getIndex() == exceptionIndex || athrow.getValue().getOpcode() == 192 && ((CheckCast)athrow.getValue()).getObjectref().getOpcode() == 25 && ((ALoad)((CheckCast)athrow.getValue()).getObjectref()).getIndex() == exceptionIndex;
    }

    public static int computeTryToIndex(List<Instruction> instructions, FastCodeExcepcion fce, int lastIndex, int maxOffset) {
        int beforeMaxOffset = fce.getTryFromOffset();
        int index = InstructionUtil.getIndexForOffset(instructions, fce.getTryFromOffset());
        while (index <= lastIndex) {
            Instruction instruction = instructions.get(index);
            if (instruction.getOffset() > maxOffset) {
                return index - 1;
            }
            switch (instruction.getOpcode()) {
                case 177: 
                case 191: 
                case 273: {
                    if (instruction.getOffset() < beforeMaxOffset) break;
                    return index;
                }
                case 167: {
                    int jumpOffset = ((BranchInstruction)instruction).getJumpOffset();
                    if (jumpOffset > instruction.getOffset()) {
                        if (jumpOffset < maxOffset) {
                            if (beforeMaxOffset >= jumpOffset) break;
                            beforeMaxOffset = jumpOffset;
                            break;
                        }
                        if (instruction.getOffset() < beforeMaxOffset) break;
                        return index;
                    }
                    if (jumpOffset >= fce.getTryFromOffset() || instruction.getOffset() < beforeMaxOffset) break;
                    return index;
                }
                case 260: 
                case 261: 
                case 262: {
                    index = ComparisonInstructionAnalyzer.getLastIndex(instructions, index);
                    BranchInstruction lastBi = (BranchInstruction)instructions.get(index);
                    int jumpOffset = lastBi.getJumpOffset();
                    if (jumpOffset <= instruction.getOffset() || jumpOffset >= maxOffset || beforeMaxOffset >= jumpOffset) break;
                    beforeMaxOffset = jumpOffset;
                    break;
                }
                case 170: 
                case 171: {
                    Switch s = (Switch)instruction;
                    int maxSwitchOffset = s.getDefaultOffset();
                    int i = s.getOffsets().length;
                    while (i-- > 0) {
                        int offset = s.getOffset(i);
                        if (maxSwitchOffset >= offset) continue;
                        maxSwitchOffset = offset;
                    }
                    if ((maxSwitchOffset += s.getOffset()) <= instruction.getOffset() || maxSwitchOffset >= maxOffset || beforeMaxOffset >= maxSwitchOffset) break;
                    beforeMaxOffset = maxSwitchOffset;
                }
            }
            ++index;
        }
        if (index == instructions.size()) {
            return index - 1;
        }
        return index;
    }

    public static class FastAggregatedCodeExcepcion {
        private int[] otherCatchTypes;
        private int nbrFinally;
        private boolean synchronizedFlag;
        private final CodeException codeException;

        public FastAggregatedCodeExcepcion(int startPc, int endPc, int handlerPc, int catchType) {
            this.codeException = new CodeException(startPc, endPc, handlerPc, catchType);
            this.otherCatchTypes = null;
            this.nbrFinally = catchType == 0 ? 1 : 0;
        }

        public int getCatchType() {
            return this.codeException.getCatchType();
        }

        public int getStartPC() {
            return this.codeException.getStartPC();
        }

        public int getEndPC() {
            return this.codeException.getEndPC();
        }

        public int getHandlerPC() {
            return this.codeException.getHandlerPC();
        }
    }

    public static class FastCodeExcepcion
    implements Comparable<FastCodeExcepcion> {
        private final int tryFromOffset;
        private int tryToOffset;
        private final List<FastCodeExceptionCatch> catches;
        private int finallyFromOffset;
        private int nbrFinally;
        private int maxOffset;
        private int afterOffset;
        private int type;
        private final boolean synchronizedFlag;

        FastCodeExcepcion(int tryFromOffset, int tryToOffset, int maxOffset, boolean synchronizedFlag) {
            this.tryFromOffset = tryFromOffset;
            this.setTryToOffset(tryToOffset);
            this.catches = new ArrayList<FastCodeExceptionCatch>();
            this.setFinallyFromOffset(-1);
            this.nbrFinally = 0;
            this.maxOffset = maxOffset;
            this.setAfterOffset(-1);
            this.setType(0);
            this.synchronizedFlag = synchronizedFlag;
        }

        @Override
        public int compareTo(FastCodeExcepcion other) {
            if (this.getTryFromOffset() != other.getTryFromOffset()) {
                return this.getTryFromOffset() - other.getTryFromOffset();
            }
            if (this.maxOffset != other.maxOffset) {
                return other.maxOffset - this.maxOffset;
            }
            return other.getTryToOffset() - this.getTryToOffset();
        }

        public int hashCode() {
            return Objects.hash(this.tryFromOffset, this.tryToOffset, this.maxOffset);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((FastCodeExcepcion)obj) == 0;
        }

        public int getTryFromOffset() {
            return this.tryFromOffset;
        }

        public List<FastCodeExceptionCatch> getCatches() {
            return this.catches;
        }

        public boolean hasSynchronizedFlag() {
            return this.synchronizedFlag;
        }

        public int getFinallyFromOffset() {
            return this.finallyFromOffset;
        }

        private void setFinallyFromOffset(int finallyFromOffset) {
            this.finallyFromOffset = finallyFromOffset;
        }

        public int getAfterOffset() {
            return this.afterOffset;
        }

        private void setAfterOffset(int afterOffset) {
            this.afterOffset = afterOffset;
        }

        public int getType() {
            return this.type;
        }

        private void setType(int type) {
            this.type = type;
        }

        public int getTryToOffset() {
            return this.tryToOffset;
        }

        private void setTryToOffset(int tryToOffset) {
            this.tryToOffset = tryToOffset;
        }
    }

    public static class FastCodeExceptionCatch
    implements Comparable<FastCodeExceptionCatch> {
        private final int type;
        private final int[] otherTypes;
        private final int fromOffset;

        public FastCodeExceptionCatch(int type, int[] otherCatchTypes, int fromOffset) {
            this.type = type;
            this.otherTypes = otherCatchTypes;
            this.fromOffset = fromOffset;
        }

        @Override
        public int compareTo(FastCodeExceptionCatch other) {
            return this.getFromOffset() - other.getFromOffset();
        }

        public int hashCode() {
            return Objects.hash(this.getFromOffset());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((FastCodeExceptionCatch)obj) == 0;
        }

        public int getFromOffset() {
            return this.fromOffset;
        }

        public int getType() {
            return this.type;
        }

        public int[] getOtherTypes() {
            return this.otherTypes;
        }
    }
}

