/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTry;

public final class DupLocalVariableAnalyzer {
    private DupLocalVariableAnalyzer() {
    }

    public static void declare(ClassFile classFile, Method method, List<Instruction> list) {
        DupLocalVariableAnalyzer.recursiveDeclare(classFile, method.getLocalVariables(), method.getCode().length, list);
    }

    private static void recursiveDeclare(ClassFile classFile, LocalVariables localVariables, int codeLength, List<Instruction> list) {
        Instruction instruction;
        int length = list.size();
        int index = 0;
        while (index < length) {
            instruction = list.get(index);
            switch (instruction.getOpcode()) {
                case 301: 
                case 302: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 319: {
                    List<Instruction> instructions = ((FastList)instruction).getInstructions();
                    if (instructions == null) break;
                    DupLocalVariableAnalyzer.recursiveDeclare(classFile, localVariables, codeLength, instructions);
                    break;
                }
                case 307: {
                    FastTest2Lists ft2l = (FastTest2Lists)instruction;
                    DupLocalVariableAnalyzer.recursiveDeclare(classFile, localVariables, codeLength, ft2l.getInstructions());
                    DupLocalVariableAnalyzer.recursiveDeclare(classFile, localVariables, codeLength, ft2l.getInstructions2());
                    break;
                }
                case 314: 
                case 315: 
                case 316: {
                    FastSwitch.Pair[] pairs = ((FastSwitch)instruction).getPairs();
                    if (pairs == null) break;
                    int i = pairs.length - 1;
                    while (i >= 0) {
                        List<Instruction> instructions = pairs[i].getInstructions();
                        if (instructions != null) {
                            DupLocalVariableAnalyzer.recursiveDeclare(classFile, localVariables, codeLength, instructions);
                        }
                        --i;
                    }
                    break;
                }
                case 318: {
                    int i;
                    FastTry ft = (FastTry)instruction;
                    DupLocalVariableAnalyzer.recursiveDeclare(classFile, localVariables, codeLength, ft.getInstructions());
                    if (ft.getCatches() != null) {
                        i = ft.getCatches().size() - 1;
                        while (i >= 0) {
                            DupLocalVariableAnalyzer.recursiveDeclare(classFile, localVariables, codeLength, ft.getCatches().get(i).instructions());
                            --i;
                        }
                    }
                    if (ft.getFinallyInstructions() == null) break;
                    DupLocalVariableAnalyzer.recursiveDeclare(classFile, localVariables, codeLength, ft.getFinallyInstructions());
                }
            }
            ++index;
        }
        int i = 0;
        while (i < length) {
            instruction = list.get(i);
            if (instruction.getOpcode() == 264) {
                DupStore dupStore = (DupStore)instruction;
                String signature = dupStore.getObjectref().getReturnedSignature(classFile, localVariables);
                ConstantPool constants = classFile.getConstantPool();
                int signatureIndex = constants.addConstantUtf8(signature);
                int nameIndex = constants.addConstantUtf8("tmp" + dupStore.getOffset() + "_" + ((DupStore)instruction).getObjectref().getOffset());
                int varIndex = localVariables.size();
                LocalVariable lv = new LocalVariable(dupStore.getOffset(), codeLength, nameIndex, signatureIndex, varIndex);
                lv.setDeclarationFlag(true);
                localVariables.add(lv);
                list.set(i, new FastDeclaration(dupStore.getOffset(), 0, lv, dupStore));
            }
            ++i;
        }
    }
}

