/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.Deque;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import org.apache.bcel.Const;

public class UnaryOperatorFactory
implements InstructionFactory {
    private final int priority;
    private final String signature;
    private final String operator;

    public UnaryOperatorFactory(int priority, String signature, String operator) {
        this.priority = priority;
        this.signature = signature;
        this.operator = operator;
    }

    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        Instruction i = stack.pop();
        stack.push(new UnaryOperatorInstruction(266, offset, lineNumber, this.priority, this.signature, this.operator, i));
        return Const.getNoOfOperands((int)opcode);
    }
}

