/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.Deque;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;

public class TableSwitchFactory
implements InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        int i = offset + 4 & 0xFFFC;
        int defaultOffset = (code[i] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
        int low = (code[i += 4] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
        int high = (code[i += 4] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
        i += 4;
        int length = high - low + 1;
        int[] offsets = new int[length];
        int j = 0;
        while (j < length) {
            offsets[j] = (code[i] & 0xFF) << 24 | (code[i + 1] & 0xFF) << 16 | (code[i + 2] & 0xFF) << 8 | code[i + 3] & 0xFF;
            i += 4;
            ++j;
        }
        Instruction key = stack.pop();
        list.add(new TableSwitch(opcode, offset, lineNumber, key, defaultOffset, offsets, low));
        return i - offset - 1;
    }
}

