/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.Deque;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import jd.core.util.SignatureUtil;
import org.apache.bcel.Const;

public class ReturnInstructionFactory
implements InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        int signatureIndex = method.getSignatureIndex();
        String signature = classFile.getConstantPool().getConstantUtf8(signatureIndex);
        String returnSignature = SignatureUtil.getMethodReturnedSignature(signature);
        ReturnInstruction ri = new ReturnInstruction(273, offset, lineNumber, stack.pop(), returnSignature);
        list.add(ri);
        listForAnalyze.add(ri);
        return Const.getNoOfOperands((int)opcode);
    }
}

