/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import org.apache.bcel.Const;

public class MultiANewArrayFactory
implements InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        int index = (code[offset + 1] & 0xFF) << 8 | code[offset + 2] & 0xFF;
        int count = code[offset + 3] & 0xFF;
        ArrayList<Instruction> dimensions = new ArrayList<Instruction>(count);
        int i = 0;
        while (i < count) {
            dimensions.add(stack.pop());
            ++i;
        }
        MultiANewArray instruction = new MultiANewArray(opcode, offset, lineNumber, index, dimensions);
        stack.push(instruction);
        listForAnalyze.add(instruction);
        return Const.getNoOfOperands((int)opcode);
    }
}

