/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokeinterface;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import jd.core.util.SignatureUtil;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;

public class InvokeinterfaceFactory
implements InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        int index = (code[offset + 1] & 0xFF) << 8 | code[offset + 2] & 0xFF;
        ConstantPool constants = classFile.getConstantPool();
        ConstantInterfaceMethodref cimr = constants.getConstantInterfaceMethodref(index);
        Objects.requireNonNull(cimr, "Invalid ConstantInterfaceMethodref index");
        ConstantNameAndType cnat = constants.getConstantNameAndType(cimr.getNameAndTypeIndex());
        String methodDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
        int nbrOfParameters = SignatureUtil.getParameterSignatureCount(methodDescriptor);
        ArrayList<Instruction> args = new ArrayList<Instruction>(nbrOfParameters);
        int i = nbrOfParameters;
        while (i > 0) {
            args.add(stack.pop());
            --i;
        }
        Collections.reverse(args);
        Instruction objectref = stack.pop();
        Invokeinterface instruction = new Invokeinterface(opcode, offset, lineNumber, index, objectref, args);
        if (!"V".equals(SignatureUtil.getMethodReturnedSignature(methodDescriptor))) {
            stack.push(instruction);
        } else {
            list.add(instruction);
        }
        listForAnalyze.add(instruction);
        return Const.getNoOfOperands((int)opcode);
    }
}

