/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.ArrayReference;
import jd.core.model.instruction.bytecode.instruction.ConstructorReference;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.bytecode.instruction.LambdaInstruction;
import jd.core.model.instruction.bytecode.instruction.MethodReference;
import jd.core.model.instruction.bytecode.instruction.StaticMethodReference;
import jd.core.process.analyzer.classfile.ClassFileAnalyzer;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.BootstrapMethod;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodType;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.util.Base;

public class InvokeDynamicFactory
implements InstructionFactory {
    /*
     * WARNING - void declaration
     */
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        Invokevirtual invokevirtual;
        Instruction lastInstruction;
        Instruction instruction;
        ConstantPool constants = classFile.getConstantPool();
        if (!listForAnalyze.isEmpty() && (instruction = (lastInstruction = listForAnalyze.get(listForAnalyze.size() - 1))) instanceof Invokevirtual && (invokevirtual = (Invokevirtual)instruction) == (Invokevirtual)instruction) {
            void mie;
            ConstantCP mieRef = constants.getConstantMethodref(mie.getIndex());
            ConstantNameAndType mieNameAndType = constants.getConstantNameAndType(mieRef.getNameAndTypeIndex());
            String mieName = constants.getConstantUtf8(mieNameAndType.getNameIndex());
            String mieDesc = constants.getConstantUtf8(mieNameAndType.getSignatureIndex());
            if ("getClass".equals(mieName) && "()Ljava/lang/Class;".equals(mieDesc)) {
                listForAnalyze.remove(listForAnalyze.size() - 1);
                list.remove(list.size() - 1);
            }
        }
        int opcode = code[offset] & 0xFF;
        int index = (code[offset + 1] & 0xFF) << 8 | code[offset + 2] & 0xFF;
        TypeMaker typeMaker = new TypeMaker(classFile.getLoader());
        ConstantInvokeDynamic cid = constants.getConstantInvokeDynamic(index);
        ConstantNameAndType indyCnat = constants.getConstantNameAndType(cid.getNameAndTypeIndex());
        String indyMethodName = constants.getConstantUtf8(indyCnat.getNameIndex());
        String indyDescriptor = constants.getConstantUtf8(indyCnat.getSignatureIndex());
        TypeMaker.MethodTypes indyMethodTypes = typeMaker.makeMethodTypes(classFile.getThisClassName(), indyMethodName, indyDescriptor);
        BootstrapMethods attributeBootstrapMethods = classFile.getAttributeBootstrapMethods();
        List<Instruction> indyParameters = InvokeDynamicFactory.extractParametersFromStack(stack, indyMethodTypes.getParameterTypes());
        BootstrapMethod bootstrapMethod = attributeBootstrapMethods.getBootstrapMethods()[cid.getClassIndex()];
        int[] bootstrapArguments = bootstrapMethod.getBootstrapArguments();
        ConstantMethodType cmt0 = constants.getConstantMethodType(bootstrapArguments[0]);
        String descriptor0 = constants.getConstantUtf8(cmt0.getDescriptorIndex());
        TypeMaker.MethodTypes methodTypes0 = typeMaker.makeMethodTypes(classFile.getThisClassName(), null, descriptor0);
        int parameterCount = Optional.ofNullable(methodTypes0.getParameterTypes()).map(Base::size).orElse(0);
        ConstantMethodHandle constantMethodHandle1 = constants.getConstantMethodHandle(bootstrapArguments[1]);
        ConstantCP cmr1 = constants.getConstantMethodref(constantMethodHandle1.getReferenceIndex());
        String typeName = constants.getConstantClassName(cmr1.getClassIndex());
        ConstantNameAndType cnat1 = constants.getConstantNameAndType(cmr1.getNameAndTypeIndex());
        String name1 = constants.getConstantUtf8(cnat1.getNameIndex());
        String descriptor1 = constants.getConstantUtf8(cnat1.getSignatureIndex());
        String internalTypeName = classFile.getInternalClassName();
        boolean arrayRef = false;
        Method lambdaMethod = null;
        if (typeName.equals(internalTypeName.substring(1, internalTypeName.length() - 1))) {
            Method[] methodArray = classFile.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method methodDeclaration = methodArray[n2];
                String methodName = constants.getConstantUtf8(methodDeclaration.getNameIndex());
                String methodDesc = constants.getConstantUtf8(methodDeclaration.getDescriptorIndex());
                if ((methodDeclaration.getAccessFlags() & 0x1002) == 4098 && methodName.equals(name1) && methodDesc.equals(descriptor1)) {
                    if (ByteCodeUtil.getArrayRefIndex((byte[])methodDeclaration.getCode())) {
                        arrayRef = true;
                        break;
                    }
                    lambdaMethod = methodDeclaration;
                }
                ++n2;
            }
        }
        if (lambdaMethod != null && lambdaMethod.isLambda(constants)) {
            ClassFileAnalyzer.preAnalyzeSingleMethod(classFile, classFile.getVariableNameGenerator(), -1, lambdaMethod);
            ClassFileAnalyzer.analyzeSingleMethod(null, classFile, null, lambdaMethod);
            LocalVariables localVariables = lambdaMethod.getLocalVariables();
            List<String> localVariableNames = localVariables == null ? Collections.emptyList() : localVariables.getFormalParameterNames(constants);
            ClassFileAnalyzer.postAnalyzeSingleMethod(classFile, lambdaMethod);
            List<String> lambdaParameterNames = InvokeDynamicFactory.prepareLambdaParameterNames(localVariableNames, parameterCount);
            stack.push(new LambdaInstruction(opcode, offset + 1, lineNumber, lambdaParameterNames, indyMethodTypes.getReturnedType(), lambdaMethod, classFile));
            return Const.getNoOfOperands((int)opcode);
        }
        if (indyParameters == null) {
            ObjectType ot = typeMaker.makeFromInternalTypeName(typeName);
            if (arrayRef) {
                String arrayDescriptor = descriptor1.replace("(I)", "");
                ObjectType type = typeMaker.makeFromDescriptor(arrayDescriptor);
                stack.push(new ArrayReference(opcode, offset, lineNumber, type, arrayDescriptor));
            } else if ("<init>".equals(name1)) {
                stack.push(new ConstructorReference(opcode, offset, lineNumber, ot, descriptor1));
            } else {
                stack.push(new StaticMethodReference(opcode, offset, lineNumber, new ObjectTypeReferenceExpression(lineNumber, ot), typeName, name1, descriptor1));
            }
            return Const.getNoOfOperands((int)opcode);
        }
        stack.push(new MethodReference(opcode, offset, lineNumber, indyParameters, typeName, name1, descriptor1));
        return Const.getNoOfOperands((int)opcode);
    }

    private static List<Instruction> extractParametersFromStack(Deque<Instruction> stack, BaseType parameterTypes) {
        int count;
        if (parameterTypes == null) {
            return null;
        }
        switch (parameterTypes.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Instruction parameter = stack.pop();
                return Collections.singletonList(parameter);
            }
        }
        ArrayList<Instruction> parameters = new ArrayList<Instruction>();
        int i = count = parameterTypes.size() - 1;
        while (i >= 0) {
            if (!stack.isEmpty()) {
                Instruction parameter = stack.pop();
                parameters.add(parameter);
            }
            --i;
        }
        Collections.reverse(parameters);
        return parameters;
    }

    private static List<String> prepareLambdaParameterNames(List<String> formalParameters, int parameterCount) {
        if (formalParameters == null || parameterCount == 0) {
            return Collections.emptyList();
        }
        if (formalParameters.size() == parameterCount) {
            return formalParameters;
        }
        return formalParameters.subList(formalParameters.size() - parameterCount, formalParameters.size());
    }
}

