/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.Deque;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import org.apache.bcel.Const;

public class IfXNullFactory
implements InstructionFactory {
    private final int cmp;

    public IfXNullFactory(int cmp) {
        this.cmp = cmp;
    }

    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int nextOffset;
        Instruction instruction;
        int opcode = code[offset] & 0xFF;
        short branch = (short)((code[offset + 1] & 0xFF) << 8 | code[offset + 2] & 0xFF);
        list.add(new IfInstruction(262, offset, lineNumber, this.cmp, stack.pop(), branch));
        if (!(stack.isEmpty() || (instruction = stack.peek()).getOpcode() != 263 || (nextOffset = offset + Const.getNoOfOperands((int)opcode) + 1) >= code.length || (code[nextOffset] & 0xFF) != 87 && (code[nextOffset] & 0xFF) != 176)) {
            DupLoad dp = (DupLoad)instruction;
            stack.push(new DupLoad(dp.getOpcode(), dp.getOffset(), dp.getLineNumber(), dp.getDupStore()));
        }
        return Const.getNoOfOperands((int)opcode);
    }
}

