/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.Deque;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.IInc;
import jd.core.model.instruction.bytecode.instruction.ILoad;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import org.apache.bcel.Const;

public class ILoadFactory
implements InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        Instruction last;
        int opcode = code[offset] & 0xFF;
        int index = opcode == 21 ? code[offset + 1] & 0xFF : opcode - 26;
        Instruction instruction = new ILoad(21, offset, lineNumber, index);
        if (!stack.isEmpty() && !jumps[offset] && (last = stack.peek()).getOpcode() == 132) {
            if (((IInc)last).getIndex() == index) {
                listForAnalyze.add(instruction);
                IInc iinc = (IInc)last;
                stack.pop();
                instruction = new IncInstruction(277, iinc.getOffset(), iinc.getLineNumber(), instruction, iinc.getCount());
            } else {
                stack.pop();
                list.add(last);
                listForAnalyze.add(last);
            }
        }
        stack.push(instruction);
        listForAnalyze.add(instruction);
        return Const.getNoOfOperands((int)opcode);
    }
}

