/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.Deque;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.IInc;
import jd.core.model.instruction.bytecode.instruction.ILoad;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import org.apache.bcel.Const;

public class IIncFactory
implements InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        byte index = code[offset + 1];
        byte count = code[offset + 2];
        if (stack.isEmpty() || jumps[offset]) {
            IInc instruction = new IInc(opcode, offset, lineNumber, index, count);
            list.add(instruction);
            listForAnalyze.add(instruction);
        } else {
            Instruction instruction = stack.peek();
            if (instruction.getOpcode() == 21 && ((ILoad)instruction).getIndex() == index) {
                stack.pop();
                instruction = new IncInstruction(278, offset, lineNumber, instruction, count);
                stack.push(instruction);
                listForAnalyze.add(instruction);
            } else if (count == -1 || count == 1) {
                stack.push(new IInc(opcode, offset, lineNumber, index, count));
            } else {
                instruction = new IInc(opcode, offset, lineNumber, index, count);
                list.add(instruction);
                listForAnalyze.add(instruction);
            }
        }
        return Const.getNoOfOperands((int)opcode);
    }
}

