/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.Deque;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.IBinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import org.apache.bcel.Const;

public class IBinaryOperatorFactory
implements InstructionFactory {
    private final int priority;
    private final String operator;

    public IBinaryOperatorFactory(int priority, String operator) {
        this.priority = priority;
        this.operator = operator;
    }

    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        Instruction i2 = stack.pop();
        Instruction i1 = stack.pop();
        IBinaryOperatorInstruction instruction = new IBinaryOperatorInstruction(267, offset, lineNumber, this.priority, this.operator, i1, i2);
        stack.push(instruction);
        listForAnalyze.add(instruction);
        return Const.getNoOfOperands((int)opcode);
    }
}

