/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.Deque;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Goto;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import org.apache.bcel.Const;

public class GotoFactory
implements InstructionFactory {
    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        short value = (short)((code[offset + 1] & 0xFF) << 8 | code[offset + 2] & 0xFF);
        if (!stack.isEmpty() && !list.isEmpty()) {
            GotoFactory.generateTernaryOpStore(list, listForAnalyze, stack, code, offset, value);
        }
        list.add(new Goto(opcode, offset, lineNumber, value));
        return Const.getNoOfOperands((int)opcode);
    }

    private static void generateTernaryOpStore(List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int value) {
        int i = list.size();
        while (i-- > 0) {
            Instruction previousInstruction = list.get(i);
            if (!ByteCodeUtil.isIfInstruction((int)previousInstruction.getOpcode(), (boolean)false)) continue;
            int ternaryOp2ndValueOffset = GotoFactory.search2ndValueOffset(code, offset, offset + value);
            Instruction value0 = stack.pop();
            TernaryOpStore tos = new TernaryOpStore(280, offset - 1, value0.getLineNumber(), value0, ternaryOp2ndValueOffset);
            list.add(tos);
            listForAnalyze.add(tos);
            return;
        }
    }

    private static int search2ndValueOffset(byte[] code, int offset, int jumpOffset) {
        int result = offset;
        while (offset < jumpOffset) {
            int opcode = code[offset] & 0xFF;
            if (opcode >= 1 && opcode <= 53 || opcode >= 79 && opcode <= 86 || opcode >= 89 && opcode <= 152 || opcode == 178 || opcode == 180 || opcode >= 182 && opcode <= 185 || opcode >= 187 && opcode <= 190 || opcode >= 192 && opcode <= 193 || opcode >= 196 && opcode <= 197 || opcode >= 256 && opcode <= 259 || opcode == 263 || opcode >= 265 && opcode <= 268 || opcode >= 270 && opcode <= 271 || opcode >= 274 && opcode <= 278 || opcode == 285) {
                result = opcode == 90 ? offset - 1 : offset;
            }
            short nbOfOperands = Const.getNoOfOperands((int)opcode);
            switch (nbOfOperands) {
                case -2: {
                    switch (opcode) {
                        case 170: {
                            offset = ByteCodeUtil.nextTableSwitchOffset((byte[])code, (int)offset);
                            break;
                        }
                        case 171: {
                            offset = ByteCodeUtil.nextLookupSwitchOffset((byte[])code, (int)offset);
                            break;
                        }
                        case 196: {
                            offset = ByteCodeUtil.nextWideOffset((byte[])code, (int)offset);
                        }
                    }
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    offset += nbOfOperands;
                }
            }
            ++offset;
        }
        return result;
    }
}

