/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.Deque;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import org.apache.bcel.Const;

public class ArrayLoadInstructionFactory
implements InstructionFactory {
    private final String signature;

    public ArrayLoadInstructionFactory(String signature) {
        this.signature = signature;
    }

    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Deque<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        Instruction index = stack.pop();
        Instruction arrayref = stack.pop();
        ArrayLoadInstruction instruction = new ArrayLoadInstruction(271, offset, lineNumber, arrayref, index, this.signature);
        stack.push(instruction);
        listForAnalyze.add(instruction);
        return Const.getNoOfOperands((int)opcode);
    }
}

