/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.ExceptionLoad;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.ReturnAddressLoad;
import jd.core.process.analyzer.instruction.bytecode.InstructionListException;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactoryConstants;
import jd.core.process.analyzer.instruction.bytecode.factory.UnexpectedOpcodeException;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.util.IntSet;
import jd.core.util.SignatureUtil;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.LineNumber;
import org.apache.commons.lang3.ArrayUtils;

public final class InstructionListBuilder {
    private static final CodeExceptionComparator COMPARATOR = new CodeExceptionComparator();

    private InstructionListBuilder() {
    }

    public static void build(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze) {
        byte[] code = method.getCode();
        if (code != null) {
            int offset = 0;
            try {
                int nextLineOffset;
                int lineNumber;
                int exceptionOffset;
                int length = code.length;
                boolean[] jumps = new boolean[length];
                IntSet offsetSet = new IntSet();
                InstructionListBuilder.populateJumpsArrayAndSubProcOffsets(code, length, jumps, offsetSet);
                int[] subProcOffsets = offsetSet.toArray();
                int subProcOffsetsIndex = 0;
                int subProcOffset = subProcOffsets == null ? -1 : subProcOffsets[0];
                ArrayDeque<Instruction> stack = new ArrayDeque<Instruction>();
                Object[] codeExceptions = method.getCodeExceptions();
                int codeExceptionsIndex = 0;
                ConstantPool constants = classFile.getConstantPool();
                if (ArrayUtils.isEmpty((Object[])codeExceptions)) {
                    exceptionOffset = -1;
                } else {
                    Arrays.sort(codeExceptions, COMPARATOR);
                    exceptionOffset = codeExceptions[0].getHandlerPC();
                }
                LineNumber[] lineNumbers = method.getLineNumbers();
                int lineNumbersIndex = 0;
                if (lineNumbers == null) {
                    lineNumber = 0;
                    nextLineOffset = -1;
                } else {
                    LineNumber ln = lineNumbers[lineNumbersIndex];
                    lineNumber = ln.getLineNumber();
                    nextLineOffset = -1;
                    int startPc = ln.getStartPC();
                    while (++lineNumbersIndex < lineNumbers.length) {
                        ln = lineNumbers[lineNumbersIndex];
                        if (ln.getStartPC() != startPc) {
                            nextLineOffset = ln.getStartPC();
                            break;
                        }
                        lineNumber = ln.getLineNumber();
                    }
                }
                offset = 0;
                while (offset < length) {
                    int opcode = code[offset] & 0xFF;
                    InstructionFactory factory = InstructionFactoryConstants.getInstructionFactory(opcode);
                    if (factory == null) {
                        String msg = "No factory for " + Const.getOpcodeName((int)opcode);
                        System.err.println(msg);
                        throw new UnexpectedOpcodeException(opcode);
                    }
                    if (offset == exceptionOffset && codeExceptions != null) {
                        int nextOffsetException;
                        int signatureIndex;
                        int catchType = codeExceptions[codeExceptionsIndex].getCatchType();
                        if (catchType == 0) {
                            signatureIndex = 0;
                        } else {
                            String catchClassName = SignatureUtil.createTypeName(constants.getConstantClassName(catchType));
                            signatureIndex = constants.addConstantUtf8(catchClassName);
                        }
                        ExceptionLoad el = new ExceptionLoad(270, offset, lineNumber, signatureIndex);
                        stack.push(el);
                        listForAnalyze.add(el);
                        do {
                            if (++codeExceptionsIndex < codeExceptions.length) continue;
                            nextOffsetException = -1;
                            break;
                        } while ((nextOffsetException = codeExceptions[codeExceptionsIndex].getHandlerPC()) == exceptionOffset);
                        exceptionOffset = nextOffsetException;
                    }
                    if (offset == subProcOffset) {
                        stack.push(new ReturnAddressLoad(279, offset, lineNumber));
                        if (subProcOffsets != null) {
                            subProcOffset = ++subProcOffsetsIndex >= subProcOffsets.length ? -1 : subProcOffsets[subProcOffsetsIndex];
                        }
                    }
                    if (lineNumbers != null && offset == nextLineOffset) {
                        LineNumber ln = lineNumbers[lineNumbersIndex];
                        lineNumber = ln.getLineNumber();
                        nextLineOffset = -1;
                        int startPc = ln.getStartPC();
                        while (++lineNumbersIndex < lineNumbers.length) {
                            ln = lineNumbers[lineNumbersIndex];
                            if (ln.getStartPC() != startPc) {
                                nextLineOffset = ln.getStartPC();
                                break;
                            }
                            lineNumber = ln.getLineNumber();
                        }
                    }
                    offset += factory.create(classFile, method, list, listForAnalyze, stack, code, offset, lineNumber, jumps);
                    ++offset;
                }
                if (!stack.isEmpty()) {
                    String className = classFile.getClassName();
                    String methodName = classFile.getConstantPool().getConstantUtf8(method.getNameIndex());
                    System.err.println("'" + className + '.' + methodName + "' build error: stack not empty. stack=" + stack);
                }
            }
            catch (Exception e) {
                throw new InstructionListException(classFile, method, offset, e);
            }
        }
    }

    private static void populateJumpsArrayAndSubProcOffsets(byte[] code, int length, boolean[] jumps, IntSet offsetSet) {
        int offset = 0;
        while (offset < length) {
            int opcode = code[offset] & 0xFF;
            block0 : switch (Const.getNoOfOperands((int)opcode)) {
                case 0: {
                    break;
                }
                case 2: {
                    int jumpOffset;
                    switch (opcode) {
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: 
                        case 167: 
                        case 198: 
                        case 199: {
                            jumpOffset = offset++ + (short)((code[offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                            jumps[jumpOffset] = true;
                            break block0;
                        }
                        case 168: {
                            jumpOffset = offset++ + (short)((code[offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                            offsetSet.add(jumpOffset);
                            break block0;
                        }
                    }
                    offset += 2;
                    break;
                }
                case 4: {
                    int jumpOffset;
                    switch (opcode) {
                        case 200: {
                            jumpOffset = offset++ + ((code[offset] & 0xFF) << 24) | (code[++offset] & 0xFF) << 16 | (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                            jumps[jumpOffset] = true;
                            break block0;
                        }
                        case 201: {
                            jumpOffset = offset++ + ((code[offset] & 0xFF) << 24) | (code[++offset] & 0xFF) << 16 | (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                            offsetSet.add(jumpOffset);
                            break block0;
                        }
                    }
                    offset += 4;
                    break;
                }
                default: {
                    offset = switch (opcode) {
                        case 170 -> ByteCodeUtil.nextTableSwitchOffset((byte[])code, (int)offset);
                        case 171 -> ByteCodeUtil.nextLookupSwitchOffset((byte[])code, (int)offset);
                        case 196 -> ByteCodeUtil.nextWideOffset((byte[])code, (int)offset);
                        default -> offset + Const.getNoOfOperands((int)opcode);
                    };
                }
            }
            ++offset;
        }
    }

    private static class CodeExceptionComparator
    implements Serializable,
    Comparator<CodeException> {
        private static final long serialVersionUID = 1L;

        private CodeExceptionComparator() {
        }

        @Override
        public int compare(CodeException ce1, CodeException ce2) {
            if (ce1.getHandlerPC() != ce2.getHandlerPC()) {
                return ce1.getHandlerPC() - ce2.getHandlerPC();
            }
            if (ce1.getEndPC() != ce2.getEndPC()) {
                return ce1.getEndPC() - ce2.getEndPC();
            }
            if (ce1.getStartPC() != ce2.getStartPC()) {
                return ce1.getStartPC() - ce2.getStartPC();
            }
            return 0;
        }
    }
}

