/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jd.core.model.instruction.bytecode.instruction.BranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.Goto;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;

public final class ComparisonInstructionAnalyzer {
    private ComparisonInstructionAnalyzer() {
    }

    public static void aggregate(List<Instruction> list) {
        int afterOffest = -1;
        int index = list.size();
        while (index-- > 0) {
            Instruction prevI;
            Instruction instruction = list.get(index);
            if (ByteCodeUtil.isIfInstruction((int)instruction.getOpcode(), (boolean)false) && index > 0 && ByteCodeUtil.isIfOrGotoInstruction((int)(prevI = list.get(index - 1)).getOpcode(), (boolean)false)) {
                BranchInstruction bi = (BranchInstruction)instruction;
                BranchInstruction prevBi = (BranchInstruction)prevI;
                int prevBiJumpOffset = prevBi.getJumpOffset();
                if (prevBiJumpOffset == bi.getJumpOffset() || prevBi.getBranch() > 0 && prevBiJumpOffset <= afterOffest) {
                    index = ComparisonInstructionAnalyzer.analyzeIfInstructions(list, index, bi, afterOffest);
                }
            }
            afterOffest = instruction.getOffset();
        }
    }

    private static int analyzeIfInstructions(List<Instruction> list, int index, BranchInstruction lastBi, int afterOffest) {
        int arrayLength = list.get(list.size() - 1).getOffset();
        boolean[] offsetToPreviousGotoFlag = new boolean[arrayLength];
        boolean[] inversedTernaryOpLogic = new boolean[arrayLength];
        int firstIndex = ComparisonInstructionAnalyzer.searchFirstIndex(list, index, lastBi, afterOffest, offsetToPreviousGotoFlag, inversedTernaryOpLogic);
        if ((firstIndex = ComparisonInstructionAnalyzer.reduceFirstIndex(list, firstIndex, index)) < index) {
            ArrayList<Instruction> branchInstructions = new ArrayList<Instruction>(index - firstIndex + 1);
            branchInstructions.add(lastBi);
            while (index > firstIndex) {
                branchInstructions.add(list.remove(--index));
            }
            Collections.reverse(branchInstructions);
            list.set(index, ComparisonInstructionAnalyzer.createIfInstructions(offsetToPreviousGotoFlag, inversedTernaryOpLogic, branchInstructions, lastBi));
        }
        return index;
    }

    private static int reduceFirstIndex(List<Instruction> list, int firstIndex, int lastIndex) {
        int jumpOffset;
        Instruction i;
        int firstOffset;
        int newFirstOffset = firstOffset = firstIndex == 0 ? 0 : list.get(firstIndex - 1).getOffset();
        int lastOffset = list.get(lastIndex).getOffset();
        int index = firstIndex;
        while (index-- > 0) {
            i = list.get(index);
            if (!ByteCodeUtil.isIfOrGotoInstruction((int)i.getOpcode(), (boolean)false) || newFirstOffset >= (jumpOffset = ((BranchInstruction)i).getJumpOffset()) || jumpOffset > lastOffset) continue;
            newFirstOffset = jumpOffset;
        }
        index = list.size();
        while (--index > lastIndex) {
            i = list.get(index);
            if (!ByteCodeUtil.isIfOrGotoInstruction((int)i.getOpcode(), (boolean)false) || newFirstOffset >= (jumpOffset = ((BranchInstruction)i).getJumpOffset()) || jumpOffset > lastOffset) continue;
            newFirstOffset = jumpOffset;
        }
        if (newFirstOffset != firstOffset) {
            index = firstIndex;
            while (index <= lastIndex) {
                i = list.get(index);
                if (i.getOffset() > newFirstOffset) {
                    firstIndex = index;
                    break;
                }
                ++index;
            }
        }
        return firstIndex;
    }

    private static int searchFirstIndex(List<Instruction> list, int lastIndex, BranchInstruction lastBi, int afterOffest, boolean[] offsetToPreviousGotoFlag, boolean[] inversedTernaryOpLogic) {
        int index = lastIndex;
        int lastBiJumpOffset = lastBi.getJumpOffset();
        Instruction nextInstruction = lastBi;
        while (index-- > 0) {
            Instruction instruction = list.get(index);
            int opcode = instruction.getOpcode();
            if (ByteCodeUtil.isIfInstruction((int)opcode, (boolean)false)) {
                BranchInstruction bi = (BranchInstruction)instruction;
                jumpOffset = bi.getJumpOffset();
                if (jumpOffset == lastBiJumpOffset) {
                    if (bi.getBranch() > 0 && instruction.getLineNumber() != 0 && nextInstruction.getLineNumber() != 0) {
                        int length = list.size();
                        boolean instructionBetweenIf = false;
                        int i = lastIndex + 1;
                        while (i < length) {
                            int lineNumber;
                            Instruction ins = list.get(i);
                            if (ins.getOpcode() == 132 && (lineNumber = ins.getLineNumber()) != 0 && instruction.getLineNumber() <= lineNumber && lineNumber < nextInstruction.getLineNumber()) {
                                instructionBetweenIf = true;
                                break;
                            }
                            ++i;
                        }
                        if (instructionBetweenIf) {
                            break;
                        }
                    }
                } else if (jumpOffset != lastBiJumpOffset && (bi.getBranch() <= 0 || jumpOffset > afterOffest)) {
                    break;
                }
            } else {
                Instruction lastInstructionValue1;
                Goto g;
                if (opcode != 167 || (jumpOffset = (g = (Goto)instruction).getJumpOffset()) != lastBiJumpOffset && (jumpOffset <= nextInstruction.getOffset() || jumpOffset > afterOffest) || index <= 0 || !ByteCodeUtil.isIfInstruction((int)(opcode = (lastInstructionValue1 = list.get(index - 1)).getOpcode()), (boolean)false)) break;
                int jumpOffsetValue1 = ((BranchInstruction)lastInstructionValue1).getJumpOffset();
                if (g.getOffset() < jumpOffsetValue1 && jumpOffsetValue1 <= lastBi.getOffset()) break;
                Instruction lastInstructionValue2 = list.get(lastIndex);
                int jumpIndex = lastIndex - 1;
                while (jumpIndex > index) {
                    Instruction jumpInstruction = list.get(jumpIndex);
                    if (jumpOffset > jumpInstruction.getOffset()) {
                        lastInstructionValue2 = jumpInstruction;
                        break;
                    }
                    --jumpIndex;
                }
                opcode = lastInstructionValue2.getOpcode();
                if (!ByteCodeUtil.isIfInstruction((int)opcode, (boolean)false)) break;
                int jumpOffsetValue2 = ((BranchInstruction)lastInstructionValue2).getJumpOffset();
                if (jumpOffsetValue1 == jumpOffsetValue2) {
                    nextOffset = nextInstruction.getOffset();
                    j = g.getOffset() + 1;
                    while (j < nextOffset) {
                        offsetToPreviousGotoFlag[j] = true;
                        ++j;
                    }
                } else {
                    if (jumpOffset != jumpOffsetValue2) break;
                    nextOffset = nextInstruction.getOffset();
                    j = g.getOffset() + 1;
                    while (j < nextOffset) {
                        offsetToPreviousGotoFlag[j] = true;
                        ++j;
                    }
                    inversedTernaryOpLogic[g.getOffset()] = true;
                }
            }
            nextInstruction = instruction;
        }
        return index + 1;
    }

    private static ComplexConditionalBranchInstruction createIfInstructions(boolean[] offsetToPreviousGotoFlag, boolean[] inversedTernaryOpLogic, List<Instruction> branchInstructions, BranchInstruction lastBi) {
        ComparisonInstructionAnalyzer.reconstructTernaryOperators(offsetToPreviousGotoFlag, inversedTernaryOpLogic, branchInstructions, lastBi);
        ComplexConditionalBranchInstruction cbl = ComparisonInstructionAnalyzer.assembleAndCreateIfInstructions(branchInstructions, lastBi);
        ComparisonInstructionAnalyzer.setOperator(cbl, lastBi, false);
        return cbl;
    }

    private static void reconstructTernaryOperators(boolean[] offsetToPreviousGotoFlag, boolean[] inversedTernaryOpLogic, List<Instruction> branchInstructions, BranchInstruction lastBi) {
        if (branchInstructions.size() <= 1) {
            return;
        }
        int index = branchInstructions.size() - 1;
        int nextOffest = branchInstructions.get(index).getOffset();
        while (index-- > 0) {
            BranchInstruction lastTernaryOpTestBi;
            int lastTernaryOpTestBiJumpOffset;
            Instruction i = branchInstructions.get(index);
            if (ByteCodeUtil.isIfInstruction((int)i.getOpcode(), (boolean)false) && (lastTernaryOpTestBiJumpOffset = (lastTernaryOpTestBi = (BranchInstruction)i).getJumpOffset()) >= 0 && lastBi.getOffset() >= lastTernaryOpTestBiJumpOffset && offsetToPreviousGotoFlag[lastTernaryOpTestBiJumpOffset]) {
                BranchInstruction value2;
                int gotoJumpOffset;
                BranchInstruction value1;
                BranchInstruction test;
                ArrayList<Instruction> ternaryOpTestInstructions = new ArrayList<Instruction>();
                ternaryOpTestInstructions.add(lastTernaryOpTestBi);
                while (index > 0) {
                    Instruction ternaryOpTestInstruction;
                    int opcode;
                    if (!ByteCodeUtil.isIfOrGotoInstruction((int)(opcode = (ternaryOpTestInstruction = branchInstructions.get(--index)).getOpcode()), (boolean)false)) {
                        ++index;
                        break;
                    }
                    BranchInstruction bi = (BranchInstruction)ternaryOpTestInstruction;
                    int branchOffset = bi.getBranch();
                    int jumpOffset = bi.getOffset() + branchOffset;
                    if (jumpOffset != lastTernaryOpTestBiJumpOffset && (branchOffset <= 0 || jumpOffset > nextOffest)) {
                        ++index;
                        break;
                    }
                    branchInstructions.remove(index);
                    ternaryOpTestInstructions.add(ternaryOpTestInstruction);
                }
                if (ternaryOpTestInstructions.size() > 1) {
                    Collections.reverse(ternaryOpTestInstructions);
                    test = ComparisonInstructionAnalyzer.createIfInstructions(offsetToPreviousGotoFlag, inversedTernaryOpLogic, ternaryOpTestInstructions, lastTernaryOpTestBi);
                } else {
                    test = lastTernaryOpTestBi;
                }
                ComparisonInstructionAnalyzer.inverseComparison(test);
                ArrayList<Instruction> ternaryOpValue1Instructions = new ArrayList<Instruction>();
                ++index;
                while (index < branchInstructions.size()) {
                    Instruction instruction = branchInstructions.get(index);
                    if (instruction.getOffset() >= lastTernaryOpTestBiJumpOffset) break;
                    ternaryOpValue1Instructions.add(instruction);
                    branchInstructions.remove(index);
                }
                Goto g = (Goto)ternaryOpValue1Instructions.remove(ternaryOpValue1Instructions.size() - 1);
                if (ternaryOpValue1Instructions.size() > 1) {
                    BranchInstruction lastTernaryOpValueBi = (BranchInstruction)ternaryOpValue1Instructions.get(ternaryOpValue1Instructions.size() - 1);
                    value1 = ComparisonInstructionAnalyzer.assembleAndCreateIfInstructions(ternaryOpValue1Instructions, lastTernaryOpValueBi);
                } else {
                    value1 = (BranchInstruction)ternaryOpValue1Instructions.get(ternaryOpValue1Instructions.size() - 1);
                }
                if (inversedTernaryOpLogic[g.getOffset()]) {
                    gotoJumpOffset = value1.getJumpOffset();
                    ComparisonInstructionAnalyzer.inverseComparison(value1);
                } else {
                    gotoJumpOffset = g.getJumpOffset();
                }
                ArrayList<Instruction> ternaryOpValue2Instructions = new ArrayList<Instruction>();
                while (index < branchInstructions.size()) {
                    Instruction instruction = branchInstructions.get(index);
                    if (instruction.getOpcode() == 167 || instruction.getOffset() >= gotoJumpOffset) break;
                    ternaryOpValue2Instructions.add(instruction);
                    branchInstructions.remove(index);
                }
                if (ternaryOpValue2Instructions.size() > 1) {
                    BranchInstruction lastTernaryOpValueBi = (BranchInstruction)ternaryOpValue2Instructions.get(ternaryOpValue2Instructions.size() - 1);
                    value2 = ComparisonInstructionAnalyzer.assembleAndCreateIfInstructions(ternaryOpValue2Instructions, lastTernaryOpValueBi);
                } else {
                    value2 = (BranchInstruction)ternaryOpValue2Instructions.get(ternaryOpValue2Instructions.size() - 1);
                }
                --index;
                TernaryOperator to = new TernaryOperator(281, value2.getOffset(), test.getLineNumber(), test, value1, value2);
                ArrayList<Instruction> instructions = new ArrayList<Instruction>(1);
                instructions.add(to);
                ComplexConditionalBranchInstruction cbl = new ComplexConditionalBranchInstruction(284, value2.getOffset(), test.getLineNumber(), 1, instructions, value2.getBranch());
                branchInstructions.set(index, cbl);
            }
            nextOffest = i.getOffset();
        }
    }

    private static ComplexConditionalBranchInstruction assembleAndCreateIfInstructions(List<Instruction> branchInstructions, BranchInstruction lastBi) {
        int length = branchInstructions.size();
        int lastBiOffset = lastBi.getOffset();
        int i = 0;
        while (i < length) {
            BranchInstruction branchInstruction = (BranchInstruction)branchInstructions.get(i);
            int jumpOffset = branchInstruction.getJumpOffset();
            if (branchInstruction.getBranch() > 0 && jumpOffset < lastBiOffset) {
                BranchInstruction subLastBi = lastBi;
                ArrayList<Instruction> subBranchInstructions = new ArrayList<Instruction>();
                subBranchInstructions.add(branchInstruction);
                ++i;
                while (i < length) {
                    branchInstruction = (BranchInstruction)branchInstructions.get(i);
                    if (branchInstruction.getOffset() >= jumpOffset) break;
                    subBranchInstructions.add(branchInstruction);
                    subLastBi = branchInstruction;
                    branchInstructions.remove(i);
                    --length;
                }
                --i;
                if (subBranchInstructions.size() > 1) {
                    branchInstructions.set(i, ComparisonInstructionAnalyzer.assembleAndCreateIfInstructions(subBranchInstructions, subLastBi));
                }
            }
            ++i;
        }
        ComparisonInstructionAnalyzer.analyzeLastTestBlock(branchInstructions);
        int lineNumber = branchInstructions.get(0).getLineNumber();
        return new ComplexConditionalBranchInstruction(284, lastBi.getOffset(), lineNumber, 1, branchInstructions, lastBi.getBranch());
    }

    private static void analyzeLastTestBlock(List<Instruction> branchInstructions) {
        int length = branchInstructions.size();
        if (length > 1) {
            --length;
            BranchInstruction branchInstruction = (BranchInstruction)branchInstructions.get(0);
            int firstJumpOffset = branchInstruction.getJumpOffset();
            int i = 1;
            while (i < length) {
                branchInstruction = (BranchInstruction)branchInstructions.get(i);
                int jumpOffset = branchInstruction.getJumpOffset();
                if (firstJumpOffset != jumpOffset) {
                    BranchInstruction subLastBi = branchInstruction;
                    ArrayList<Instruction> subJumpInstructions = new ArrayList<Instruction>(length);
                    subJumpInstructions.add(branchInstruction);
                    ++i;
                    while (i <= length) {
                        subLastBi = (BranchInstruction)branchInstructions.remove(i);
                        subJumpInstructions.add(subLastBi);
                        --length;
                    }
                    ComparisonInstructionAnalyzer.analyzeLastTestBlock(subJumpInstructions);
                    int lineNumber = branchInstructions.get(0).getLineNumber();
                    branchInstructions.set(--i, new ComplexConditionalBranchInstruction(284, subLastBi.getOffset(), lineNumber, 1, subJumpInstructions, subLastBi.getBranch()));
                }
                ++i;
            }
        }
    }

    private static void setOperator(ComplexConditionalBranchInstruction cbl, BranchInstruction lastBi, boolean inverse) {
        List<Instruction> instructions = cbl.getInstructions();
        int lastIndex = instructions.size() - 1;
        BranchInstruction firstBi = (BranchInstruction)instructions.get(0);
        if (firstBi.getJumpOffset() == lastBi.getJumpOffset()) {
            cbl.setCmp(inverse ? 0 : 2);
            int i = 0;
            while (i <= lastIndex) {
                ComparisonInstructionAnalyzer.setOperator(instructions.get(i), inverse);
                ++i;
            }
        } else {
            cbl.setCmp(inverse ? 2 : 0);
            boolean tmpInverse = !inverse;
            int i = 0;
            while (i < lastIndex) {
                ComparisonInstructionAnalyzer.setOperator(instructions.get(i++), tmpInverse);
            }
            ComparisonInstructionAnalyzer.setOperator(instructions.get(i), inverse);
        }
    }

    private static void setOperator(Instruction instruction, boolean inverse) {
        switch (instruction.getOpcode()) {
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                ComparisonInstructionAnalyzer.setOperator(to.getValue1(), inverse);
                ComparisonInstructionAnalyzer.setOperator(to.getValue2(), inverse);
                break;
            }
            case 284: {
                ComplexConditionalBranchInstruction cbl = (ComplexConditionalBranchInstruction)instruction;
                int length = cbl.getInstructions().size();
                if (length == 1) {
                    ComparisonInstructionAnalyzer.setOperator(cbl.getInstructions().get(0), inverse);
                    break;
                }
                if (length <= 1) break;
                ComparisonInstructionAnalyzer.setOperator(cbl, (BranchInstruction)cbl.getInstructions().get(length - 1), inverse);
                break;
            }
            default: {
                if (!inverse) break;
                ConditionalBranchInstruction cbi = (ConditionalBranchInstruction)instruction;
                cbi.setCmp(7 - cbi.getCmp());
            }
        }
    }

    public static void inverseComparison(Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 260: 
            case 261: 
            case 262: {
                ConditionalBranchInstruction cbi = (ConditionalBranchInstruction)instruction;
                cbi.setCmp(7 - cbi.getCmp());
                break;
            }
            case 284: {
                ComplexConditionalBranchInstruction ccbi = (ComplexConditionalBranchInstruction)instruction;
                ccbi.setCmp(2 - ccbi.getCmp());
                int i = ccbi.getInstructions().size() - 1;
                while (i >= 0) {
                    ComparisonInstructionAnalyzer.inverseComparison(ccbi.getInstructions().get(i));
                    --i;
                }
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                ComparisonInstructionAnalyzer.inverseComparison(to.getValue1());
                ComparisonInstructionAnalyzer.inverseComparison(to.getValue2());
            }
        }
    }

    public static int getLastIndex(List<Instruction> list, int firstIndex) {
        int length = list.size();
        int index = firstIndex + 1;
        while (index < length) {
            Instruction instruction = list.get(index);
            int opcode = instruction.getOpcode();
            if (!ByteCodeUtil.isIfOrGotoInstruction((int)opcode, (boolean)false)) break;
            ++index;
        }
        if (index - 1 == firstIndex) {
            return firstIndex;
        }
        boolean[] dummy = new boolean[list.get(length - 1).getOffset()];
        while (--index > firstIndex) {
            BranchInstruction lastBi = (BranchInstruction)list.get(index);
            int afterOffest = index + 1 < length ? list.get(index + 1).getOffset() : -1;
            int firstIndexTmp = ComparisonInstructionAnalyzer.searchFirstIndex(list, index, lastBi, afterOffest, dummy, dummy);
            if (firstIndex == (firstIndexTmp = ComparisonInstructionAnalyzer.reduceFirstIndex(list, firstIndexTmp, index))) break;
        }
        return index;
    }
}

