/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.attribute.ObjectrefAttribute;
import jd.core.model.instruction.bytecode.instruction.attribute.ValuerefAttribute;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantNameAndType;

public class SetConstantTypeInStringIndexOfMethodsVisitor {
    private final ConstantPool constants;

    public SetConstantTypeInStringIndexOfMethodsVisitor(ConstantPool constants) {
        this.constants = constants;
    }

    public void visit(Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 190: {
                this.visit(((ArrayLength)instruction).getArrayref());
                break;
            }
            case 83: 
            case 272: {
                this.visit(((ArrayStoreInstruction)instruction).getArrayref());
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                this.visit(ai.getTest());
                if (ai.getMsg() == null) break;
                this.visit(ai.getMsg());
                break;
            }
            case 191: {
                this.visit(((AThrow)instruction).getValue());
                break;
            }
            case 266: {
                this.visit(((UnaryOperatorInstruction)instruction).getValue());
                break;
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                this.visit(boi.getValue1());
                this.visit(boi.getValue2());
                break;
            }
            case 87: 
            case 180: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 264: 
            case 280: {
                this.visit(((ObjectrefAttribute)((Object)instruction)).getObjectref());
                break;
            }
            case 54: 
            case 58: 
            case 179: 
            case 269: 
            case 273: {
                this.visit(((ValuerefAttribute)((Object)instruction)).getValueref());
                break;
            }
            case 275: 
            case 276: {
                this.visit(((ConvertInstruction)instruction).getValue());
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                this.visit(ifCmp.getValue1());
                this.visit(ifCmp.getValue2());
                break;
            }
            case 260: 
            case 262: {
                this.visit(((IfInstruction)instruction).getValue());
                break;
            }
            case 284: {
                this.visit(((ComplexConditionalBranchInstruction)instruction).getInstructions());
                break;
            }
            case 182: {
                int nbrOfParameters;
                Invokevirtual iv = (Invokevirtual)instruction;
                ConstantCP cmr = this.constants.getConstantMethodref(iv.getIndex());
                ConstantClass cc = this.constants.getConstantClass(cmr.getClassIndex());
                if (cc.getNameIndex() == this.constants.getStringClassNameIndex() && 1 <= (nbrOfParameters = iv.getArgs().size()) && nbrOfParameters <= 2) {
                    String name;
                    int opcode = iv.getArgs().get(0).getOpcode();
                    ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
                    String methodDescriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
                    String methodReturnedSignature = SignatureUtil.getMethodReturnedSignature(methodDescriptor);
                    List<String> parameterSignatures = SignatureUtil.getParameterSignatures(methodDescriptor);
                    if ((opcode == 16 || opcode == 17) && "I".equals(methodReturnedSignature) && "I".equals(parameterSignatures.get(0)) && ("indexOf".equals(name = this.constants.getConstantUtf8(cnat.getNameIndex())) || "lastIndexOf".equals(name))) {
                        IConst ic = (IConst)iv.getArgs().get(0);
                        ic.setReturnedSignature("C");
                        break;
                    }
                }
            }
            case 183: 
            case 185: {
                this.visit(((InvokeNoStaticInstruction)instruction).getObjectref());
            }
            case 184: 
            case 274: {
                List<Instruction> list = ((InvokeInstruction)instruction).getArgs();
                int i = list.size() - 1;
                while (i >= 0) {
                    this.visit(list.get(i));
                    --i;
                }
                break;
            }
            case 170: 
            case 171: {
                this.visit(((Switch)instruction).getKey());
                break;
            }
            case 197: {
                this.visit(((MultiANewArray)instruction).getDimensions());
                break;
            }
            case 188: {
                this.visit(((NewArray)instruction).getDimension());
                break;
            }
            case 189: {
                this.visit(((ANewArray)instruction).getDimension());
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                this.visit(putField.getObjectref());
                this.visit(putField.getValueref());
                break;
            }
            case 277: 
            case 278: {
                this.visit(((IncInstruction)instruction).getValue());
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                this.visit(iai.getNewArray());
                if (iai.getValues() == null) break;
                this.visit(iai.getValues());
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 186: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 271: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not search String.indexOf in " + instruction.getClass().getName() + ", opcode=" + instruction.getOpcode());
            }
        }
    }

    public void visit(List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            this.visit(instructions.get(i));
            --i;
        }
    }
}

