/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.attribute.ObjectrefAttribute;
import jd.core.model.instruction.bytecode.instruction.attribute.ValuerefAttribute;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastForEach;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;

public final class SearchInstructionByTypeVisitor<T extends Instruction> {
    private final Class<T> type;
    private final Predicate<T> predicate;

    public SearchInstructionByTypeVisitor(Class<T> type, Predicate<T> predicate) {
        this.type = type;
        this.predicate = predicate;
    }

    public SearchInstructionByTypeVisitor(Class<T> type) {
        this(type, null);
    }

    public T visit(Instruction instruction) throws RuntimeException {
        Objects.requireNonNull(instruction, "Null instruction");
        if (this.type.isInstance(instruction)) {
            Instruction convertedInstruction = (Instruction)this.type.cast(instruction);
            if (this.predicate == null || this.predicate.test(convertedInstruction)) {
                return (T)convertedInstruction;
            }
        }
        switch (instruction.getOpcode()) {
            case 190: {
                return this.visit(((ArrayLength)instruction).getArrayref());
            }
            case 83: 
            case 272: {
                return (T)Optional.ofNullable(this.visit(((ArrayStoreInstruction)instruction).getArrayref())).orElseGet(() -> this.visit(((ArrayStoreInstruction)instruction).getValueref()));
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                T tmp = this.visit(ai.getTest());
                if (tmp != null) {
                    return tmp;
                }
                if (ai.getMsg() == null) {
                    return null;
                }
                return this.visit(ai.getMsg());
            }
            case 191: {
                return this.visit(((AThrow)instruction).getValue());
            }
            case 266: {
                return this.visit(((UnaryOperatorInstruction)instruction).getValue());
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                return (T)Optional.ofNullable(this.visit(boi.getValue1())).orElseGet(() -> this.visit(boi.getValue2()));
            }
            case 87: 
            case 180: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 264: 
            case 280: {
                return this.visit(((ObjectrefAttribute)((Object)instruction)).getObjectref());
            }
            case 54: 
            case 58: 
            case 179: 
            case 269: 
            case 273: {
                return this.visit(((ValuerefAttribute)((Object)instruction)).getValueref());
            }
            case 275: 
            case 276: {
                return this.visit(((ConvertInstruction)instruction).getValue());
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                return (T)Optional.ofNullable(this.visit(ifCmp.getValue1())).orElseGet(() -> this.visit(ifCmp.getValue2()));
            }
            case 260: 
            case 262: {
                return this.visit(((IfInstruction)instruction).getValue());
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).getInstructions();
                int i = branchList.size() - 1;
                while (i >= 0) {
                    T tmp = this.visit(branchList.get(i));
                    if (tmp != null) {
                        return tmp;
                    }
                    --i;
                }
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                T result = this.visit(((InvokeNoStaticInstruction)instruction).getObjectref());
                if (result != null) {
                    return result;
                }
            }
            case 184: 
            case 274: {
                List<Instruction> list = ((InvokeInstruction)instruction).getArgs();
                int i = list.size() - 1;
                while (i >= 0) {
                    T tmp = this.visit(list.get(i));
                    if (tmp != null) {
                        return tmp;
                    }
                    --i;
                }
                break;
            }
            case 170: 
            case 171: {
                T result = this.visit(((Switch)instruction).getKey());
                if (result == null) break;
                return result;
            }
            case 197: {
                List<Instruction> dimensions = ((MultiANewArray)instruction).getDimensions();
                int i = dimensions.size() - 1;
                while (i >= 0) {
                    T tmp = this.visit(dimensions.get(i));
                    if (tmp != null) {
                        return tmp;
                    }
                    --i;
                }
                break;
            }
            case 188: {
                return this.visit(((NewArray)instruction).getDimension());
            }
            case 189: {
                return this.visit(((ANewArray)instruction).getDimension());
            }
            case 181: {
                PutField putField = (PutField)instruction;
                return (T)Optional.ofNullable(this.visit(putField.getObjectref())).orElseGet(() -> this.visit(putField.getValueref()));
            }
            case 277: 
            case 278: {
                return this.visit(((IncInstruction)instruction).getValue());
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                T tmp = this.visit(iai.getNewArray());
                if (tmp != null) {
                    return tmp;
                }
                if (iai.getValues() == null) break;
                return this.visit(iai.getValues());
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                return (T)Optional.ofNullable(this.visit(to.getValue1())).orElseGet(() -> this.visit(to.getValue2()));
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                T tmp = this.visit(ft.getInstructions());
                if (tmp != null) {
                    return tmp;
                }
                List<FastTry.FastCatch> catches = ft.getCatches();
                int i = catches.size() - 1;
                while (i >= 0) {
                    tmp = this.visit(catches.get(i).instructions());
                    if (tmp != null) {
                        return tmp;
                    }
                    --i;
                }
                if (ft.getFinallyInstructions() == null) break;
                return this.visit(ft.getFinallyInstructions());
            }
            case 319: {
                FastSynchronized fsy = (FastSynchronized)instruction;
                return (T)Optional.ofNullable(this.visit(fsy.getMonitor())).orElseGet(() -> this.visit(fsy.getInstructions()));
            }
            case 304: {
                T tmp;
                FastFor ff = (FastFor)instruction;
                if (ff.getInit() != null && (tmp = this.visit(ff.getInit())) != null) {
                    return tmp;
                }
                if (ff.getInc() != null && (tmp = this.visit(ff.getInc())) != null) {
                    return tmp;
                }
            }
            case 301: 
            case 302: 
            case 306: {
                T tmp;
                FastTestList ftl = (FastTestList)instruction;
                if (ftl.getTest() != null && (tmp = this.visit(ftl.getTest())) != null) {
                    return tmp;
                }
            }
            case 303: {
                List<Instruction> instructions = ((FastList)instruction).getInstructions();
                if (instructions == null) break;
                return this.visit(instructions);
            }
            case 305: {
                FastForEach ffe = (FastForEach)instruction;
                T tmp = this.visit(ffe.getVariable());
                if (tmp != null) {
                    return tmp;
                }
                tmp = this.visit(ffe.getValues());
                if (tmp != null) {
                    return tmp;
                }
                return this.visit(ffe.getInstructions());
            }
            case 307: {
                FastTest2Lists ft2l = (FastTest2Lists)instruction;
                T tmp = this.visit(ft2l.getTest());
                if (tmp != null) {
                    return tmp;
                }
                tmp = this.visit(ft2l.getInstructions());
                if (tmp != null) {
                    return tmp;
                }
                return this.visit(ft2l.getInstructions2());
            }
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                FastInstruction fi = (FastInstruction)instruction;
                if (fi.getInstruction() == null) break;
                return this.visit(fi.getInstruction());
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                if (fd.getInstruction() == null) break;
                return this.visit(fd.getInstruction());
            }
            case 314: 
            case 315: 
            case 316: {
                FastSwitch fs = (FastSwitch)instruction;
                T tmp = this.visit(fs.getTest());
                if (tmp != null) {
                    return tmp;
                }
                FastSwitch.Pair[] pairs = fs.getPairs();
                int i = pairs.length - 1;
                while (i >= 0) {
                    List<Instruction> instructions = pairs[i].getInstructions();
                    if (instructions != null && (tmp = this.visit(instructions)) != null) {
                        return tmp;
                    }
                    --i;
                }
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 186: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 271: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not search instruction in " + instruction.getClass().getName() + "=" + instruction.getOpcode());
            }
        }
        return null;
    }

    private T visit(List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            T instruction = this.visit(instructions.get(i));
            if (instruction != null) {
                return instruction;
            }
            --i;
        }
        return null;
    }
}

