/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.process.analyzer.instruction.fast.visitor.AbstractReplaceInstructionVisitor;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantNameAndType;

public class ReplaceStringBuxxxerVisitor
extends AbstractReplaceInstructionVisitor<Instruction> {
    private final ClassFile classFile;
    private final LocalVariables localVariables;

    public ReplaceStringBuxxxerVisitor(ClassFile classFile, LocalVariables localVariables) {
        this.classFile = classFile;
        this.localVariables = localVariables;
    }

    @Override
    protected Instruction newInstruction(Instruction i, Instruction item) {
        return item;
    }

    @Override
    protected Instruction match(Instruction parentFound, Instruction instruction) {
        return this.match(instruction);
    }

    @Override
    protected Instruction match(Instruction i) {
        if (i.getOpcode() == 182) {
            ConstantNameAndType cnat;
            ConstantCP cmr;
            Invokevirtual iv = (Invokevirtual)i;
            ConstantPool constants = this.classFile.getConstantPool();
            ConstantClass cc = constants.getConstantClass((cmr = constants.getConstantMethodref(iv.getIndex())).getClassIndex());
            if ((cc.getNameIndex() == constants.getStringBufferClassNameIndex() || cc.getNameIndex() == constants.getStringBuilderClassNameIndex()) && (cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex())).getNameIndex() == constants.getToStringIndex()) {
                SignatureInfo signatureInfo = new SignatureInfo();
                Instruction result = this.match(iv.getObjectref(), cmr.getClassIndex(), signatureInfo);
                if (signatureInfo.accept()) {
                    return result;
                }
            }
        }
        return null;
    }

    private Instruction match(Instruction i, int classIndex, SignatureInfo signatureInfo) {
        InvokeNew in;
        ConstantCP cmr;
        ConstantPool constants = this.classFile.getConstantPool();
        if (i.getOpcode() == 182) {
            ConstantNameAndType cnat;
            InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)i;
            ConstantCP cmr2 = constants.getConstantMethodref(insi.getIndex());
            if (cmr2.getClassIndex() == classIndex && (cnat = constants.getConstantNameAndType(cmr2.getNameAndTypeIndex())).getNameIndex() == constants.getAppendIndex() && insi.getArgs().size() == 1) {
                String descriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
                List<String> parameterSignatures = SignatureUtil.getParameterSignatures(descriptor);
                signatureInfo.appendSignatures.add(parameterSignatures.get(0));
                Instruction result = this.match(insi.getObjectref(), cmr2.getClassIndex(), signatureInfo);
                if (result == null) {
                    return insi.getArgs().get(0);
                }
                return new BinaryOperatorInstruction(267, i.getOffset(), i.getLineNumber(), 4, "Ljava/lang/String;", "+", result, insi.getArgs().get(0));
            }
        } else if (i.getOpcode() == 274 && (cmr = constants.getConstantMethodref((in = (InvokeNew)i).getIndex())).getClassIndex() == classIndex && in.getArgs().size() == 1) {
            ConstantNameAndType cnat;
            Invokestatic is;
            ConstantClass cc;
            Instruction arg0 = in.getArgs().get(0);
            if (arg0.getOpcode() == 184 && (cc = constants.getConstantClass((cmr = constants.getConstantMethodref((is = (Invokestatic)arg0).getIndex())).getClassIndex())).getNameIndex() == constants.getStringClassNameIndex() && (cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex())).getNameIndex() == constants.getValueOfIndex() && is.getArgs().size() == 1) {
                return is.getArgs().get(0);
            }
            signatureInfo.invokeNewSignature = arg0.getReturnedSignature(this.classFile, this.localVariables);
            return arg0;
        }
        return null;
    }

    private static class SignatureInfo {
        private String invokeNewSignature;
        private Set<String> appendSignatures = new HashSet<String>();

        private SignatureInfo() {
        }

        private boolean accept() {
            return !"I".equals(this.invokeNewSignature) && this.appendSignatures.contains("Ljava/lang/String;");
        }
    }
}

