/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.process.analyzer.instruction.fast.visitor.AbstractReplaceInstructionVisitor;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;

public class ReplaceOuterAccessorVisitor
extends AbstractReplaceInstructionVisitor<ClassFile> {
    protected final ClassFile classFile;

    public ReplaceOuterAccessorVisitor(ClassFile classFile) {
        this.classFile = classFile;
    }

    @Override
    protected ClassFile match(Instruction parentFound, Instruction instruction) {
        return this.match(instruction);
    }

    @Override
    protected ClassFile match(Instruction instruction) {
        String methodDescriptor;
        ConstantCP cmr;
        if (instruction.getOpcode() != 184) {
            return null;
        }
        Invokestatic is = (Invokestatic)instruction;
        if (is.getArgs().size() != 1) {
            return null;
        }
        ClassFile matchedClassFile = this.innerMatch(is.getArgs().get(0));
        if (matchedClassFile == null || !matchedClassFile.isAInnerClass()) {
            return null;
        }
        ConstantPool constants = this.classFile.getConstantPool();
        String className = constants.getConstantClassName((cmr = constants.getConstantMethodref(is.getIndex())).getClassIndex());
        if (!className.equals(matchedClassFile.getThisClassName())) {
            return null;
        }
        ConstantNameAndType cnat = constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String methodName = constants.getConstantUtf8(cnat.getNameIndex());
        Method method = matchedClassFile.getMethod(methodName, methodDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex()));
        if (method == null || (method.getAccessFlags() & 0x1008) != 4104) {
            return null;
        }
        ClassFile outerClassFile = matchedClassFile.getOuterClass();
        String returnedSignature = SignatureUtil.getMethodReturnedSignature(methodDescriptor);
        if (!returnedSignature.equals(outerClassFile.getInternalClassName())) {
            return null;
        }
        return outerClassFile;
    }

    private ClassFile innerMatch(Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 285: {
                GetStatic gs = (GetStatic)instruction;
                ConstantPool constants = this.classFile.getConstantPool();
                ConstantFieldref cfr = constants.getConstantFieldref(gs.getIndex());
                String className = constants.getConstantClassName(cfr.getClassIndex());
                ClassFile outerClassFile = this.classFile.getOuterClass();
                if (outerClassFile == null || !className.equals(outerClassFile.getThisClassName())) {
                    return null;
                }
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                String descriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
                if (!descriptor.equals(outerClassFile.getInternalClassName())) {
                    return null;
                }
                return outerClassFile;
            }
            case 184: {
                return this.match(instruction);
            }
        }
        return null;
    }

    @Override
    protected Instruction newInstruction(Instruction i, ClassFile matchedClassFile) {
        String internalMatchedClassName = matchedClassFile.getInternalClassName();
        String matchedClassName = matchedClassFile.getThisClassName();
        ConstantPool constants = this.classFile.getConstantPool();
        int signatureIndex = constants.addConstantUtf8(matchedClassName);
        int classIndex = constants.addConstantClass(signatureIndex);
        int thisIndex = constants.getThisLocalVariableNameIndex();
        int descriptorIndex = constants.addConstantUtf8(internalMatchedClassName);
        int nameAndTypeIndex = constants.addConstantNameAndType(thisIndex, descriptorIndex);
        int matchedThisFieldrefIndex = constants.addConstantFieldref(classIndex, nameAndTypeIndex);
        return new GetStatic(285, i.getOffset(), i.getLineNumber(), matchedThisFieldrefIndex);
    }
}

