/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.classfile.visitor.ReplaceOuterAccessorVisitor;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;

public class ReplaceMultipleOuterReferenceVisitor
extends ReplaceOuterAccessorVisitor {
    public ReplaceMultipleOuterReferenceVisitor(ClassFile classFile) {
        super(classFile);
    }

    @Override
    protected ClassFile match(Instruction instruction) {
        if (instruction.getOpcode() != 180) {
            return null;
        }
        GetField gf = (GetField)instruction;
        switch (gf.getObjectref().getOpcode()) {
            case 25: {
                ALoad aload = (ALoad)gf.getObjectref();
                if (aload.getIndex() != 0) {
                    return null;
                }
                Field field = this.classFile.getOuterThisField();
                if (field == null) {
                    return null;
                }
                ConstantPool constants = this.classFile.getConstantPool();
                ConstantFieldref cfr = constants.getConstantFieldref(gf.getIndex());
                if (cfr.getClassIndex() != this.classFile.getThisClassIndex()) {
                    return null;
                }
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                if (field.getNameIndex() != cnat.getNameIndex() || field.getDescriptorIndex() != cnat.getSignatureIndex()) {
                    return null;
                }
                return this.classFile.getOuterClass();
            }
            case 285: {
                ConstantPool constants = this.classFile.getConstantPool();
                GetStatic gs = (GetStatic)gf.getObjectref();
                ConstantFieldref cfr = constants.getConstantFieldref(gs.getIndex());
                String className = constants.getConstantClassName(cfr.getClassIndex());
                ClassFile outerClass = this.classFile.getOuterClass();
                while (outerClass != null) {
                    if (outerClass.getThisClassName().equals(className)) {
                        String outerFieldDescriptor;
                        ConstantPool outerConstants;
                        String outerFieldName;
                        Field outerField = outerClass.getOuterThisField();
                        if (outerField == null) {
                            return null;
                        }
                        cfr = constants.getConstantFieldref(gf.getIndex());
                        ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                        String fieldName = constants.getConstantUtf8(cnat.getNameIndex());
                        if (!fieldName.equals(outerFieldName = (outerConstants = outerClass.getConstantPool()).getConstantUtf8(outerField.getNameIndex()))) {
                            return null;
                        }
                        String fieldDescriptor = constants.getConstantUtf8(cnat.getSignatureIndex());
                        if (!fieldDescriptor.equals(outerFieldDescriptor = outerConstants.getConstantUtf8(outerField.getDescriptorIndex()))) {
                            return null;
                        }
                        return outerClass.getOuterClass();
                    }
                    outerClass = outerClass.getOuterClass();
                }
                return null;
            }
            case 180: {
                ConstantPool matchedConstants;
                String matchedFieldName;
                ConstantPool constants = this.classFile.getConstantPool();
                ConstantFieldref cfr = constants.getConstantFieldref(gf.getIndex());
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                String descriptorName = constants.getConstantUtf8(cnat.getSignatureIndex());
                if (!SignatureUtil.isObjectSignature(descriptorName)) {
                    return null;
                }
                ClassFile matchedClassFile = this.match(gf.getObjectref());
                if (matchedClassFile == null || !matchedClassFile.isAInnerClass()) {
                    return null;
                }
                Field matchedField = matchedClassFile.getOuterThisField();
                if (matchedField == null) {
                    return null;
                }
                String className = constants.getConstantClassName(cfr.getClassIndex());
                if (!className.equals(matchedClassFile.getThisClassName())) {
                    return null;
                }
                String fieldName = constants.getConstantUtf8(cnat.getNameIndex());
                if (!fieldName.equals(matchedFieldName = (matchedConstants = matchedClassFile.getConstantPool()).getConstantUtf8(matchedField.getNameIndex()))) {
                    return null;
                }
                String matchedDescriptorName = matchedConstants.getConstantUtf8(matchedField.getDescriptorIndex());
                if (!descriptorName.equals(matchedDescriptorName)) {
                    return null;
                }
                return matchedClassFile.getOuterClass();
            }
        }
        return null;
    }
}

