/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.New;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.attribute.ObjectrefAttribute;
import jd.core.model.instruction.bytecode.instruction.attribute.ValuerefAttribute;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastForEach;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;
import jd.core.model.reference.ReferenceMap;
import jd.core.process.writer.SourceWriteable;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;

public class ReferenceVisitor {
    private final ConstantPool constants;
    private final ReferenceMap referenceMap;

    public ReferenceVisitor(ConstantPool constants, ReferenceMap referenceMap) {
        this.constants = constants;
        this.referenceMap = referenceMap;
    }

    public void visit(Instruction instruction) {
        if (instruction == null) {
            return;
        }
        switch (instruction.getOpcode()) {
            case 190: {
                ArrayLength al = (ArrayLength)instruction;
                this.visit(al.getArrayref());
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                this.visit(asi.getValueref());
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                this.visit(ai.getTest());
                this.visit(ai.getMsg());
                break;
            }
            case 191: {
                AThrow aThrow = (AThrow)instruction;
                this.visit(aThrow.getValue());
                break;
            }
            case 266: {
                UnaryOperatorInstruction uoi = (UnaryOperatorInstruction)instruction;
                this.visit(uoi.getValue());
                break;
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                this.visit(boi.getValue1());
                this.visit(boi.getValue2());
                break;
            }
            case 192: {
                CheckCast checkCast = (CheckCast)instruction;
                this.visitCheckCastAndMultiANewArray(checkCast.getIndex());
                this.visit(checkCast.getObjectref());
                break;
            }
            case 54: 
            case 58: 
            case 179: 
            case 269: 
            case 273: {
                ValuerefAttribute v = (ValuerefAttribute)((Object)instruction);
                this.visit(v.getValueref());
                break;
            }
            case 87: 
            case 194: 
            case 195: 
            case 264: 
            case 280: {
                ObjectrefAttribute o = (ObjectrefAttribute)((Object)instruction);
                this.visit(o.getObjectref());
                break;
            }
            case 275: 
            case 276: {
                ConvertInstruction ci = (ConvertInstruction)instruction;
                this.visit(ci.getValue());
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                this.visit(ifCmp.getValue1());
                this.visit(ifCmp.getValue2());
                break;
            }
            case 260: 
            case 262: {
                IfInstruction iff = (IfInstruction)instruction;
                this.visit(iff.getValue());
                break;
            }
            case 284: {
                this.visit(((ComplexConditionalBranchInstruction)instruction).getInstructions());
                break;
            }
            case 193: {
                InstanceOf instanceOf = (InstanceOf)instruction;
                this.visitCheckCastAndMultiANewArray(instanceOf.getIndex());
                this.visit(instanceOf.getObjectref());
                break;
            }
            case 186: {
                if (!(instruction instanceof SourceWriteable instanceOf)) break;
                this.addReference(ref.getInternalTypeName());
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                InvokeNoStaticInstruction insi = (InvokeNoStaticInstruction)instruction;
                this.visit(insi.getObjectref());
            }
            case 184: 
            case 274: {
                InvokeInstruction ii = (InvokeInstruction)instruction;
                if (!(ii instanceof InvokeNoStaticInstruction)) {
                    ConstantCP cmr = this.constants.getConstantMethodref(ii.getIndex());
                    String internalName = this.constants.getConstantClassName(cmr.getClassIndex());
                    this.addReference(internalName);
                }
                this.visit(ii.getArgs());
                break;
            }
            case 170: 
            case 171: {
                Switch sw = (Switch)instruction;
                this.visit(sw.getKey());
                break;
            }
            case 197: {
                MultiANewArray multiANewArray = (MultiANewArray)instruction;
                this.visitCheckCastAndMultiANewArray(multiANewArray.getIndex());
                this.visit(multiANewArray.getDimensions());
                break;
            }
            case 188: {
                NewArray newArray = (NewArray)instruction;
                this.visit(newArray.getDimension());
                break;
            }
            case 187: {
                New aNew = (New)instruction;
                this.addReference(this.constants.getConstantClassName(aNew.getIndex()));
                break;
            }
            case 189: {
                ANewArray aNewArray = (ANewArray)instruction;
                this.addReference(this.constants.getConstantClassName(aNewArray.getIndex()));
                this.visit(aNewArray.getDimension());
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                this.visit(putField.getObjectref());
                this.visit(putField.getValueref());
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                this.visit(to.getTest());
                this.visit(to.getValue1());
                this.visit(to.getValue2());
                break;
            }
            case 180: {
                GetField getField = (GetField)instruction;
                this.visit(getField.getObjectref());
            }
            case 178: 
            case 285: {
                IndexInstruction indexInstruction = (IndexInstruction)instruction;
                ConstantFieldref cfr = this.constants.getConstantFieldref(indexInstruction.getIndex());
                String internalName = this.constants.getConstantClassName(cfr.getClassIndex());
                this.addReference(internalName);
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                this.visit(iai.getNewArray());
                int index = iai.getValues().size() - 1;
                while (index >= 0) {
                    this.visit(iai.getValues().get(index));
                    --index;
                }
                break;
            }
            case 304: {
                FastFor ff = (FastFor)instruction;
                this.visit(ff.getInit());
                this.visit(ff.getInc());
            }
            case 301: 
            case 302: 
            case 306: {
                FastTestList ftl = (FastTestList)instruction;
                this.visit(ftl.getTest());
            }
            case 303: {
                List<Instruction> instructions = ((FastList)instruction).getInstructions();
                this.visit(instructions);
                break;
            }
            case 305: {
                FastForEach ffe = (FastForEach)instruction;
                this.visit(ffe.getVariable());
                this.visit(ffe.getValues());
                this.visit(ffe.getInstructions());
                break;
            }
            case 307: {
                FastTest2Lists ft2l = (FastTest2Lists)instruction;
                this.visit(ft2l.getTest());
                this.visit(ft2l.getInstructions());
                this.visit(ft2l.getInstructions2());
                break;
            }
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                FastInstruction fi = (FastInstruction)instruction;
                this.visit(fi.getInstruction());
                break;
            }
            case 314: 
            case 315: 
            case 316: {
                FastSwitch fs = (FastSwitch)instruction;
                this.visit(fs.getTest());
                FastSwitch.Pair[] pairs = fs.getPairs();
                int i = pairs.length - 1;
                while (i >= 0) {
                    this.visit(pairs[i].getInstructions());
                    --i;
                }
                break;
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                this.visit(fd.getInstruction());
                break;
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                this.visit(ft.getInstructions());
                List<FastTry.FastCatch> catches = ft.getCatches();
                int i = catches.size() - 1;
                while (i >= 0) {
                    this.visit(catches.get(i).instructions());
                    --i;
                }
                this.visit(ft.getFinallyInstructions());
                break;
            }
            case 319: {
                FastSynchronized fsy = (FastSynchronized)instruction;
                this.visit(fsy.getMonitor());
                this.visit(fsy.getInstructions());
                break;
            }
            case 320: {
                FastLabel fla = (FastLabel)instruction;
                this.visit(fla.getInstruction());
                break;
            }
            case 18: {
                IndexInstruction indexInstruction = (IndexInstruction)instruction;
                Constant constant = cst = this.constants.get(indexInstruction.getIndex());
                if (!(constant instanceof ConstantClass i)) break;
                String internalName = this.constants.getConstantUtf8(cc.getNameIndex());
                this.addReference(internalName);
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 271: 
            case 277: 
            case 278: 
            case 279: {
                break;
            }
            default: {
                System.err.println("Can not count reference in " + instruction.getClass().getName() + ", opcode=" + instruction.getOpcode());
            }
        }
    }

    public void visit(List<Instruction> instructions) {
        if (instructions != null) {
            int i = instructions.size() - 1;
            while (i >= 0) {
                this.visit(instructions.get(i));
                --i;
            }
        }
    }

    private void visitCheckCastAndMultiANewArray(int index) {
        Constant c = this.constants.get(index);
        if (c instanceof ConstantClass var3_4) {
            this.addReference(this.constants.getConstantUtf8(cc.getNameIndex()));
        }
    }

    private void addReference(String signature) {
        if (signature.charAt(0) == '[') {
            if ((signature = SignatureUtil.cutArrayDimensionPrefix(signature)).charAt(0) == 'L') {
                this.referenceMap.add(SignatureUtil.getInnerName(signature));
            }
        } else {
            this.referenceMap.add(signature);
        }
    }
}

