/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.Map;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.accessor.Accessor;
import jd.core.model.classfile.accessor.PutFieldAccessor;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.process.analyzer.classfile.visitor.OuterGetStaticVisitor;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;

public class OuterPutFieldVisitor
extends OuterGetStaticVisitor {
    public OuterPutFieldVisitor(Map<String, ClassFile> innerClassesMap, ConstantPool constants) {
        super(innerClassesMap, constants);
    }

    @Override
    protected Accessor match(Instruction i) {
        if (i.getOpcode() != 184) {
            return null;
        }
        Invokestatic is = (Invokestatic)i;
        ConstantCP cmr = this.constants.getConstantMethodref(is.getIndex());
        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
        int nbrOfParameters = SignatureUtil.getParameterSignatureCount(descriptor);
        if (nbrOfParameters != 2) {
            return null;
        }
        String className = this.constants.getConstantClassName(cmr.getClassIndex());
        ClassFile classFile = (ClassFile)this.innerClassesMap.get(className);
        if (classFile == null) {
            return null;
        }
        String name = this.constants.getConstantUtf8(cnat.getNameIndex());
        Accessor accessor = classFile.getAccessor(name, descriptor);
        if (accessor == null || accessor.tag() != 4) {
            return null;
        }
        return accessor;
    }

    @Override
    protected Instruction newInstruction(Instruction i, Accessor a) {
        PutFieldAccessor pfa = (PutFieldAccessor)a;
        Invokestatic is = (Invokestatic)i;
        int nameIndex = this.constants.addConstantUtf8(pfa.fieldName());
        int descriptorIndex = this.constants.addConstantUtf8(pfa.fieldDescriptor());
        int cnatIndex = this.constants.addConstantNameAndType(nameIndex, descriptorIndex);
        int classNameIndex = this.constants.addConstantUtf8(pfa.className());
        int classIndex = this.constants.addConstantClass(classNameIndex);
        int cfrIndex = this.constants.addConstantFieldref(classIndex, cnatIndex);
        Instruction valueref = is.getArgs().remove(1);
        Instruction objectref = is.getArgs().remove(0);
        return new PutField(181, i.getOffset(), i.getLineNumber(), cfrIndex, objectref, valueref);
    }
}

