/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.Map;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.accessor.Accessor;
import jd.core.model.classfile.accessor.InvokeMethodAccessor;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokeinterface;
import jd.core.model.instruction.bytecode.instruction.Invokespecial;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Invokevirtual;
import jd.core.process.analyzer.classfile.visitor.OuterGetStaticVisitor;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;

public class OuterInvokeMethodVisitor
extends OuterGetStaticVisitor {
    public OuterInvokeMethodVisitor(Map<String, ClassFile> innerClassesMap, ConstantPool constants) {
        super(innerClassesMap, constants);
    }

    @Override
    protected Accessor match(Instruction i) {
        if (i.getOpcode() != 184) {
            return null;
        }
        Invokestatic is = (Invokestatic)i;
        ConstantCP cmr = this.constants.getConstantMethodref(is.getIndex());
        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
        String className = this.constants.getConstantClassName(cmr.getClassIndex());
        ClassFile classFile = (ClassFile)this.innerClassesMap.get(className);
        if (classFile == null) {
            return null;
        }
        String name = this.constants.getConstantUtf8(cnat.getNameIndex());
        Accessor accessor = classFile.getAccessor(name, descriptor);
        if (accessor == null || accessor.tag() != 5) {
            return null;
        }
        return accessor;
    }

    @Override
    protected Instruction newInstruction(Instruction i, Accessor a) {
        InvokeMethodAccessor ima = (InvokeMethodAccessor)a;
        Invokestatic is = (Invokestatic)i;
        int nameIndex = this.constants.addConstantUtf8(ima.methodName());
        int descriptorIndex = this.constants.addConstantUtf8(ima.methodDescriptor());
        int cnatIndex = this.constants.addConstantNameAndType(nameIndex, descriptorIndex);
        int classNameIndex = this.constants.addConstantUtf8(ima.className());
        int classIndex = this.constants.addConstantClass(classNameIndex);
        int cmrIndex = this.constants.addConstantMethodref(classIndex, cnatIndex);
        switch (ima.methodOpcode()) {
            case 183: {
                Instruction objectref = is.getArgs().remove(0);
                return new Invokespecial(183, i.getOffset(), i.getLineNumber(), cmrIndex, objectref, is.getArgs());
            }
            case 182: {
                Instruction objectref = is.getArgs().remove(0);
                return new Invokevirtual(182, i.getOffset(), i.getLineNumber(), cmrIndex, objectref, is.getArgs());
            }
            case 185: {
                Instruction objectref = is.getArgs().remove(0);
                return new Invokeinterface(185, i.getOffset(), i.getLineNumber(), cmrIndex, objectref, is.getArgs());
            }
            case 184: {
                return new Invokestatic(184, i.getOffset(), i.getLineNumber(), cmrIndex, is.getArgs());
            }
        }
        return i;
    }
}

