/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.Map;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.accessor.Accessor;
import jd.core.model.classfile.accessor.IncGetStaticAccessor;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.classfile.visitor.OuterGetStaticVisitor;

public class OuterIncGetStaticVisitor
extends OuterGetStaticVisitor {
    public OuterIncGetStaticVisitor(Map<String, ClassFile> innerClassesMap, ConstantPool constants) {
        super(innerClassesMap, constants);
    }

    @Override
    protected byte getTargetTag() {
        return 7;
    }

    @Override
    protected Instruction newInstruction(Instruction i, Accessor a) {
        IncGetStaticAccessor igfa = (IncGetStaticAccessor)a;
        int nameIndex = this.constants.addConstantUtf8(igfa.fieldName());
        int descriptorIndex = this.constants.addConstantUtf8(igfa.fieldDescriptor());
        int cnatIndex = this.constants.addConstantNameAndType(nameIndex, descriptorIndex);
        int classNameIndex = this.constants.addConstantUtf8(igfa.className());
        int classIndex = this.constants.addConstantClass(classNameIndex);
        int cfrIndex = this.constants.addConstantFieldref(classIndex, cnatIndex);
        GetStatic getStatic = new GetStatic(178, i.getOffset(), i.getLineNumber(), cfrIndex);
        return new IncInstruction(igfa.opcode(), i.getOffset(), i.getLineNumber(), getStatic, igfa.count());
    }
}

