/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.Map;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.accessor.Accessor;
import jd.core.model.classfile.accessor.IncGetFieldAccessor;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.process.analyzer.classfile.visitor.OuterGetFieldVisitor;

public class OuterIncGetFieldVisitor
extends OuterGetFieldVisitor {
    public OuterIncGetFieldVisitor(Map<String, ClassFile> innerClassesMap, ConstantPool constants) {
        super(innerClassesMap, constants);
    }

    @Override
    protected byte getTargetTag() {
        return 6;
    }

    @Override
    protected Instruction newInstruction(Instruction i, Accessor a) {
        IncGetFieldAccessor igfa = (IncGetFieldAccessor)a;
        Invokestatic is = (Invokestatic)i;
        int nameIndex = this.constants.addConstantUtf8(igfa.fieldName());
        int descriptorIndex = this.constants.addConstantUtf8(igfa.fieldDescriptor());
        int cnatIndex = this.constants.addConstantNameAndType(nameIndex, descriptorIndex);
        int classNameIndex = this.constants.addConstantUtf8(igfa.className());
        int classIndex = this.constants.addConstantClass(classNameIndex);
        int cfrIndex = this.constants.addConstantFieldref(classIndex, cnatIndex);
        Instruction objectref = is.getArgs().remove(0);
        GetField getField = new GetField(180, i.getOffset(), i.getLineNumber(), cfrIndex, objectref);
        return new IncInstruction(igfa.opcode(), i.getOffset(), i.getLineNumber(), getField, igfa.count());
    }
}

