/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.Map;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.accessor.Accessor;
import jd.core.model.classfile.accessor.GetStaticAccessor;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.process.analyzer.instruction.fast.visitor.AbstractReplaceInstructionVisitor;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;

public class OuterGetStaticVisitor
extends AbstractReplaceInstructionVisitor<Accessor> {
    protected final Map<String, ClassFile> innerClassesMap;
    protected final ConstantPool constants;

    public OuterGetStaticVisitor(Map<String, ClassFile> innerClassesMap, ConstantPool constants) {
        this.innerClassesMap = innerClassesMap;
        this.constants = constants;
    }

    @Override
    protected Accessor match(Instruction parentFound, Instruction instruction) {
        return this.match(instruction);
    }

    @Override
    protected Accessor match(Instruction i) {
        if (i.getOpcode() != 184) {
            return null;
        }
        Invokestatic is = (Invokestatic)i;
        ConstantCP cmr = this.constants.getConstantMethodref(is.getIndex());
        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
        if (descriptor.charAt(1) != ')') {
            return null;
        }
        String className = this.constants.getConstantClassName(cmr.getClassIndex());
        ClassFile classFile = this.innerClassesMap.get(className);
        if (classFile == null) {
            return null;
        }
        String name = this.constants.getConstantUtf8(cnat.getNameIndex());
        Accessor accessor = classFile.getAccessor(name, descriptor);
        if (accessor == null || accessor.tag() != this.getTargetTag()) {
            return null;
        }
        return accessor;
    }

    protected byte getTargetTag() {
        return 1;
    }

    @Override
    protected Instruction newInstruction(Instruction i, Accessor a) {
        GetStaticAccessor gsa = (GetStaticAccessor)a;
        int nameIndex = this.constants.addConstantUtf8(gsa.fieldName());
        int descriptorIndex = this.constants.addConstantUtf8(gsa.fieldDescriptor());
        int cnatIndex = this.constants.addConstantNameAndType(nameIndex, descriptorIndex);
        int classNameIndex = this.constants.addConstantUtf8(gsa.className());
        int classIndex = this.constants.addConstantClass(classNameIndex);
        int cfrIndex = this.constants.addConstantFieldref(classIndex, cnatIndex);
        return new GetStatic(178, i.getOffset(), i.getLineNumber(), cfrIndex);
    }
}

