/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.Map;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.accessor.Accessor;
import jd.core.model.classfile.accessor.GetFieldAccessor;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.process.analyzer.classfile.visitor.OuterGetStaticVisitor;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;

public class OuterGetFieldVisitor
extends OuterGetStaticVisitor {
    public OuterGetFieldVisitor(Map<String, ClassFile> innerClassesMap, ConstantPool constants) {
        super(innerClassesMap, constants);
    }

    @Override
    protected Accessor match(Instruction i) {
        if (i.getOpcode() != 184) {
            return null;
        }
        Invokestatic is = (Invokestatic)i;
        ConstantCP cmr = this.constants.getConstantMethodref(is.getIndex());
        ConstantNameAndType cnat = this.constants.getConstantNameAndType(cmr.getNameAndTypeIndex());
        String descriptor = this.constants.getConstantUtf8(cnat.getSignatureIndex());
        int nbrOfParameters = SignatureUtil.getParameterSignatureCount(descriptor);
        if (nbrOfParameters != 1) {
            return null;
        }
        String className = this.constants.getConstantClassName(cmr.getClassIndex());
        ClassFile classFile = (ClassFile)this.innerClassesMap.get(className);
        if (classFile == null) {
            return null;
        }
        String name = this.constants.getConstantUtf8(cnat.getNameIndex());
        Accessor accessor = classFile.getAccessor(name, descriptor);
        if (accessor == null || accessor.tag() != this.getTargetTag()) {
            return null;
        }
        return accessor;
    }

    @Override
    protected byte getTargetTag() {
        return 3;
    }

    @Override
    protected Instruction newInstruction(Instruction i, Accessor a) {
        GetFieldAccessor gfa = (GetFieldAccessor)a;
        Invokestatic is = (Invokestatic)i;
        int nameIndex = this.constants.addConstantUtf8(gfa.fieldName());
        int descriptorIndex = this.constants.addConstantUtf8(gfa.fieldDescriptor());
        int cnatIndex = this.constants.addConstantNameAndType(nameIndex, descriptorIndex);
        int classNameIndex = this.constants.addConstantUtf8(gfa.className());
        int classIndex = this.constants.addConstantClass(classNameIndex);
        int cfrIndex = this.constants.addConstantFieldref(classIndex, cnatIndex);
        Instruction objectref = is.getArgs().remove(0);
        return new GetField(180, i.getOffset(), i.getLineNumber(), cfrIndex, objectref);
    }
}

