/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.visitor;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.AssertInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.IConst;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.Switch;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.attribute.ObjectrefAttribute;
import jd.core.model.instruction.bytecode.instruction.attribute.ValuerefAttribute;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.util.SignatureUtil;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.Signature;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public final class CheckCastAndConvertInstructionVisitor {
    private CheckCastAndConvertInstructionVisitor() {
    }

    private static void visit(ClassFile classFile, Method method, Instruction instruction) {
        LocalVariables localVariables = method.getLocalVariables();
        switch (instruction.getOpcode()) {
            case 83: 
            case 190: 
            case 272: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((ArrayInstruction)instruction).getArrayref());
                break;
            }
            case 286: {
                AssertInstruction ai = (AssertInstruction)instruction;
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ai.getTest());
                if (ai.getMsg() == null) break;
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ai.getMsg());
                break;
            }
            case 191: {
                TypeMaker typeMaker;
                TypeMaker.MethodTypes methodTypes;
                BaseType exceptionTypes;
                Instruction valueref = ((AThrow)instruction).getValueref();
                Signature signature = method.getAttributeSignature();
                if (signature != null && signature.getSignature().indexOf(94) != -1 && (exceptionTypes = (methodTypes = (typeMaker = new TypeMaker(classFile.getLoader())).makeMethodTypes(classFile.getThisClassName(), method.getName(classFile.getConstantPool()), signature.getSignature())).getExceptionTypes()) != null && exceptionTypes.size() == 1) {
                    Type exceptionType = (Type)exceptionTypes.getFirst();
                    String expressionSignature = valueref.getReturnedSignature(classFile, localVariables);
                    Type expressionType = typeMaker.makeFromSignature(expressionSignature);
                    if (exceptionType.isGenericType() && !exceptionType.equals(expressionType)) {
                        String exceptionSignature = exceptionType.getDescriptor();
                        int descriptorIndex = classFile.getConstantPool().addConstantUtf8(String.valueOf('T') + exceptionSignature + ';');
                        ValuerefAttribute valuerefAttribute = (ValuerefAttribute)((Object)instruction);
                        CheckCastAndConvertInstructionVisitor.addOrUpdateCast(localVariables, classFile, valuerefAttribute, descriptorIndex);
                    }
                }
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, valueref);
                break;
            }
            case 266: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((UnaryOperatorInstruction)instruction).getValue());
                break;
            }
            case 265: 
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, boi.getValue1());
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, boi.getValue2());
                break;
            }
            case 192: {
                CheckCast cc = (CheckCast)instruction;
                if (cc.getObjectref().getOpcode() == 192) {
                    cc.setObjectref(((CheckCast)cc.getObjectref()).getObjectref());
                }
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, cc.getObjectref());
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                StoreInstruction si = (StoreInstruction)instruction;
                LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(si.getIndex(), si.getOffset());
                if (lv != null) {
                    CheckCastAndConvertInstructionVisitor.addOrUpdateCast(localVariables, classFile, si, lv.getSignatureIndex());
                }
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, si.getValueref());
                break;
            }
            case 87: 
            case 180: 
            case 193: 
            case 194: 
            case 195: 
            case 264: 
            case 280: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((ObjectrefAttribute)((Object)instruction)).getObjectref());
                break;
            }
            case 275: 
            case 276: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((ConvertInstruction)instruction).getValue());
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ifCmp.getValue1());
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ifCmp.getValue2());
                break;
            }
            case 260: 
            case 262: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((IfInstruction)instruction).getValue());
                break;
            }
            case 284: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((ComplexConditionalBranchInstruction)instruction).getInstructions());
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((InvokeNoStaticInstruction)instruction).getObjectref());
            }
            case 184: 
            case 274: {
                List<String> parameterSignatures = ((InvokeInstruction)instruction).getListOfParameterSignatures(classFile.getConstantPool());
                if (parameterSignatures == null) break;
                List<Instruction> args = ((InvokeInstruction)instruction).getArgs();
                int i = parameterSignatures.size();
                int j = args.size();
                while (i-- > 0 && j-- > 0) {
                    Instruction arg = args.get(j);
                    if (ByteCodeUtil.isLoadIntValue((int)arg.getOpcode())) {
                        String argSignature = ((IConst)arg).getSignature();
                        String parameterSignature = parameterSignatures.get(i);
                        if (!parameterSignature.equals(argSignature)) {
                            int paramBitFields;
                            int argBitFields = SignatureUtil.createArgOrReturnBitFields(argSignature);
                            if ((argBitFields | (paramBitFields = SignatureUtil.createTypesBitField(parameterSignature))) != 0) continue;
                            args.set(j, new ConvertInstruction(275, arg.getOffset() - 1, arg.getLineNumber(), arg, parameterSignature));
                            continue;
                        }
                        if (SignatureUtil.isByteOrShortSignature(parameterSignature)) {
                            args.set(j, new ConvertInstruction(275, arg.getOffset() - 1, arg.getLineNumber(), arg, parameterSignature));
                            continue;
                        }
                        CheckCastAndConvertInstructionVisitor.visit(classFile, method, arg);
                        continue;
                    }
                    CheckCastAndConvertInstructionVisitor.visit(classFile, method, arg);
                }
                break;
            }
            case 170: 
            case 171: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((Switch)instruction).getKey());
                break;
            }
            case 197: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((MultiANewArray)instruction).getDimensions());
                break;
            }
            case 188: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((NewArray)instruction).getDimension());
                break;
            }
            case 189: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((ANewArray)instruction).getDimension());
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                ConstantFieldref cfr = classFile.getConstantPool().getConstantFieldref(putField.getIndex());
                ConstantNameAndType cnat = classFile.getConstantPool().getConstantNameAndType(cfr.getNameAndTypeIndex());
                Field field = classFile.getField(cnat.getNameIndex(), cnat.getSignatureIndex());
                if (field != null) {
                    CheckCastAndConvertInstructionVisitor.addOrUpdateCast(localVariables, classFile, putField, field.getSignatureIndex());
                }
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, putField.getObjectref());
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, putField.getValueref());
                break;
            }
            case 179: 
            case 273: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((ValuerefAttribute)((Object)instruction)).getValueref());
                break;
            }
            case 277: 
            case 278: {
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, ((IncInstruction)instruction).getValue());
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, iai.getNewArray());
                if (iai.getValues() == null) break;
                CheckCastAndConvertInstructionVisitor.visit(classFile, method, iai.getValues());
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 186: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 268: 
            case 270: 
            case 271: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not check cast and convert instruction in " + instruction.getClass().getName() + ", opcode=" + instruction.getOpcode());
            }
        }
    }

    public static void visit(ClassFile classFile, Method method, List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            CheckCastAndConvertInstructionVisitor.visit(classFile, method, instructions.get(i));
            --i;
        }
    }

    public static void addOrUpdateCast(LocalVariables localVariables, ClassFile classFile, ValuerefAttribute valuerefAttribute, int descriptorIndex) {
        Instruction valueref = valuerefAttribute.getValueref();
        String expressionSignature = valueref.getReturnedSignature(classFile, localVariables);
        String signature = classFile.getConstantPool().getConstantUtf8(descriptorIndex);
        TypeMaker typeMaker = new TypeMaker(classFile.getLoader());
        Type receiverType = typeMaker.makeFromSignature(signature);
        if (valueref instanceof CheckCast var9_10) {
            String castSignature = cc.getReturnedSignature(classFile, localVariables);
            Type castType = typeMaker.makeFromSignature(castSignature);
            if (castType.isObjectType() && receiverType.isGenericType() && receiverType.getDimension() == castType.getDimension()) {
                cc.setIndex(descriptorIndex);
            }
        } else if (expressionSignature != null) {
            Type expressionType = typeMaker.makeFromSignature(expressionSignature);
            if (receiverType.isGenericType() && (!expressionType.isGenericType() || valueref instanceof ALoad && !expressionType.equals(receiverType))) {
                valuerefAttribute.setValueref(new CheckCast(192, valuerefAttribute.getOffset(), valuerefAttribute.getLineNumber(), descriptorIndex, valueref));
            }
            if (receiverType.isObjectType() && expressionType != null && expressionType.isObjectType() && typeMaker.isRawTypeAssignable((ObjectType)receiverType, (ObjectType)expressionType)) {
                ObjectType otLeft = (ObjectType)receiverType;
                ObjectType otRight = (ObjectType)expressionType;
                BaseTypeArgument typeArgsLeft = otLeft.getTypeArguments();
                BaseTypeArgument typeArgsRight = otRight.getTypeArguments();
                if (typeArgsLeft instanceof ObjectType && typeArgsRight instanceof WildcardTypeArgument || typeArgsLeft instanceof GenericType && (typeArgsRight instanceof WildcardExtendsTypeArgument || typeArgsRight instanceof WildcardSuperTypeArgument)) {
                    valuerefAttribute.setValueref(new CheckCast(192, valuerefAttribute.getOffset(), valuerefAttribute.getLineNumber(), descriptorIndex, valueref));
                }
                if (typeArgsLeft != null && typeArgsLeft.isTypeArgumentList() && typeArgsRight != null && typeArgsRight.isTypeArgumentList()) {
                    int j = 0;
                    while (j < typeArgsRight.getTypeArgumentList().size()) {
                        TypeArgument typeArgumentLeft = (TypeArgument)typeArgsLeft.getTypeArgumentList().get(j);
                        TypeArgument typeArgumentRight = (TypeArgument)typeArgsRight.getTypeArgumentList().get(j);
                        if (typeArgumentLeft instanceof GenericType && typeArgumentRight instanceof WildcardExtendsTypeArgument) {
                            valuerefAttribute.setValueref(new CheckCast(192, valuerefAttribute.getOffset(), valuerefAttribute.getLineNumber(), descriptorIndex, valueref));
                            break;
                        }
                        ++j;
                    }
                }
            }
        }
    }
}

