/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.ConstInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.attribute.ValuerefAttribute;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import jd.core.process.analyzer.util.ReconstructorUtil;

public final class PostIncReconstructor {
    private PostIncReconstructor() {
    }

    public static void reconstruct(List<Instruction> list) {
        int length = list.size();
        int dupStoreIndex = 0;
        while (dupStoreIndex < length) {
            if (list.get(dupStoreIndex).getOpcode() == 264) {
                DupStore dupstore = (DupStore)list.get(dupStoreIndex);
                int xstorePutfieldPutstaticIndex = dupStoreIndex;
                while (++xstorePutfieldPutstaticIndex < length) {
                    int value;
                    ConstInstruction ci;
                    Instruction i = list.get(xstorePutfieldPutstaticIndex);
                    BinaryOperatorInstruction boi = null;
                    int loadOpCode = ByteCodeUtil.getLoadOpCode((int)i.getOpcode());
                    if (dupstore.getObjectref().getOpcode() == loadOpCode && ((IndexInstruction)i).getIndex() == ((IndexInstruction)dupstore.getObjectref()).getIndex()) {
                        if ((i = ((ValuerefAttribute)((Object)i)).getValueref()).getOpcode() == 275 || i.getOpcode() == 276) {
                            i = ((ConvertInstruction)i).getValue();
                        }
                        if (i.getOpcode() == 267) {
                            boi = (BinaryOperatorInstruction)i;
                        }
                    }
                    if (boi == null || boi.getValue1().getOpcode() != 263 || boi.getValue1().getOffset() != dupstore.getOffset() || boi.getValue2().getOpcode() != 256 && boi.getValue2().getOpcode() != 257 && boi.getValue2().getOpcode() != 259 && boi.getValue2().getOpcode() != 258 || (ci = (ConstInstruction)boi.getValue2()).getValue() != 1) continue;
                    if ("+".equals(boi.getOperator())) {
                        value = 1;
                    } else {
                        if (!"-".equals(boi.getOperator())) continue;
                        value = -1;
                    }
                    IncInstruction inc = new IncInstruction(278, boi.getOffset(), boi.getLineNumber(), dupstore.getObjectref(), value);
                    ReconstructorUtil.replaceDupLoad(list, xstorePutfieldPutstaticIndex + 1, dupstore, inc);
                    list.remove(xstorePutfieldPutstaticIndex);
                    list.remove(dupStoreIndex);
                    --dupStoreIndex;
                    length = list.size();
                    break;
                }
            }
            ++dupStoreIndex;
        }
    }
}

