/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.List;
import java.util.Map;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.classfile.visitor.OuterGetFieldVisitor;
import jd.core.process.analyzer.classfile.visitor.OuterGetStaticVisitor;
import jd.core.process.analyzer.classfile.visitor.OuterIncGetFieldVisitor;
import jd.core.process.analyzer.classfile.visitor.OuterIncGetStaticVisitor;
import jd.core.process.analyzer.classfile.visitor.OuterInvokeMethodVisitor;
import jd.core.process.analyzer.classfile.visitor.OuterPutFieldVisitor;
import jd.core.process.analyzer.classfile.visitor.OuterPutStaticVisitor;
import jd.core.process.analyzer.classfile.visitor.ReplaceMultipleOuterReferenceVisitor;
import jd.core.process.analyzer.classfile.visitor.ReplaceOuterAccessorVisitor;
import jd.core.process.analyzer.classfile.visitor.ReplaceOuterReferenceVisitor;
import jd.core.util.SignatureUtil;

public class OuterReferenceReconstructor {
    private final ClassFile classFile;
    private final ReplaceOuterReferenceVisitor outerReferenceVisitor;
    private final ReplaceMultipleOuterReferenceVisitor multipleOuterReference;
    private final ReplaceOuterAccessorVisitor outerAccessorVisitor;
    private final OuterGetStaticVisitor outerIncGetStaticVisitor;
    private final OuterGetStaticVisitor outerGetStaticVisitor;
    private final OuterPutStaticVisitor outerPutStaticVisitor;
    private final OuterIncGetFieldVisitor outerIncGetFieldVisitor;
    private final OuterGetFieldVisitor outerGetFieldVisitor;
    private final OuterPutFieldVisitor outerPutFieldVisitor;
    private final OuterInvokeMethodVisitor outerMethodVisitor;

    public OuterReferenceReconstructor(Map<String, ClassFile> innerClassesMap, ClassFile classFile) {
        this.classFile = classFile;
        ConstantPool constants = classFile.getConstantPool();
        this.outerReferenceVisitor = new ReplaceOuterReferenceVisitor(25, 1, OuterReferenceReconstructor.createOuterThisInstructionIndex(classFile));
        this.multipleOuterReference = new ReplaceMultipleOuterReferenceVisitor(classFile);
        this.outerAccessorVisitor = new ReplaceOuterAccessorVisitor(classFile);
        this.outerIncGetFieldVisitor = new OuterIncGetFieldVisitor(innerClassesMap, constants);
        this.outerGetFieldVisitor = new OuterGetFieldVisitor(innerClassesMap, constants);
        this.outerPutFieldVisitor = new OuterPutFieldVisitor(innerClassesMap, constants);
        this.outerIncGetStaticVisitor = new OuterIncGetStaticVisitor(innerClassesMap, constants);
        this.outerGetStaticVisitor = new OuterGetStaticVisitor(innerClassesMap, constants);
        this.outerPutStaticVisitor = new OuterPutStaticVisitor(innerClassesMap, constants);
        this.outerMethodVisitor = new OuterInvokeMethodVisitor(innerClassesMap, constants);
    }

    public void reconstruct(Method method, List<Instruction> list) {
        if (this.classFile.getOuterThisField() != null) {
            ConstantPool constants = this.classFile.getConstantPool();
            if (method.getNameIndex() == constants.getInstanceConstructorIndex()) {
                this.outerReferenceVisitor.visit(list);
            }
            this.multipleOuterReference.visit(list);
            this.outerAccessorVisitor.visit(list);
        }
        this.outerIncGetFieldVisitor.visit(list);
        this.outerGetFieldVisitor.visit(list);
        this.outerPutFieldVisitor.visit(list);
        this.outerIncGetStaticVisitor.visit(list);
        this.outerGetStaticVisitor.visit(list);
        this.outerPutStaticVisitor.visit(list);
        this.outerMethodVisitor.visit(list);
    }

    private static int createOuterThisInstructionIndex(ClassFile classFile) {
        if (classFile.getOuterClass() == null) {
            return 0;
        }
        String internalOuterClassName = classFile.getOuterClass().getInternalClassName();
        String outerClassName = SignatureUtil.getInnerName(internalOuterClassName);
        ConstantPool constants = classFile.getConstantPool();
        int signatureIndex = constants.addConstantUtf8(outerClassName);
        int classIndex = constants.addConstantClass(signatureIndex);
        int thisIndex = constants.getThisLocalVariableNameIndex();
        int descriptorIndex = constants.addConstantUtf8(internalOuterClassName);
        int nameAndTypeIndex = constants.addConstantNameAndType(thisIndex, descriptorIndex);
        return constants.addConstantFieldref(classIndex, nameAndTypeIndex);
    }
}

