/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.IndexInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import org.apache.bcel.classfile.ConstantCP;

public class NewInstructionReconstructorBase {
    protected NewInstructionReconstructorBase() {
    }

    public static void initAnonymousClassConstructorParameterName(ClassFile classFile, Method method, InvokeNew invokeNew) {
        ConstantCP cmr;
        ConstantPool constants = classFile.getConstantPool();
        String internalClassName = constants.getConstantClassName((cmr = constants.getConstantMethodref(invokeNew.getIndex())).getClassIndex());
        ClassFile innerClassFile = classFile.getInnerClassFile(internalClassName);
        if (innerClassFile != null) {
            ConstantPool innerConstants = innerClassFile.getConstantPool();
            LocalVariables localVariables = method.getLocalVariables();
            Field[] fieldArray = innerClassFile.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field innerField = fieldArray[n2];
                int index = innerField.getAnonymousClassConstructorParameterIndex();
                if (index != -1) {
                    innerField.setAnonymousClassConstructorParameterIndex(-1);
                    Instruction arg = NewInstructionReconstructorBase.searchInstructionInArgs(invokeNew.getArgs(), index);
                    if (arg != null) {
                        LocalVariable lv;
                        int argOpCode;
                        if (arg.getOpcode() == 192) {
                            arg = ((CheckCast)arg).getObjectref();
                        }
                        if (((argOpCode = arg.getOpcode()) == 268 || argOpCode == 25 || argOpCode == 21) && (lv = localVariables.getLocalVariableWithIndexAndOffset(((IndexInstruction)arg).getIndex(), arg.getOffset())) != null) {
                            String name = constants.getConstantUtf8(lv.getNameIndex());
                            innerField.setOuterMethodLocalVariableNameIndex(innerConstants.addConstantUtf8(name));
                            innerField.setConstantPool(innerConstants);
                            lv.setFinalFlag(true);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private static Instruction searchInstructionInArgs(List<Instruction> args, int index) {
        return args.stream().filter(IndexInstruction.class::isInstance).filter(ii -> ((IndexInstruction)ii).getIndex() == index).findFirst().orElse(null);
    }
}

