/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.Invokespecial;
import jd.core.model.instruction.bytecode.instruction.New;
import jd.core.process.analyzer.classfile.reconstructor.NewInstructionReconstructorBase;
import jd.core.process.analyzer.util.ReconstructorUtil;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;

public final class NewInstructionReconstructor
extends NewInstructionReconstructorBase {
    private NewInstructionReconstructor() {
    }

    public static void reconstruct(ClassFile classFile, Method method, List<Instruction> list) {
        int dupStoreIndex = 0;
        while (dupStoreIndex < list.size()) {
            DupStore ds;
            if (list.get(dupStoreIndex).getOpcode() == 264 && (ds = (DupStore)list.get(dupStoreIndex)).getObjectref().getOpcode() == 187) {
                int invokespecialIndex = dupStoreIndex;
                int length = list.size();
                while (++invokespecialIndex < length) {
                    String signature;
                    ConstantCP cmr;
                    ConstantPool constants;
                    ConstantNameAndType cnat;
                    DupLoad dl;
                    Invokespecial is;
                    Instruction instruction = list.get(invokespecialIndex);
                    if (instruction.getOpcode() != 183 || (is = (Invokespecial)instruction).getObjectref().getOpcode() != 263 || (dl = (DupLoad)is.getObjectref()).getOffset() != ds.getOffset() || (cnat = (constants = classFile.getConstantPool()).getConstantNameAndType((cmr = constants.getConstantMethodref(is.getIndex())).getNameAndTypeIndex())).getNameIndex() != constants.getInstanceConstructorIndex()) continue;
                    New nw = (New)ds.getObjectref();
                    List<Instruction> args = is.getArgs();
                    if (!args.isEmpty() && args.get(0).getOpcode() == 285) {
                        args.remove(0);
                    }
                    if (!args.isEmpty() && args.get(args.size() - 1).getOpcode() == 1 && (signature = constants.getConstantUtf8(cnat.getSignatureIndex())).endsWith("$1;)V")) {
                        args.remove(args.size() - 1);
                    }
                    InvokeNew invokeNew = new InvokeNew(274, is.getOffset(), nw.getLineNumber(), is.getIndex(), args);
                    Instruction parentFound = ReconstructorUtil.replaceDupLoad(list, invokespecialIndex + 1, ds, invokeNew);
                    list.remove(invokespecialIndex);
                    if (parentFound == null) {
                        list.set(dupStoreIndex, invokeNew);
                    } else {
                        list.remove(dupStoreIndex--);
                    }
                    NewInstructionReconstructor.initAnonymousClassConstructorParameterName(classFile, method, invokeNew);
                    break;
                }
            }
            ++dupStoreIndex;
        }
    }
}

