/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.ArrayList;
import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.ILoad;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokespecial;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.process.analyzer.classfile.visitor.CompareInstructionVisitor;
import jd.core.process.analyzer.classfile.visitor.SearchInstructionByTypeVisitor;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;

public final class InitInstanceFieldsReconstructor {
    private InitInstanceFieldsReconstructor() {
    }

    public static void reconstruct(ClassFile classFile) {
        ArrayList<PutField> putFieldList = new ArrayList<PutField>();
        ConstantPool constants = classFile.getConstantPool();
        Method[] methods = classFile.getMethods();
        int methodIndex = methods.length;
        Method putFieldListMethod = null;
        while (methodIndex > 0) {
            if (((method = methods[--methodIndex]).getAccessFlags() & 0x1040) != 0 || method.getCode() == null || method.getFastNodes() == null || method.containsError() || method.getNameIndex() != constants.getInstanceConstructorIndex() || (list = method.getFastNodes()) == null) continue;
            int length = list.size();
            if (length <= 0) break;
            int j = InitInstanceFieldsReconstructor.getSuperCallIndex(classFile, constants, list);
            if (j < 0) continue;
            int lineNumberBefore = ++j > 0 ? list.get(j - 1).getLineNumber() : 0;
            Instruction instruction = null;
            while (j < length) {
                if ((instruction = list.get(j++)).getOpcode() != 181 || (cfr = constants.getConstantFieldref((putField = (PutField)instruction).getIndex())).getClassIndex() != classFile.getThisClassIndex() || putField.getObjectref().getOpcode() != 25 || (aLaod = (ALoad)putField.getObjectref()).getIndex() != 0 || (visitor = new SearchInstructionByTypeVisitor<LoadInstruction>(LoadInstruction.class, i -> i.getOpcode() != 25 || i.getIndex() != 0)).visit(putField.getValueref()) != null) break;
                putFieldList.add(putField);
                putFieldListMethod = method;
            }
            if (lineNumberBefore == 0 || instruction == null) break;
            int i2 = putFieldList.size();
            int lineNumberAfter = instruction.getLineNumber();
            if (instruction.getOpcode() == 177 && j == length && i2 != 0 && lineNumberAfter == ((PutField)putFieldList.get(i2 - 1)).getLineNumber()) break;
            while (i2-- > 0) {
                int lineNumber = ((PutField)putFieldList.get(i2)).getLineNumber();
                if (lineNumberBefore > lineNumber || lineNumber > lineNumberAfter) continue;
                putFieldList.remove(i2);
            }
            break block0;
        }
        CompareInstructionVisitor visitor = new CompareInstructionVisitor();
        block3: while (methodIndex > 0) {
            if (((method = methods[--methodIndex]).getAccessFlags() & 0x1040) != 0 || method.getCode() == null || method.getNameIndex() != constants.getInstanceConstructorIndex() || (length = (list = method.getFastNodes()).size()) <= 0 || (j = InitInstanceFieldsReconstructor.getSuperCallIndex(classFile, constants, list)) < 0) continue;
            int firstPutFieldIndex = j + 1;
            int putFieldListLength = putFieldList.size();
            while (firstPutFieldIndex + putFieldListLength > length) {
                putFieldList.remove(--putFieldListLength);
            }
            int i3 = 0;
            while (i3 < putFieldListLength) {
                Instruction initFieldInstruction = (Instruction)putFieldList.get(i3);
                instruction = list.get(firstPutFieldIndex + i3);
                if (initFieldInstruction.getLineNumber() != instruction.getLineNumber() || !visitor.visit(initFieldInstruction, instruction)) {
                    while (i3 < putFieldListLength) {
                        putFieldList.remove(--putFieldListLength);
                    }
                    continue block3;
                }
                ++i3;
            }
        }
        int putFieldListLength = putFieldList.size();
        Field[] fields = classFile.getFields();
        if (putFieldListLength > 0) {
            int fieldLength = fields.length;
            int putFieldListIndex = putFieldListLength;
            while (putFieldListIndex-- > 0) {
                PutField putField = (PutField)putFieldList.get(putFieldListIndex);
                ConstantFieldref cfr = constants.getConstantFieldref(putField.getIndex());
                ConstantNameAndType cnat = constants.getConstantNameAndType(cfr.getNameAndTypeIndex());
                int fieldIndex = 0;
                while (fieldIndex < fieldLength) {
                    Field field = fields[fieldIndex];
                    if (cnat.getNameIndex() == field.getNameIndex() && cnat.getSignatureIndex() == field.getDescriptorIndex() && (field.getAccessFlags() & 8) == 0) {
                        Instruction valueref = putField.getValueref();
                        field.setValueAndMethod(valueref, putFieldListMethod);
                        if (valueref.getOpcode() != 283) break;
                        valueref.setOpcode(282);
                        break;
                    }
                    ++fieldIndex;
                }
                if (fieldIndex != fieldLength) continue;
                putFieldList.remove(putFieldListIndex);
                --putFieldListLength;
            }
            if (putFieldListLength > 0) {
                methodIndex = methods.length;
                block9: while (methodIndex-- > 0) {
                    Method method = methods[methodIndex];
                    if ((method.getAccessFlags() & 0x1040) != 0 || method.getCode() == null || method.getNameIndex() != constants.getInstanceConstructorIndex() || (list = method.getFastNodes()).isEmpty()) continue;
                    putFieldListIndex = 0;
                    int putFieldIndex = ((PutField)putFieldList.get(putFieldListIndex)).getIndex();
                    int index = 0;
                    while (index < list.size()) {
                        instruction = list.get(index);
                        if (!(instruction.getOpcode() != 181 || (putField = (PutField)instruction).getIndex() != putFieldIndex || (cfr = constants.getConstantFieldref(putField.getIndex())).getClassIndex() != classFile.getThisClassIndex() || putField.getObjectref().getOpcode() != 25 || (aLoad = (ALoad)putField.getObjectref()).getIndex() != 0 || (var22_35 = (putFieldValueref = putField.getValueref())) instanceof ALoad && (var20_34 = (ALoad)var22_35) == (ALoad)var22_35 && aload.getIndex() != 0 || putFieldValueref instanceof ILoad var23_36 && iload.getIndex() != 0)) {
                            list.remove(index--);
                            if (++putFieldListIndex >= putFieldListLength) continue block9;
                            putFieldIndex = ((PutField)putFieldList.get(putFieldListIndex)).getIndex();
                        }
                        ++index;
                    }
                }
            }
        }
    }

    private static int getSuperCallIndex(ClassFile classFile, ConstantPool constants, List<Instruction> list) {
        int length = list.size();
        int i = 0;
        while (i < length) {
            ConstantCP cmr;
            ConstantNameAndType cnat;
            Invokespecial is;
            Instruction instruction = list.get(i);
            if (instruction.getOpcode() == 183 && (is = (Invokespecial)instruction).getObjectref().getOpcode() == 25 && ((ALoad)is.getObjectref()).getIndex() == 0 && (cnat = constants.getConstantNameAndType((cmr = constants.getConstantMethodref(is.getIndex())).getNameAndTypeIndex())).getNameIndex() == constants.getInstanceConstructorIndex()) {
                if (cmr.getClassIndex() == classFile.getThisClassIndex()) {
                    return -1;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }
}

