/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.List;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.ConstantPool;
import jd.core.model.classfile.Field;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.Goto;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.Invokestatic;
import jd.core.model.instruction.bytecode.instruction.Ldc;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.reference.ReferenceMap;
import jd.core.process.analyzer.classfile.visitor.ReplaceGetStaticVisitor;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;

public final class DotClass14Reconstructor {
    private DotClass14Reconstructor() {
    }

    public static void reconstruct(ReferenceMap referenceMap, ClassFile classFile, List<Instruction> list) {
        int i = list.size();
        if (i < 6) {
            return;
        }
        i -= 5;
        ConstantPool constants = classFile.getConstantPool();
        block0: while (i-- > 0) {
            Ldc ldc;
            Constant cv;
            ConstantNameAndType cnatMethod;
            String nameMethod;
            ConstantCP cmr;
            ClassFile matchingClassFile;
            String nameField;
            ConstantNameAndType cnatField;
            String descriptorField;
            ConstantFieldref cfr;
            TernaryOpStore tos;
            PutStatic ps;
            Invokestatic is;
            DupStore ds;
            IfInstruction ii;
            Instruction instruction = list.get(i);
            if (instruction.getOpcode() != 262 || (ii = (IfInstruction)instruction).getValue().getOpcode() != 178) continue;
            int jumpOffset = ii.getJumpOffset();
            instruction = list.get(i + 1);
            if (instruction.getOpcode() != 264 || (ds = (DupStore)instruction).getObjectref().getOpcode() != 184 || (is = (Invokestatic)ds.getObjectref()).getArgs().size() != 1 || (instruction = is.getArgs().get(0)).getOpcode() != 18 || (instruction = list.get(i + 2)).getOpcode() != 179 || (ps = (PutStatic)instruction).getValueref().getOpcode() != 263 || ds.getOffset() != ps.getValueref().getOffset() || (instruction = list.get(i + 3)).getOpcode() != 280 || (tos = (TernaryOpStore)instruction).getObjectref().getOpcode() != 263 || ds.getOffset() != tos.getObjectref().getOffset() || (instruction = list.get(i + 4)).getOpcode() != 167) continue;
            Goto g = (Goto)instruction;
            instruction = list.get(i + 5);
            if (g.getOffset() >= jumpOffset || jumpOffset > instruction.getOffset()) continue;
            GetStatic gs = (GetStatic)ii.getValue();
            if (ps.getIndex() != gs.getIndex() || DotClass14Reconstructor.searchMatchingClassFile((cfr = constants.getConstantFieldref(gs.getIndex())).getClassIndex(), classFile) == null || !"Ljava/lang/Class;".equals(descriptorField = constants.getConstantUtf8((cnatField = constants.getConstantNameAndType(cfr.getNameAndTypeIndex())).getSignatureIndex())) || !(nameField = constants.getConstantUtf8(cnatField.getNameIndex())).startsWith("class$") && !nameField.startsWith("array$") || (matchingClassFile = DotClass14Reconstructor.searchMatchingClassFile((cmr = constants.getConstantMethodref(is.getIndex())).getClassIndex(), classFile)) == null || !"class$".equals(nameMethod = constants.getConstantUtf8((cnatMethod = constants.getConstantNameAndType(cmr.getNameAndTypeIndex())).getNameIndex())) || (cv = constants.getConstantValue((ldc = (Ldc)is.getArgs().get(0)).getIndex())).getTag() != 8) continue;
            ConstantString cs = (ConstantString)cv;
            String signature = constants.getConstantUtf8(cs.getStringIndex());
            String internalName = signature.replace('.', '/');
            referenceMap.add(internalName);
            int index = constants.addConstantUtf8(internalName);
            index = constants.addConstantClass(index);
            ldc = new Ldc(18, ii.getOffset(), ii.getLineNumber(), index);
            ReplaceGetStaticVisitor visitor = new ReplaceGetStaticVisitor(gs.getIndex(), ldc);
            visitor.visit(instruction);
            list.remove(i + 4);
            list.remove(i + 3);
            list.remove(i + 2);
            list.remove(i + 1);
            list.remove(i);
            if (matchingClassFile == classFile) {
                Field[] fields = classFile.getFields();
                int j = fields.length;
                while (j-- > 0) {
                    Field field = fields[j];
                    if (field.getNameIndex() != cnatField.getNameIndex()) continue;
                    field.setAccessFlags(field.getAccessFlags() | 0x1000);
                    break;
                }
                Method[] methods = classFile.getMethods();
                j = methods.length;
                while (j-- > 0) {
                    Method method = methods[j];
                    if (method.getNameIndex() != cnatMethod.getNameIndex()) continue;
                    method.setAccessFlags(method.getAccessFlags() | 0x1000);
                    continue block0;
                }
                continue;
            }
            ConstantPool matchingConstants = matchingClassFile.getConstantPool();
            Field[] fields = matchingClassFile.getFields();
            int j = fields.length;
            while (j-- > 0) {
                Field field = fields[j];
                if (!nameField.equals(matchingConstants.getConstantUtf8(field.getNameIndex()))) continue;
                field.setAccessFlags(field.getAccessFlags() | 0x1000);
                break;
            }
            Method[] methods = matchingClassFile.getMethods();
            j = methods.length;
            while (j-- > 0) {
                Method method = methods[j];
                if (!nameMethod.equals(matchingConstants.getConstantUtf8(method.getNameIndex()))) continue;
                method.setAccessFlags(method.getAccessFlags() | 0x1000);
                continue block0;
            }
        }
    }

    private static ClassFile searchMatchingClassFile(int classIndex, ClassFile classFile) {
        if (classIndex == classFile.getThisClassIndex()) {
            return classFile;
        }
        String className = classFile.getConstantPool().getConstantClassName(classIndex);
        do {
            if ((classFile = classFile.getOuterClass()) != null) continue;
            return null;
        } while (!classFile.getThisClassName().equals(className));
        return classFile;
    }
}

