/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.ConstInstruction;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.process.analyzer.classfile.visitor.CompareInstructionVisitor;

public final class AssignmentOperatorReconstructor {
    private AssignmentOperatorReconstructor() {
    }

    public static void reconstruct(List<Instruction> list) {
        int index = list.size();
        block7: while (index-- > 0) {
            Instruction i = list.get(index);
            switch (i.getOpcode()) {
                case 179: {
                    if (((PutStatic)i).getValueref().getOpcode() != 267) break;
                    AssignmentOperatorReconstructor.reconstructPutStaticOperator(list, index, i);
                    break;
                }
                case 181: {
                    if (((PutField)i).getValueref().getOpcode() != 267) break;
                    index = AssignmentOperatorReconstructor.reconstructPutFieldOperator(list, index, i);
                    break;
                }
                case 54: {
                    BinaryOperatorInstruction boi;
                    if (((StoreInstruction)i).getValueref().getOpcode() != 267 || (boi = (BinaryOperatorInstruction)((StoreInstruction)i).getValueref()).getValue1().getOpcode() != 21) continue block7;
                    AssignmentOperatorReconstructor.reconstructStoreOperator(list, index, i, boi);
                    break;
                }
                case 269: {
                    BinaryOperatorInstruction boi;
                    if (((StoreInstruction)i).getValueref().getOpcode() != 267 || (boi = (BinaryOperatorInstruction)((StoreInstruction)i).getValueref()).getValue1().getOpcode() != 268) continue block7;
                    AssignmentOperatorReconstructor.reconstructStoreOperator(list, index, i, boi);
                    break;
                }
                case 272: {
                    if (((ArrayStoreInstruction)i).getValueref().getOpcode() != 267) break;
                    index = AssignmentOperatorReconstructor.reconstructArrayOperator(list, index, i);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void reconstructPutStaticOperator(List<Instruction> list, int index, Instruction i) {
        PutStatic putStatic = (PutStatic)i;
        BinaryOperatorInstruction boi = (BinaryOperatorInstruction)putStatic.getValueref();
        if (boi.getValue1().getOpcode() != 178) {
            return;
        }
        GetStatic getStatic = (GetStatic)boi.getValue1();
        if (putStatic.getLineNumber() != getStatic.getLineNumber() || putStatic.getIndex() != getStatic.getIndex()) {
            return;
        }
        String newOperator = String.valueOf(boi.getOperator()) + "=";
        Instruction instruction = boi.getValue2();
        if (instruction instanceof ConstInstruction var7_8 && AssignmentOperatorReconstructor.isPlusOrMinusEqual(newOperator)) {
            void ci;
            int sign = "+=".equals(newOperator) ? 1 : -1;
            list.set(index, new IncInstruction(278, putStatic.getOffset(), getStatic.getLineNumber(), getStatic, sign * ci.getValue()));
        } else {
            list.set(index, new AssignmentInstruction(265, putStatic.getOffset(), getStatic.getLineNumber(), boi.getPriority(), newOperator, getStatic, boi.getValue2()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int reconstructPutFieldOperator(List<Instruction> list, int index, Instruction i) {
        PutField putField = (PutField)i;
        BinaryOperatorInstruction boi = (BinaryOperatorInstruction)putField.getValueref();
        if (boi.getValue1().getOpcode() != 180) {
            return index;
        }
        GetField getField = (GetField)boi.getValue1();
        CompareInstructionVisitor visitor = new CompareInstructionVisitor();
        if (putField.getLineNumber() != getField.getLineNumber() || putField.getIndex() != getField.getIndex() || !visitor.visit(putField.getObjectref(), getField.getObjectref())) {
            return index;
        }
        if (putField.getObjectref().getOpcode() == 263) {
            DupLoad dupLoad = (DupLoad)getField.getObjectref();
            index = AssignmentOperatorReconstructor.deleteDupStoreInstruction(list, index, dupLoad);
            getField.setObjectref(dupLoad.getDupStore().getObjectref());
        }
        String newOperator = String.valueOf(boi.getOperator()) + "=";
        Instruction instruction = boi.getValue2();
        if (instruction instanceof ConstInstruction var8_9 && AssignmentOperatorReconstructor.isPlusOrMinusEqual(newOperator)) {
            void ci;
            int sign = "+=".equals(newOperator) ? 1 : -1;
            list.set(index, new IncInstruction(278, putField.getOffset(), getField.getLineNumber(), getField, sign * ci.getValue()));
        } else {
            list.set(index, new AssignmentInstruction(265, putField.getOffset(), getField.getLineNumber(), boi.getPriority(), newOperator, getField, boi.getValue2()));
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    private static void reconstructStoreOperator(List<Instruction> list, int index, Instruction i, BinaryOperatorInstruction boi) {
        StoreInstruction si = (StoreInstruction)i;
        LoadInstruction li = (LoadInstruction)boi.getValue1();
        if (si.getLineNumber() != li.getLineNumber() || si.getIndex() != li.getIndex()) {
            return;
        }
        String newOperator = String.valueOf(boi.getOperator()) + "=";
        Instruction instruction = boi.getValue2();
        if (instruction instanceof ConstInstruction var7_8 && AssignmentOperatorReconstructor.isPlusOrMinusEqual(newOperator)) {
            void ci;
            list.set(index, new IncInstruction(278, si.getOffset(), li.getLineNumber(), li, ci.getValue()));
        } else {
            list.set(index, new AssignmentInstruction(265, si.getOffset(), li.getLineNumber(), boi.getPriority(), newOperator, li, boi.getValue2()));
        }
    }

    private static boolean isPlusOrMinusEqual(String newOperator) {
        return "+=".equals(newOperator) || "-=".equals(newOperator);
    }

    private static int reconstructArrayOperator(List<Instruction> list, int index, Instruction i) {
        DupLoad dupLoad;
        ArrayStoreInstruction asi = (ArrayStoreInstruction)i;
        BinaryOperatorInstruction boi = (BinaryOperatorInstruction)asi.getValueref();
        if (boi.getValue1().getOpcode() != 271) {
            return index;
        }
        ArrayLoadInstruction ali = (ArrayLoadInstruction)boi.getValue1();
        CompareInstructionVisitor visitor = new CompareInstructionVisitor();
        if (asi.getLineNumber() != ali.getLineNumber() || !visitor.visit(asi.getArrayref(), ali.getArrayref()) || !visitor.visit(asi.getIndexref(), ali.getIndexref())) {
            return index;
        }
        if (asi.getArrayref().getOpcode() == 263) {
            dupLoad = (DupLoad)ali.getArrayref();
            index = AssignmentOperatorReconstructor.deleteDupStoreInstruction(list, index, dupLoad);
            ali.setArrayref(dupLoad.getDupStore().getObjectref());
        }
        if (asi.getIndexref().getOpcode() == 263) {
            dupLoad = (DupLoad)ali.getIndexref();
            index = AssignmentOperatorReconstructor.deleteDupStoreInstruction(list, index, dupLoad);
            ali.setIndexref(dupLoad.getDupStore().getObjectref());
        }
        String newOperator = String.valueOf(boi.getOperator()) + "=";
        list.set(index, new AssignmentInstruction(265, asi.getOffset(), ali.getLineNumber(), boi.getPriority(), newOperator, ali, boi.getValue2()));
        return index;
    }

    private static int deleteDupStoreInstruction(List<Instruction> list, int index, DupLoad dupLoad) {
        int indexTmp = index;
        while (indexTmp-- > 0) {
            Instruction i = list.get(indexTmp);
            if (dupLoad.getDupStore() != i) continue;
            list.remove(indexTmp);
            return --index;
        }
        return index;
    }
}

