/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile.reconstructor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.AALoad;
import jd.core.model.instruction.bytecode.instruction.AAStore;
import jd.core.model.instruction.bytecode.instruction.ALoad;
import jd.core.model.instruction.bytecode.instruction.AStore;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.GetStatic;
import jd.core.model.instruction.bytecode.instruction.ILoad;
import jd.core.model.instruction.bytecode.instruction.IStore;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.attribute.ValuerefAttribute;
import jd.core.process.analyzer.classfile.visitor.CompareInstructionVisitor;
import jd.core.process.analyzer.classfile.visitor.ReplaceDupLoadVisitor;
import jd.core.process.analyzer.classfile.visitor.SearchInstructionByTypeVisitor;

public final class AssignmentInstructionReconstructor {
    private AssignmentInstructionReconstructor() {
    }

    public static void reconstruct(List<Instruction> list) {
        int dupStoreIndex = 0;
        while (dupStoreIndex < list.size()) {
            if (list.get(dupStoreIndex).getOpcode() == 264) {
                DupStore dupStore = (DupStore)list.get(dupStoreIndex);
                int length = list.size();
                if (dupStoreIndex + 1 >= length || (i = list.get(dupStoreIndex + 1)).getOpcode() != 83 && i.getOpcode() != 272 || (i = ((ArrayStoreInstruction)i).getArrayref()).getOpcode() != 263 || ((DupLoad)i).getDupStore() != dupStore) {
                    int xstorePutfieldPutstaticIndex = dupStoreIndex;
                    while (++xstorePutfieldPutstaticIndex < length) {
                        Instruction xstorePutfieldPutstatic = list.get(xstorePutfieldPutstaticIndex);
                        Instruction dupload1 = null;
                        if (xstorePutfieldPutstatic instanceof ValuerefAttribute var7_8) {
                            Instruction i = valRefAttr.getValueref();
                            if (i.getOpcode() == 263 && ((DupLoad)i).getDupStore() == dupStore) {
                                dupload1 = i;
                            }
                        } else if (xstorePutfieldPutstatic.getOpcode() == 57 || xstorePutfieldPutstatic.getOpcode() == 56 || xstorePutfieldPutstatic.getOpcode() == 55) {
                            new RuntimeException("Unexpected instruction").printStackTrace();
                        }
                        if (dupload1 == null) continue;
                        Instruction dupload2 = null;
                        int dupload2Index = xstorePutfieldPutstaticIndex;
                        SearchInstructionByTypeVisitor<DupLoad> searchDupLoadInstructionVisitor = new SearchInstructionByTypeVisitor<DupLoad>(DupLoad.class, dl -> dl.getDupStore() == dupStore);
                        while (dupload2 == null && ++dupload2Index < length) {
                            dupload2 = searchDupLoadInstructionVisitor.visit(list.get(dupload2Index));
                        }
                        if (dupload2 == null) continue;
                        if (dupload1.getLineNumber() == dupload2.getLineNumber()) {
                            newInstruction = AssignmentInstructionReconstructor.createAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                            visitor = new ReplaceDupLoadVisitor(dupStore, newInstruction);
                            visitor.visit(list.get(dupload2Index));
                            int j = dupStoreIndex;
                            while (j-- > 0) {
                                if (list.get(j).getOpcode() != 280 || (tos = (TernaryOpStore)list.get(j)).getTernaryOp2ndValueOffset() != dupStore.getOffset()) continue;
                                tos.setTernaryOp2ndValueOffset(newInstruction.getOffset());
                                break;
                            }
                            list.remove(xstorePutfieldPutstaticIndex);
                            list.remove(dupStoreIndex);
                            --dupStoreIndex;
                            length -= 2;
                            continue;
                        }
                        newInstruction = AssignmentInstructionReconstructor.createInstruction(xstorePutfieldPutstatic);
                        if (newInstruction == null) continue;
                        visitor = new ReplaceDupLoadVisitor(dupStore, dupStore.getObjectref());
                        visitor.visit(xstorePutfieldPutstatic);
                        visitor.init(dupStore, newInstruction);
                        visitor.visit(list.get(dupload2Index));
                        list.remove(dupStoreIndex);
                        --dupStoreIndex;
                        --length;
                    }
                }
            }
            ++dupStoreIndex;
        }
    }

    private static Instruction createInstruction(Instruction xstorePutfieldPutstatic) {
        return switch (xstorePutfieldPutstatic.getOpcode()) {
            case 58 -> new ALoad(25, xstorePutfieldPutstatic.getOffset(), xstorePutfieldPutstatic.getLineNumber(), ((AStore)xstorePutfieldPutstatic).getIndex());
            case 54 -> new ILoad(21, xstorePutfieldPutstatic.getOffset(), xstorePutfieldPutstatic.getLineNumber(), ((IStore)xstorePutfieldPutstatic).getIndex());
            case 269 -> new LoadInstruction(268, xstorePutfieldPutstatic.getOffset(), xstorePutfieldPutstatic.getLineNumber(), ((StoreInstruction)xstorePutfieldPutstatic).getIndex(), xstorePutfieldPutstatic.getReturnedSignature(null, null));
            case 181 -> new GetField(180, xstorePutfieldPutstatic.getOffset(), xstorePutfieldPutstatic.getLineNumber(), ((PutField)xstorePutfieldPutstatic).getIndex(), ((PutField)xstorePutfieldPutstatic).getObjectref());
            case 179 -> new GetStatic(178, xstorePutfieldPutstatic.getOffset(), xstorePutfieldPutstatic.getLineNumber(), ((PutStatic)xstorePutfieldPutstatic).getIndex());
            case 83 -> new AALoad(271, xstorePutfieldPutstatic.getOffset(), xstorePutfieldPutstatic.getLineNumber(), ((AAStore)xstorePutfieldPutstatic).getArrayref(), ((AAStore)xstorePutfieldPutstatic).getIndexref());
            case 272 -> new ArrayLoadInstruction(271, xstorePutfieldPutstatic.getOffset(), xstorePutfieldPutstatic.getLineNumber(), ((ArrayStoreInstruction)xstorePutfieldPutstatic).getArrayref(), ((ArrayStoreInstruction)xstorePutfieldPutstatic).getIndexref(), ((ArrayStoreInstruction)xstorePutfieldPutstatic).getSignature());
            default -> null;
        };
    }

    private static Instruction createAssignmentInstruction(Instruction xstorePutfieldPutstatic, DupStore dupStore) {
        if (dupStore.getObjectref().getOpcode() == 267) {
            Instruction value1 = ((BinaryOperatorInstruction)dupStore.getObjectref()).getValue1();
            if (xstorePutfieldPutstatic.getLineNumber() == value1.getLineNumber()) {
                switch (xstorePutfieldPutstatic.getOpcode()) {
                    case 58: {
                        if (value1.getOpcode() != 25 || ((StoreInstruction)xstorePutfieldPutstatic).getIndex() != ((LoadInstruction)value1).getIndex()) break;
                        return AssignmentInstructionReconstructor.createBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 54: {
                        if (value1.getOpcode() != 21 || ((StoreInstruction)xstorePutfieldPutstatic).getIndex() != ((LoadInstruction)value1).getIndex()) break;
                        return AssignmentInstructionReconstructor.createBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 269: {
                        if (value1.getOpcode() != 268 || ((StoreInstruction)xstorePutfieldPutstatic).getIndex() != ((LoadInstruction)value1).getIndex()) break;
                        return AssignmentInstructionReconstructor.createBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 181: {
                        CompareInstructionVisitor visitor;
                        if (value1.getOpcode() != 180 || ((PutField)xstorePutfieldPutstatic).getIndex() != ((GetField)value1).getIndex() || !(visitor = new CompareInstructionVisitor()).visit(((PutField)xstorePutfieldPutstatic).getObjectref(), ((GetField)value1).getObjectref())) break;
                        return AssignmentInstructionReconstructor.createBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 179: {
                        if (value1.getOpcode() != 178 || ((PutStatic)xstorePutfieldPutstatic).getIndex() != ((GetStatic)value1).getIndex()) break;
                        return AssignmentInstructionReconstructor.createBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 83: {
                        if (value1.getOpcode() != 50) break;
                        ArrayStoreInstruction aas = (ArrayStoreInstruction)xstorePutfieldPutstatic;
                        ArrayLoadInstruction aal = (ArrayLoadInstruction)value1;
                        CompareInstructionVisitor visitor = new CompareInstructionVisitor();
                        if (!visitor.visit(aas.getArrayref(), aal.getArrayref()) || !visitor.visit(aas.getIndexref(), aal.getIndexref())) break;
                        return AssignmentInstructionReconstructor.createBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 272: {
                        if (value1.getOpcode() != 271) break;
                        ArrayStoreInstruction aas = (ArrayStoreInstruction)xstorePutfieldPutstatic;
                        ArrayLoadInstruction aal = (ArrayLoadInstruction)value1;
                        CompareInstructionVisitor visitor = new CompareInstructionVisitor();
                        if (!visitor.visit(aas.getArrayref(), aal.getArrayref()) || !visitor.visit(aas.getIndexref(), aal.getIndexref())) break;
                        return AssignmentInstructionReconstructor.createBinaryOperatorAssignmentInstruction(xstorePutfieldPutstatic, dupStore);
                    }
                    case 55: 
                    case 56: 
                    case 57: {
                        new RuntimeException("Unexpected instruction").printStackTrace();
                    }
                }
            }
        }
        Instruction newInstruction = AssignmentInstructionReconstructor.createInstruction(xstorePutfieldPutstatic);
        return new AssignmentInstruction(265, xstorePutfieldPutstatic.getOffset(), dupStore.getLineNumber(), 14, "=", newInstruction, dupStore.getObjectref());
    }

    private static AssignmentInstruction createBinaryOperatorAssignmentInstruction(Instruction xstorePutfieldPutstatic, DupStore dupstore) {
        BinaryOperatorInstruction boi = (BinaryOperatorInstruction)dupstore.getObjectref();
        String newOperator = String.valueOf(boi.getOperator()) + "=";
        return new AssignmentInstruction(265, xstorePutfieldPutstatic.getOffset(), dupstore.getLineNumber(), boi.getPriority(), newOperator, AssignmentInstructionReconstructor.createInstruction(xstorePutfieldPutstatic), boi.getValue2());
    }
}

