/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.classfile;

import jd.core.model.reference.ReferenceMap;
import jd.core.util.CharArrayUtil;
import org.apache.commons.lang3.Validate;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SignatureFormatException;

public final class SignatureAnalyzer {
    private SignatureAnalyzer() {
    }

    public static void analyzeClassSignature(ReferenceMap referenceMap, String signature) {
        try {
            char[] caSignature = signature.toCharArray();
            int length = caSignature.length;
            int index = 0;
            index = SignatureAnalyzer.analyzeGenerics(referenceMap, caSignature, length, index);
            index = SignatureAnalyzer.analyzeSignature(referenceMap, caSignature, length, index);
            while (index < signature.length()) {
                index = SignatureAnalyzer.analyzeSignature(referenceMap, caSignature, length, index);
            }
        }
        catch (RuntimeException e) {
            System.err.println("SignatureAnalyzer.AnalyzeClassSignature: Infinite loop, signature=" + signature);
            throw e;
        }
    }

    public static void analyzeMethodSignature(ReferenceMap referenceMap, String signature) {
        try {
            char[] caSignature = signature.toCharArray();
            int length = caSignature.length;
            int index = 0;
            index = SignatureAnalyzer.analyzeGenerics(referenceMap, caSignature, length, index);
            if (caSignature[index] != '(') {
                throw new SignatureFormatException(signature);
            }
            ++index;
            while (caSignature[index] != ')') {
                index = SignatureAnalyzer.analyzeSignature(referenceMap, caSignature, length, index);
            }
            SignatureAnalyzer.analyzeSignature(referenceMap, caSignature, length, ++index);
        }
        catch (RuntimeException e) {
            System.err.println("SignatureAnalyzer.AnalyzeMethodSignature: Infinite loop, signature=" + signature);
            throw e;
        }
    }

    public static void analyzeSimpleSignature(ReferenceMap referenceMap, String signature) {
        try {
            char[] caSignature = signature.toCharArray();
            SignatureAnalyzer.analyzeSignature(referenceMap, caSignature, caSignature.length, 0);
        }
        catch (RuntimeException e) {
            System.err.println("SignatureAnalyzer.AnalyzeSimpleSignature: Infinite loop, signature=" + signature);
            throw e;
        }
    }

    private static int analyzeGenerics(ReferenceMap referenceMap, char[] caSignature, int length, int index) {
        if (caSignature[index] == '<') {
            ++index;
            while (index < length) {
                if (caSignature[index = CharArrayUtil.indexOf(caSignature, ':', index) + 1] == ':') {
                    ++index;
                }
                if (caSignature[index = SignatureAnalyzer.analyzeSignature(referenceMap, caSignature, length, index)] == '>') break;
            }
            ++index;
        }
        return index;
    }

    private static int analyzeSignature(ReferenceMap referenceMap, char[] caSignature, int length, int index) {
        int debugCounter = 0;
        while (true) {
            if (caSignature[index] == '[') {
                while (++index < length) {
                    if (caSignature[index] == 'L' && index + 1 < length && caSignature[index + 1] == '[') {
                        ++index;
                        --length;
                        continue;
                    }
                    if (caSignature[index] != '[') break;
                }
            }
            switch (caSignature[index]) {
                case '.': 
                case 'L': {
                    String internalName;
                    String internalPackageName;
                    boolean classFlag = caSignature[index] == 'L';
                    int beginIndex = ++index;
                    int c = 46;
                    while (index < length) {
                        c = caSignature[index];
                        if (c == 59 || c == 60) break;
                        ++index;
                    }
                    if (classFlag && !"java/lang".equals(internalPackageName = (internalName = CharArrayUtil.substring(caSignature, beginIndex, index)).substring(0, internalName.lastIndexOf(47)))) {
                        String importedInternalName = referenceMap.getSimpleNameClashWith(internalName);
                        if (importedInternalName == null) {
                            referenceMap.add(internalName);
                        } else {
                            referenceMap.remove(importedInternalName);
                        }
                    }
                    if (c == 60) {
                        ++index;
                        while (caSignature[index] != '>') {
                            index = SignatureAnalyzer.analyzeSignature(referenceMap, caSignature, length, index);
                        }
                        ++index;
                    }
                    if (caSignature[index] != ';') break;
                    ++index;
                    break;
                }
                case '+': 
                case '-': {
                    index = SignatureAnalyzer.analyzeSignature(referenceMap, caSignature, length, index + 1);
                    break;
                }
                case 'T': {
                    index = CharArrayUtil.indexOf(caSignature, ';', index + 1) + 1;
                    break;
                }
                case '*': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    ++index;
                }
            }
            if (index >= length || caSignature[index] != '.') break;
            Validate.inclusiveBetween((long)0L, (long)3000L, (long)(++debugCounter), (String)"Infinite loop");
        }
        return index;
    }
}

